package carbon

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCarbon_Constellation(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected string
	}{
		{"", ""},
		{"0", ""},
		{"0000-00-00", ""},
		{"00:00:00", ""},
		{"0000-00-00 00:00:00", ""},

		{"2020-01-05", "Capricorn"},
		{"2020-01-22", "Aquarius"},
		{"2020-02-05", "Aquarius"},
		{"2020-03-05", "Pisces"},
		{"2020-04-05", "Aries"},
		{"2020-05-05", "Taurus"},
		{"2020-06-05", "Gemini"},
		{"2020-07-05", "Cancer"},
		{"2020-08-05", "Leo"},
		{"2020-09-05", "Virgo"},
		{"2020-10-05", "Libra"},
		{"2020-11-05", "Scorpio"},
		{"2020-12-05", "Sagittarius"},
		{"2020-12-22", "Capricorn"},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.Constellation(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsAries(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-03-21", true},
		{"2020-04-19", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsAries(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsTaurus(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-04-20", true},
		{"2020-05-20", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsTaurus(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsGemini(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-05-21", true},
		{"2020-06-21", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsGemini(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsCancer(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-06-22", true},
		{"2020-07-22", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsCancer(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsLeo(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-07-23", true},
		{"2020-08-05", true},
		{"2020-08-22", true},
		{"2020-08-23", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsLeo(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsVirgo(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-08-23", true},
		{"2020-09-22", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsVirgo(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsLibra(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-09-23", true},
		{"2020-10-23", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsLibra(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsScorpio(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-10-24", true},
		{"2020-11-22", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsScorpio(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsSagittarius(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-11-23", true},
		{"2020-12-21", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsSagittarius(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsCapricorn(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-12-22", true},
		{"2020-01-19", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsCapricorn(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsAquarius(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-01-20", true},
		{"2020-02-18", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsAquarius(), "Current test index is "+strconv.Itoa(index))
	}
}

func TestCarbon_IsPisces(t *testing.T) {
	assert := assert.New(t)

	tests := []struct {
		input    string
		expected bool
	}{
		{"", false},
		{"0", false},
		{"0000-00-00", false},
		{"00:00:00", false},
		{"0000-00-00 00:00:00", false},

		{"2020-02-19", true},
		{"2020-03-20", true},
		{"2020-08-05", false},
	}

	for index, test := range tests {
		c := SetTimezone(PRC).Parse(test.input)
		assert.Nil(c.Error)
		assert.Equal(test.expected, c.IsPisces(), "Current test index is "+strconv.Itoa(index))
	}
}
