// Code generated by go-swagger; DO NOT EDIT.

package operation_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaitParams creates a new WaitParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaitParams() *WaitParams {
	return &WaitParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewWaitParamsWithTimeout creates a new WaitParams object
// with the ability to set a timeout on a request.
func NewWaitParamsWithTimeout(timeout time.Duration) *WaitParams {
	return &WaitParams{
		requestTimeout: timeout,
	}
}

// NewWaitParamsWithContext creates a new WaitParams object
// with the ability to set a context for a request.
func NewWaitParamsWithContext(ctx context.Context) *WaitParams {
	return &WaitParams{
		Context: ctx,
	}
}

// NewWaitParamsWithHTTPClient creates a new WaitParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaitParamsWithHTTPClient(client *http.Client) *WaitParams {
	return &WaitParams{
		HTTPClient: client,
	}
}

/*
WaitParams contains all the parameters to send to the API endpoint

	for the wait operation.

	Typically these are written to a http.Request.
*/
type WaitParams struct {

	/* ID.

	   id is the UUID of the operation.
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	/* Timeout.

	     timeout is the duration to wait until timing out and returning.
	The shortest timeout is always used, so if the HTTP/RPC call has a
	shorter timeout then that will be used instead. When the timeout is
	reached, Wait will return with the operation no matter what state it is
	in.
	*/
	Timeout *string

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the wait params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaitParams) WithDefaults() *WaitParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the wait params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaitParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithRequestTimeout adds the timeout to the wait params
func (o *WaitParams) WithRequestTimeout(timeout time.Duration) *WaitParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the wait params
func (o *WaitParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the wait params
func (o *WaitParams) WithContext(ctx context.Context) *WaitParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the wait params
func (o *WaitParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the wait params
func (o *WaitParams) WithHTTPClient(client *http.Client) *WaitParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the wait params
func (o *WaitParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the wait params
func (o *WaitParams) WithID(id string) *WaitParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the wait params
func (o *WaitParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the wait params
func (o *WaitParams) WithLocationOrganizationID(locationOrganizationID string) *WaitParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the wait params
func (o *WaitParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the wait params
func (o *WaitParams) WithLocationProjectID(locationProjectID string) *WaitParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the wait params
func (o *WaitParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the wait params
func (o *WaitParams) WithLocationRegionProvider(locationRegionProvider *string) *WaitParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the wait params
func (o *WaitParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the wait params
func (o *WaitParams) WithLocationRegionRegion(locationRegionRegion *string) *WaitParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the wait params
func (o *WaitParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithTimeout adds the timeout to the wait params
func (o *WaitParams) WithTimeout(timeout *string) *WaitParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the wait params
func (o *WaitParams) SetTimeout(timeout *string) {
	o.Timeout = timeout
}

// WriteToRequest writes these params to a swagger request
func (o *WaitParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout string

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := qrTimeout
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
