// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make app-layers"
// DO NOT EDIT

package opentracing

import (
	"archive/zip"
	"bytes"
	"context"
	"crypto/ecdsa"
	"io"
	"mime/multipart"
	"net/http"
	"net/url"
	"reflect"
	"time"

	"github.com/mattermost/mattermost-server/v6/app"
	"github.com/mattermost/mattermost-server/v6/app/request"
	"github.com/mattermost/mattermost-server/v6/audit"
	"github.com/mattermost/mattermost-server/v6/einterfaces"
	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/plugin"
	"github.com/mattermost/mattermost-server/v6/services/httpservice"
	"github.com/mattermost/mattermost-server/v6/services/imageproxy"
	"github.com/mattermost/mattermost-server/v6/services/remotecluster"
	"github.com/mattermost/mattermost-server/v6/services/searchengine"
	"github.com/mattermost/mattermost-server/v6/services/timezones"
	"github.com/mattermost/mattermost-server/v6/services/tracing"
	"github.com/mattermost/mattermost-server/v6/shared/filestore"
	"github.com/mattermost/mattermost-server/v6/shared/i18n"
	"github.com/mattermost/mattermost-server/v6/shared/mlog"
	"github.com/mattermost/mattermost-server/v6/store"
	"github.com/opentracing/opentracing-go/ext"
	spanlog "github.com/opentracing/opentracing-go/log"
)

type OpenTracingAppLayer struct {
	app app.AppIface

	srv *app.Server

	log              *mlog.Logger
	notificationsLog *mlog.Logger

	accountMigration einterfaces.AccountMigrationInterface
	cluster          einterfaces.ClusterInterface
	compliance       einterfaces.ComplianceInterface
	dataRetention    einterfaces.DataRetentionInterface
	searchEngine     *searchengine.Broker
	ldap             einterfaces.LdapInterface
	messageExport    einterfaces.MessageExportInterface
	metrics          einterfaces.MetricsInterface
	notification     einterfaces.NotificationInterface
	saml             einterfaces.SamlInterface

	httpService httpservice.HTTPService
	imageProxy  *imageproxy.ImageProxy
	timezones   *timezones.Timezones

	ctx context.Context
}

func (a *OpenTracingAppLayer) ActivateMfa(userID string, token string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ActivateMfa")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ActivateMfa(userID, token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddChannelMember(c *request.Context, userID string, channel *model.Channel, opts app.ChannelMemberOpts) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddChannelMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddChannelMember(c, userID, channel, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddChannelsToRetentionPolicy(policyID string, channelIDs []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddChannelsToRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddChannelsToRetentionPolicy(policyID, channelIDs)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddConfigListener(listener func(*model.Config, *model.Config)) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddConfigListener")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddConfigListener(listener)

	return resultVar0
}

func (a *OpenTracingAppLayer) AddCursorIdsForPostList(originalList *model.PostList, afterPost string, beforePost string, since int64, page int, perPage int, collapsedThreads bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddCursorIdsForPostList")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AddCursorIdsForPostList(originalList, afterPost, beforePost, since, page, perPage, collapsedThreads)
}

func (a *OpenTracingAppLayer) AddDirectChannels(teamID string, user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddDirectChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddDirectChannels(teamID, user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddLdapPrivateCertificate(fileData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddLdapPrivateCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddLdapPrivateCertificate(fileData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddLdapPublicCertificate(fileData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddLdapPublicCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddLdapPublicCertificate(fileData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddPublicKey(name string, key io.Reader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddPublicKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddPublicKey(name, key)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddRemoteCluster(rc *model.RemoteCluster) (*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddRemoteCluster")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddRemoteCluster(rc)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddSamlIdpCertificate(fileData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddSamlIdpCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddSamlIdpCertificate(fileData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddSamlPrivateCertificate(fileData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddSamlPrivateCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddSamlPrivateCertificate(fileData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddSamlPublicCertificate(fileData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddSamlPublicCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddSamlPublicCertificate(fileData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddSessionToCache(session *model.Session) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddSessionToCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AddSessionToCache(session)
}

func (a *OpenTracingAppLayer) AddStatusCache(status *model.Status) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddStatusCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AddStatusCache(status)
}

func (a *OpenTracingAppLayer) AddStatusCacheSkipClusterSend(status *model.Status) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddStatusCacheSkipClusterSend")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AddStatusCacheSkipClusterSend(status)
}

func (a *OpenTracingAppLayer) AddTeamMember(c *request.Context, teamID string, userID string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddTeamMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddTeamMember(c, teamID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddTeamMemberByInviteId(c *request.Context, inviteId string, userID string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddTeamMemberByInviteId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddTeamMemberByInviteId(c, inviteId, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddTeamMemberByToken(c *request.Context, userID string, tokenID string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddTeamMemberByToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddTeamMemberByToken(c, userID, tokenID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddTeamMembers(c *request.Context, teamID string, userIDs []string, userRequestorId string, graceful bool) ([]*model.TeamMemberWithError, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddTeamMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddTeamMembers(c, teamID, userIDs, userRequestorId, graceful)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddTeamsToRetentionPolicy(policyID string, teamIDs []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddTeamsToRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddTeamsToRetentionPolicy(policyID, teamIDs)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddUserToChannel(user *model.User, channel *model.Channel, skipTeamMemberIntegrityCheck bool) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddUserToChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AddUserToChannel(user, channel, skipTeamMemberIntegrityCheck)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AddUserToTeam(c *request.Context, teamID string, userID string, userRequestorId string) (*model.Team, *model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddUserToTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.AddUserToTeam(c, teamID, userID, userRequestorId)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) AddUserToTeamByInviteId(c *request.Context, inviteId string, userID string) (*model.Team, *model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddUserToTeamByInviteId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.AddUserToTeamByInviteId(c, inviteId, userID)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) AddUserToTeamByTeamId(c *request.Context, teamID string, user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddUserToTeamByTeamId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AddUserToTeamByTeamId(c, teamID, user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AddUserToTeamByToken(c *request.Context, userID string, tokenID string) (*model.Team, *model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AddUserToTeamByToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.AddUserToTeamByToken(c, userID, tokenID)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) AdjustImage(file io.Reader) (*bytes.Buffer, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AdjustImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AdjustImage(file)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AllowOAuthAppAccessToUser(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AllowOAuthAppAccessToUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AllowOAuthAppAccessToUser(userID, authRequest)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AppendFile(fr io.Reader, path string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AppendFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AppendFile(fr, path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AsymmetricSigningKey() *ecdsa.PrivateKey {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AsymmetricSigningKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AsymmetricSigningKey()

	return resultVar0
}

func (a *OpenTracingAppLayer) AttachCloudSessionCookie(c *request.Context, w http.ResponseWriter, r *http.Request) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AttachCloudSessionCookie")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AttachCloudSessionCookie(c, w, r)
}

func (a *OpenTracingAppLayer) AttachDeviceId(sessionID string, deviceID string, expiresAt int64) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AttachDeviceId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.AttachDeviceId(sessionID, deviceID, expiresAt)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) AttachSessionCookies(c *request.Context, w http.ResponseWriter, r *http.Request) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AttachSessionCookies")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.AttachSessionCookies(c, w, r)
}

func (a *OpenTracingAppLayer) AuthenticateUserForLogin(c *request.Context, id string, loginId string, password string, mfaToken string, cwsToken string, ldapOnly bool) (user *model.User, err *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AuthenticateUserForLogin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AuthenticateUserForLogin(c, id, loginId, password, mfaToken, cwsToken, ldapOnly)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AuthorizeOAuthUser(w http.ResponseWriter, r *http.Request, service string, code string, state string, redirectURI string) (io.ReadCloser, string, map[string]string, *model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AuthorizeOAuthUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2, resultVar3, resultVar4 := a.app.AuthorizeOAuthUser(w, r, service, code, state, redirectURI)

	if resultVar4 != nil {
		span.LogFields(spanlog.Error(resultVar4))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2, resultVar3, resultVar4
}

func (a *OpenTracingAppLayer) AutocompleteChannels(userID string, term string) (model.ChannelListWithTeamData, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AutocompleteChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AutocompleteChannels(userID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AutocompleteChannelsForSearch(teamID string, userID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AutocompleteChannelsForSearch")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AutocompleteChannelsForSearch(teamID, userID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AutocompleteChannelsForTeam(teamID string, userID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AutocompleteChannelsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AutocompleteChannelsForTeam(teamID, userID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AutocompleteUsersInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AutocompleteUsersInChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AutocompleteUsersInChannel(teamID, channelID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) AutocompleteUsersInTeam(teamID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInTeam, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.AutocompleteUsersInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.AutocompleteUsersInTeam(teamID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) BroadcastStatus(status *model.Status) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BroadcastStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.BroadcastStatus(status)
}

func (a *OpenTracingAppLayer) BuildPostReactions(postID string) (*[]app.ReactionImportData, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BuildPostReactions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.BuildPostReactions(postID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) BuildPushNotificationMessage(contentsConfig string, post *model.Post, user *model.User, channel *model.Channel, channelName string, senderName string, explicitMention bool, channelWideMention bool, replyToThreadType string) (*model.PushNotification, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BuildPushNotificationMessage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.BuildPushNotificationMessage(contentsConfig, post, user, channel, channelName, senderName, explicitMention, channelWideMention, replyToThreadType)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) BuildSamlMetadataObject(idpMetadata []byte) (*model.SamlMetadataResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BuildSamlMetadataObject")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.BuildSamlMetadataObject(idpMetadata)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) BulkExport(writer io.Writer, outPath string, opts model.BulkExportOpts) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BulkExport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.BulkExport(writer, outPath, opts)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) BulkImport(c *request.Context, jsonlReader io.Reader, attachmentsReader *zip.Reader, dryRun bool, workers int) (*model.AppError, int) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BulkImport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.BulkImport(c, jsonlReader, attachmentsReader, dryRun, workers)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) BulkImportWithPath(c *request.Context, jsonlReader io.Reader, attachmentsReader *zip.Reader, dryRun bool, workers int, importPath string) (*model.AppError, int) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.BulkImportWithPath")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.BulkImportWithPath(c, jsonlReader, attachmentsReader, dryRun, workers, importPath)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CancelJob(jobId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CancelJob")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CancelJob(jobId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ChannelMembersMinusGroupMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.ChannelMembersMinusGroupMembers(channelID, groupIDs, page, perPage)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) ChannelMembersToAdd(since int64, channelID *string, includeRemovedMembers bool) ([]*model.UserChannelIDPair, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ChannelMembersToAdd")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ChannelMembersToAdd(since, channelID, includeRemovedMembers)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ChannelMembersToRemove(teamID *string) ([]*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ChannelMembersToRemove")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ChannelMembersToRemove(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) Channels() *app.Channels {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.Channels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.Channels()

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckCanInviteToSharedChannel(channelId string) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckCanInviteToSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckCanInviteToSharedChannel(channelId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckForClientSideCert(r *http.Request) (string, string, string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckForClientSideCert")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.CheckForClientSideCert(r)

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) CheckIntegrity() <-chan model.IntegrityCheckResult {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckIntegrity")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckIntegrity()

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckMandatoryS3Fields(settings *model.FileSettings) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckMandatoryS3Fields")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckMandatoryS3Fields(settings)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckPasswordAndAllCriteria(user *model.User, password string, mfaToken string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckPasswordAndAllCriteria")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckPasswordAndAllCriteria(user, password, mfaToken)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckProviderAttributes(user *model.User, patch *model.UserPatch) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckProviderAttributes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckProviderAttributes(user, patch)

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckRolesExist(roleNames []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckRolesExist")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckRolesExist(roleNames)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckUserAllAuthenticationCriteria(user *model.User, mfaToken string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckUserAllAuthenticationCriteria")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckUserAllAuthenticationCriteria(user, mfaToken)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckUserMfa(user *model.User, token string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckUserMfa")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckUserMfa(user, token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckUserPostflightAuthenticationCriteria(user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckUserPostflightAuthenticationCriteria")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckUserPostflightAuthenticationCriteria(user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckUserPreflightAuthenticationCriteria(user *model.User, mfaToken string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckUserPreflightAuthenticationCriteria")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckUserPreflightAuthenticationCriteria(user, mfaToken)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CheckWebConn(userID string, connectionID string) *app.CheckConnResult {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CheckWebConn")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CheckWebConn(userID, connectionID)

	return resultVar0
}

func (a *OpenTracingAppLayer) ClearChannelMembersCache(channelID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearChannelMembersCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearChannelMembersCache(channelID)
}

func (a *OpenTracingAppLayer) ClearLatestVersionCache() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearLatestVersionCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearLatestVersionCache()
}

func (a *OpenTracingAppLayer) ClearSessionCacheForAllUsers() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearSessionCacheForAllUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearSessionCacheForAllUsers()
}

func (a *OpenTracingAppLayer) ClearSessionCacheForAllUsersSkipClusterSend() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearSessionCacheForAllUsersSkipClusterSend")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearSessionCacheForAllUsersSkipClusterSend()
}

func (a *OpenTracingAppLayer) ClearSessionCacheForUser(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearSessionCacheForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearSessionCacheForUser(userID)
}

func (a *OpenTracingAppLayer) ClearSessionCacheForUserSkipClusterSend(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearSessionCacheForUserSkipClusterSend")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearSessionCacheForUserSkipClusterSend(userID)
}

func (a *OpenTracingAppLayer) ClearTeamMembersCache(teamID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClearTeamMembersCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ClearTeamMembersCache(teamID)
}

func (a *OpenTracingAppLayer) ClientConfig() map[string]string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClientConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ClientConfig()

	return resultVar0
}

func (a *OpenTracingAppLayer) ClientConfigHash() string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClientConfigHash")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ClientConfigHash()

	return resultVar0
}

func (a *OpenTracingAppLayer) ClientConfigWithComputed() map[string]string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ClientConfigWithComputed")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ClientConfigWithComputed()

	return resultVar0
}

func (a *OpenTracingAppLayer) Cloud() einterfaces.CloudInterface {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.Cloud")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.Cloud()

	return resultVar0
}

func (a *OpenTracingAppLayer) CompareAndDeletePluginKey(pluginID string, key string, oldValue []byte) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CompareAndDeletePluginKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CompareAndDeletePluginKey(pluginID, key, oldValue)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CompareAndSetPluginKey(pluginID string, key string, oldValue []byte, newValue []byte) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CompareAndSetPluginKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CompareAndSetPluginKey(pluginID, key, oldValue, newValue)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CompleteOAuth(c *request.Context, service string, body io.ReadCloser, teamID string, props map[string]string, tokenUser *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CompleteOAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CompleteOAuth(c, service, body, teamID, props, tokenUser)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CompleteOnboarding(c *request.Context, request *model.CompleteOnboardingRequest) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CompleteOnboarding")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CompleteOnboarding(c, request)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CompleteSwitchWithOAuth(service string, userData io.Reader, email string, tokenUser *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CompleteSwitchWithOAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CompleteSwitchWithOAuth(service, userData, email, tokenUser)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) Config() *model.Config {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.Config")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.Config()

	return resultVar0
}

func (a *OpenTracingAppLayer) ConvertBotToUser(bot *model.Bot, userPatch *model.UserPatch, sysadmin bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ConvertBotToUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ConvertBotToUser(bot, userPatch, sysadmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ConvertUserToBot(user *model.User) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ConvertUserToBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ConvertUserToBot(user)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CopyFileInfos(userID string, fileIDs []string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CopyFileInfos")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CopyFileInfos(userID, fileIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateBot(c *request.Context, bot *model.Bot) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateBot(c, bot)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateChannel(c *request.Context, channel *model.Channel, addMember bool) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateChannel(c, channel, addMember)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateChannelScheme(channel *model.Channel) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateChannelScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateChannelScheme(channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateChannelWithUser(c *request.Context, channel *model.Channel, userID string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateChannelWithUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateChannelWithUser(c, channel, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateCommand(cmd *model.Command) (*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateCommand(cmd)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateCommandPost(c *request.Context, post *model.Post, teamID string, response *model.CommandResponse, skipSlackParsing bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateCommandPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	span.SetTag("teamID", teamID)

	span.SetTag("skipSlackParsing", skipSlackParsing)

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateCommandPost(c, post, teamID, response, skipSlackParsing)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateCommandWebhook(commandID string, args *model.CommandArgs) (*model.CommandWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateCommandWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateCommandWebhook(commandID, args)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateDefaultMemberships(c *request.Context, since int64, includeRemovedMembers bool) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateDefaultMemberships")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CreateDefaultMemberships(c, since, includeRemovedMembers)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) CreateEmoji(sessionUserId string, emoji *model.Emoji, multiPartImageData *multipart.Form) (*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateEmoji")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateEmoji(sessionUserId, emoji, multiPartImageData)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateGroup(group *model.Group) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateGroup(group)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateGroupChannel(userIDs []string, creatorId string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateGroupChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateGroupChannel(userIDs, creatorId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateGroupWithUserIds(group *model.GroupWithUserIds) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateGroupWithUserIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateGroupWithUserIds(group)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateGuest(c *request.Context, user *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateGuest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateGuest(c, user)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateIncomingWebhookForChannel(creatorId string, channel *model.Channel, hook *model.IncomingWebhook) (*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateIncomingWebhookForChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateIncomingWebhookForChannel(creatorId, channel, hook)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateJob(job *model.Job) (*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateJob")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateJob(job)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateOAuthApp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateOAuthApp(app)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateOAuthStateToken(extra string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateOAuthStateToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateOAuthStateToken(extra)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateOAuthUser(c *request.Context, service string, userData io.Reader, teamID string, tokenUser *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateOAuthUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateOAuthUser(c, service, userData, teamID, tokenUser)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateOutgoingWebhook(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateOutgoingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateOutgoingWebhook(hook)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreatePasswordRecoveryToken(userID string, email string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreatePasswordRecoveryToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreatePasswordRecoveryToken(userID, email)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreatePost(c *request.Context, post *model.Post, channel *model.Channel, triggerWebhooks bool, setOnline bool) (savedPost *model.Post, err *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreatePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreatePost(c, post, channel, triggerWebhooks, setOnline)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreatePostAsUser(c *request.Context, post *model.Post, currentSessionId string, setOnline bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreatePostAsUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreatePostAsUser(c, post, currentSessionId, setOnline)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreatePostMissingChannel(c *request.Context, post *model.Post, triggerWebhooks bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreatePostMissingChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreatePostMissingChannel(c, post, triggerWebhooks)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateRetentionPolicy(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateRetentionPolicy(policy)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateRole(role *model.Role) (*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateRole")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateRole(role)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateScheme(scheme *model.Scheme) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateScheme(scheme)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateSession(session *model.Session) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateSession(session)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateSidebarCategory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateSidebarCategory(userID, teamID, newCategory)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateTeam(c *request.Context, team *model.Team) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateTeam(c, team)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateTeamWithUser(c *request.Context, team *model.Team, userID string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateTeamWithUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateTeamWithUser(c, team, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateTermsOfService(text string, userID string) (*model.TermsOfService, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateTermsOfService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateTermsOfService(text, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUploadSession(us *model.UploadSession) (*model.UploadSession, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUploadSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUploadSession(us)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUser(c *request.Context, user *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUser(c, user)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUserAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUserAccessToken(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUserAsAdmin(c *request.Context, user *model.User, redirect string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUserAsAdmin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUserAsAdmin(c, user, redirect)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUserFromSignup(c *request.Context, user *model.User, redirect string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUserFromSignup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUserFromSignup(c, user, redirect)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUserWithInviteId(c *request.Context, user *model.User, inviteId string, redirect string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUserWithInviteId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUserWithInviteId(c, user, inviteId, redirect)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateUserWithToken(c *request.Context, user *model.User, token *model.Token) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateUserWithToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateUserWithToken(c, user, token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateWebhookPost(c *request.Context, userID string, channel *model.Channel, text string, overrideUsername string, overrideIconURL string, overrideIconEmoji string, props model.StringInterface, postType string, postRootId string) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateWebhookPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.CreateWebhookPost(c, userID, channel, text, overrideUsername, overrideIconURL, overrideIconEmoji, props, postType, postRootId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) CreateZipFileAndAddFiles(fileBackend filestore.FileBackend, fileDatas []model.FileData, zipFileName string, directory string) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.CreateZipFileAndAddFiles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.CreateZipFileAndAddFiles(fileBackend, fileDatas, zipFileName, directory)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DBHealthCheckDelete() error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DBHealthCheckDelete")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DBHealthCheckDelete()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DBHealthCheckWrite() error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DBHealthCheckWrite")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DBHealthCheckWrite()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeactivateGuests(c *request.Context) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeactivateGuests")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeactivateGuests(c)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeactivateMfa(userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeactivateMfa")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeactivateMfa(userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeauthorizeOAuthAppForUser(userID string, appID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeauthorizeOAuthAppForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeauthorizeOAuthAppForUser(userID, appID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DefaultChannelNames() []string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DefaultChannelNames")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DefaultChannelNames()

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteAllExpiredPluginKeys() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteAllExpiredPluginKeys")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteAllExpiredPluginKeys()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteAllKeysForPlugin(pluginID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteAllKeysForPlugin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteAllKeysForPlugin(pluginID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteBrandImage() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteBrandImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteBrandImage()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteChannel(c *request.Context, channel *model.Channel, userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteChannel(c, channel, userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteChannelScheme(channel *model.Channel) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteChannelScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteChannelScheme(channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteCommand(commandID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteCommand(commandID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteEmoji(emoji *model.Emoji) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteEmoji")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteEmoji(emoji)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteEphemeralPost(userID string, postID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteEphemeralPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DeleteEphemeralPost(userID, postID)
}

func (a *OpenTracingAppLayer) DeleteExport(name string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteExport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteExport(name)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteGroup(groupID string) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteGroup(groupID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteGroupConstrainedMemberships(c *request.Context) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteGroupConstrainedMemberships")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteGroupConstrainedMemberships(c)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteGroupMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteGroupMember(groupID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteGroupMembers(groupID string, userIDs []string) ([]*model.GroupMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteGroupMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteGroupMembers(groupID, userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteGroupSyncable")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteGroupSyncable(groupID, syncableID, syncableType)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteIncomingWebhook(hookID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteIncomingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteIncomingWebhook(hookID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteOAuthApp(appID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteOAuthApp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteOAuthApp(appID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteOutgoingWebhook(hookID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteOutgoingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteOutgoingWebhook(hookID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeletePluginKey(pluginID string, key string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeletePluginKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeletePluginKey(pluginID, key)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeletePost(postID string, deleteByID string) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeletePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeletePost(postID, deleteByID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeletePreferences(userID string, preferences model.Preferences) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeletePreferences")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeletePreferences(userID, preferences)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeletePublicKey(name string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeletePublicKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeletePublicKey(name)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteReactionForPost(c *request.Context, reaction *model.Reaction) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteReactionForPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteReactionForPost(c, reaction)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteRemoteCluster(remoteClusterId string) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteRemoteCluster")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteRemoteCluster(remoteClusterId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteRetentionPolicy(policyID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteRetentionPolicy(policyID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteScheme(schemeId string) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteScheme(schemeId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteSharedChannel(channelID string) (bool, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteSharedChannel(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteSharedChannelRemote(id string) (bool, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteSharedChannelRemote")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DeleteSharedChannelRemote(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DeleteSidebarCategory(userID string, teamID string, categoryId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteSidebarCategory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteSidebarCategory(userID, teamID, categoryId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DeleteToken(token *model.Token) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DeleteToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DeleteToken(token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DemoteUserToGuest(user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DemoteUserToGuest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DemoteUserToGuest(user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DisableAutoResponder(userID string, asAdmin bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DisableAutoResponder")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DisableAutoResponder(userID, asAdmin)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DisablePlugin(id string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DisablePlugin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DisablePlugin(id)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DisableUserAccessToken(token *model.UserAccessToken) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DisableUserAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DisableUserAccessToken(token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DoActionRequest(c *request.Context, rawURL string, body []byte) (*http.Response, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoActionRequest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DoActionRequest(c, rawURL, body)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DoAdvancedPermissionsMigration() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoAdvancedPermissionsMigration")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DoAdvancedPermissionsMigration()
}

func (a *OpenTracingAppLayer) DoAppMigrations() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoAppMigrations")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DoAppMigrations()
}

func (a *OpenTracingAppLayer) DoCommandRequest(cmd *model.Command, p url.Values) (*model.Command, *model.CommandResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoCommandRequest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.DoCommandRequest(cmd, p)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) DoEmojisPermissionsMigration() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoEmojisPermissionsMigration")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DoEmojisPermissionsMigration()
}

func (a *OpenTracingAppLayer) DoGuestRolesCreationMigration() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoGuestRolesCreationMigration")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DoGuestRolesCreationMigration()
}

func (a *OpenTracingAppLayer) DoLocalRequest(c *request.Context, rawURL string, body []byte) (*http.Response, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoLocalRequest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DoLocalRequest(c, rawURL, body)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DoLogin(c *request.Context, w http.ResponseWriter, r *http.Request, user *model.User, deviceID string, isMobile bool, isOAuthUser bool, isSaml bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoLogin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DoLogin(c, w, r, user, deviceID, isMobile, isOAuthUser, isSaml)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DoPermissionsMigrations() error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoPermissionsMigrations")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DoPermissionsMigrations()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DoPostAction(c *request.Context, postID string, actionId string, userID string, selectedOption string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoPostAction")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DoPostAction(c, postID, actionId, userID, selectedOption)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DoPostActionWithCookie(c *request.Context, postID string, actionId string, userID string, selectedOption string, cookie *model.PostActionCookie) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoPostActionWithCookie")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DoPostActionWithCookie(c, postID, actionId, userID, selectedOption, cookie)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DoSystemConsoleRolesCreationMigration() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoSystemConsoleRolesCreationMigration")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.DoSystemConsoleRolesCreationMigration()
}

func (a *OpenTracingAppLayer) DoUploadFile(c *request.Context, now time.Time, rawTeamId string, rawChannelId string, rawUserId string, rawFilename string, data []byte) (*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoUploadFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DoUploadFile(c, now, rawTeamId, rawChannelId, rawUserId, rawFilename, data)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) DoUploadFileExpectModification(c *request.Context, now time.Time, rawTeamId string, rawChannelId string, rawUserId string, rawFilename string, data []byte) (*model.FileInfo, []byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoUploadFileExpectModification")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.DoUploadFileExpectModification(c, now, rawTeamId, rawChannelId, rawUserId, rawFilename, data)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) DoubleCheckPassword(user *model.User, password string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DoubleCheckPassword")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.DoubleCheckPassword(user, password)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) DownloadFromURL(downloadURL string) ([]byte, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.DownloadFromURL")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.DownloadFromURL(downloadURL)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) EnablePlugin(id string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.EnablePlugin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.EnablePlugin(id)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) EnableUserAccessToken(token *model.UserAccessToken) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.EnableUserAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.EnableUserAccessToken(token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) EnvironmentConfig(filter func(reflect.StructField) bool) map[string]interface{} {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.EnvironmentConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.EnvironmentConfig(filter)

	return resultVar0
}

func (a *OpenTracingAppLayer) ExecuteCommand(c *request.Context, args *model.CommandArgs) (*model.CommandResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ExecuteCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	span.SetTag("args", args)

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ExecuteCommand(c, args)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ExportPermissions(w io.Writer) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ExportPermissions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ExportPermissions(w)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ExtendSessionExpiryIfNeeded(session *model.Session) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ExtendSessionExpiryIfNeeded")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ExtendSessionExpiryIfNeeded(session)

	return resultVar0
}

func (a *OpenTracingAppLayer) ExtractContentFromFileInfo(fileInfo *model.FileInfo) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ExtractContentFromFileInfo")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ExtractContentFromFileInfo(fileInfo)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) FetchSamlMetadataFromIdp(url string) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FetchSamlMetadataFromIdp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FetchSamlMetadataFromIdp(url)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FileBackend() filestore.FileBackend {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FileBackend")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.FileBackend()

	return resultVar0
}

func (a *OpenTracingAppLayer) FileExists(path string) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FileExists")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FileExists(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FileModTime(path string) (time.Time, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FileModTime")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FileModTime(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FileReader(path string) (filestore.ReadCloseSeeker, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FileReader")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FileReader(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FileSize(path string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FileSize")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FileSize(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FillInChannelProps(channel *model.Channel) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FillInChannelProps")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.FillInChannelProps(channel)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) FillInChannelsProps(channelList model.ChannelList) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FillInChannelsProps")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.FillInChannelsProps(channelList)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) FillInPostProps(post *model.Post, channel *model.Channel) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FillInPostProps")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.FillInPostProps(post, channel)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) FilterNonGroupChannelMembers(userIDs []string, channel *model.Channel) ([]string, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FilterNonGroupChannelMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FilterNonGroupChannelMembers(userIDs, channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FilterNonGroupTeamMembers(userIDs []string, team *model.Team) ([]string, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FilterNonGroupTeamMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FilterNonGroupTeamMembers(userIDs, team)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FilterUsersByVisible(viewer *model.User, otherUsers []*model.User) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FilterUsersByVisible")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.FilterUsersByVisible(viewer, otherUsers)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) FindTeamByName(name string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.FindTeamByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.FindTeamByName(name)

	return resultVar0
}

func (a *OpenTracingAppLayer) GenerateMfaSecret(userID string) (*model.MfaSecret, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GenerateMfaSecret")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GenerateMfaSecret(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GeneratePublicLink(siteURL string, info *model.FileInfo) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GeneratePublicLink")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GeneratePublicLink(siteURL, info)

	return resultVar0
}

func (a *OpenTracingAppLayer) GenerateSupportPacket() []model.FileData {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GenerateSupportPacket")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GenerateSupportPacket()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetActivePluginManifests() ([]*model.Manifest, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetActivePluginManifests")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetActivePluginManifests()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllChannels(page int, perPage int, opts model.ChannelSearchOpts) (model.ChannelListWithTeamData, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllChannels(page, perPage, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllChannelsCount(opts model.ChannelSearchOpts) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllChannelsCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllChannelsCount(opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllLdapGroupsPage(page int, perPage int, opts model.LdapGroupSearchOpts) ([]*model.Group, int, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllLdapGroupsPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetAllLdapGroupsPage(page, perPage, opts)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetAllPrivateTeams() ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllPrivateTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllPrivateTeams()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllPublicTeams() ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllPublicTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllPublicTeams()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllRemoteClusters(filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllRemoteClusters")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllRemoteClusters(filter)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllRoles() ([]*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllRoles()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllStatuses() map[string]*model.Status {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllStatuses")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetAllStatuses()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetAllTeams() ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllTeams()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllTeamsPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllTeamsPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllTeamsPage(offset, limit, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAllTeamsPageWithCount(offset int, limit int, opts *model.TeamSearch) (*model.TeamsWithCount, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAllTeamsPageWithCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAllTeamsPageWithCount(offset, limit, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAnalytics(name string, teamID string) (model.AnalyticsRows, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAnalytics")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAnalytics(name, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAppliedSchemaMigrations() ([]model.AppliedMigration, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAppliedSchemaMigrations")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAppliedSchemaMigrations()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAudits(userID string, limit int) (model.Audits, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAudits")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAudits(userID, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAuditsPage(userID string, page int, perPage int) (model.Audits, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAuditsPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAuditsPage(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAuthorizationCode(w http.ResponseWriter, r *http.Request, service string, props map[string]string, loginHint string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAuthorizationCode")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAuthorizationCode(w, r, service, props, loginHint)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetAuthorizedAppsForUser(userID string, page int, perPage int) ([]*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetAuthorizedAppsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetAuthorizedAppsForUser(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetBot(botUserId, includeDeleted)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetBots(options *model.BotGetOptions) (model.BotList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetBots")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetBots(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetBrandImage() ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetBrandImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetBrandImage()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetBulkReactionsForPosts(postIDs []string) (map[string][]*model.Reaction, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetBulkReactionsForPosts")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetBulkReactionsForPosts(postIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannel(channelID string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannel(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelByName(channelName string, teamID string, includeDeleted bool) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelByName(channelName, teamID, includeDeleted)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelByNameForTeamName(channelName string, teamName string, includeDeleted bool) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelByNameForTeamName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelByNameForTeamName(channelName, teamName, includeDeleted)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelCounts")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelCounts(teamID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelFileCount(channelID string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelFileCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelFileCount(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelGroupUsers(channelID string) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelGroupUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelGroupUsers(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelGuestCount(channelID string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelGuestCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelGuestCount(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMember(ctx, channelID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMemberCount(channelID string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMemberCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMemberCount(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersByIds(channelID string, userIDs []string) (model.ChannelMembers, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersByIds(channelID, userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersForUser(teamID string, userID string) (model.ChannelMembers, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersForUser(teamID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersForUserWithPagination(userID string, page int, perPage int) ([]*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersForUserWithPagination")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersForUserWithPagination(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersPage(channelID string, page int, perPage int) (model.ChannelMembers, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersPage(channelID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersTimezones(channelID string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersTimezones")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersTimezones(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelMembersWithTeamDataForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelMembersWithTeamDataForUserWithPagination")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelMembersWithTeamDataForUserWithPagination(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelModerationsForChannel(channel *model.Channel) ([]*model.ChannelModeration, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelModerationsForChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelModerationsForChannel(channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelPinnedPostCount(channelID string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelPinnedPostCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelPinnedPostCount(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelPoliciesForUser(userID string, offset int, limit int) (*model.RetentionPolicyForChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelPoliciesForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelPoliciesForUser(userID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelUnread")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelUnread(channelID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannels(channelIDs []string) ([]*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannels(channelIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsByNames(channelNames []string, teamID string) ([]*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsByNames")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsByNames(channelNames, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForRetentionPolicy(policyID string, offset int, limit int) (*model.ChannelsWithCount, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForRetentionPolicy(policyID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForScheme(scheme *model.Scheme, offset int, limit int) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForScheme(scheme, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForSchemePage(scheme *model.Scheme, page int, perPage int) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForSchemePage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForSchemePage(scheme, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForTeamForUser(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForTeamForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForTeamForUser(teamID, userID, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForTeamForUserWithCursor(teamID string, userID string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForTeamForUserWithCursor")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForTeamForUserWithCursor(teamID, userID, opts, afterChannelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsForUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsForUser(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetChannelsUserNotIn(teamID string, userID string, offset int, limit int) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetChannelsUserNotIn")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetChannelsUserNotIn(teamID, userID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetCloudSession(token string) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetCloudSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetCloudSession(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetClusterId() string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetClusterId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetClusterId()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetClusterPluginStatuses() (model.PluginStatuses, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetClusterPluginStatuses")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetClusterPluginStatuses()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetClusterStatus() []*model.ClusterInfo {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetClusterStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetClusterStatus()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetCommand(commandID string) (*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetCommand(commandID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetCommonTeamIDsForTwoUsers(userID string, otherUserID string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetCommonTeamIDsForTwoUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetCommonTeamIDsForTwoUsers(userID, otherUserID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetComplianceFile(job *model.Compliance) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetComplianceFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetComplianceFile(job)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetComplianceReport(reportId string) (*model.Compliance, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetComplianceReport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetComplianceReport(reportId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetComplianceReports(page int, perPage int) (model.Compliances, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetComplianceReports")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetComplianceReports(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetConfigFile(name string) ([]byte, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetConfigFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetConfigFile(name)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetCookieDomain() string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetCookieDomain")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetCookieDomain()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetCustomStatus(userID string) (*model.CustomStatus, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetCustomStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetCustomStatus(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetDefaultProfileImage(user *model.User) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetDefaultProfileImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetDefaultProfileImage(user)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetDeletedChannels(teamID string, offset int, limit int, userID string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetDeletedChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetDeletedChannels(teamID, offset, limit, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetEmoji(emojiId string) (*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEmoji")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetEmoji(emojiId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetEmojiByName(emojiName string) (*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEmojiByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetEmojiByName(emojiName)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetEmojiImage(emojiId string) ([]byte, string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEmojiImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetEmojiImage(emojiId)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetEmojiList(page int, perPage int, sort string) ([]*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEmojiList")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetEmojiList(page, perPage, sort)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetEmojiStaticURL(emojiName string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEmojiStaticURL")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetEmojiStaticURL(emojiName)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetEnvironmentConfig(filter func(reflect.StructField) bool) map[string]interface{} {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetEnvironmentConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetEnvironmentConfig(filter)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetFile(fileID string) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFile(fileID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFileInfo(fileID string) (*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFileInfo")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFileInfo(fileID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFileInfos(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFileInfos")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFileInfos(page, perPage, opt)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFileInfosForPost(postID string, fromMaster bool) ([]*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFileInfosForPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFileInfosForPost(postID, fromMaster)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFileInfosForPostWithMigration(postID string) ([]*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFileInfosForPostWithMigration")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFileInfosForPostWithMigration(postID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFilteredUsersStats(options *model.UserCountOptions) (*model.UsersStats, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFilteredUsersStats")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFilteredUsersStats(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFlaggedPosts")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFlaggedPosts(userID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFlaggedPostsForChannel(userID string, channelID string, offset int, limit int) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFlaggedPostsForChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFlaggedPostsForChannel(userID, channelID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetFlaggedPostsForTeam(userID string, teamID string, offset int, limit int) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetFlaggedPostsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetFlaggedPostsForTeam(userID, teamID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGlobalRetentionPolicy() (*model.GlobalRetentionPolicy, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGlobalRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGlobalRetentionPolicy()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroup(id string, opts *model.GetGroupOpts) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroup(id, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupByName(name string, opts model.GroupSearchOpts) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupByName(name, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupByRemoteID")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupByRemoteID(remoteID, groupSource)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupChannel(userIDs []string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupChannel(userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupMemberCount(groupID string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupMemberCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupMemberCount(groupID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupMemberUsers(groupID string) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupMemberUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupMemberUsers(groupID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, int, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupMemberUsersPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetGroupMemberUsersPage(groupID, page, perPage)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupSyncable")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupSyncable(groupID, syncableID, syncableType)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupSyncables(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupSyncables")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupSyncables(groupID, syncableType)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroups(page int, perPage int, opts model.GroupSearchOpts) ([]*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroups")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroups(page, perPage, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsAssociatedToChannelsByTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupsAssociatedToChannelsByTeam(teamID, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsByChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetGroupsByChannel(channelID, opts)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetGroupsByIDs(groupIDs []string) ([]*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsByIDs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupsByIDs(groupIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsBySource")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupsBySource(groupSource)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsByTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetGroupsByTeam(teamID, opts)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetGroupsByUserId(userID string) ([]*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetGroupsByUserId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetGroupsByUserId(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetHubForUserId(userID string) *app.Hub {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetHubForUserId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetHubForUserId(userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetIncomingWebhook(hookID string) (*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetIncomingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetIncomingWebhook(hookID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetIncomingWebhooksForTeamPage(teamID string, page int, perPage int) ([]*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetIncomingWebhooksForTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetIncomingWebhooksForTeamPage(teamID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetIncomingWebhooksForTeamPageByUser(teamID string, userID string, page int, perPage int) ([]*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetIncomingWebhooksForTeamPageByUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetIncomingWebhooksForTeamPageByUser(teamID, userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetIncomingWebhooksPage(page int, perPage int) ([]*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetIncomingWebhooksPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetIncomingWebhooksPage(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetIncomingWebhooksPageByUser(userID string, page int, perPage int) ([]*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetIncomingWebhooksPageByUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetIncomingWebhooksPageByUser(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJob(id string) (*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJob")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJob(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobs(offset int, limit int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobs(offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobsByType(jobType string, offset int, limit int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobsByType")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobsByType(jobType, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobsByTypePage(jobType string, page int, perPage int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobsByTypePage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobsByTypePage(jobType, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobsByTypes(jobTypes []string, offset int, limit int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobsByTypes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobsByTypes(jobTypes, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobsByTypesPage(jobType []string, page int, perPage int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobsByTypesPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobsByTypesPage(jobType, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetJobsPage(page int, perPage int) ([]*model.Job, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetJobsPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetJobsPage(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetKnownUsers(userID string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetKnownUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetKnownUsers(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetLatestTermsOfService() (*model.TermsOfService, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetLatestTermsOfService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetLatestTermsOfService()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetLatestVersion(latestVersionUrl string) (*model.GithubReleaseInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetLatestVersion")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetLatestVersion(latestVersionUrl)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetLdapGroup(ldapGroupID string) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetLdapGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetLdapGroup(ldapGroupID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetLogs(page int, perPage int) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetLogs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetLogs(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetLogsSkipSend(page int, perPage int) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetLogsSkipSend")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetLogsSkipSend(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetMarketplacePlugins(filter *model.MarketplacePluginFilter) ([]*model.MarketplacePlugin, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetMarketplacePlugins")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetMarketplacePlugins(filter)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetMemberCountsByGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetMemberCountsByGroup(ctx, channelID, includeTimezones)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetMessageForNotification(post *model.Post, translateFunc i18n.TranslateFunc) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetMessageForNotification")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetMessageForNotification(post, translateFunc)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetMultipleEmojiByName(names []string) ([]*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetMultipleEmojiByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetMultipleEmojiByName(names)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetNewUsersForTeamPage(teamID string, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetNewUsersForTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetNewUsersForTeamPage(teamID, page, perPage, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetNextPostIdFromPostList(postList *model.PostList, collapsedThreads bool) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetNextPostIdFromPostList")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetNextPostIdFromPostList(postList, collapsedThreads)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetNotificationNameFormat(user *model.User) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetNotificationNameFormat")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetNotificationNameFormat(user)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetNumberOfChannelsOnTeam(teamID string) (int, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetNumberOfChannelsOnTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetNumberOfChannelsOnTeam(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthAccessTokenForCodeFlow(clientId string, grantType string, redirectURI string, code string, secret string, refreshToken string) (*model.AccessResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthAccessTokenForCodeFlow")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthAccessTokenForCodeFlow(clientId, grantType, redirectURI, code, secret, refreshToken)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthAccessTokenForImplicitFlow(userID string, authRequest *model.AuthorizeRequest) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthAccessTokenForImplicitFlow")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthAccessTokenForImplicitFlow(userID, authRequest)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthApp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthApp(appID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthApps(page int, perPage int) ([]*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthApps")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthApps(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthAppsByCreator(userID string, page int, perPage int) ([]*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthAppsByCreator")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthAppsByCreator(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthCodeRedirect(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthCodeRedirect")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthCodeRedirect(userID, authRequest)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthImplicitRedirect(userID string, authRequest *model.AuthorizeRequest) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthImplicitRedirect")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthImplicitRedirect(userID, authRequest)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthLoginEndpoint(w http.ResponseWriter, r *http.Request, service string, teamID string, action string, redirectTo string, loginHint string, isMobile bool) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthLoginEndpoint")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthLoginEndpoint(w, r, service, teamID, action, redirectTo, loginHint, isMobile)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthSignupEndpoint(w http.ResponseWriter, r *http.Request, service string, teamID string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthSignupEndpoint")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthSignupEndpoint(w, r, service, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOAuthStateToken(token string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOAuthStateToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOAuthStateToken(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOnboarding() (*model.System, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOnboarding")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOnboarding()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOpenGraphMetadata(requestURL string) ([]byte, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOpenGraphMetadata")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOpenGraphMetadata(requestURL)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOrCreateDirectChannel(c *request.Context, userID string, otherUserID string, channelOptions ...model.ChannelOption) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOrCreateDirectChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOrCreateDirectChannel(c, userID, otherUserID, channelOptions...)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhook(hookID string) (*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhook(hookID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhooksForChannelPageByUser(channelID string, userID string, page int, perPage int) ([]*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhooksForChannelPageByUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhooksForChannelPageByUser(channelID, userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhooksForTeamPage(teamID string, page int, perPage int) ([]*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhooksForTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhooksForTeamPage(teamID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhooksForTeamPageByUser(teamID string, userID string, page int, perPage int) ([]*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhooksForTeamPageByUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhooksForTeamPageByUser(teamID, userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhooksPage(page int, perPage int) ([]*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhooksPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhooksPage(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetOutgoingWebhooksPageByUser(userID string, page int, perPage int) ([]*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetOutgoingWebhooksPageByUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetOutgoingWebhooksPageByUser(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPasswordRecoveryToken(token string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPasswordRecoveryToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPasswordRecoveryToken(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPermalinkPost(c *request.Context, postID string, userID string) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPermalinkPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPermalinkPost(c, postID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPinnedPosts(channelID string) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPinnedPosts")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPinnedPosts(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPluginKey(pluginID string, key string) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPluginKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPluginKey(pluginID, key)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPluginStatus(id string) (*model.PluginStatus, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPluginStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPluginStatus(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPluginStatuses() (model.PluginStatuses, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPluginStatuses")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPluginStatuses()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPlugins() (*model.PluginsResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPlugins")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPlugins()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPluginsEnvironment() *plugin.Environment {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPluginsEnvironment")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetPluginsEnvironment()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetPostAfterTime(channelID string, time int64, collapsedThreads bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostAfterTime")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostAfterTime(channelID, time, collapsedThreads)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostIdAfterTime(channelID string, time int64, collapsedThreads bool) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostIdAfterTime")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostIdAfterTime(channelID, time, collapsedThreads)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostIdBeforeTime(channelID string, time int64, collapsedThreads bool) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostIdBeforeTime")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostIdBeforeTime(channelID, time, collapsedThreads)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostIfAuthorized(postID string, session *model.Session) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostIfAuthorized")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostIfAuthorized(postID, session)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostThread(postID string, opts model.GetPostsOptions, userID string) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostThread")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostThread(postID, opts, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPosts(channelID string, offset int, limit int) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPosts")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPosts(channelID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsAfterPost(options model.GetPostsOptions) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsAfterPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsAfterPost(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsAroundPost(before bool, options model.GetPostsOptions) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsAroundPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsAroundPost(before, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsBeforePost(options model.GetPostsOptions) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsBeforePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsBeforePost(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsByIds(postIDs []string) ([]*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsByIds(postIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsEtag(channelID string, collapsedThreads bool) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsEtag")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetPostsEtag(channelID, collapsedThreads)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetPostsForChannelAroundLastUnread(channelID string, userID string, limitBefore int, limitAfter int, skipFetchThreads bool, collapsedThreads bool, collapsedThreadsExtended bool) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsForChannelAroundLastUnread")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsForChannelAroundLastUnread(channelID, userID, limitBefore, limitAfter, skipFetchThreads, collapsedThreads, collapsedThreadsExtended)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsPage(options model.GetPostsOptions) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsPage(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPostsSince(options model.GetPostsSinceOptions) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPostsSince")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPostsSince(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPreferenceByCategoryAndNameForUser(userID string, category string, preferenceName string) (*model.Preference, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPreferenceByCategoryAndNameForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPreferenceByCategoryAndNameForUser(userID, category, preferenceName)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPreferenceByCategoryForUser(userID string, category string) (model.Preferences, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPreferenceByCategoryForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPreferenceByCategoryForUser(userID, category)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPreferencesForUser(userID string) (model.Preferences, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPreferencesForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPreferencesForUser(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPrevPostIdFromPostList(postList *model.PostList, collapsedThreads bool) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPrevPostIdFromPostList")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetPrevPostIdFromPostList(postList, collapsedThreads)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPrivateChannelsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPrivateChannelsForTeam(teamID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetProductNotices(c *request.Context, userID string, teamID string, client model.NoticeClientType, clientVersion string, locale string) (model.NoticeMessages, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetProductNotices")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetProductNotices(c, userID, teamID, client, clientVersion, locale)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetProfileImage(user *model.User) ([]byte, bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetProfileImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.GetProfileImage(user)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) GetPublicChannelsByIdsForTeam(teamID string, channelIDs []string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPublicChannelsByIdsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPublicChannelsByIdsForTeam(teamID, channelIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPublicChannelsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPublicChannelsForTeam(teamID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetPublicKey(name string) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetPublicKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetPublicKey(name)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetReactionsForPost(postID string) ([]*model.Reaction, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetReactionsForPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetReactionsForPost(postID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRecentlyActiveUsersForTeam(teamID string) (map[string]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRecentlyActiveUsersForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRecentlyActiveUsersForTeam(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRecentlyActiveUsersForTeamPage(teamID string, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRecentlyActiveUsersForTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRecentlyActiveUsersForTeamPage(teamID, page, perPage, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRemoteCluster(remoteClusterId string) (*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRemoteCluster")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRemoteCluster(remoteClusterId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRemoteClusterForUser(remoteID string, userID string) (*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRemoteClusterForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRemoteClusterForUser(remoteID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRemoteClusterService() (remotecluster.RemoteClusterServiceIFace, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRemoteClusterService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRemoteClusterService()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRemoteClusterSession(token string, remoteId string) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRemoteClusterSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRemoteClusterSession(token, remoteId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRetentionPolicies(offset int, limit int) (*model.RetentionPolicyWithTeamAndChannelCountsList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRetentionPolicies")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRetentionPolicies(offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRetentionPoliciesCount() (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRetentionPoliciesCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRetentionPoliciesCount()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRetentionPolicy(policyID string) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRetentionPolicy(policyID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRole(id string) (*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRole")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRole(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRoleByName(ctx context.Context, name string) (*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRoleByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRoleByName(ctx, name)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetRolesByNames(names []string) ([]*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetRolesByNames")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetRolesByNames(names)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSamlCertificateStatus() *model.SamlCertificateStatus {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSamlCertificateStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSamlCertificateStatus()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetSamlMetadata() (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSamlMetadata")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSamlMetadata()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSamlMetadataFromIdp(idpMetadataURL string) (*model.SamlMetadataResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSamlMetadataFromIdp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSamlMetadataFromIdp(idpMetadataURL)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSanitizeOptions(asAdmin bool) map[string]bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSanitizeOptions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSanitizeOptions(asAdmin)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetSanitizedConfig() *model.Config {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSanitizedConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSanitizedConfig()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetScheme(id string) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetScheme(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSchemeByName(name string) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSchemeByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSchemeByName(name)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSchemeRolesForChannel(channelID string) (guestRoleName string, userRoleName string, adminRoleName string, err *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSchemeRolesForChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2, resultVar3 := a.app.GetSchemeRolesForChannel(channelID)

	if resultVar3 != nil {
		span.LogFields(spanlog.Error(resultVar3))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2, resultVar3
}

func (a *OpenTracingAppLayer) GetSchemeRolesForTeam(teamID string) (string, string, string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSchemeRolesForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2, resultVar3 := a.app.GetSchemeRolesForTeam(teamID)

	if resultVar3 != nil {
		span.LogFields(spanlog.Error(resultVar3))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2, resultVar3
}

func (a *OpenTracingAppLayer) GetSchemes(scope string, offset int, limit int) ([]*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSchemes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSchemes(scope, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSchemesPage(scope string, page int, perPage int) ([]*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSchemesPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSchemesPage(scope, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSession(token string) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSession(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSessionById(sessionID string) (*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSessionById")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSessionById(sessionID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSessionLengthInMillis(session *model.Session) int64 {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSessionLengthInMillis")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSessionLengthInMillis(session)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetSessions(userID string) ([]*model.Session, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSessions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSessions(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannel(channelID string) (*model.SharedChannel, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannel(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannelRemote(id string) (*model.SharedChannelRemote, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannelRemote")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannelRemote(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannelRemoteByIds(channelID string, remoteID string) (*model.SharedChannelRemote, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannelRemoteByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannelRemoteByIds(channelID, remoteID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannelRemotes(opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannelRemotes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannelRemotes(opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannelRemotesStatus(channelID string) ([]*model.SharedChannelRemoteStatus, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannelRemotesStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannelRemotesStatus(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannels(page int, perPage int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannels(page, perPage, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSharedChannelsCount(opts model.SharedChannelFilterOpts) (int64, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSharedChannelsCount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSharedChannelsCount(opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSidebarCategories")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSidebarCategories(userID, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSidebarCategory(categoryId string) (*model.SidebarCategoryWithChannels, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSidebarCategory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSidebarCategory(categoryId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSidebarCategoryOrder(userID string, teamID string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSidebarCategoryOrder")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSidebarCategoryOrder(userID, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSinglePost(postID string) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSinglePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSinglePost(postID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSiteURL() string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSiteURL")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSiteURL()

	return resultVar0
}

func (a *OpenTracingAppLayer) GetStatus(userID string) (*model.Status, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetStatus(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetStatusFromCache(userID string) *model.Status {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetStatusFromCache")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetStatusFromCache(userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetStatusesByIds(userIDs []string) (map[string]interface{}, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetStatusesByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetStatusesByIds(userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetSuggestions(c *request.Context, commandArgs *model.CommandArgs, commands []*model.Command, roleID string) []model.AutocompleteSuggestion {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSuggestions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetSuggestions(c, commandArgs, commands, roleID)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetSystemBot() (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetSystemBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetSystemBot()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeam(teamID string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeam(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamByInviteId(inviteId string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamByInviteId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamByInviteId(inviteId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamByName(name string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamByName")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamByName(name)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamGroupUsers(teamID string) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamGroupUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamGroupUsers(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamIcon(team *model.Team) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamIcon")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamIcon(team)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamIdFromQuery(query url.Values) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamIdFromQuery")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamIdFromQuery(query)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamMember(teamID string, userID string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamMember(teamID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamMembers(teamID, offset, limit, teamMembersGetOptions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamMembersByIds(teamID string, userIDs []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamMembersByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamMembersByIds(teamID, userIDs, restrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamMembersForUser(userID string) ([]*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamMembersForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamMembersForUser(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamMembersForUserWithPagination(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamMembersForUserWithPagination")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamMembersForUserWithPagination(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamPoliciesForUser(userID string, offset int, limit int) (*model.RetentionPolicyForTeamList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamPoliciesForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamPoliciesForUser(userID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamSchemeChannelRoles(teamID string) (guestRoleName string, userRoleName string, adminRoleName string, err *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamSchemeChannelRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2, resultVar3 := a.app.GetTeamSchemeChannelRoles(teamID)

	if resultVar3 != nil {
		span.LogFields(spanlog.Error(resultVar3))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2, resultVar3
}

func (a *OpenTracingAppLayer) GetTeamStats(teamID string, restrictions *model.ViewUsersRestrictions) (*model.TeamStats, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamStats")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamStats(teamID, restrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamUnread(teamID string, userID string) (*model.TeamUnread, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamUnread")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamUnread(teamID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeams(teamIDs []string) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeams(teamIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamsForRetentionPolicy(policyID string, offset int, limit int) (*model.TeamsWithCount, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamsForRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamsForRetentionPolicy(policyID, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamsForScheme(scheme *model.Scheme, offset int, limit int) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamsForScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamsForScheme(scheme, offset, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamsForSchemePage(scheme *model.Scheme, page int, perPage int) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamsForSchemePage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamsForSchemePage(scheme, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamsForUser(userID string) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamsForUser(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTeamsUnreadForUser(excludeTeamId string, userID string, includeCollapsedThreads bool) ([]*model.TeamUnread, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTeamsUnreadForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTeamsUnreadForUser(excludeTeamId, userID, includeCollapsedThreads)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTermsOfService(id string) (*model.TermsOfService, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTermsOfService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTermsOfService(id)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetThreadForUser(teamID string, threadMembership *model.ThreadMembership, extended bool) (*model.ThreadResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetThreadForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetThreadForUser(teamID, threadMembership, extended)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetThreadMembershipForUser(userId string, threadId string) (*model.ThreadMembership, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetThreadMembershipForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetThreadMembershipForUser(userId, threadId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetThreadMembershipsForUser(userID string, teamID string) ([]*model.ThreadMembership, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetThreadMembershipsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetThreadMembershipsForUser(userID, teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetThreadsForUser(userID string, teamID string, options model.GetUserThreadsOpts) (*model.Threads, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetThreadsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetThreadsForUser(userID, teamID, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTokenById(token string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTokenById")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTokenById(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTopReactionsForTeamSince(teamID string, userID string, opts *model.InsightsOpts) (*model.TopReactionList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTopReactionsForTeamSince")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTopReactionsForTeamSince(teamID, userID, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTopReactionsForUserSince(userID string, teamID string, opts *model.InsightsOpts) (*model.TopReactionList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTopReactionsForUserSince")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTopReactionsForUserSince(userID, teamID, opts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetTotalUsersStats(viewRestrictions *model.ViewUsersRestrictions) (*model.UsersStats, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetTotalUsersStats")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetTotalUsersStats(viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUploadSession(uploadId string) (*model.UploadSession, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUploadSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUploadSession(uploadId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUploadSessionsForUser(userID string) ([]*model.UploadSession, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUploadSessionsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUploadSessionsForUser(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUser(userID string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUser(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserAccessToken(tokenID string, sanitize bool) (*model.UserAccessToken, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserAccessToken(tokenID, sanitize)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserAccessTokens(page int, perPage int) ([]*model.UserAccessToken, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserAccessTokens")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserAccessTokens(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserAccessTokensForUser(userID string, page int, perPage int) ([]*model.UserAccessToken, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserAccessTokensForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserAccessTokensForUser(userID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserByAuth(authData *string, authService string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserByAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserByAuth(authData, authService)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserByEmail(email string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserByEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserByEmail(email)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserByUsername(username string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserByUsername")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserByUsername(username)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserForLogin(id string, loginId string) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserForLogin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserForLogin(id, loginId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserStatusesByIds(userIDs []string) ([]*model.Status, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserStatusesByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserStatusesByIds(userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUserTermsOfService(userID string) (*model.UserTermsOfService, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUserTermsOfService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUserTermsOfService(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsers(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersByGroupChannelIds(c *request.Context, channelIDs []string, asAdmin bool) (map[string][]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersByGroupChannelIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersByGroupChannelIds(c, channelIDs, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersByIds(userIDs []string, options *store.UserGetByIdsOpts) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersByIds")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersByIds(userIDs, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersByUsernames(usernames []string, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersByUsernames")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersByUsernames(usernames, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersEtag(restrictionsHash string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersEtag")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetUsersEtag(restrictionsHash)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetUsersInChannel(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInChannel(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInChannelByStatus(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInChannelByStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInChannelByStatus(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInChannelMap(options *model.UserGetOptions, asAdmin bool) (map[string]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInChannelMap")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInChannelMap(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInChannelPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInChannelPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInChannelPage(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInChannelPageByStatus(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInChannelPageByStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInChannelPageByStatus(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInTeam(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInTeam(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersInTeamEtag(teamID string, restrictionsHash string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInTeamEtag")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetUsersInTeamEtag(teamID, restrictionsHash)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetUsersInTeamPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersInTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersInTeamPage(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInChannel(teamID string, channelID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInChannel(teamID, channelID, groupConstrained, offset, limit, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInChannelMap(teamID string, channelID string, groupConstrained bool, offset int, limit int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) (map[string]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInChannelMap")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInChannelMap(teamID, channelID, groupConstrained, offset, limit, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInChannelPage(teamID string, channelID string, groupConstrained bool, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInChannelPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInChannelPage(teamID, channelID, groupConstrained, page, perPage, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInGroupPage(groupID string, page int, perPage int) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInGroupPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInGroupPage(groupID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInTeam(teamID, groupConstrained, offset, limit, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersNotInTeamEtag(teamID string, restrictionsHash string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInTeamEtag")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.GetUsersNotInTeamEtag(teamID, restrictionsHash)

	return resultVar0
}

func (a *OpenTracingAppLayer) GetUsersNotInTeamPage(teamID string, groupConstrained bool, page int, perPage int, asAdmin bool, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersNotInTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersNotInTeamPage(teamID, groupConstrained, page, perPage, asAdmin, viewRestrictions)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersPage(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersWithInvalidEmails(page int, perPage int) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersWithInvalidEmails")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersWithInvalidEmails(page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersWithoutTeam(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersWithoutTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersWithoutTeam(options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetUsersWithoutTeamPage(options *model.UserGetOptions, asAdmin bool) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetUsersWithoutTeamPage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetUsersWithoutTeamPage(options, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetVerifyEmailToken(token string) (*model.Token, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetVerifyEmailToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetVerifyEmailToken(token)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetViewUsersRestrictions(userID string) (*model.ViewUsersRestrictions, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetViewUsersRestrictions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetViewUsersRestrictions(userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetWarnMetricsBot() (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetWarnMetricsBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetWarnMetricsBot()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) GetWarnMetricsStatus() (map[string]*model.WarnMetricStatus, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.GetWarnMetricsStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.GetWarnMetricsStatus()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) Handle404(w http.ResponseWriter, r *http.Request) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.Handle404")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.Handle404(w, r)
}

func (a *OpenTracingAppLayer) HandleCommandResponse(c *request.Context, command *model.Command, args *model.CommandArgs, response *model.CommandResponse, builtIn bool) (*model.CommandResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleCommandResponse")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.HandleCommandResponse(c, command, args, response, builtIn)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) HandleCommandResponsePost(c *request.Context, command *model.Command, args *model.CommandArgs, response *model.CommandResponse, builtIn bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleCommandResponsePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.HandleCommandResponsePost(c, command, args, response, builtIn)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) HandleCommandWebhook(c *request.Context, hookID string, response *model.CommandResponse) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleCommandWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HandleCommandWebhook(c, hookID, response)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) HandleImages(previewPathList []string, thumbnailPathList []string, fileData [][]byte) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleImages")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.HandleImages(previewPathList, thumbnailPathList, fileData)
}

func (a *OpenTracingAppLayer) HandleIncomingWebhook(c *request.Context, hookID string, req *model.IncomingWebhookRequest) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleIncomingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HandleIncomingWebhook(c, hookID, req)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) HandleMessageExportConfig(cfg *model.Config, appCfg *model.Config) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HandleMessageExportConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.HandleMessageExportConfig(cfg, appCfg)
}

func (a *OpenTracingAppLayer) HasPermissionTo(askingUserId string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionTo")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionTo(askingUserId, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasPermissionToChannel(askingUserId string, channelID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionToChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionToChannel(askingUserId, channelID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasPermissionToChannelByPost(askingUserId string, postID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionToChannelByPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionToChannelByPost(askingUserId, postID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasPermissionToReadChannel(userID string, channel *model.Channel) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionToReadChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionToReadChannel(userID, channel)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasPermissionToTeam(askingUserId string, teamID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionToTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionToTeam(askingUserId, teamID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasPermissionToUser(askingUserId string, userID string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasPermissionToUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.HasPermissionToUser(askingUserId, userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) HasRemote(channelID string, remoteID string) (bool, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasRemote")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.HasRemote(channelID, remoteID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) HasSharedChannel(channelID string) (bool, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HasSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.HasSharedChannel(channelID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) HubRegister(webConn *app.WebConn) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HubRegister")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.HubRegister(webConn)
}

func (a *OpenTracingAppLayer) HubUnregister(webConn *app.WebConn) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.HubUnregister")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.HubUnregister(webConn)
}

func (a *OpenTracingAppLayer) ImageProxyAdder() func(string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ImageProxyAdder")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ImageProxyAdder()

	return resultVar0
}

func (a *OpenTracingAppLayer) ImageProxyRemover() (f func(string) string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ImageProxyRemover")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ImageProxyRemover()

	return resultVar0
}

func (a *OpenTracingAppLayer) ImportPermissions(jsonl io.Reader) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ImportPermissions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ImportPermissions(jsonl)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) InitPlugins(c *request.Context, pluginDir string, webappPluginDir string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InitPlugins")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.InitPlugins(c, pluginDir, webappPluginDir)
}

func (a *OpenTracingAppLayer) InstallPlugin(pluginFile io.ReadSeeker, replace bool) (*model.Manifest, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InstallPlugin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.InstallPlugin(pluginFile, replace)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) InvalidateAllEmailInvites() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InvalidateAllEmailInvites")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.InvalidateAllEmailInvites()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) InvalidateAllResendInviteEmailJobs() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InvalidateAllResendInviteEmailJobs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.InvalidateAllResendInviteEmailJobs()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) InvalidateCacheForUser(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InvalidateCacheForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.InvalidateCacheForUser(userID)
}

func (a *OpenTracingAppLayer) InviteGuestsToChannels(teamID string, guestsInvite *model.GuestsInvite, senderId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InviteGuestsToChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.InviteGuestsToChannels(teamID, guestsInvite, senderId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) InviteGuestsToChannelsGracefully(teamID string, guestsInvite *model.GuestsInvite, senderId string) ([]*model.EmailInviteWithError, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InviteGuestsToChannelsGracefully")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.InviteGuestsToChannelsGracefully(teamID, guestsInvite, senderId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) InviteNewUsersToTeam(emailList []string, teamID string, senderId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InviteNewUsersToTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.InviteNewUsersToTeam(emailList, teamID, senderId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) InviteNewUsersToTeamGracefully(memberInvite *model.MemberInvite, teamID string, senderId string, reminderInterval string) ([]*model.EmailInviteWithError, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.InviteNewUsersToTeamGracefully")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.InviteNewUsersToTeamGracefully(memberInvite, teamID, senderId, reminderInterval)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) IsCRTEnabledForUser(userID string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsCRTEnabledForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsCRTEnabledForUser(userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) IsFirstUserAccount() bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsFirstUserAccount")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsFirstUserAccount()

	return resultVar0
}

func (a *OpenTracingAppLayer) IsLeader() bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsLeader")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsLeader()

	return resultVar0
}

func (a *OpenTracingAppLayer) IsPasswordValid(password string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsPasswordValid")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsPasswordValid(password)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) IsPhase2MigrationCompleted() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsPhase2MigrationCompleted")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsPhase2MigrationCompleted()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) IsUserAway(lastActivityAt int64) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsUserAway")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsUserAway(lastActivityAt)

	return resultVar0
}

func (a *OpenTracingAppLayer) IsUserSignUpAllowed() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.IsUserSignUpAllowed")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.IsUserSignUpAllowed()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) JoinChannel(c *request.Context, channel *model.Channel, userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.JoinChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.JoinChannel(c, channel, userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) JoinDefaultChannels(c *request.Context, teamID string, user *model.User, shouldBeAdmin bool, userRequestorId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.JoinDefaultChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.JoinDefaultChannels(c, teamID, user, shouldBeAdmin, userRequestorId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) JoinUserToTeam(c *request.Context, team *model.Team, user *model.User, userRequestorId string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.JoinUserToTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.JoinUserToTeam(c, team, user, userRequestorId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) LeaveChannel(c *request.Context, channelID string, userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LeaveChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.LeaveChannel(c, channelID, userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) LeaveTeam(c *request.Context, team *model.Team, user *model.User, requestorId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LeaveTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.LeaveTeam(c, team, user, requestorId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) License() *model.License {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.License")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.License()

	return resultVar0
}

func (a *OpenTracingAppLayer) LimitedClientConfig() map[string]string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LimitedClientConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.LimitedClientConfig()

	return resultVar0
}

func (a *OpenTracingAppLayer) LimitedClientConfigWithComputed() map[string]string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LimitedClientConfigWithComputed")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.LimitedClientConfigWithComputed()

	return resultVar0
}

func (a *OpenTracingAppLayer) ListAllCommands(teamID string, T i18n.TranslateFunc) ([]*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListAllCommands")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListAllCommands(teamID, T)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListAutocompleteCommands(teamID string, T i18n.TranslateFunc) ([]*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListAutocompleteCommands")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	span.SetTag("teamID", teamID)

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListAutocompleteCommands(teamID, T)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListDirectory(path string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListDirectory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListDirectory(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListDirectoryRecursively(path string) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListDirectoryRecursively")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListDirectoryRecursively(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListExports() ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListExports")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListExports()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListImports() ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListImports")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListImports()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListPluginKeys(pluginID string, page int, perPage int) ([]string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListPluginKeys")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListPluginKeys(pluginID, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ListTeamCommands(teamID string) ([]*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ListTeamCommands")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ListTeamCommands(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) LogAuditRec(rec *audit.Record, err error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LogAuditRec")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.LogAuditRec(rec, err)
}

func (a *OpenTracingAppLayer) LogAuditRecWithLevel(rec *audit.Record, level mlog.Level, err error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LogAuditRecWithLevel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.LogAuditRecWithLevel(rec, level, err)
}

func (a *OpenTracingAppLayer) LoginByOAuth(c *request.Context, service string, userData io.Reader, teamID string, tokenUser *model.User) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.LoginByOAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.LoginByOAuth(c, service, userData, teamID, tokenUser)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) MakeAuditRecord(event string, initialStatus string) *audit.Record {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MakeAuditRecord")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MakeAuditRecord(event, initialStatus)

	return resultVar0
}

func (a *OpenTracingAppLayer) MakePermissionError(s *model.Session, permissions []*model.Permission) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MakePermissionError")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MakePermissionError(s, permissions)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) MarkChannelAsUnreadFromPost(postID string, userID string, collapsedThreadsSupported bool) (*model.ChannelUnreadAt, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MarkChannelAsUnreadFromPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.MarkChannelAsUnreadFromPost(postID, userID, collapsedThreadsSupported)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) MarkChannelsAsViewed(channelIDs []string, userID string, currentSessionId string, collapsedThreadsSupported bool) (map[string]int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MarkChannelsAsViewed")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.MarkChannelsAsViewed(channelIDs, userID, currentSessionId, collapsedThreadsSupported)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) MaxPostSize() int {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MaxPostSize")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MaxPostSize()

	return resultVar0
}

func (a *OpenTracingAppLayer) MentionsToPublicChannels(message string, teamID string) model.ChannelMentionMap {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MentionsToPublicChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MentionsToPublicChannels(message, teamID)

	return resultVar0
}

func (a *OpenTracingAppLayer) MentionsToTeamMembers(message string, teamID string) model.UserMentionMap {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MentionsToTeamMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MentionsToTeamMembers(message, teamID)

	return resultVar0
}

func (a *OpenTracingAppLayer) MigrateFilenamesToFileInfos(post *model.Post) []*model.FileInfo {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MigrateFilenamesToFileInfos")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MigrateFilenamesToFileInfos(post)

	return resultVar0
}

func (a *OpenTracingAppLayer) MigrateIdLDAP(toAttribute string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MigrateIdLDAP")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MigrateIdLDAP(toAttribute)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) MoveChannel(c *request.Context, team *model.Team, channel *model.Channel, user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MoveChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MoveChannel(c, team, channel, user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) MoveCommand(team *model.Team, command *model.Command) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MoveCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MoveCommand(team, command)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) MoveFile(oldPath string, newPath string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.MoveFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.MoveFile(oldPath, newPath)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) NewClusterDiscoveryService() *app.ClusterDiscoveryService {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NewClusterDiscoveryService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.NewClusterDiscoveryService()

	return resultVar0
}

func (a *OpenTracingAppLayer) NewPluginAPI(c *request.Context, manifest *model.Manifest) plugin.API {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NewPluginAPI")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.NewPluginAPI(c, manifest)

	return resultVar0
}

func (a *OpenTracingAppLayer) NewWebConn(cfg *app.WebConnConfig) *app.WebConn {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NewWebConn")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.NewWebConn(cfg)

	return resultVar0
}

func (a *OpenTracingAppLayer) NotifyAndSetWarnMetricAck(warnMetricId string, sender *model.User, forceAck bool, isBot bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NotifyAndSetWarnMetricAck")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.NotifyAndSetWarnMetricAck(warnMetricId, sender, forceAck, isBot)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) NotifySessionsExpired() error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NotifySessionsExpired")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.NotifySessionsExpired()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) NotifySharedChannelUserUpdate(user *model.User) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.NotifySharedChannelUserUpdate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.NotifySharedChannelUserUpdate(user)
}

func (a *OpenTracingAppLayer) OpenInteractiveDialog(request model.OpenDialogRequest) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.OpenInteractiveDialog")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.OpenInteractiveDialog(request)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) OriginChecker() func(*http.Request) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.OriginChecker")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.OriginChecker()

	return resultVar0
}

func (a *OpenTracingAppLayer) OverrideIconURLIfEmoji(post *model.Post) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.OverrideIconURLIfEmoji")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.OverrideIconURLIfEmoji(post)
}

func (a *OpenTracingAppLayer) PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchBot(botUserId, botPatch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchChannel(c *request.Context, channel *model.Channel, patch *model.ChannelPatch, userID string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchChannel(c, channel, patch, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchChannelModerationsForChannel(channel *model.Channel, channelModerationsPatch []*model.ChannelModerationPatch) ([]*model.ChannelModeration, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchChannelModerationsForChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchChannelModerationsForChannel(channel, channelModerationsPatch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchPost(c *request.Context, postID string, patch *model.PostPatch) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchPost(c, postID, patch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchRetentionPolicy(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchRetentionPolicy(patch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchRole(role *model.Role, patch *model.RolePatch) (*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchRole")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchRole(role, patch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchScheme(scheme *model.Scheme, patch *model.SchemePatch) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchScheme(scheme, patch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchTeam(teamID string, patch *model.TeamPatch) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchTeam(teamID, patch)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PatchUser(userID string, patch *model.UserPatch, asAdmin bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PatchUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PatchUser(userID, patch, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PermanentDeleteAllUsers(c *request.Context) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteAllUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteAllUsers(c)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PermanentDeleteBot(botUserId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteBot(botUserId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PermanentDeleteChannel(channel *model.Channel) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteChannel(channel)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PermanentDeleteTeam(team *model.Team) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteTeam(team)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PermanentDeleteTeamId(teamID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteTeamId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteTeamId(teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PermanentDeleteUser(c *request.Context, user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PermanentDeleteUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PermanentDeleteUser(c, user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PluginCommandsForTeam(teamID string) []*model.Command {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PluginCommandsForTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PluginCommandsForTeam(teamID)

	return resultVar0
}

func (a *OpenTracingAppLayer) PopulateWebConnConfig(s *model.Session, cfg *app.WebConnConfig, seqVal string) (*app.WebConnConfig, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PopulateWebConnConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.PopulateWebConnConfig(s, cfg, seqVal)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) PostActionCookieSecret() []byte {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostActionCookieSecret")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostActionCookieSecret()

	return resultVar0
}

func (a *OpenTracingAppLayer) PostAddToChannelMessage(c *request.Context, user *model.User, addedUser *model.User, channel *model.Channel, postRootId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostAddToChannelMessage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostAddToChannelMessage(c, user, addedUser, channel, postRootId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PostPatchWithProxyRemovedFromImageURLs(patch *model.PostPatch) *model.PostPatch {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostPatchWithProxyRemovedFromImageURLs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostPatchWithProxyRemovedFromImageURLs(patch)

	return resultVar0
}

func (a *OpenTracingAppLayer) PostUpdateChannelDisplayNameMessage(c *request.Context, userID string, channel *model.Channel, oldChannelDisplayName string, newChannelDisplayName string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostUpdateChannelDisplayNameMessage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostUpdateChannelDisplayNameMessage(c, userID, channel, oldChannelDisplayName, newChannelDisplayName)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PostUpdateChannelHeaderMessage(c *request.Context, userID string, channel *model.Channel, oldChannelHeader string, newChannelHeader string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostUpdateChannelHeaderMessage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostUpdateChannelHeaderMessage(c, userID, channel, oldChannelHeader, newChannelHeader)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PostUpdateChannelPurposeMessage(c *request.Context, userID string, channel *model.Channel, oldChannelPurpose string, newChannelPurpose string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostUpdateChannelPurposeMessage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostUpdateChannelPurposeMessage(c, userID, channel, oldChannelPurpose, newChannelPurpose)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PostWithProxyAddedToImageURLs(post *model.Post) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostWithProxyAddedToImageURLs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostWithProxyAddedToImageURLs(post)

	return resultVar0
}

func (a *OpenTracingAppLayer) PostWithProxyRemovedFromImageURLs(post *model.Post) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PostWithProxyRemovedFromImageURLs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PostWithProxyRemovedFromImageURLs(post)

	return resultVar0
}

func (a *OpenTracingAppLayer) PreparePostForClient(originalPost *model.Post, isNewPost bool, isEditPost bool) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PreparePostForClient")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PreparePostForClient(originalPost, isNewPost, isEditPost)

	return resultVar0
}

func (a *OpenTracingAppLayer) PreparePostForClientWithEmbedsAndImages(originalPost *model.Post, isNewPost bool, isEditPost bool) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PreparePostForClientWithEmbedsAndImages")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PreparePostForClientWithEmbedsAndImages(originalPost, isNewPost, isEditPost)

	return resultVar0
}

func (a *OpenTracingAppLayer) PreparePostListForClient(originalList *model.PostList) *model.PostList {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PreparePostListForClient")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PreparePostListForClient(originalList)

	return resultVar0
}

func (a *OpenTracingAppLayer) ProcessSlackAttachments(attachments []*model.SlackAttachment) []*model.SlackAttachment {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ProcessSlackAttachments")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ProcessSlackAttachments(attachments)

	return resultVar0
}

func (a *OpenTracingAppLayer) ProcessSlackText(text string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ProcessSlackText")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ProcessSlackText(text)

	return resultVar0
}

func (a *OpenTracingAppLayer) PromoteGuestToUser(c *request.Context, user *model.User, requestorId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PromoteGuestToUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PromoteGuestToUser(c, user, requestorId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) Publish(message *model.WebSocketEvent) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.Publish")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.Publish(message)
}

func (a *OpenTracingAppLayer) PublishUserTyping(userID string, channelID string, parentId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PublishUserTyping")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PublishUserTyping(userID, channelID, parentId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PurgeBleveIndexes() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PurgeBleveIndexes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PurgeBleveIndexes()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) PurgeElasticsearchIndexes() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.PurgeElasticsearchIndexes")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.PurgeElasticsearchIndexes()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ReadFile(path string) ([]byte, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ReadFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ReadFile(path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RecycleDatabaseConnection() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RecycleDatabaseConnection")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.RecycleDatabaseConnection()
}

func (a *OpenTracingAppLayer) RegenCommandToken(cmd *model.Command) (*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RegenCommandToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RegenCommandToken(cmd)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RegenOutgoingWebhookToken(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RegenOutgoingWebhookToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RegenOutgoingWebhookToken(hook)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RegenerateOAuthAppSecret(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RegenerateOAuthAppSecret")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RegenerateOAuthAppSecret(app)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RegenerateTeamInviteId(teamID string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RegenerateTeamInviteId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RegenerateTeamInviteId(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RegisterPluginCommand(pluginID string, command *model.Command) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RegisterPluginCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RegisterPluginCommand(pluginID, command)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ReloadConfig() error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ReloadConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ReloadConfig()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveAllDeactivatedMembersFromChannel(channel *model.Channel) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveAllDeactivatedMembersFromChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveAllDeactivatedMembersFromChannel(channel)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveChannelsFromRetentionPolicy(policyID string, channelIDs []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveChannelsFromRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveChannelsFromRetentionPolicy(policyID, channelIDs)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveConfigListener(id string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveConfigListener")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.RemoveConfigListener(id)
}

func (a *OpenTracingAppLayer) RemoveCustomStatus(userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveCustomStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveCustomStatus(userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveDirectory(path string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveDirectory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveDirectory(path)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveFile(path string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveFile(path)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveLdapPrivateCertificate() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveLdapPrivateCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveLdapPrivateCertificate()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveLdapPublicCertificate() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveLdapPublicCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveLdapPublicCertificate()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveRecentCustomStatus(userID string, status *model.CustomStatus) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveRecentCustomStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveRecentCustomStatus(userID, status)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveSamlIdpCertificate() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveSamlIdpCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveSamlIdpCertificate()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveSamlPrivateCertificate() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveSamlPrivateCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveSamlPrivateCertificate()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveSamlPublicCertificate() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveSamlPublicCertificate")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveSamlPublicCertificate()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveTeamIcon(teamID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveTeamIcon")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveTeamIcon(teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveTeamsFromRetentionPolicy(policyID string, teamIDs []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveTeamsFromRetentionPolicy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveTeamsFromRetentionPolicy(policyID, teamIDs)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveUserFromChannel(c *request.Context, userIDToRemove string, removerUserId string, channel *model.Channel) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveUserFromChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveUserFromChannel(c, userIDToRemove, removerUserId, channel)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveUserFromTeam(c *request.Context, teamID string, userID string, requestorId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveUserFromTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveUserFromTeam(c, teamID, userID, requestorId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RemoveUsersFromChannelNotMemberOfTeam(c *request.Context, remover *model.User, channel *model.Channel, team *model.Team) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RemoveUsersFromChannelNotMemberOfTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RemoveUsersFromChannelNotMemberOfTeam(c, remover, channel, team)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RenameChannel(channel *model.Channel, newChannelName string, newDisplayName string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RenameChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RenameChannel(channel, newChannelName, newDisplayName)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RenameTeam(team *model.Team, newTeamName string, newDisplayName string) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RenameTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RenameTeam(team, newTeamName, newDisplayName)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RequestLicenseAndAckWarnMetric(c *request.Context, warnMetricId string, isBot bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RequestLicenseAndAckWarnMetric")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RequestLicenseAndAckWarnMetric(c, warnMetricId, isBot)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ResetPasswordFromToken(userSuppliedTokenString string, newPassword string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ResetPasswordFromToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ResetPasswordFromToken(userSuppliedTokenString, newPassword)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ResetPermissionsSystem() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ResetPermissionsSystem")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.ResetPermissionsSystem()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ResetSamlAuthDataToEmail(includeDeleted bool, dryRun bool, userIDs []string) (numAffected int, appErr *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ResetSamlAuthDataToEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ResetSamlAuthDataToEmail(includeDeleted, dryRun, userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RestoreChannel(c *request.Context, channel *model.Channel, userID string) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RestoreChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RestoreChannel(c, channel, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RestoreTeam(teamID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RestoreTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RestoreTeam(teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RestrictUsersGetByPermissions(userID string, options *model.UserGetOptions) (*model.UserGetOptions, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RestrictUsersGetByPermissions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RestrictUsersGetByPermissions(userID, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) RestrictUsersSearchByPermissions(userID string, options *model.UserSearchOptions) (*model.UserSearchOptions, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RestrictUsersSearchByPermissions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.RestrictUsersSearchByPermissions(userID, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) ReturnSessionToPool(session *model.Session) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ReturnSessionToPool")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ReturnSessionToPool(session)
}

func (a *OpenTracingAppLayer) RevokeAccessToken(token string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeAccessToken(token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeAllSessions(userID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeAllSessions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeAllSessions(userID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeSession(session *model.Session) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeSession")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeSession(session)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeSessionById(sessionID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeSessionById")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeSessionById(sessionID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeSessionsForDeviceId(userID string, deviceID string, currentSessionId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeSessionsForDeviceId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeSessionsForDeviceId(userID, deviceID, currentSessionId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeSessionsFromAllUsers() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeSessionsFromAllUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeSessionsFromAllUsers()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RevokeUserAccessToken(token *model.UserAccessToken) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RevokeUserAccessToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RevokeUserAccessToken(token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) RolesGrantPermission(roleNames []string, permissionId string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.RolesGrantPermission")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.RolesGrantPermission(roleNames, permissionId)

	return resultVar0
}

func (a *OpenTracingAppLayer) SanitizePostListMetadataForUser(postList *model.PostList, userID string) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SanitizePostListMetadataForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SanitizePostListMetadataForUser(postList, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SanitizePostMetadataForUser(post *model.Post, userID string) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SanitizePostMetadataForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SanitizePostMetadataForUser(post, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SanitizeProfile(user *model.User, asAdmin bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SanitizeProfile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SanitizeProfile(user, asAdmin)
}

func (a *OpenTracingAppLayer) SanitizeTeam(session model.Session, team *model.Team) *model.Team {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SanitizeTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SanitizeTeam(session, team)

	return resultVar0
}

func (a *OpenTracingAppLayer) SanitizeTeams(session model.Session, teams []*model.Team) []*model.Team {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SanitizeTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SanitizeTeams(session, teams)

	return resultVar0
}

func (a *OpenTracingAppLayer) SaveAndBroadcastStatus(status *model.Status) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveAndBroadcastStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SaveAndBroadcastStatus(status)
}

func (a *OpenTracingAppLayer) SaveBrandImage(imageData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveBrandImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SaveBrandImage(imageData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SaveComplianceReport(job *model.Compliance) (*model.Compliance, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveComplianceReport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SaveComplianceReport(job)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SaveConfig(newCfg *model.Config, sendConfigChangeClusterMessage bool) (*model.Config, *model.Config, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.SaveConfig(newCfg, sendConfigChangeClusterMessage)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) SaveReactionForPost(c *request.Context, reaction *model.Reaction) (*model.Reaction, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveReactionForPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SaveReactionForPost(c, reaction)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SaveSharedChannel(sc *model.SharedChannel) (*model.SharedChannel, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SaveSharedChannel(sc)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SaveSharedChannelRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveSharedChannelRemote")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SaveSharedChannelRemote(remote)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SaveUserTermsOfService(userID string, termsOfServiceId string, accepted bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SaveUserTermsOfService")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SaveUserTermsOfService(userID, termsOfServiceId, accepted)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SchemesIterator(scope string, batchSize int) func() []*model.Scheme {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SchemesIterator")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SchemesIterator(scope, batchSize)

	return resultVar0
}

func (a *OpenTracingAppLayer) SearchAllChannels(term string, opts model.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchAllChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.SearchAllChannels(term, opts)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) SearchAllTeams(searchOpts *model.TeamSearch) ([]*model.Team, int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchAllTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.SearchAllTeams(searchOpts)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) SearchArchivedChannels(teamID string, term string, userID string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchArchivedChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchArchivedChannels(teamID, term, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchChannels(teamID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchChannels(teamID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchChannelsForUser(userID string, teamID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchChannelsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchChannelsForUser(userID, teamID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchChannelsUserNotIn(teamID string, userID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchChannelsUserNotIn")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchChannelsUserNotIn(teamID, userID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchEmoji(name string, prefixOnly bool, limit int) ([]*model.Emoji, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchEmoji")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchEmoji(name, prefixOnly, limit)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchEngine() *searchengine.Broker {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchEngine")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SearchEngine()

	return resultVar0
}

func (a *OpenTracingAppLayer) SearchFilesInTeamForUser(c *request.Context, terms string, userId string, teamId string, isOrSearch bool, includeDeletedChannels bool, timeZoneOffset int, page int, perPage int) (*model.FileInfoList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchFilesInTeamForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchFilesInTeamForUser(c, terms, userId, teamId, isOrSearch, includeDeletedChannels, timeZoneOffset, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchGroupChannels(userID string, term string) (model.ChannelList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchGroupChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchGroupChannels(userID, term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchPostsForUser(c *request.Context, terms string, userID string, teamID string, isOrSearch bool, includeDeletedChannels bool, timeZoneOffset int, page int, perPage int) (*model.PostSearchResults, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchPostsForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchPostsForUser(c, terms, userID, teamID, isOrSearch, includeDeletedChannels, timeZoneOffset, page, perPage)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) (*model.PostList, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchPostsInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchPostsInTeam(teamID, paramsList)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchPrivateTeams(searchOpts *model.TeamSearch) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchPrivateTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchPrivateTeams(searchOpts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchPublicTeams(searchOpts *model.TeamSearch) ([]*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchPublicTeams")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchPublicTeams(searchOpts)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUserAccessTokens(term string) ([]*model.UserAccessToken, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUserAccessTokens")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUserAccessTokens(term)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsers(props *model.UserSearch, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsers(props, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersInChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersInChannel(channelID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersInGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersInGroup(groupID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersInTeam(teamID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersInTeam(teamID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersNotInChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersNotInChannel(teamID, channelID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersNotInGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersNotInGroup(groupID, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersNotInTeam(notInTeamId string, term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersNotInTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersNotInTeam(notInTeamId, term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SearchUsersWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SearchUsersWithoutTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SearchUsersWithoutTeam(term, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SendAckToPushProxy(ack *model.PushNotificationAck) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendAckToPushProxy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendAckToPushProxy(ack)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendAutoResponse(c *request.Context, channel *model.Channel, receiver *model.User, post *model.Post) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendAutoResponse")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SendAutoResponse(c, channel, receiver, post)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SendAutoResponseIfNecessary(c *request.Context, channel *model.Channel, sender *model.User, post *model.Post) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendAutoResponseIfNecessary")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SendAutoResponseIfNecessary(c, channel, sender, post)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SendCloudTrialEndWarningEmail(trialEndDate string, siteURL string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendCloudTrialEndWarningEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendCloudTrialEndWarningEmail(trialEndDate, siteURL)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendCloudTrialEndedEmail() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendCloudTrialEndedEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendCloudTrialEndedEmail()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendEmailVerification(user *model.User, newEmail string, redirect string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendEmailVerification")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendEmailVerification(user, newEmail, redirect)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendEphemeralPost(userID string, post *model.Post) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendEphemeralPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendEphemeralPost(userID, post)

	return resultVar0
}

func (a *OpenTracingAppLayer) SendNoCardPaymentFailedEmail() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendNoCardPaymentFailedEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendNoCardPaymentFailedEmail()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendNotifications(post *model.Post, team *model.Team, channel *model.Channel, sender *model.User, parentPostList *model.PostList, setOnline bool) ([]string, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendNotifications")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SendNotifications(post, team, channel, sender, parentPostList, setOnline)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SendPasswordReset(email string, siteURL string) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendPasswordReset")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SendPasswordReset(email, siteURL)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SendPaymentFailedEmail(failedPayment *model.FailedPayment) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendPaymentFailedEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendPaymentFailedEmail(failedPayment)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SendTestPushNotification(deviceID string) string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SendTestPushNotification")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SendTestPushNotification(deviceID)

	return resultVar0
}

func (a *OpenTracingAppLayer) ServeInterPluginRequest(w http.ResponseWriter, r *http.Request, sourcePluginId string, destinationPluginId string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ServeInterPluginRequest")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.ServeInterPluginRequest(w, r, sourcePluginId, destinationPluginId)
}

func (a *OpenTracingAppLayer) SessionHasPermissionTo(session model.Session, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionTo")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionTo(session, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToAny(session model.Session, permissions []*model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToAny")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToAny(session, permissions)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToCategory(session model.Session, userID string, teamID string, categoryId string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToCategory")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToCategory(session, userID, teamID, categoryId)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToChannel(session model.Session, channelID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToChannel(session, channelID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToChannelByPost(session model.Session, postID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToChannelByPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToChannelByPost(session, postID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToCreateJob(session model.Session, job *model.Job) (bool, *model.Permission) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToCreateJob")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SessionHasPermissionToCreateJob(session, job)

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SessionHasPermissionToGroup(session model.Session, groupID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToGroup(session, groupID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToManageBot(session model.Session, botUserId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToManageBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToManageBot(session, botUserId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToReadJob(session model.Session, jobType string) (bool, *model.Permission) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToReadJob")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SessionHasPermissionToReadJob(session, jobType)

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SessionHasPermissionToTeam(session model.Session, teamID string, permission *model.Permission) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToTeam(session, teamID, permission)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToUser(session model.Session, userID string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToUser(session, userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionHasPermissionToUserOrBot(session model.Session, userID string) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionHasPermissionToUserOrBot")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionHasPermissionToUserOrBot(session, userID)

	return resultVar0
}

func (a *OpenTracingAppLayer) SessionIsRegistered(session model.Session) bool {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SessionIsRegistered")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SessionIsRegistered(session)

	return resultVar0
}

func (a *OpenTracingAppLayer) SetActiveChannel(userID string, channelID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetActiveChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetActiveChannel(userID, channelID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetAutoResponderStatus(user *model.User, oldNotifyProps model.StringMap) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetAutoResponderStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetAutoResponderStatus(user, oldNotifyProps)
}

func (a *OpenTracingAppLayer) SetChannels(ch *app.Channels) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetChannels")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetChannels(ch)
}

func (a *OpenTracingAppLayer) SetCustomStatus(userID string, cs *model.CustomStatus) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetCustomStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetCustomStatus(userID, cs)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetDefaultProfileImage(user *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetDefaultProfileImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetDefaultProfileImage(user)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetPhase2PermissionsMigrationStatus(isComplete bool) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetPhase2PermissionsMigrationStatus")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetPhase2PermissionsMigrationStatus(isComplete)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetPluginKey(pluginID string, key string, value []byte) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetPluginKey")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetPluginKey(pluginID, key, value)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetPluginKeyWithExpiry(pluginID string, key string, value []byte, expireInSeconds int64) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetPluginKeyWithExpiry")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetPluginKeyWithExpiry(pluginID, key, value, expireInSeconds)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetPluginKeyWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetPluginKeyWithOptions")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SetPluginKeyWithOptions(pluginID, key, value, options)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SetProfileImage(userID string, imageData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetProfileImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetProfileImage(userID, imageData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetProfileImageFromFile(userID string, file io.Reader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetProfileImageFromFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetProfileImageFromFile(userID, file)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetProfileImageFromMultiPartFile(userID string, file multipart.File) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetProfileImageFromMultiPartFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetProfileImageFromMultiPartFile(userID, file)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetRemoteClusterLastPingAt(remoteClusterId string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetRemoteClusterLastPingAt")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetRemoteClusterLastPingAt(remoteClusterId)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetSamlIdpCertificateFromMetadata(data []byte) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetSamlIdpCertificateFromMetadata")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetSamlIdpCertificateFromMetadata(data)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetSearchEngine(se *searchengine.Broker) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetSearchEngine")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetSearchEngine(se)
}

func (a *OpenTracingAppLayer) SetSessionExpireInDays(session *model.Session, days int) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetSessionExpireInDays")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetSessionExpireInDays(session, days)
}

func (a *OpenTracingAppLayer) SetStatusAwayIfNeeded(userID string, manual bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusAwayIfNeeded")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusAwayIfNeeded(userID, manual)
}

func (a *OpenTracingAppLayer) SetStatusDoNotDisturb(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusDoNotDisturb")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusDoNotDisturb(userID)
}

func (a *OpenTracingAppLayer) SetStatusDoNotDisturbTimed(userId string, endtime int64) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusDoNotDisturbTimed")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusDoNotDisturbTimed(userId, endtime)
}

func (a *OpenTracingAppLayer) SetStatusLastActivityAt(userID string, activityAt int64) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusLastActivityAt")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusLastActivityAt(userID, activityAt)
}

func (a *OpenTracingAppLayer) SetStatusOffline(userID string, manual bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusOffline")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusOffline(userID, manual)
}

func (a *OpenTracingAppLayer) SetStatusOnline(userID string, manual bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusOnline")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusOnline(userID, manual)
}

func (a *OpenTracingAppLayer) SetStatusOutOfOffice(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetStatusOutOfOffice")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SetStatusOutOfOffice(userID)
}

func (a *OpenTracingAppLayer) SetTeamIcon(teamID string, imageData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetTeamIcon")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetTeamIcon(teamID, imageData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetTeamIconFromFile(team *model.Team, file io.Reader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetTeamIconFromFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetTeamIconFromFile(team, file)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SetTeamIconFromMultiPartFile(teamID string, file multipart.File) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SetTeamIconFromMultiPartFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SetTeamIconFromMultiPartFile(teamID, file)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SlackImport(c *request.Context, fileData multipart.File, fileSize int64, teamID string) (*model.AppError, *bytes.Buffer) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SlackImport")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SlackImport(c, fileData, fileSize, teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SoftDeleteTeam(teamID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SoftDeleteTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SoftDeleteTeam(teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SubmitInteractiveDialog(c *request.Context, request model.SubmitDialogRequest) (*model.SubmitDialogResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SubmitInteractiveDialog")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SubmitInteractiveDialog(c, request)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SwitchEmailToLdap(email string, password string, code string, ldapLoginId string, ldapPassword string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SwitchEmailToLdap")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SwitchEmailToLdap(email, password, code, ldapLoginId, ldapPassword)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SwitchEmailToOAuth(w http.ResponseWriter, r *http.Request, email string, password string, code string, service string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SwitchEmailToOAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SwitchEmailToOAuth(w, r, email, password, code, service)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SwitchLdapToEmail(ldapPassword string, code string, email string, newPassword string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SwitchLdapToEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SwitchLdapToEmail(ldapPassword, code, email, newPassword)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SwitchOAuthToEmail(email string, password string, requesterId string) (string, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SwitchOAuthToEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.SwitchOAuthToEmail(email, password, requesterId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) SyncLdap(includeRemovedMembers bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SyncLdap")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SyncLdap(includeRemovedMembers)
}

func (a *OpenTracingAppLayer) SyncPlugins() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SyncPlugins")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SyncPlugins()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) SyncRolesAndMembership(c *request.Context, syncableID string, syncableType model.GroupSyncableType, includeRemovedMembers bool) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SyncRolesAndMembership")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.SyncRolesAndMembership(c, syncableID, syncableType, includeRemovedMembers)
}

func (a *OpenTracingAppLayer) SyncSyncableRoles(syncableID string, syncableType model.GroupSyncableType) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.SyncSyncableRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.SyncSyncableRoles(syncableID, syncableType)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TeamMembersMinusGroupMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1, resultVar2 := a.app.TeamMembersMinusGroupMembers(teamID, groupIDs, page, perPage)

	if resultVar2 != nil {
		span.LogFields(spanlog.Error(resultVar2))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1, resultVar2
}

func (a *OpenTracingAppLayer) TeamMembersToAdd(since int64, teamID *string, includeRemovedMembers bool) ([]*model.UserTeamIDPair, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TeamMembersToAdd")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.TeamMembersToAdd(since, teamID, includeRemovedMembers)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TeamMembersToRemove")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.TeamMembersToRemove(teamID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) TelemetryId() string {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TelemetryId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TelemetryId()

	return resultVar0
}

func (a *OpenTracingAppLayer) TestElasticsearch(cfg *model.Config) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestElasticsearch")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestElasticsearch(cfg)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TestEmail(userID string, cfg *model.Config) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestEmail(userID, cfg)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TestFileStoreConnection() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestFileStoreConnection")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestFileStoreConnection()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TestFileStoreConnectionWithConfig(cfg *model.FileSettings) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestFileStoreConnectionWithConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestFileStoreConnectionWithConfig(cfg)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TestLdap() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestLdap")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestLdap()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) TestSiteURL(siteURL string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TestSiteURL")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TestSiteURL(siteURL)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ToggleMuteChannel(channelID string, userID string) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ToggleMuteChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ToggleMuteChannel(channelID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) TotalWebsocketConnections() int {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TotalWebsocketConnections")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.TotalWebsocketConnections()

	return resultVar0
}

func (a *OpenTracingAppLayer) TriggerWebhook(c *request.Context, payload *model.OutgoingWebhookPayload, hook *model.OutgoingWebhook, post *model.Post, channel *model.Channel) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.TriggerWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.TriggerWebhook(c, payload, hook, post, channel)
}

func (a *OpenTracingAppLayer) UnregisterPluginCommand(pluginID string, teamID string, trigger string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UnregisterPluginCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UnregisterPluginCommand(pluginID, teamID, trigger)
}

func (a *OpenTracingAppLayer) UpdateActive(c *request.Context, user *model.User, active bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateActive")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateActive(c, user, active)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateBotActive(c *request.Context, botUserId string, active bool) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateBotActive")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateBotActive(c, botUserId, active)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateBotOwner(botUserId string, newOwnerId string) (*model.Bot, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateBotOwner")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateBotOwner(botUserId, newOwnerId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannel(channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannelMemberNotifyProps(data map[string]string, channelID string, userID string) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannelMemberNotifyProps")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannelMemberNotifyProps(data, channelID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannelMemberRoles(channelID string, userID string, newRoles string) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannelMemberRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannelMemberRoles(channelID, userID, newRoles)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannelMemberSchemeRoles(channelID string, userID string, isSchemeGuest bool, isSchemeUser bool, isSchemeAdmin bool) (*model.ChannelMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannelMemberSchemeRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannelMemberSchemeRoles(channelID, userID, isSchemeGuest, isSchemeUser, isSchemeAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannelPrivacy(c *request.Context, oldChannel *model.Channel, user *model.User) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannelPrivacy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannelPrivacy(c, oldChannel, user)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateChannelScheme(channel *model.Channel) (*model.Channel, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateChannelScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateChannelScheme(channel)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateCommand(oldCmd *model.Command, updatedCmd *model.Command) (*model.Command, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateCommand")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateCommand(oldCmd, updatedCmd)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateConfig(f func(*model.Config)) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateConfig")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateConfig(f)
}

func (a *OpenTracingAppLayer) UpdateDNDStatusOfUsers() {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateDNDStatusOfUsers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateDNDStatusOfUsers()
}

func (a *OpenTracingAppLayer) UpdateEphemeralPost(userID string, post *model.Post) *model.Post {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateEphemeralPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateEphemeralPost(userID, post)

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateExpiredDNDStatuses() ([]*model.Status, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateExpiredDNDStatuses")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateExpiredDNDStatuses()

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateGroup(group *model.Group) (*model.Group, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateGroup(group)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateGroupSyncable")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateGroupSyncable(groupSyncable)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateHashedPassword(user *model.User, newHashedPassword string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateHashedPassword")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateHashedPassword(user, newHashedPassword)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateHashedPasswordByUserId(userID string, newHashedPassword string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateHashedPasswordByUserId")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateHashedPasswordByUserId(userID, newHashedPassword)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateIncomingWebhook(oldHook *model.IncomingWebhook, updatedHook *model.IncomingWebhook) (*model.IncomingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateIncomingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateIncomingWebhook(oldHook, updatedHook)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateLastActivityAtIfNeeded(session model.Session) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateLastActivityAtIfNeeded")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateLastActivityAtIfNeeded(session)
}

func (a *OpenTracingAppLayer) UpdateMfa(activate bool, userID string, token string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateMfa")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateMfa(activate, userID, token)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateMobileAppBadge(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateMobileAppBadge")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateMobileAppBadge(userID)
}

func (a *OpenTracingAppLayer) UpdateOAuthApp(oldApp *model.OAuthApp, updatedApp *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateOAuthApp")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateOAuthApp(oldApp, updatedApp)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateOAuthUserAttrs(userData io.Reader, user *model.User, provider einterfaces.OAuthProvider, service string, tokenUser *model.User) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateOAuthUserAttrs")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateOAuthUserAttrs(userData, user, provider, service, tokenUser)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateOutgoingWebhook(oldHook *model.OutgoingWebhook, updatedHook *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateOutgoingWebhook")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateOutgoingWebhook(oldHook, updatedHook)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdatePassword(user *model.User, newPassword string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePassword")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdatePassword(user, newPassword)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdatePasswordAsUser(userID string, currentPassword string, newPassword string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePasswordAsUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdatePasswordAsUser(userID, currentPassword, newPassword)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdatePasswordByUserIdSendEmail(userID string, newPassword string, method string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePasswordByUserIdSendEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdatePasswordByUserIdSendEmail(userID, newPassword, method)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdatePasswordSendEmail(user *model.User, newPassword string, method string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePasswordSendEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdatePasswordSendEmail(user, newPassword, method)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdatePost(c *request.Context, post *model.Post, safeUpdate bool) (*model.Post, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdatePost(c, post, safeUpdate)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdatePreferences(userID string, preferences model.Preferences) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdatePreferences")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdatePreferences(userID, preferences)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateProductNotices() *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateProductNotices")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateProductNotices()

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateRemoteCluster(rc *model.RemoteCluster) (*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateRemoteCluster")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateRemoteCluster(rc)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateRemoteClusterTopics(remoteClusterId string, topics string) (*model.RemoteCluster, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateRemoteClusterTopics")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateRemoteClusterTopics(remoteClusterId, topics)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateRole(role *model.Role) (*model.Role, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateRole")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateRole(role)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateScheme(scheme *model.Scheme) (*model.Scheme, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateScheme(scheme)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateSharedChannel(sc *model.SharedChannel) (*model.SharedChannel, error) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateSharedChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateSharedChannel(sc)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateSharedChannelRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateSharedChannelRemoteCursor")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateSharedChannelRemoteCursor(id, cursor)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateSidebarCategories")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateSidebarCategories(userID, teamID, categories)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateSidebarCategoryOrder")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateSidebarCategoryOrder(userID, teamID, categoryOrder)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateTeam(team *model.Team) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateTeam")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateTeam(team)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateTeamMemberRoles(teamID string, userID string, newRoles string) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateTeamMemberRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateTeamMemberRoles(teamID, userID, newRoles)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateTeamMemberSchemeRoles(teamID string, userID string, isSchemeGuest bool, isSchemeUser bool, isSchemeAdmin bool) (*model.TeamMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateTeamMemberSchemeRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateTeamMemberSchemeRoles(teamID, userID, isSchemeGuest, isSchemeUser, isSchemeAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateTeamPrivacy(teamID string, teamType string, allowOpenInvite bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateTeamPrivacy")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateTeamPrivacy(teamID, teamType, allowOpenInvite)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateTeamScheme(team *model.Team) (*model.Team, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateTeamScheme")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateTeamScheme(team)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateThreadFollowForUser(userID string, teamID string, threadID string, state bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateThreadFollowForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateThreadFollowForUser(userID, teamID, threadID, state)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateThreadFollowForUserFromChannelAdd(userID string, teamID string, threadID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateThreadFollowForUserFromChannelAdd")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateThreadFollowForUserFromChannelAdd(userID, teamID, threadID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateThreadReadForUser(currentSessionId string, userID string, teamID string, threadID string, timestamp int64) (*model.ThreadResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateThreadReadForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateThreadReadForUser(currentSessionId, userID, teamID, threadID, timestamp)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateThreadReadForUserByPost(currentSessionId string, userID string, teamID string, threadID string, postID string) (*model.ThreadResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateThreadReadForUserByPost")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateThreadReadForUserByPost(currentSessionId, userID, teamID, threadID, postID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateThreadsReadForUser(userID string, teamID string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateThreadsReadForUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateThreadsReadForUser(userID, teamID)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateUser(user *model.User, sendNotifications bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateUser(user, sendNotifications)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateUserActive(c *request.Context, userID string, active bool) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUserActive")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateUserActive(c, userID, active)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateUserAsUser(user *model.User, asAdmin bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUserAsUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateUserAsUser(user, asAdmin)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateUserAuth(userID string, userAuth *model.UserAuth) (*model.UserAuth, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUserAuth")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateUserAuth(userID, userAuth)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateUserRoles(userID string, newRoles string, sendWebSocketEvent bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUserRoles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateUserRoles(userID, newRoles, sendWebSocketEvent)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateUserRolesWithUser(user *model.User, newRoles string, sendWebSocketEvent bool) (*model.User, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateUserRolesWithUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpdateUserRolesWithUser(user, newRoles, sendWebSocketEvent)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpdateViewedProductNotices(userID string, noticeIds []string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateViewedProductNotices")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UpdateViewedProductNotices(userID, noticeIds)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UpdateViewedProductNoticesForNewUser(userID string) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateViewedProductNoticesForNewUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateViewedProductNoticesForNewUser(userID)
}

func (a *OpenTracingAppLayer) UpdateWebConnUserActivity(session model.Session, activityAt int64) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpdateWebConnUserActivity")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	a.app.UpdateWebConnUserActivity(session, activityAt)
}

func (a *OpenTracingAppLayer) UploadData(c *request.Context, us *model.UploadSession, rd io.Reader) (*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadData")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UploadData(c, us, rd)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UploadEmojiImage(id string, imageData *multipart.FileHeader) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadEmojiImage")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.UploadEmojiImage(id, imageData)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) UploadFile(c *request.Context, data []byte, channelID string, filename string) (*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UploadFile(c, data, channelID, filename)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UploadFileX(c *request.Context, channelID string, name string, input io.Reader, opts ...func(*app.UploadFileTask)) (*model.FileInfo, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadFileX")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UploadFileX(c, channelID, name, input, opts...)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UploadFiles(c *request.Context, teamID string, channelID string, userID string, files []io.ReadCloser, filenames []string, clientIds []string, now time.Time) (*model.FileUploadResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadFiles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UploadFiles(c, teamID, channelID, userID, files, filenames, clientIds, now)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UploadMultipartFiles(c *request.Context, teamID string, channelID string, userID string, fileHeaders []*multipart.FileHeader, clientIds []string, now time.Time) (*model.FileUploadResponse, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UploadMultipartFiles")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UploadMultipartFiles(c, teamID, channelID, userID, fileHeaders, clientIds, now)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpsertGroupMember(groupID string, userID string) (*model.GroupMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpsertGroupMember")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpsertGroupMember(groupID, userID)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpsertGroupMembers(groupID string, userIDs []string) ([]*model.GroupMember, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpsertGroupMembers")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpsertGroupMembers(groupID, userIDs)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UpsertGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UpsertGroupSyncable")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UpsertGroupSyncable(groupSyncable)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UserCanSeeOtherUser(userID string, otherUserId string) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UserCanSeeOtherUser")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UserCanSeeOtherUser(userID, otherUserId)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) UserIsInAdminRoleGroup(userID string, syncableID string, syncableType model.GroupSyncableType) (bool, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.UserIsInAdminRoleGroup")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.UserIsInAdminRoleGroup(userID, syncableID, syncableType)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) VerifyEmailFromToken(userSuppliedTokenString string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.VerifyEmailFromToken")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.VerifyEmailFromToken(userSuppliedTokenString)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) VerifyPlugin(plugin io.ReadSeeker, signature io.ReadSeeker) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.VerifyPlugin")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.VerifyPlugin(plugin, signature)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) VerifyUserEmail(userID string, email string) *model.AppError {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.VerifyUserEmail")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0 := a.app.VerifyUserEmail(userID, email)

	if resultVar0 != nil {
		span.LogFields(spanlog.Error(resultVar0))
		ext.Error.Set(span, true)
	}

	return resultVar0
}

func (a *OpenTracingAppLayer) ViewChannel(view *model.ChannelView, userID string, currentSessionId string, collapsedThreadsSupported bool) (map[string]int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.ViewChannel")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.ViewChannel(view, userID, currentSessionId, collapsedThreadsSupported)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func (a *OpenTracingAppLayer) WriteFile(fr io.Reader, path string) (int64, *model.AppError) {
	origCtx := a.ctx
	span, newCtx := tracing.StartSpanWithParentByContext(a.ctx, "app.WriteFile")

	a.ctx = newCtx
	a.app.Srv().Store.SetContext(newCtx)
	defer func() {
		a.app.Srv().Store.SetContext(origCtx)
		a.ctx = origCtx
	}()

	defer span.Finish()
	resultVar0, resultVar1 := a.app.WriteFile(fr, path)

	if resultVar1 != nil {
		span.LogFields(spanlog.Error(resultVar1))
		ext.Error.Set(span, true)
	}

	return resultVar0, resultVar1
}

func NewOpenTracingAppLayer(childApp app.AppIface, ctx context.Context) *OpenTracingAppLayer {
	newApp := OpenTracingAppLayer{
		app: childApp,
		ctx: ctx,
	}

	newApp.srv = childApp.Srv()
	newApp.log = childApp.Log()
	newApp.notificationsLog = childApp.NotificationsLog()
	newApp.accountMigration = childApp.AccountMigration()
	newApp.cluster = childApp.Cluster()
	newApp.compliance = childApp.Compliance()
	newApp.dataRetention = childApp.DataRetention()
	newApp.searchEngine = childApp.SearchEngine()
	newApp.ldap = childApp.Ldap()
	newApp.messageExport = childApp.MessageExport()
	newApp.metrics = childApp.Metrics()
	newApp.notification = childApp.Notification()
	newApp.saml = childApp.Saml()
	newApp.httpService = childApp.HTTPService()
	newApp.imageProxy = childApp.ImageProxy()
	newApp.timezones = childApp.Timezones()

	return &newApp
}

func (a *OpenTracingAppLayer) Srv() *app.Server {
	return a.srv
}
func (a *OpenTracingAppLayer) Log() *mlog.Logger {
	return a.log
}
func (a *OpenTracingAppLayer) NotificationsLog() *mlog.Logger {
	return a.notificationsLog
}
func (a *OpenTracingAppLayer) AccountMigration() einterfaces.AccountMigrationInterface {
	return a.accountMigration
}
func (a *OpenTracingAppLayer) Cluster() einterfaces.ClusterInterface {
	return a.cluster
}
func (a *OpenTracingAppLayer) Compliance() einterfaces.ComplianceInterface {
	return a.compliance
}
func (a *OpenTracingAppLayer) DataRetention() einterfaces.DataRetentionInterface {
	return a.dataRetention
}
func (a *OpenTracingAppLayer) Ldap() einterfaces.LdapInterface {
	return a.ldap
}
func (a *OpenTracingAppLayer) MessageExport() einterfaces.MessageExportInterface {
	return a.messageExport
}
func (a *OpenTracingAppLayer) Metrics() einterfaces.MetricsInterface {
	return a.metrics
}
func (a *OpenTracingAppLayer) Notification() einterfaces.NotificationInterface {
	return a.notification
}
func (a *OpenTracingAppLayer) Saml() einterfaces.SamlInterface {
	return a.saml
}
func (a *OpenTracingAppLayer) HTTPService() httpservice.HTTPService {
	return a.httpService
}
func (a *OpenTracingAppLayer) ImageProxy() *imageproxy.ImageProxy {
	return a.imageProxy
}
func (a *OpenTracingAppLayer) Timezones() *timezones.Timezones {
	return a.timezones
}
func (a *OpenTracingAppLayer) SetServer(srv *app.Server) {
	a.srv = srv
}
