// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make store-layers"
// DO NOT EDIT

package opentracinglayer

import (
	"context"

	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/services/tracing"
	"github.com/mattermost/mattermost-server/v6/store"
	"github.com/opentracing/opentracing-go/ext"
	spanlog "github.com/opentracing/opentracing-go/log"
)

type OpenTracingLayer struct {
	store.Store
	AuditStore                store.AuditStore
	BotStore                  store.BotStore
	ChannelStore              store.ChannelStore
	ChannelMemberHistoryStore store.ChannelMemberHistoryStore
	ClusterDiscoveryStore     store.ClusterDiscoveryStore
	CommandStore              store.CommandStore
	CommandWebhookStore       store.CommandWebhookStore
	ComplianceStore           store.ComplianceStore
	EmojiStore                store.EmojiStore
	FileInfoStore             store.FileInfoStore
	GroupStore                store.GroupStore
	JobStore                  store.JobStore
	LicenseStore              store.LicenseStore
	LinkMetadataStore         store.LinkMetadataStore
	OAuthStore                store.OAuthStore
	PluginStore               store.PluginStore
	PostStore                 store.PostStore
	PreferenceStore           store.PreferenceStore
	ProductNoticesStore       store.ProductNoticesStore
	ReactionStore             store.ReactionStore
	RemoteClusterStore        store.RemoteClusterStore
	RetentionPolicyStore      store.RetentionPolicyStore
	RoleStore                 store.RoleStore
	SchemeStore               store.SchemeStore
	SessionStore              store.SessionStore
	SharedChannelStore        store.SharedChannelStore
	StatusStore               store.StatusStore
	SystemStore               store.SystemStore
	TeamStore                 store.TeamStore
	TermsOfServiceStore       store.TermsOfServiceStore
	ThreadStore               store.ThreadStore
	TokenStore                store.TokenStore
	UploadSessionStore        store.UploadSessionStore
	UserStore                 store.UserStore
	UserAccessTokenStore      store.UserAccessTokenStore
	UserTermsOfServiceStore   store.UserTermsOfServiceStore
	WebhookStore              store.WebhookStore
}

func (s *OpenTracingLayer) Audit() store.AuditStore {
	return s.AuditStore
}

func (s *OpenTracingLayer) Bot() store.BotStore {
	return s.BotStore
}

func (s *OpenTracingLayer) Channel() store.ChannelStore {
	return s.ChannelStore
}

func (s *OpenTracingLayer) ChannelMemberHistory() store.ChannelMemberHistoryStore {
	return s.ChannelMemberHistoryStore
}

func (s *OpenTracingLayer) ClusterDiscovery() store.ClusterDiscoveryStore {
	return s.ClusterDiscoveryStore
}

func (s *OpenTracingLayer) Command() store.CommandStore {
	return s.CommandStore
}

func (s *OpenTracingLayer) CommandWebhook() store.CommandWebhookStore {
	return s.CommandWebhookStore
}

func (s *OpenTracingLayer) Compliance() store.ComplianceStore {
	return s.ComplianceStore
}

func (s *OpenTracingLayer) Emoji() store.EmojiStore {
	return s.EmojiStore
}

func (s *OpenTracingLayer) FileInfo() store.FileInfoStore {
	return s.FileInfoStore
}

func (s *OpenTracingLayer) Group() store.GroupStore {
	return s.GroupStore
}

func (s *OpenTracingLayer) Job() store.JobStore {
	return s.JobStore
}

func (s *OpenTracingLayer) License() store.LicenseStore {
	return s.LicenseStore
}

func (s *OpenTracingLayer) LinkMetadata() store.LinkMetadataStore {
	return s.LinkMetadataStore
}

func (s *OpenTracingLayer) OAuth() store.OAuthStore {
	return s.OAuthStore
}

func (s *OpenTracingLayer) Plugin() store.PluginStore {
	return s.PluginStore
}

func (s *OpenTracingLayer) Post() store.PostStore {
	return s.PostStore
}

func (s *OpenTracingLayer) Preference() store.PreferenceStore {
	return s.PreferenceStore
}

func (s *OpenTracingLayer) ProductNotices() store.ProductNoticesStore {
	return s.ProductNoticesStore
}

func (s *OpenTracingLayer) Reaction() store.ReactionStore {
	return s.ReactionStore
}

func (s *OpenTracingLayer) RemoteCluster() store.RemoteClusterStore {
	return s.RemoteClusterStore
}

func (s *OpenTracingLayer) RetentionPolicy() store.RetentionPolicyStore {
	return s.RetentionPolicyStore
}

func (s *OpenTracingLayer) Role() store.RoleStore {
	return s.RoleStore
}

func (s *OpenTracingLayer) Scheme() store.SchemeStore {
	return s.SchemeStore
}

func (s *OpenTracingLayer) Session() store.SessionStore {
	return s.SessionStore
}

func (s *OpenTracingLayer) SharedChannel() store.SharedChannelStore {
	return s.SharedChannelStore
}

func (s *OpenTracingLayer) Status() store.StatusStore {
	return s.StatusStore
}

func (s *OpenTracingLayer) System() store.SystemStore {
	return s.SystemStore
}

func (s *OpenTracingLayer) Team() store.TeamStore {
	return s.TeamStore
}

func (s *OpenTracingLayer) TermsOfService() store.TermsOfServiceStore {
	return s.TermsOfServiceStore
}

func (s *OpenTracingLayer) Thread() store.ThreadStore {
	return s.ThreadStore
}

func (s *OpenTracingLayer) Token() store.TokenStore {
	return s.TokenStore
}

func (s *OpenTracingLayer) UploadSession() store.UploadSessionStore {
	return s.UploadSessionStore
}

func (s *OpenTracingLayer) User() store.UserStore {
	return s.UserStore
}

func (s *OpenTracingLayer) UserAccessToken() store.UserAccessTokenStore {
	return s.UserAccessTokenStore
}

func (s *OpenTracingLayer) UserTermsOfService() store.UserTermsOfServiceStore {
	return s.UserTermsOfServiceStore
}

func (s *OpenTracingLayer) Webhook() store.WebhookStore {
	return s.WebhookStore
}

type OpenTracingLayerAuditStore struct {
	store.AuditStore
	Root *OpenTracingLayer
}

type OpenTracingLayerBotStore struct {
	store.BotStore
	Root *OpenTracingLayer
}

type OpenTracingLayerChannelStore struct {
	store.ChannelStore
	Root *OpenTracingLayer
}

type OpenTracingLayerChannelMemberHistoryStore struct {
	store.ChannelMemberHistoryStore
	Root *OpenTracingLayer
}

type OpenTracingLayerClusterDiscoveryStore struct {
	store.ClusterDiscoveryStore
	Root *OpenTracingLayer
}

type OpenTracingLayerCommandStore struct {
	store.CommandStore
	Root *OpenTracingLayer
}

type OpenTracingLayerCommandWebhookStore struct {
	store.CommandWebhookStore
	Root *OpenTracingLayer
}

type OpenTracingLayerComplianceStore struct {
	store.ComplianceStore
	Root *OpenTracingLayer
}

type OpenTracingLayerEmojiStore struct {
	store.EmojiStore
	Root *OpenTracingLayer
}

type OpenTracingLayerFileInfoStore struct {
	store.FileInfoStore
	Root *OpenTracingLayer
}

type OpenTracingLayerGroupStore struct {
	store.GroupStore
	Root *OpenTracingLayer
}

type OpenTracingLayerJobStore struct {
	store.JobStore
	Root *OpenTracingLayer
}

type OpenTracingLayerLicenseStore struct {
	store.LicenseStore
	Root *OpenTracingLayer
}

type OpenTracingLayerLinkMetadataStore struct {
	store.LinkMetadataStore
	Root *OpenTracingLayer
}

type OpenTracingLayerOAuthStore struct {
	store.OAuthStore
	Root *OpenTracingLayer
}

type OpenTracingLayerPluginStore struct {
	store.PluginStore
	Root *OpenTracingLayer
}

type OpenTracingLayerPostStore struct {
	store.PostStore
	Root *OpenTracingLayer
}

type OpenTracingLayerPreferenceStore struct {
	store.PreferenceStore
	Root *OpenTracingLayer
}

type OpenTracingLayerProductNoticesStore struct {
	store.ProductNoticesStore
	Root *OpenTracingLayer
}

type OpenTracingLayerReactionStore struct {
	store.ReactionStore
	Root *OpenTracingLayer
}

type OpenTracingLayerRemoteClusterStore struct {
	store.RemoteClusterStore
	Root *OpenTracingLayer
}

type OpenTracingLayerRetentionPolicyStore struct {
	store.RetentionPolicyStore
	Root *OpenTracingLayer
}

type OpenTracingLayerRoleStore struct {
	store.RoleStore
	Root *OpenTracingLayer
}

type OpenTracingLayerSchemeStore struct {
	store.SchemeStore
	Root *OpenTracingLayer
}

type OpenTracingLayerSessionStore struct {
	store.SessionStore
	Root *OpenTracingLayer
}

type OpenTracingLayerSharedChannelStore struct {
	store.SharedChannelStore
	Root *OpenTracingLayer
}

type OpenTracingLayerStatusStore struct {
	store.StatusStore
	Root *OpenTracingLayer
}

type OpenTracingLayerSystemStore struct {
	store.SystemStore
	Root *OpenTracingLayer
}

type OpenTracingLayerTeamStore struct {
	store.TeamStore
	Root *OpenTracingLayer
}

type OpenTracingLayerTermsOfServiceStore struct {
	store.TermsOfServiceStore
	Root *OpenTracingLayer
}

type OpenTracingLayerThreadStore struct {
	store.ThreadStore
	Root *OpenTracingLayer
}

type OpenTracingLayerTokenStore struct {
	store.TokenStore
	Root *OpenTracingLayer
}

type OpenTracingLayerUploadSessionStore struct {
	store.UploadSessionStore
	Root *OpenTracingLayer
}

type OpenTracingLayerUserStore struct {
	store.UserStore
	Root *OpenTracingLayer
}

type OpenTracingLayerUserAccessTokenStore struct {
	store.UserAccessTokenStore
	Root *OpenTracingLayer
}

type OpenTracingLayerUserTermsOfServiceStore struct {
	store.UserTermsOfServiceStore
	Root *OpenTracingLayer
}

type OpenTracingLayerWebhookStore struct {
	store.WebhookStore
	Root *OpenTracingLayer
}

func (s *OpenTracingLayerAuditStore) Get(user_id string, offset int, limit int) (model.Audits, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "AuditStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.AuditStore.Get(user_id, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerAuditStore) PermanentDeleteByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "AuditStore.PermanentDeleteByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.AuditStore.PermanentDeleteByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerAuditStore) Save(audit *model.Audit) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "AuditStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.AuditStore.Save(audit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerBotStore) Get(userID string, includeDeleted bool) (*model.Bot, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "BotStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.BotStore.Get(userID, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerBotStore) GetAll(options *model.BotGetOptions) ([]*model.Bot, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "BotStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.BotStore.GetAll(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerBotStore) PermanentDelete(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "BotStore.PermanentDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.BotStore.PermanentDelete(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerBotStore) Save(bot *model.Bot) (*model.Bot, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "BotStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.BotStore.Save(bot)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerBotStore) Update(bot *model.Bot) (*model.Bot, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "BotStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.BotStore.Update(bot)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.AnalyticsDeletedTypeCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.AnalyticsDeletedTypeCount(teamID, channelType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.AnalyticsTypeCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.AnalyticsTypeCount(teamID, channelType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) Autocomplete(userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Autocomplete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.Autocomplete(userID, term, includeDeleted, isGuest)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) AutocompleteInTeam(teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.AutocompleteInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.AutocompleteInTeam(teamID, userID, term, includeDeleted, isGuest)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.AutocompleteInTeamForSearch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.AutocompleteInTeamForSearch(teamID, userID, term, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) ClearAllCustomRoleAssignments() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.ClearAllCustomRoleAssignments")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.ClearAllCustomRoleAssignments()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.ClearCaches()

}

func (s *OpenTracingLayerChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.ClearSidebarOnTeamLeave")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.ClearSidebarOnTeamLeave(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) CountPostsAfter(channelID string, timestamp int64, userID string) (int, int, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.CountPostsAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ChannelStore.CountPostsAfter(channelID, timestamp, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerChannelStore) CreateDirectChannel(userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.CreateDirectChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.CreateDirectChannel(userID, otherUserID, channelOptions...)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) CreateInitialSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.CreateInitialSidebarCategories")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.CreateInitialSidebarCategories(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.CreateSidebarCategory")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.CreateSidebarCategory(userID, teamID, newCategory)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) Delete(channelID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.Delete(channelID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) DeleteSidebarCategory(categoryID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.DeleteSidebarCategory")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.DeleteSidebarCategory(categoryID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.DeleteSidebarChannelsByPreferences")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.DeleteSidebarChannelsByPreferences(preferences)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.Get(id, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAll(teamID string) ([]*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAll(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannelMembersById(id string) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannelMembersById")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannelMembersById(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannelMembersForUser(userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannelMembersForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannelMembersForUser(userID, allowFromCache, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannelMembersNotifyPropsForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannelMembersNotifyPropsForChannel(channelID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannels(page, perPage, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannelsCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannelsCount(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllChannelsForExportAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllChannelsForExportAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string) ([]*model.DirectChannelForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetAllDirectChannelsForExportAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetAllDirectChannelsForExportAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetByName(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetByName(team_id, name, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetByNameIncludeDeleted(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetByNameIncludeDeleted")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetByNameIncludeDeleted(team_id, name, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetByNames(team_id string, names []string, allowFromCache bool) ([]*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetByNames")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetByNames(team_id, names, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelCounts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelCounts(teamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelMembersForExport(userID string, teamID string) ([]*model.ChannelMemberForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelMembersForExport")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelMembersForExport(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelMembersTimezones")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelMembersTimezones(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelUnread")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelUnread(channelID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannels(teamID, userID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsBatchForIndexing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsBatchForIndexing(startTime, startChannelID, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsByIds(channelIds, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsByScheme")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsByScheme(schemeID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsByUser(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsWithCursor(teamId string, userId string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsWithCursor")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsWithCursor(teamId, userId, opts, afterChannelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetChannelsWithTeamDataByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetChannelsWithTeamDataByIds(channelIds, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetDeleted(team_id string, offset int, limit int, userID string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetDeleted")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetDeleted(team_id, offset, limit, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetDeletedByName(team_id string, name string) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetDeletedByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetDeletedByName(team_id, name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetFileCount(channelID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetFileCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetFileCount(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetForPost(postID string) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetForPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetForPost(postID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetGuestCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetGuestCount(channelID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMany")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMany(ids, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMember(ctx, channelID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMemberCount(channelID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMemberCountFromCache(channelID string) int64 {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMemberCountFromCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.ChannelStore.GetMemberCountFromCache(channelID)
	return result
}

func (s *OpenTracingLayerChannelStore) GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMemberCountsByGroup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMemberCountsByGroup(ctx, channelID, includeTimezones)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMemberForPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMemberForPost(postID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembers(channelID string, offset int, limit int) (model.ChannelMembers, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembers(channelID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersByChannelIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersByChannelIds(channelIds, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersByIds(channelID, userIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersForUser(teamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersForUserWithCursor(userID string, afterChannel string, afterUser string, limit int, lastUpdateAt int) (model.ChannelMembers, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersForUserWithCursor")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersForUserWithCursor(userID, afterChannel, afterUser, limit, lastUpdateAt)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersForUserWithPagination")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersForUserWithPagination(userID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMembersInfoByChannelIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMembersInfoByChannelIds(channelIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetMoreChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetMoreChannels(teamID, userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetPinnedPostCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetPinnedPostCount(channelID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetPinnedPosts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetPinnedPosts(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetPrivateChannelsForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetPrivateChannelsForTeam(teamID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetPublicChannelsByIdsForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetPublicChannelsByIdsForTeam(teamID, channelIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetPublicChannelsForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetPublicChannelsForTeam(teamID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetSidebarCategories")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetSidebarCategories(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetSidebarCategory")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetSidebarCategory(categoryID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetSidebarCategoryOrder")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetSidebarCategoryOrder(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetTeamChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetTeamChannels(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetTeamForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetTeamForChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GetTeamMembersForChannel(channelID string) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GetTeamMembersForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GetTeamMembersForChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) GroupSyncedChannelCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.GroupSyncedChannelCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.GroupSyncedChannelCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.IncrementMentionCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.IncrementMentionCount(channelID, userIDs, isRoot)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) InvalidateAllChannelMembersForUser(userID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateAllChannelMembersForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateAllChannelMembersForUser(userID)

}

func (s *OpenTracingLayerChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateCacheForChannelMembersNotifyProps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateCacheForChannelMembersNotifyProps(channelID)

}

func (s *OpenTracingLayerChannelStore) InvalidateChannel(id string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateChannel(id)

}

func (s *OpenTracingLayerChannelStore) InvalidateChannelByName(teamID string, name string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateChannelByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateChannelByName(teamID, name)

}

func (s *OpenTracingLayerChannelStore) InvalidateGuestCount(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateGuestCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateGuestCount(channelID)

}

func (s *OpenTracingLayerChannelStore) InvalidateMemberCount(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidateMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidateMemberCount(channelID)

}

func (s *OpenTracingLayerChannelStore) InvalidatePinnedPostCount(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.InvalidatePinnedPostCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.ChannelStore.InvalidatePinnedPostCount(channelID)

}

func (s *OpenTracingLayerChannelStore) IsUserInChannelUseCache(userID string, channelID string) bool {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.IsUserInChannelUseCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.ChannelStore.IsUserInChannelUseCache(userID, channelID)
	return result
}

func (s *OpenTracingLayerChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.MigrateChannelMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.MigrateChannelMembers(fromChannelID, fromUserID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) PermanentDelete(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.PermanentDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.PermanentDelete(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) PermanentDeleteByTeam(teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.PermanentDeleteByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.PermanentDeleteByTeam(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) PermanentDeleteMembersByChannel(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.PermanentDeleteMembersByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.PermanentDeleteMembersByChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) PermanentDeleteMembersByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.PermanentDeleteMembersByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.PermanentDeleteMembersByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) RemoveAllDeactivatedMembers(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.RemoveAllDeactivatedMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.RemoveAllDeactivatedMembers(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) RemoveMember(channelID string, userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.RemoveMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.RemoveMember(channelID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) RemoveMembers(channelID string, userIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.RemoveMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.RemoveMembers(channelID, userIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) ResetAllChannelSchemes() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.ResetAllChannelSchemes")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.ResetAllChannelSchemes()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) Restore(channelID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Restore")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.Restore(channelID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) Save(channel *model.Channel, maxChannelsPerTeam int64) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.Save(channel, maxChannelsPerTeam)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SaveDirectChannel(channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SaveDirectChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SaveDirectChannel(channel, member1, member2)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SaveMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SaveMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SaveMember(member)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SaveMultipleMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SaveMultipleMembers(members)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchAllChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ChannelStore.SearchAllChannels(term, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerChannelStore) SearchArchivedInTeam(teamID string, term string, userID string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchArchivedInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SearchArchivedInTeam(teamID, term, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchForUserInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SearchForUserInTeam(userID, teamID, term, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchGroupChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SearchGroupChannels(userID, term)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SearchInTeam(teamID, term, includeDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SearchMore")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.SearchMore(userID, teamID, term)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SetDeleteAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.SetDeleteAt(channelID, deleteAt, updateAt)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) SetShared(channelId string, shared bool) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.SetShared")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.SetShared(channelId, shared)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) Update(channel *model.Channel) (*model.Channel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.Update(channel)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateLastViewedAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UpdateLastViewedAt(channelIds, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateLastViewedAtPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UpdateLastViewedAtPost(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UpdateMember(member)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateMemberNotifyProps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UpdateMemberNotifyProps(channelID, userID, props)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateMembersRole(channelID string, userIDs []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateMembersRole")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.UpdateMembersRole(channelID, userIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateMultipleMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UpdateMultipleMembers(members)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateSidebarCategories")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ChannelStore.UpdateSidebarCategories(userID, teamID, categories)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateSidebarCategoryOrder")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.UpdateSidebarCategoryOrder(userID, teamID, categoryOrder)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateSidebarChannelCategoryOnMove")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.UpdateSidebarChannelCategoryOnMove(channel, newTeamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UpdateSidebarChannelsByPreferences")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelStore.UpdateSidebarChannelsByPreferences(preferences)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelStore.UserBelongsToChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelStore.UserBelongsToChannels(userID, channelIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelMemberHistoryStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) GetChannelsLeftSince(userID string, since int64) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.GetChannelsLeftSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelMemberHistoryStore.GetChannelsLeftSince(userID, since)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) GetUsersInChannelDuring(startTime int64, endTime int64, channelID string) ([]*model.ChannelMemberHistoryResult, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.GetUsersInChannelDuring")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelMemberHistoryStore.GetUsersInChannelDuring(startTime, endTime, channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) LogJoinEvent(userID string, channelID string, joinTime int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.LogJoinEvent")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelMemberHistoryStore.LogJoinEvent(userID, channelID, joinTime)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) LogLeaveEvent(userID string, channelID string, leaveTime int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.LogLeaveEvent")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ChannelMemberHistoryStore.LogLeaveEvent(userID, channelID, leaveTime)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.PermanentDeleteBatch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ChannelMemberHistoryStore.PermanentDeleteBatch(endTime, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerChannelMemberHistoryStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerClusterDiscoveryStore) Cleanup() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.Cleanup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ClusterDiscoveryStore.Cleanup()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerClusterDiscoveryStore) Delete(discovery *model.ClusterDiscovery) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ClusterDiscoveryStore.Delete(discovery)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerClusterDiscoveryStore) Exists(discovery *model.ClusterDiscovery) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.Exists")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ClusterDiscoveryStore.Exists(discovery)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerClusterDiscoveryStore) GetAll(discoveryType string, clusterName string) ([]*model.ClusterDiscovery, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ClusterDiscoveryStore.GetAll(discoveryType, clusterName)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerClusterDiscoveryStore) Save(discovery *model.ClusterDiscovery) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ClusterDiscoveryStore.Save(discovery)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerClusterDiscoveryStore) SetLastPingAt(discovery *model.ClusterDiscovery) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ClusterDiscoveryStore.SetLastPingAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ClusterDiscoveryStore.SetLastPingAt(discovery)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerCommandStore) AnalyticsCommandCount(teamID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.AnalyticsCommandCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.AnalyticsCommandCount(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandStore) Delete(commandID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.CommandStore.Delete(commandID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerCommandStore) Get(id string) (*model.Command, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandStore) GetByTeam(teamID string) ([]*model.Command, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.GetByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.GetByTeam(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandStore) GetByTrigger(teamID string, trigger string) (*model.Command, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.GetByTrigger")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.GetByTrigger(teamID, trigger)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandStore) PermanentDeleteByTeam(teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.PermanentDeleteByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.CommandStore.PermanentDeleteByTeam(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerCommandStore) PermanentDeleteByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.PermanentDeleteByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.CommandStore.PermanentDeleteByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerCommandStore) Save(webhook *model.Command) (*model.Command, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.Save(webhook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandStore) Update(hook *model.Command) (*model.Command, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandStore.Update(hook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandWebhookStore) Cleanup() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandWebhookStore.Cleanup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.CommandWebhookStore.Cleanup()

}

func (s *OpenTracingLayerCommandWebhookStore) Get(id string) (*model.CommandWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandWebhookStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandWebhookStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandWebhookStore) Save(webhook *model.CommandWebhook) (*model.CommandWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandWebhookStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.CommandWebhookStore.Save(webhook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerCommandWebhookStore) TryUse(id string, limit int) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "CommandWebhookStore.TryUse")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.CommandWebhookStore.TryUse(id, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerComplianceStore) ComplianceExport(compliance *model.Compliance, cursor model.ComplianceExportCursor, limit int) ([]*model.CompliancePost, model.ComplianceExportCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.ComplianceExport")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ComplianceStore.ComplianceExport(compliance, cursor, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerComplianceStore) Get(id string) (*model.Compliance, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ComplianceStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerComplianceStore) GetAll(offset int, limit int) (model.Compliances, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ComplianceStore.GetAll(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerComplianceStore) MessageExport(cursor model.MessageExportCursor, limit int) ([]*model.MessageExport, model.MessageExportCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.MessageExport")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ComplianceStore.MessageExport(cursor, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerComplianceStore) Save(compliance *model.Compliance) (*model.Compliance, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ComplianceStore.Save(compliance)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerComplianceStore) Update(compliance *model.Compliance) (*model.Compliance, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ComplianceStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ComplianceStore.Update(compliance)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) Delete(emoji *model.Emoji, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.EmojiStore.Delete(emoji, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerEmojiStore) Get(ctx context.Context, id string, allowFromCache bool) (*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.Get(ctx, id, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) GetByName(ctx context.Context, name string, allowFromCache bool) (*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.GetByName(ctx, name, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) GetList(offset int, limit int, sort string) ([]*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.GetList")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.GetList(offset, limit, sort)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) GetMultipleByName(names []string) ([]*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.GetMultipleByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.GetMultipleByName(names)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) Save(emoji *model.Emoji) (*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.Save(emoji)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerEmojiStore) Search(name string, prefixOnly bool, limit int) ([]*model.Emoji, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "EmojiStore.Search")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.EmojiStore.Search(name, prefixOnly, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) AttachToPost(fileID string, postID string, creatorID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.AttachToPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.FileInfoStore.AttachToPost(fileID, postID, creatorID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerFileInfoStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.FileInfoStore.ClearCaches()

}

func (s *OpenTracingLayerFileInfoStore) CountAll() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.CountAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.CountAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) DeleteForPost(postID string) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.DeleteForPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.DeleteForPost(postID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) Get(id string) (*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetByIds(ids []string) ([]*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetByIds(ids)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetByPath(path string) (*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetByPath")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetByPath(path)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetFilesBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.FileForIndexing, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetFilesBatchForIndexing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetFilesBatchForIndexing(startTime, startFileID, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetForPost(postID string, readFromMaster bool, includeDeleted bool, allowFromCache bool) ([]*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetForPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetForPost(postID, readFromMaster, includeDeleted, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetForUser(userID string) ([]*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetFromMaster(id string) (*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetFromMaster")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetFromMaster(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) GetWithOptions(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.GetWithOptions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.GetWithOptions(page, perPage, opt)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) InvalidateFileInfosForPostCache(postID string, deleted bool) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.InvalidateFileInfosForPostCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.FileInfoStore.InvalidateFileInfosForPostCache(postID, deleted)

}

func (s *OpenTracingLayerFileInfoStore) PermanentDelete(fileID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.PermanentDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.FileInfoStore.PermanentDelete(fileID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerFileInfoStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.PermanentDeleteBatch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.PermanentDeleteBatch(endTime, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) PermanentDeleteByUser(userID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.PermanentDeleteByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.PermanentDeleteByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) Save(info *model.FileInfo) (*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.Save(info)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) Search(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.FileInfoList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.Search")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.Search(paramsList, userID, teamID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerFileInfoStore) SetContent(fileID string, content string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.SetContent")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.FileInfoStore.SetContent(fileID, content)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerFileInfoStore) Upsert(info *model.FileInfo) (*model.FileInfo, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "FileInfoStore.Upsert")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.FileInfoStore.Upsert(info)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) AdminRoleGroupsForSyncableMember(userID string, syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.AdminRoleGroupsForSyncableMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.AdminRoleGroupsForSyncableMember(userID, syncableID, syncableType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.ChannelMembersMinusGroupMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.ChannelMembersMinusGroupMembers(channelID, groupIDs, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) ChannelMembersToAdd(since int64, channelID *string, includeRemovedMembers bool) ([]*model.UserChannelIDPair, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.ChannelMembersToAdd")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.ChannelMembersToAdd(since, channelID, includeRemovedMembers)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) ChannelMembersToRemove(channelID *string) ([]*model.ChannelMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.ChannelMembersToRemove")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.ChannelMembersToRemove(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CountChannelMembersMinusGroupMembers(channelID string, groupIDs []string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CountChannelMembersMinusGroupMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CountChannelMembersMinusGroupMembers(channelID, groupIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CountGroupsByChannel(channelID string, opts model.GroupSearchOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CountGroupsByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CountGroupsByChannel(channelID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CountGroupsByTeam(teamID string, opts model.GroupSearchOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CountGroupsByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CountGroupsByTeam(teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CountTeamMembersMinusGroupMembers(teamID string, groupIDs []string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CountTeamMembersMinusGroupMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CountTeamMembersMinusGroupMembers(teamID, groupIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) Create(group *model.Group) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.Create")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.Create(group)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CreateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CreateGroupSyncable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CreateGroupSyncable(groupSyncable)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) CreateWithUserIds(group *model.GroupWithUserIds) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.CreateWithUserIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.CreateWithUserIds(group)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) Delete(groupID string) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.Delete(groupID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.DeleteGroupSyncable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.DeleteGroupSyncable(groupID, syncableID, syncableType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) DeleteMember(groupID string, userID string) (*model.GroupMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.DeleteMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.DeleteMember(groupID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) DeleteMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.DeleteMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.DeleteMembers(groupID, userIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) DistinctGroupMemberCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.DistinctGroupMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.DistinctGroupMemberCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) Get(groupID string) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.Get(groupID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetAllBySource(groupSource model.GroupSource) ([]*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetAllBySource")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetAllBySource(groupSource)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetAllGroupSyncablesByGroupId(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetAllGroupSyncablesByGroupId")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetAllGroupSyncablesByGroupId(groupID, syncableType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetByIDs(groupIDs []string) ([]*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetByIDs")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetByIDs(groupIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetByName(name string, opts model.GroupSearchOpts) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetByName(name, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetByRemoteID")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetByRemoteID(remoteID, groupSource)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetByUser(userID string) ([]*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetGroupSyncable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetGroupSyncable(groupID, syncableID, syncableType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetGroups(page int, perPage int, opts model.GroupSearchOpts) ([]*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetGroups")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetGroups(page, perPage, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetGroupsAssociatedToChannelsByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetGroupsAssociatedToChannelsByTeam(teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetGroupsByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetGroupsByChannel(channelID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetGroupsByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetGroupsByTeam(teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMember(groupID string, userID string) (*model.GroupMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMember(groupID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMemberCount(groupID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMemberCount(groupID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMemberUsers(groupID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMemberUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMemberUsers(groupID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMemberUsersInTeam(groupID string, teamID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMemberUsersInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMemberUsersInTeam(groupID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMemberUsersNotInChannel(groupID string, channelID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMemberUsersNotInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMemberUsersNotInChannel(groupID, channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetMemberUsersPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetMemberUsersPage(groupID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GetNonMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GetNonMemberUsersPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GetNonMemberUsersPage(groupID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupChannelCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupChannelCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupChannelCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupCountBySource(source model.GroupSource) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupCountBySource")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupCountBySource(source)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupCountWithAllowReference() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupCountWithAllowReference")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupCountWithAllowReference()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupMemberCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupMemberCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) GroupTeamCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.GroupTeamCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.GroupTeamCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) PermanentDeleteMembersByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.PermanentDeleteMembersByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.GroupStore.PermanentDeleteMembersByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerGroupStore) PermittedSyncableAdmins(syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.PermittedSyncableAdmins")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.PermittedSyncableAdmins(syncableID, syncableType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.TeamMembersMinusGroupMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.TeamMembersMinusGroupMembers(teamID, groupIDs, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) TeamMembersToAdd(since int64, teamID *string, includeRemovedMembers bool) ([]*model.UserTeamIDPair, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.TeamMembersToAdd")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.TeamMembersToAdd(since, teamID, includeRemovedMembers)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.TeamMembersToRemove")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.TeamMembersToRemove(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) Update(group *model.Group) (*model.Group, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.Update(group)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.UpdateGroupSyncable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.UpdateGroupSyncable(groupSyncable)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) UpsertMember(groupID string, userID string) (*model.GroupMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.UpsertMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.UpsertMember(groupID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerGroupStore) UpsertMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "GroupStore.UpsertMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.GroupStore.UpsertMembers(groupID, userIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) Cleanup(expiryTime int64, batchSize int) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.Cleanup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.JobStore.Cleanup(expiryTime, batchSize)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerJobStore) Delete(id string) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.Delete(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) Get(id string) (*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllByStatus(status string) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllByStatus")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllByStatus(status)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllByType(jobType string) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllByType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllByType(jobType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllByTypeAndStatus(jobType string, status string) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllByTypeAndStatus")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllByTypeAndStatus(jobType, status)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllByTypePage(jobType string, offset int, limit int) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllByTypePage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllByTypePage(jobType, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllByTypesPage(jobTypes []string, offset int, limit int) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllByTypesPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllByTypesPage(jobTypes, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetAllPage(offset int, limit int) ([]*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetAllPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetAllPage(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetCountByStatusAndType(status string, jobType string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetCountByStatusAndType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetCountByStatusAndType(status, jobType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetNewestJobByStatusAndType(status string, jobType string) (*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetNewestJobByStatusAndType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetNewestJobByStatusAndType(status, jobType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) GetNewestJobByStatusesAndType(statuses []string, jobType string) (*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.GetNewestJobByStatusesAndType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.GetNewestJobByStatusesAndType(statuses, jobType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) Save(job *model.Job) (*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.Save(job)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) UpdateOptimistically(job *model.Job, currentStatus string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.UpdateOptimistically")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.UpdateOptimistically(job, currentStatus)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) UpdateStatus(id string, status string) (*model.Job, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.UpdateStatus")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.UpdateStatus(id, status)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerJobStore) UpdateStatusOptimistically(id string, currentStatus string, newStatus string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "JobStore.UpdateStatusOptimistically")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.JobStore.UpdateStatusOptimistically(id, currentStatus, newStatus)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerLicenseStore) Get(id string) (*model.LicenseRecord, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "LicenseStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.LicenseStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerLicenseStore) GetAll() ([]*model.LicenseRecord, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "LicenseStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.LicenseStore.GetAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerLicenseStore) Save(license *model.LicenseRecord) (*model.LicenseRecord, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "LicenseStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.LicenseStore.Save(license)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerLinkMetadataStore) Get(url string, timestamp int64) (*model.LinkMetadata, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "LinkMetadataStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.LinkMetadataStore.Get(url, timestamp)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerLinkMetadataStore) Save(linkMetadata *model.LinkMetadata) (*model.LinkMetadata, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "LinkMetadataStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.LinkMetadataStore.Save(linkMetadata)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) DeleteApp(id string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.DeleteApp")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.OAuthStore.DeleteApp(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerOAuthStore) GetAccessData(token string) (*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAccessData(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetAccessDataByRefreshToken(token string) (*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAccessDataByRefreshToken")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAccessDataByRefreshToken(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetAccessDataByUserForApp(userID string, clientId string) ([]*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAccessDataByUserForApp")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAccessDataByUserForApp(userID, clientId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetApp(id string) (*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetApp")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetApp(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetAppByUser(userID string, offset int, limit int) ([]*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAppByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAppByUser(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetApps(offset int, limit int) ([]*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetApps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetApps(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetAuthData(code string) (*model.AuthData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAuthData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAuthData(code)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetAuthorizedApps(userID string, offset int, limit int) ([]*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetAuthorizedApps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetAuthorizedApps(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) GetPreviousAccessData(userID string, clientId string) (*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.GetPreviousAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.GetPreviousAccessData(userID, clientId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) PermanentDeleteAuthDataByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.PermanentDeleteAuthDataByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.OAuthStore.PermanentDeleteAuthDataByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerOAuthStore) RemoveAccessData(token string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.RemoveAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.OAuthStore.RemoveAccessData(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerOAuthStore) RemoveAllAccessData() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.RemoveAllAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.OAuthStore.RemoveAllAccessData()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerOAuthStore) RemoveAuthData(code string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.RemoveAuthData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.OAuthStore.RemoveAuthData(code)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerOAuthStore) SaveAccessData(accessData *model.AccessData) (*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.SaveAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.SaveAccessData(accessData)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) SaveApp(app *model.OAuthApp) (*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.SaveApp")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.SaveApp(app)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) SaveAuthData(authData *model.AuthData) (*model.AuthData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.SaveAuthData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.SaveAuthData(authData)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) UpdateAccessData(accessData *model.AccessData) (*model.AccessData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.UpdateAccessData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.UpdateAccessData(accessData)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerOAuthStore) UpdateApp(app *model.OAuthApp) (*model.OAuthApp, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "OAuthStore.UpdateApp")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.OAuthStore.UpdateApp(app)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) CompareAndDelete(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.CompareAndDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.CompareAndDelete(keyVal, oldValue)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) CompareAndSet(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.CompareAndSet")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.CompareAndSet(keyVal, oldValue)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) Delete(pluginID string, key string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PluginStore.Delete(pluginID, key)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPluginStore) DeleteAllExpired() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.DeleteAllExpired")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PluginStore.DeleteAllExpired()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPluginStore) DeleteAllForPlugin(PluginID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.DeleteAllForPlugin")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PluginStore.DeleteAllForPlugin(PluginID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPluginStore) Get(pluginID string, key string) (*model.PluginKeyValue, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.Get(pluginID, key)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) List(pluginID string, page int, perPage int) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.List")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.List(pluginID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) SaveOrUpdate(keyVal *model.PluginKeyValue) (*model.PluginKeyValue, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.SaveOrUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.SaveOrUpdate(keyVal)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPluginStore) SetWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PluginStore.SetWithOptions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PluginStore.SetWithOptions(pluginID, key, value, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) AnalyticsPostCount(teamID string, mustHaveFile bool, mustHaveHashtag bool) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.AnalyticsPostCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.AnalyticsPostCount(teamID, mustHaveFile, mustHaveHashtag)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) AnalyticsPostCountsByDay(options *model.AnalyticsPostCountsOptions) (model.AnalyticsRows, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.AnalyticsPostCountsByDay")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.AnalyticsPostCountsByDay(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) AnalyticsUserCountsWithPostsByDay(teamID string) (model.AnalyticsRows, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.AnalyticsUserCountsWithPostsByDay")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.AnalyticsUserCountsWithPostsByDay(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.PostStore.ClearCaches()

}

func (s *OpenTracingLayerPostStore) Delete(postID string, time int64, deleteByID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PostStore.Delete(postID, time, deleteByID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPostStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) Get(ctx context.Context, id string, opts model.GetPostsOptions, userID string, sanitizeOptions map[string]bool) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.Get(ctx, id, opts, userID, sanitizeOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetDirectPostParentsForExportAfter(limit int, afterID string) ([]*model.DirectPostForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetDirectPostParentsForExportAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetDirectPostParentsForExportAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetEtag(channelID string, allowFromCache bool, collapsedThreads bool) string {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetEtag")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.PostStore.GetEtag(channelID, allowFromCache, collapsedThreads)
	return result
}

func (s *OpenTracingLayerPostStore) GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetFlaggedPosts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetFlaggedPosts(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetFlaggedPostsForChannel(userID string, channelID string, offset int, limit int) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetFlaggedPostsForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetFlaggedPostsForChannel(userID, channelID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetFlaggedPostsForTeam(userID string, teamID string, offset int, limit int) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetFlaggedPostsForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	span.SetTag("userID", userID)

	span.SetTag("teamID", teamID)

	span.SetTag("offset", offset)

	span.SetTag("limit", limit)

	defer span.Finish()
	result, err := s.PostStore.GetFlaggedPostsForTeam(userID, teamID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetLastPostRowCreateAt() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetLastPostRowCreateAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetLastPostRowCreateAt()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetMaxPostSize() int {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetMaxPostSize")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.PostStore.GetMaxPostSize()
	return result
}

func (s *OpenTracingLayerPostStore) GetOldest() (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetOldest")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetOldest()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetOldestEntityCreationTime() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetOldestEntityCreationTime")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetOldestEntityCreationTime()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetParentsForExportAfter(limit int, afterID string) ([]*model.PostForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetParentsForExportAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetParentsForExportAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostAfterTime(channelID string, time int64, collapsedThreads bool) (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostAfterTime")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostAfterTime(channelID, time, collapsedThreads)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostIdAfterTime(channelID string, time int64, collapsedThreads bool) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostIdAfterTime")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostIdAfterTime(channelID, time, collapsedThreads)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostIdBeforeTime(channelID string, time int64, collapsedThreads bool) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostIdBeforeTime")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostIdBeforeTime(channelID, time, collapsedThreads)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPosts(options model.GetPostsOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPosts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPosts(options, allowFromCache, sanitizeOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsAfter(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsAfter(options, sanitizeOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsBatchForIndexing(startTime int64, startPostID string, limit int) ([]*model.PostForIndexing, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsBatchForIndexing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsBatchForIndexing(startTime, startPostID, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsBefore(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsBefore")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsBefore(options, sanitizeOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsByIds(postIds []string) ([]*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsByIds(postIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsCreatedAt(channelID string, time int64) ([]*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsCreatedAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsCreatedAt(channelID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsSince(options model.GetPostsSinceOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetPostsSince(options, allowFromCache, sanitizeOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetPostsSinceForSync(options model.GetPostsSinceForSyncOptions, cursor model.GetPostsSinceForSyncCursor, limit int) ([]*model.Post, model.GetPostsSinceForSyncCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetPostsSinceForSync")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.PostStore.GetPostsSinceForSync(options, cursor, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerPostStore) GetRepliesForExport(parentID string) ([]*model.ReplyForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetRepliesForExport")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetRepliesForExport(parentID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) GetSingle(id string, inclDeleted bool) (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.GetSingle")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.GetSingle(id, inclDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) HasAutoResponsePostByUserSince(options model.GetPostsSinceOptions, userId string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.HasAutoResponsePostByUserSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.HasAutoResponsePostByUserSince(options, userId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) InvalidateLastPostTimeCache(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.InvalidateLastPostTimeCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.PostStore.InvalidateLastPostTimeCache(channelID)

}

func (s *OpenTracingLayerPostStore) Overwrite(post *model.Post) (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Overwrite")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.Overwrite(post)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) OverwriteMultiple(posts []*model.Post) ([]*model.Post, int, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.OverwriteMultiple")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.PostStore.OverwriteMultiple(posts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerPostStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.PermanentDeleteBatch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.PermanentDeleteBatch(endTime, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.PermanentDeleteBatchForRetentionPolicies")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.PostStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerPostStore) PermanentDeleteByChannel(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.PermanentDeleteByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PostStore.PermanentDeleteByChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPostStore) PermanentDeleteByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.PermanentDeleteByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PostStore.PermanentDeleteByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPostStore) Save(post *model.Post) (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.Save(post)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) SaveMultiple(posts []*model.Post) ([]*model.Post, int, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.SaveMultiple")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.PostStore.SaveMultiple(posts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerPostStore) Search(teamID string, userID string, params *model.SearchParams) (*model.PostList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Search")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.Search(teamID, userID, params)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) SearchPostsForUser(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.PostSearchResults, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.SearchPostsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.SearchPostsForUser(paramsList, userID, teamID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPostStore) Update(newPost *model.Post, oldPost *model.Post) (*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PostStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PostStore.Update(newPost, oldPost)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) CleanupFlagsBatch(limit int64) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.CleanupFlagsBatch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PreferenceStore.CleanupFlagsBatch(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) Delete(userID string, category string, name string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PreferenceStore.Delete(userID, category, name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPreferenceStore) DeleteCategory(userID string, category string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.DeleteCategory")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PreferenceStore.DeleteCategory(userID, category)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPreferenceStore) DeleteCategoryAndName(category string, name string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.DeleteCategoryAndName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PreferenceStore.DeleteCategoryAndName(category, name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPreferenceStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PreferenceStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) Get(userID string, category string, name string) (*model.Preference, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PreferenceStore.Get(userID, category, name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) GetAll(userID string) (model.Preferences, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PreferenceStore.GetAll(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) GetCategory(userID string, category string) (model.Preferences, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.GetCategory")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.PreferenceStore.GetCategory(userID, category)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerPreferenceStore) PermanentDeleteByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.PermanentDeleteByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PreferenceStore.PermanentDeleteByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerPreferenceStore) Save(preferences model.Preferences) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "PreferenceStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.PreferenceStore.Save(preferences)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerProductNoticesStore) Clear(notices []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ProductNoticesStore.Clear")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ProductNoticesStore.Clear(notices)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerProductNoticesStore) ClearOldNotices(currentNotices model.ProductNotices) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ProductNoticesStore.ClearOldNotices")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ProductNoticesStore.ClearOldNotices(currentNotices)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerProductNoticesStore) GetViews(userID string) ([]model.ProductNoticeViewState, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ProductNoticesStore.GetViews")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ProductNoticesStore.GetViews(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerProductNoticesStore) View(userID string, notices []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ProductNoticesStore.View")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ProductNoticesStore.View(userID, notices)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerReactionStore) BulkGetForPosts(postIds []string) ([]*model.Reaction, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.BulkGetForPosts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.BulkGetForPosts(postIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) Delete(reaction *model.Reaction) (*model.Reaction, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.Delete(reaction)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) DeleteAllWithEmojiName(emojiName string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.DeleteAllWithEmojiName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ReactionStore.DeleteAllWithEmojiName(emojiName)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerReactionStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) GetForPost(postID string, allowFromCache bool) ([]*model.Reaction, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.GetForPost")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.GetForPost(postID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) GetForPostSince(postId string, since int64, excludeRemoteId string, inclDeleted bool) ([]*model.Reaction, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.GetForPostSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.GetForPostSince(postId, since, excludeRemoteId, inclDeleted)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) GetTopForTeamSince(teamID string, userID string, since int64, offset int, limit int) (*model.TopReactionList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.GetTopForTeamSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.GetTopForTeamSince(teamID, userID, since, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) GetTopForUserSince(userID string, teamID string, since int64, offset int, limit int) (*model.TopReactionList, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.GetTopForUserSince")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.GetTopForUserSince(userID, teamID, since, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.PermanentDeleteBatch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.PermanentDeleteBatch(endTime, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerReactionStore) Save(reaction *model.Reaction) (*model.Reaction, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ReactionStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ReactionStore.Save(reaction)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) Delete(remoteClusterId string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.Delete(remoteClusterId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) Get(remoteClusterId string) (*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.Get(remoteClusterId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) GetAll(filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.GetAll(filter)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) Save(rc *model.RemoteCluster) (*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.Save(rc)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) SetLastPingAt(remoteClusterId string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.SetLastPingAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RemoteClusterStore.SetLastPingAt(remoteClusterId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRemoteClusterStore) Update(rc *model.RemoteCluster) (*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.Update(rc)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRemoteClusterStore) UpdateTopics(remoteClusterId string, topics string) (*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RemoteClusterStore.UpdateTopics")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RemoteClusterStore.UpdateTopics(remoteClusterId, topics)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) AddChannels(policyId string, channelIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.AddChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RetentionPolicyStore.AddChannels(policyId, channelIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRetentionPolicyStore) AddTeams(policyId string, teamIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.AddTeams")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RetentionPolicyStore.AddTeams(policyId, teamIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRetentionPolicyStore) Delete(id string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RetentionPolicyStore.Delete(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRetentionPolicyStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) Get(id string) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetAll(offset int, limit int) ([]*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetAll(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetChannelPoliciesCountForUser(userID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetChannelPoliciesCountForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetChannelPoliciesCountForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetChannelPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetChannelPoliciesForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetChannelPoliciesForUser(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetChannels(policyId string, offset int, limit int) (model.ChannelListWithTeamData, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetChannels(policyId, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetChannelsCount(policyId string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetChannelsCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetChannelsCount(policyId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetTeamPoliciesCountForUser(userID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetTeamPoliciesCountForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetTeamPoliciesCountForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetTeamPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForTeam, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetTeamPoliciesForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetTeamPoliciesForUser(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetTeams(policyId string, offset int, limit int) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetTeams")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetTeams(policyId, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) GetTeamsCount(policyId string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.GetTeamsCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.GetTeamsCount(policyId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) Patch(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.Patch")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.Patch(patch)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRetentionPolicyStore) RemoveChannels(policyId string, channelIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.RemoveChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RetentionPolicyStore.RemoveChannels(policyId, channelIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRetentionPolicyStore) RemoveTeams(policyId string, teamIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.RemoveTeams")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RetentionPolicyStore.RemoveTeams(policyId, teamIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRetentionPolicyStore) Save(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RetentionPolicyStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RetentionPolicyStore.Save(policy)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) AllChannelSchemeRoles() ([]*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.AllChannelSchemeRoles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.AllChannelSchemeRoles()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) ChannelHigherScopedPermissions(roleNames []string) (map[string]*model.RolePermissions, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.ChannelHigherScopedPermissions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.ChannelHigherScopedPermissions(roleNames)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) ChannelRolesUnderTeamRole(roleName string) ([]*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.ChannelRolesUnderTeamRole")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.ChannelRolesUnderTeamRole(roleName)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) Delete(roleID string) (*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.Delete(roleID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) Get(roleID string) (*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.Get(roleID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) GetAll() ([]*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.GetAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) GetByName(ctx context.Context, name string) (*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.GetByName(ctx, name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) GetByNames(names []string) ([]*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.GetByNames")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.GetByNames(names)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerRoleStore) PermanentDeleteAll() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.PermanentDeleteAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.RoleStore.PermanentDeleteAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerRoleStore) Save(role *model.Role) (*model.Role, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "RoleStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.RoleStore.Save(role)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) CountByScope(scope string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.CountByScope")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.CountByScope(scope)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) CountWithoutPermission(scope string, permissionID string, roleScope model.RoleScope, roleType model.RoleType) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.CountWithoutPermission")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.CountWithoutPermission(scope, permissionID, roleScope, roleType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) Delete(schemeID string) (*model.Scheme, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.Delete(schemeID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) Get(schemeID string) (*model.Scheme, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.Get(schemeID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) GetAllPage(scope string, offset int, limit int) ([]*model.Scheme, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.GetAllPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.GetAllPage(scope, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) GetByName(schemeName string) (*model.Scheme, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.GetByName(schemeName)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSchemeStore) PermanentDeleteAll() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.PermanentDeleteAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SchemeStore.PermanentDeleteAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSchemeStore) Save(scheme *model.Scheme) (*model.Scheme, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SchemeStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SchemeStore.Save(scheme)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) AnalyticsSessionCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.AnalyticsSessionCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.AnalyticsSessionCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) Cleanup(expiryTime int64, batchSize int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.Cleanup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.Cleanup(expiryTime, batchSize)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) Get(ctx context.Context, sessionIDOrToken string) (*model.Session, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.Get(ctx, sessionIDOrToken)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) GetLastSessionRowCreateAt() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.GetLastSessionRowCreateAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.GetLastSessionRowCreateAt()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) GetSessions(userID string) ([]*model.Session, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.GetSessions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.GetSessions(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) GetSessionsExpired(thresholdMillis int64, mobileOnly bool, unnotifiedOnly bool) ([]*model.Session, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.GetSessionsExpired")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.GetSessionsExpired(thresholdMillis, mobileOnly, unnotifiedOnly)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) GetSessionsWithActiveDeviceIds(userID string) ([]*model.Session, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.GetSessionsWithActiveDeviceIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.GetSessionsWithActiveDeviceIds(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) PermanentDeleteSessionsByUser(teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.PermanentDeleteSessionsByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.PermanentDeleteSessionsByUser(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) Remove(sessionIDOrToken string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.Remove")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.Remove(sessionIDOrToken)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) RemoveAllSessions() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.RemoveAllSessions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.RemoveAllSessions()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) Save(session *model.Session) (*model.Session, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.Save(session)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) UpdateDeviceId(id string, deviceID string, expiresAt int64) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateDeviceId")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.UpdateDeviceId(id, deviceID, expiresAt)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSessionStore) UpdateExpiredNotify(sessionid string, notified bool) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateExpiredNotify")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.UpdateExpiredNotify(sessionid, notified)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) UpdateExpiresAt(sessionID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateExpiresAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.UpdateExpiresAt(sessionID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) UpdateLastActivityAt(sessionID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateLastActivityAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.UpdateLastActivityAt(sessionID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) UpdateProps(session *model.Session) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateProps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SessionStore.UpdateProps(session)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSessionStore) UpdateRoles(userID string, roles string) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SessionStore.UpdateRoles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SessionStore.UpdateRoles(userID, roles)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) Delete(channelId string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.Delete(channelId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) DeleteRemote(remoteId string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.DeleteRemote")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.DeleteRemote(remoteId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) Get(channelId string) (*model.SharedChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.Get(channelId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetAll(offset int, limit int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetAll(offset, limit, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetAllCount(opts model.SharedChannelFilterOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetAllCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetAllCount(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetAttachment(fileId string, remoteId string) (*model.SharedChannelAttachment, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetAttachment")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetAttachment(fileId, remoteId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetRemote(id string) (*model.SharedChannelRemote, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetRemote")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetRemote(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetRemoteByIds(channelId string, remoteId string) (*model.SharedChannelRemote, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetRemoteByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetRemoteByIds(channelId, remoteId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetRemoteForUser(remoteId string, userId string) (*model.RemoteCluster, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetRemoteForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetRemoteForUser(remoteId, userId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetRemotes(opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetRemotes")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetRemotes(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetRemotesStatus(channelId string) ([]*model.SharedChannelRemoteStatus, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetRemotesStatus")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetRemotesStatus(channelId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetSingleUser(userID string, channelID string, remoteID string) (*model.SharedChannelUser, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetSingleUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetSingleUser(userID, channelID, remoteID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetUsersForSync(filter model.GetUsersForSyncFilter) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetUsersForSync")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetUsersForSync(filter)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) GetUsersForUser(userID string) ([]*model.SharedChannelUser, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.GetUsersForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.GetUsersForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) HasChannel(channelID string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.HasChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.HasChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) HasRemote(channelID string, remoteId string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.HasRemote")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.HasRemote(channelID, remoteId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) Save(sc *model.SharedChannel) (*model.SharedChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.Save(sc)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) SaveAttachment(remote *model.SharedChannelAttachment) (*model.SharedChannelAttachment, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.SaveAttachment")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.SaveAttachment(remote)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) SaveRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.SaveRemote")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.SaveRemote(remote)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) SaveUser(remote *model.SharedChannelUser) (*model.SharedChannelUser, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.SaveUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.SaveUser(remote)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) Update(sc *model.SharedChannel) (*model.SharedChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.Update(sc)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) UpdateAttachmentLastSyncAt(id string, syncTime int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.UpdateAttachmentLastSyncAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SharedChannelStore.UpdateAttachmentLastSyncAt(id, syncTime)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSharedChannelStore) UpdateRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.UpdateRemote")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.UpdateRemote(remote)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSharedChannelStore) UpdateRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.UpdateRemoteCursor")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SharedChannelStore.UpdateRemoteCursor(id, cursor)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSharedChannelStore) UpdateUserLastSyncAt(userID string, channelID string, remoteID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.UpdateUserLastSyncAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SharedChannelStore.UpdateUserLastSyncAt(userID, channelID, remoteID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSharedChannelStore) UpsertAttachment(remote *model.SharedChannelAttachment) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SharedChannelStore.UpsertAttachment")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SharedChannelStore.UpsertAttachment(remote)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerStatusStore) Get(userID string) (*model.Status, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.StatusStore.Get(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerStatusStore) GetByIds(userIds []string) ([]*model.Status, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.GetByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.StatusStore.GetByIds(userIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerStatusStore) GetTotalActiveUsersCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.GetTotalActiveUsersCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.StatusStore.GetTotalActiveUsersCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerStatusStore) ResetAll() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.ResetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.StatusStore.ResetAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerStatusStore) SaveOrUpdate(status *model.Status) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.SaveOrUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.StatusStore.SaveOrUpdate(status)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerStatusStore) UpdateExpiredDNDStatuses() ([]*model.Status, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.UpdateExpiredDNDStatuses")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.StatusStore.UpdateExpiredDNDStatuses()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerStatusStore) UpdateLastActivityAt(userID string, lastActivityAt int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "StatusStore.UpdateLastActivityAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.StatusStore.UpdateLastActivityAt(userID, lastActivityAt)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSystemStore) Get() (model.StringMap, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SystemStore.Get()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSystemStore) GetByName(name string) (*model.System, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SystemStore.GetByName(name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSystemStore) InsertIfExists(system *model.System) (*model.System, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.InsertIfExists")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SystemStore.InsertIfExists(system)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSystemStore) PermanentDeleteByName(name string) (*model.System, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.PermanentDeleteByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.SystemStore.PermanentDeleteByName(name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerSystemStore) Save(system *model.System) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SystemStore.Save(system)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSystemStore) SaveOrUpdate(system *model.System) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.SaveOrUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SystemStore.SaveOrUpdate(system)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSystemStore) SaveOrUpdateWithWarnMetricHandling(system *model.System) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.SaveOrUpdateWithWarnMetricHandling")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SystemStore.SaveOrUpdateWithWarnMetricHandling(system)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerSystemStore) Update(system *model.System) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "SystemStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.SystemStore.Update(system)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) AnalyticsGetTeamCountForScheme(schemeID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.AnalyticsGetTeamCountForScheme")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.AnalyticsGetTeamCountForScheme(schemeID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) AnalyticsTeamCount(opts *model.TeamSearch) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.AnalyticsTeamCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.AnalyticsTeamCount(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) ClearAllCustomRoleAssignments() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.ClearAllCustomRoleAssignments")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.ClearAllCustomRoleAssignments()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.TeamStore.ClearCaches()

}

func (s *OpenTracingLayerTeamStore) Get(id string) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetActiveMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetActiveMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetActiveMemberCount(teamID, restrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetAll() ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetAllForExportAfter(limit int, afterID string) ([]*model.TeamForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetAllForExportAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetAllForExportAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetAllPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetAllPage")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetAllPage(offset, limit, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetAllPrivateTeamListing() ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetAllPrivateTeamListing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetAllPrivateTeamListing()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetAllTeamListing() ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetAllTeamListing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetAllTeamListing()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetByInviteId(inviteID string) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetByInviteId")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetByInviteId(inviteID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetByName(name string) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetByName")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetByName(name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetByNames(name []string) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetByNames")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetByNames(name)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetChannelUnreadsForAllTeams(excludeTeamID string, userID string) ([]*model.ChannelUnread, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetChannelUnreadsForAllTeams")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetChannelUnreadsForAllTeams(excludeTeamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetChannelUnreadsForTeam(teamID string, userID string) ([]*model.ChannelUnread, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetChannelUnreadsForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetChannelUnreadsForTeam(teamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetCommonTeamIDsForTwoUsers(userID string, otherUserID string) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetCommonTeamIDsForTwoUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetCommonTeamIDsForTwoUsers(userID, otherUserID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetMany(ids []string) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetMany")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetMany(ids)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetMember(ctx context.Context, teamID string, userID string) (*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetMember(ctx, teamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetMembers(teamID, offset, limit, teamMembersGetOptions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetMembersByIds(teamID string, userIds []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetMembersByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetMembersByIds(teamID, userIds, restrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTeamMembersForExport(userID string) ([]*model.TeamMemberForExport, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTeamMembersForExport")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTeamMembersForExport(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTeamsByScheme(schemeID string, offset int, limit int) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTeamsByScheme")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTeamsByScheme(schemeID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTeamsByUserId(userID string) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTeamsByUserId")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTeamsByUserId(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTeamsForUser(ctx context.Context, userID string) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTeamsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTeamsForUser(ctx, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTeamsForUserWithPagination(userID string, page int, perPage int) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTeamsForUserWithPagination")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTeamsForUserWithPagination(userID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetTotalMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetTotalMemberCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetTotalMemberCount(teamID, restrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GetUserTeamIds(userID string, allowFromCache bool) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GetUserTeamIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GetUserTeamIds(userID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) GroupSyncedTeamCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.GroupSyncedTeamCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.GroupSyncedTeamCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) InvalidateAllTeamIdsForUser(userID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.InvalidateAllTeamIdsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.TeamStore.InvalidateAllTeamIdsForUser(userID)

}

func (s *OpenTracingLayerTeamStore) MigrateTeamMembers(fromTeamID string, fromUserID string) (map[string]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.MigrateTeamMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.MigrateTeamMembers(fromTeamID, fromUserID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) PermanentDelete(teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.PermanentDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.PermanentDelete(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) RemoveAllMembersByTeam(teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.RemoveAllMembersByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.RemoveAllMembersByTeam(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) RemoveAllMembersByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.RemoveAllMembersByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.RemoveAllMembersByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) RemoveMember(teamID string, userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.RemoveMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.RemoveMember(teamID, userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) RemoveMembers(teamID string, userIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.RemoveMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.RemoveMembers(teamID, userIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) ResetAllTeamSchemes() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.ResetAllTeamSchemes")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.ResetAllTeamSchemes()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) Save(team *model.Team) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.Save(team)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) SaveMember(member *model.TeamMember, maxUsersPerTeam int) (*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SaveMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.SaveMember(member, maxUsersPerTeam)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) SaveMultipleMembers(members []*model.TeamMember, maxUsersPerTeam int) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SaveMultipleMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.SaveMultipleMembers(members, maxUsersPerTeam)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) SearchAll(opts *model.TeamSearch) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SearchAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.SearchAll(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) SearchAllPaged(opts *model.TeamSearch) ([]*model.Team, int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SearchAllPaged")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.TeamStore.SearchAllPaged(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerTeamStore) SearchOpen(opts *model.TeamSearch) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SearchOpen")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.SearchOpen(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) SearchPrivate(opts *model.TeamSearch) ([]*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.SearchPrivate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.SearchPrivate(opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) Update(team *model.Team) (*model.Team, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.Update(team)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) UpdateLastTeamIconUpdate(teamID string, curTime int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.UpdateLastTeamIconUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.UpdateLastTeamIconUpdate(teamID, curTime)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) UpdateMember(member *model.TeamMember) (*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.UpdateMember")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.UpdateMember(member)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) UpdateMembersRole(teamID string, userIDs []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.UpdateMembersRole")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TeamStore.UpdateMembersRole(teamID, userIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTeamStore) UpdateMultipleMembers(members []*model.TeamMember) ([]*model.TeamMember, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.UpdateMultipleMembers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.UpdateMultipleMembers(members)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTeamStore) UserBelongsToTeams(userID string, teamIds []string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TeamStore.UserBelongsToTeams")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TeamStore.UserBelongsToTeams(userID, teamIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTermsOfServiceStore) Get(id string, allowFromCache bool) (*model.TermsOfService, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TermsOfServiceStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TermsOfServiceStore.Get(id, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTermsOfServiceStore) GetLatest(allowFromCache bool) (*model.TermsOfService, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TermsOfServiceStore.GetLatest")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TermsOfServiceStore.GetLatest(allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTermsOfServiceStore) Save(termsOfService *model.TermsOfService) (*model.TermsOfService, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TermsOfServiceStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TermsOfServiceStore.Save(termsOfService)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) DeleteMembershipForUser(userId string, postID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.DeleteMembershipForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ThreadStore.DeleteMembershipForUser(userId, postID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerThreadStore) DeleteOrphanedRows(limit int) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.DeleteOrphanedRows")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.DeleteOrphanedRows(limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) Get(id string) (*model.Thread, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetMembershipForUser(userId string, postID string) (*model.ThreadMembership, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetMembershipForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetMembershipForUser(userId, postID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetMembershipsForUser(userId string, teamID string) ([]*model.ThreadMembership, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetMembershipsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetMembershipsForUser(userId, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetPosts(threadID string, since int64) ([]*model.Post, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetPosts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetPosts(threadID, since)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetTeamsUnreadForUser(userID string, teamIDs []string) (map[string]*model.TeamUnread, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetTeamsUnreadForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetTeamsUnreadForUser(userID, teamIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetThreadFollowers(threadID string, fetchOnlyActive bool) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetThreadFollowers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetThreadFollowers(threadID, fetchOnlyActive)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetThreadForUser(teamID string, threadMembership *model.ThreadMembership, extended bool) (*model.ThreadResponse, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetThreadForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetThreadForUser(teamID, threadMembership, extended)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetThreadUnreadReplyCount(threadMembership *model.ThreadMembership) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetThreadUnreadReplyCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetThreadUnreadReplyCount(threadMembership)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetThreadsForUser(userId string, teamID string, opts model.GetUserThreadsOpts) ([]*model.ThreadResponse, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetThreadsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetThreadsForUser(userId, teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetTotalThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetTotalThreads")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetTotalThreads(userId, teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetTotalUnreadMentions(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetTotalUnreadMentions")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetTotalUnreadMentions(userId, teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) GetTotalUnreadThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.GetTotalUnreadThreads")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.GetTotalUnreadThreads(userId, teamID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) MaintainMembership(userID string, postID string, opts store.ThreadMembershipOpts) (*model.ThreadMembership, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.MaintainMembership")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.MaintainMembership(userID, postID, opts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerThreadStore) MarkAllAsRead(userID string, threadIds []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.MarkAllAsRead")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ThreadStore.MarkAllAsRead(userID, threadIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerThreadStore) MarkAllAsReadByChannels(userID string, channelIDs []string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.MarkAllAsReadByChannels")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ThreadStore.MarkAllAsReadByChannels(userID, channelIDs)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerThreadStore) MarkAllAsReadByTeam(userID string, teamID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.MarkAllAsReadByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ThreadStore.MarkAllAsReadByTeam(userID, teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerThreadStore) MarkAsRead(userID string, threadID string, timestamp int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.MarkAsRead")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.ThreadStore.MarkAsRead(userID, threadID, timestamp)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerThreadStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.PermanentDeleteBatchForRetentionPolicies")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerThreadStore) PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, resultVar1, err
}

func (s *OpenTracingLayerThreadStore) UpdateMembership(membership *model.ThreadMembership) (*model.ThreadMembership, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "ThreadStore.UpdateMembership")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.ThreadStore.UpdateMembership(membership)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTokenStore) Cleanup(expiryTime int64) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.Cleanup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.TokenStore.Cleanup(expiryTime)

}

func (s *OpenTracingLayerTokenStore) Delete(token string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TokenStore.Delete(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTokenStore) GetAllTokensByType(tokenType string) ([]*model.Token, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.GetAllTokensByType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TokenStore.GetAllTokensByType(tokenType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTokenStore) GetByToken(token string) (*model.Token, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.GetByToken")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.TokenStore.GetByToken(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerTokenStore) RemoveAllTokensByType(tokenType string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.RemoveAllTokensByType")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TokenStore.RemoveAllTokensByType(tokenType)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerTokenStore) Save(recovery *model.Token) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "TokenStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.TokenStore.Save(recovery)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUploadSessionStore) Delete(id string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UploadSessionStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UploadSessionStore.Delete(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUploadSessionStore) Get(id string) (*model.UploadSession, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UploadSessionStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UploadSessionStore.Get(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUploadSessionStore) GetForUser(userID string) ([]*model.UploadSession, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UploadSessionStore.GetForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UploadSessionStore.GetForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUploadSessionStore) Save(session *model.UploadSession) (*model.UploadSession, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UploadSessionStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UploadSessionStore.Save(session)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUploadSessionStore) Update(session *model.UploadSession) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UploadSessionStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UploadSessionStore.Update(session)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) AnalyticsActiveCount(time int64, options model.UserCountOptions) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsActiveCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsActiveCount(time, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AnalyticsActiveCountForPeriod(startTime int64, endTime int64, options model.UserCountOptions) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsActiveCountForPeriod")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsActiveCountForPeriod(startTime, endTime, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AnalyticsGetExternalUsers(hostDomain string) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsGetExternalUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsGetExternalUsers(hostDomain)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AnalyticsGetGuestCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsGetGuestCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsGetGuestCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AnalyticsGetInactiveUsersCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsGetInactiveUsersCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsGetInactiveUsersCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AnalyticsGetSystemAdminCount() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AnalyticsGetSystemAdminCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AnalyticsGetSystemAdminCount()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) AutocompleteUsersInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.AutocompleteUsersInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.AutocompleteUsersInChannel(teamID, channelID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) ClearAllCustomRoleAssignments() error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.ClearAllCustomRoleAssignments")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.ClearAllCustomRoleAssignments()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.UserStore.ClearCaches()

}

func (s *OpenTracingLayerUserStore) Count(options model.UserCountOptions) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.Count")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.Count(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) DeactivateGuests() ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.DeactivateGuests")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.DeactivateGuests()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) DemoteUserToGuest(userID string) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.DemoteUserToGuest")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.DemoteUserToGuest(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) Get(ctx context.Context, id string) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.Get(ctx, id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAll() ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAll()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAllAfter(limit int, afterID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAllAfter")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAllAfter(limit, afterID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAllNotInAuthService(authServices []string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAllNotInAuthService")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAllNotInAuthService(authServices)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAllProfiles(options *model.UserGetOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAllProfiles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAllProfiles(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAllProfilesInChannel(ctx context.Context, channelID string, allowFromCache bool) (map[string]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAllProfilesInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAllProfilesInChannel(ctx, channelID, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAllUsingAuthService(authService string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAllUsingAuthService")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAllUsingAuthService(authService)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetAnyUnreadPostCountForChannel(userID string, channelID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetAnyUnreadPostCountForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetAnyUnreadPostCountForChannel(userID, channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetByAuth(authData *string, authService string) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetByAuth")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetByAuth(authData, authService)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetByEmail(email string) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetByEmail")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetByEmail(email)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetByUsername(username string) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetByUsername")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetByUsername(username)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetChannelGroupUsers(channelID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetChannelGroupUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetChannelGroupUsers(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetEtagForAllProfiles() string {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetEtagForAllProfiles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.UserStore.GetEtagForAllProfiles()
	return result
}

func (s *OpenTracingLayerUserStore) GetEtagForProfiles(teamID string) string {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetEtagForProfiles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.UserStore.GetEtagForProfiles(teamID)
	return result
}

func (s *OpenTracingLayerUserStore) GetEtagForProfilesNotInTeam(teamID string) string {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetEtagForProfilesNotInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result := s.UserStore.GetEtagForProfilesNotInTeam(teamID)
	return result
}

func (s *OpenTracingLayerUserStore) GetForLogin(loginID string, allowSignInWithUsername bool, allowSignInWithEmail bool) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetForLogin")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetForLogin(loginID, allowSignInWithUsername, allowSignInWithEmail)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetKnownUsers(userID string) ([]string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetKnownUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetKnownUsers(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetMany(ctx context.Context, ids []string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetMany")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetMany(ctx, ids)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetNewUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetNewUsersForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetNewUsersForTeam(teamID, offset, limit, viewRestrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfileByGroupChannelIdsForUser(userID string, channelIds []string) (map[string][]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfileByGroupChannelIdsForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfileByGroupChannelIdsForUser(userID, channelIds)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfileByIds(ctx context.Context, userIds []string, options *store.UserGetByIdsOpts, allowFromCache bool) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfileByIds")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfileByIds(ctx, userIds, options, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfiles(options *model.UserGetOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfiles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfiles(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesByUsernames(usernames []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesByUsernames")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesByUsernames(usernames, viewRestrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesInChannel(options *model.UserGetOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesInChannel(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesInChannelByStatus(options *model.UserGetOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesInChannelByStatus")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesInChannelByStatus(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesNotInChannel(teamID string, channelId string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesNotInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesNotInChannel(teamID, channelId, groupConstrained, offset, limit, viewRestrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesNotInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesNotInTeam(teamID, groupConstrained, offset, limit, viewRestrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetProfilesWithoutTeam(options *model.UserGetOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetProfilesWithoutTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetProfilesWithoutTeam(options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetRecentlyActiveUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetRecentlyActiveUsersForTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetRecentlyActiveUsersForTeam(teamID, offset, limit, viewRestrictions)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetSystemAdminProfiles() (map[string]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetSystemAdminProfiles")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetSystemAdminProfiles()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetTeamGroupUsers(teamID string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetTeamGroupUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetTeamGroupUsers(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetUnreadCount(userID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetUnreadCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetUnreadCount(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetUnreadCountForChannel(userID string, channelID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetUnreadCountForChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetUnreadCountForChannel(userID, channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetUsersBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.UserForIndexing, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetUsersBatchForIndexing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetUsersBatchForIndexing(startTime, startFileID, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) GetUsersWithInvalidEmails(page int, perPage int, restrictedDomains string) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.GetUsersWithInvalidEmails")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.GetUsersWithInvalidEmails(page, perPage, restrictedDomains)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) InferSystemInstallDate() (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.InferSystemInstallDate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.InferSystemInstallDate()
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) InsertUsers(users []*model.User) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.InsertUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.InsertUsers(users)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) InvalidateProfileCacheForUser(userID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.InvalidateProfileCacheForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.UserStore.InvalidateProfileCacheForUser(userID)

}

func (s *OpenTracingLayerUserStore) InvalidateProfilesInChannelCache(channelID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.InvalidateProfilesInChannelCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.UserStore.InvalidateProfilesInChannelCache(channelID)

}

func (s *OpenTracingLayerUserStore) InvalidateProfilesInChannelCacheByUser(userID string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.InvalidateProfilesInChannelCacheByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.UserStore.InvalidateProfilesInChannelCacheByUser(userID)

}

func (s *OpenTracingLayerUserStore) IsEmpty(excludeBots bool) (bool, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.IsEmpty")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.IsEmpty(excludeBots)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) PermanentDelete(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.PermanentDelete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.PermanentDelete(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) PromoteGuestToUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.PromoteGuestToUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.PromoteGuestToUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) ResetAuthDataToEmailForUsers(service string, userIDs []string, includeDeleted bool, dryRun bool) (int, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.ResetAuthDataToEmailForUsers")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.ResetAuthDataToEmailForUsers(service, userIDs, includeDeleted, dryRun)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) ResetLastPictureUpdate(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.ResetLastPictureUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.ResetLastPictureUpdate(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) Save(user *model.User) (*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.Save(user)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) Search(teamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.Search")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.Search(teamID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchInChannel(channelID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchInGroup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchInGroup(groupID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchNotInChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchNotInChannel(teamID, channelID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchNotInGroup")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchNotInGroup(groupID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchNotInTeam(notInTeamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchNotInTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchNotInTeam(notInTeamID, term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) SearchWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.SearchWithoutTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.SearchWithoutTeam(term, options)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) Update(user *model.User, allowRoleUpdate bool) (*model.UserUpdate, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.Update")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.Update(user, allowRoleUpdate)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) UpdateAuthData(userID string, service string, authData *string, email string, resetMfa bool) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateAuthData")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.UpdateAuthData(userID, service, authData, email, resetMfa)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) UpdateFailedPasswordAttempts(userID string, attempts int) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateFailedPasswordAttempts")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdateFailedPasswordAttempts(userID, attempts)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdateLastPictureUpdate(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateLastPictureUpdate")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdateLastPictureUpdate(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdateMfaActive(userID string, active bool) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateMfaActive")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdateMfaActive(userID, active)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdateMfaSecret(userID string, secret string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateMfaSecret")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdateMfaSecret(userID, secret)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdateNotifyProps(userID string, props map[string]string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateNotifyProps")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdateNotifyProps(userID, props)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdatePassword(userID string, newPassword string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdatePassword")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserStore.UpdatePassword(userID, newPassword)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserStore) UpdateUpdateAt(userID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.UpdateUpdateAt")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.UpdateUpdateAt(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserStore) VerifyEmail(userID string, email string) (string, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserStore.VerifyEmail")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserStore.VerifyEmail(userID, email)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) Delete(tokenID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserAccessTokenStore.Delete(tokenID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserAccessTokenStore) DeleteAllForUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.DeleteAllForUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserAccessTokenStore.DeleteAllForUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserAccessTokenStore) Get(tokenID string) (*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.Get")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.Get(tokenID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) GetAll(offset int, limit int) ([]*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.GetAll")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.GetAll(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) GetByToken(tokenString string) (*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.GetByToken")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.GetByToken(tokenString)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) GetByUser(userID string, page int, perPage int) ([]*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.GetByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.GetByUser(userID, page, perPage)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) Save(token *model.UserAccessToken) (*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.Save(token)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) Search(term string) ([]*model.UserAccessToken, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.Search")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserAccessTokenStore.Search(term)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserAccessTokenStore) UpdateTokenDisable(tokenID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.UpdateTokenDisable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserAccessTokenStore.UpdateTokenDisable(tokenID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserAccessTokenStore) UpdateTokenEnable(tokenID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserAccessTokenStore.UpdateTokenEnable")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserAccessTokenStore.UpdateTokenEnable(tokenID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserTermsOfServiceStore) Delete(userID string, termsOfServiceId string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserTermsOfServiceStore.Delete")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.UserTermsOfServiceStore.Delete(userID, termsOfServiceId)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerUserTermsOfServiceStore) GetByUser(userID string) (*model.UserTermsOfService, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserTermsOfServiceStore.GetByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserTermsOfServiceStore.GetByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerUserTermsOfServiceStore) Save(userTermsOfService *model.UserTermsOfService) (*model.UserTermsOfService, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "UserTermsOfServiceStore.Save")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.UserTermsOfServiceStore.Save(userTermsOfService)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) AnalyticsIncomingCount(teamID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.AnalyticsIncomingCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.AnalyticsIncomingCount(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) AnalyticsOutgoingCount(teamID string) (int64, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.AnalyticsOutgoingCount")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.AnalyticsOutgoingCount(teamID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) ClearCaches() {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.ClearCaches")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.WebhookStore.ClearCaches()

}

func (s *OpenTracingLayerWebhookStore) DeleteIncoming(webhookID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.DeleteIncoming")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.DeleteIncoming(webhookID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) DeleteOutgoing(webhookID string, time int64) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.DeleteOutgoing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.DeleteOutgoing(webhookID, time)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) GetIncoming(id string, allowFromCache bool) (*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncoming")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncoming(id, allowFromCache)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetIncomingByChannel(channelID string) ([]*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncomingByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncomingByChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetIncomingByTeam(teamID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncomingByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncomingByTeam(teamID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetIncomingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncomingByTeamByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncomingByTeamByUser(teamID, userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetIncomingList(offset int, limit int) ([]*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncomingList")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncomingList(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetIncomingListByUser(userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetIncomingListByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetIncomingListByUser(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoing(id string) (*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoing(id)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingByChannel(channelID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingByChannel(channelID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingByChannelByUser(channelID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingByChannelByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingByChannelByUser(channelID, userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingByTeam(teamID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingByTeam")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingByTeam(teamID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingByTeamByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingByTeamByUser(teamID, userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingList(offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingList")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingList(offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) GetOutgoingListByUser(userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.GetOutgoingListByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.GetOutgoingListByUser(userID, offset, limit)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) InvalidateWebhookCache(webhook string) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.InvalidateWebhookCache")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	s.WebhookStore.InvalidateWebhookCache(webhook)

}

func (s *OpenTracingLayerWebhookStore) PermanentDeleteIncomingByChannel(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.PermanentDeleteIncomingByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.PermanentDeleteIncomingByChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) PermanentDeleteIncomingByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.PermanentDeleteIncomingByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.PermanentDeleteIncomingByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) PermanentDeleteOutgoingByChannel(channelID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.PermanentDeleteOutgoingByChannel")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.PermanentDeleteOutgoingByChannel(channelID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) PermanentDeleteOutgoingByUser(userID string) error {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.PermanentDeleteOutgoingByUser")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	err := s.WebhookStore.PermanentDeleteOutgoingByUser(userID)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return err
}

func (s *OpenTracingLayerWebhookStore) SaveIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.SaveIncoming")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.SaveIncoming(webhook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) SaveOutgoing(webhook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.SaveOutgoing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.SaveOutgoing(webhook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) UpdateIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.UpdateIncoming")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.UpdateIncoming(webhook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayerWebhookStore) UpdateOutgoing(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {
	origCtx := s.Root.Store.Context()
	span, newCtx := tracing.StartSpanWithParentByContext(s.Root.Store.Context(), "WebhookStore.UpdateOutgoing")
	s.Root.Store.SetContext(newCtx)
	defer func() {
		s.Root.Store.SetContext(origCtx)
	}()

	defer span.Finish()
	result, err := s.WebhookStore.UpdateOutgoing(hook)
	if err != nil {
		span.LogFields(spanlog.Error(err))
		ext.Error.Set(span, true)
	}

	return result, err
}

func (s *OpenTracingLayer) Close() {
	s.Store.Close()
}

func (s *OpenTracingLayer) DropAllTables() {
	s.Store.DropAllTables()
}

func (s *OpenTracingLayer) LockToMaster() {
	s.Store.LockToMaster()
}

func (s *OpenTracingLayer) MarkSystemRanUnitTests() {
	s.Store.MarkSystemRanUnitTests()
}

func (s *OpenTracingLayer) SetContext(context context.Context) {
	s.Store.SetContext(context)
}

func (s *OpenTracingLayer) TotalMasterDbConnections() int {
	return s.Store.TotalMasterDbConnections()
}

func (s *OpenTracingLayer) TotalReadDbConnections() int {
	return s.Store.TotalReadDbConnections()
}

func (s *OpenTracingLayer) TotalSearchDbConnections() int {
	return s.Store.TotalSearchDbConnections()
}

func (s *OpenTracingLayer) UnlockFromMaster() {
	s.Store.UnlockFromMaster()
}

func New(childStore store.Store, ctx context.Context) *OpenTracingLayer {
	newStore := OpenTracingLayer{
		Store: childStore,
	}

	newStore.AuditStore = &OpenTracingLayerAuditStore{AuditStore: childStore.Audit(), Root: &newStore}
	newStore.BotStore = &OpenTracingLayerBotStore{BotStore: childStore.Bot(), Root: &newStore}
	newStore.ChannelStore = &OpenTracingLayerChannelStore{ChannelStore: childStore.Channel(), Root: &newStore}
	newStore.ChannelMemberHistoryStore = &OpenTracingLayerChannelMemberHistoryStore{ChannelMemberHistoryStore: childStore.ChannelMemberHistory(), Root: &newStore}
	newStore.ClusterDiscoveryStore = &OpenTracingLayerClusterDiscoveryStore{ClusterDiscoveryStore: childStore.ClusterDiscovery(), Root: &newStore}
	newStore.CommandStore = &OpenTracingLayerCommandStore{CommandStore: childStore.Command(), Root: &newStore}
	newStore.CommandWebhookStore = &OpenTracingLayerCommandWebhookStore{CommandWebhookStore: childStore.CommandWebhook(), Root: &newStore}
	newStore.ComplianceStore = &OpenTracingLayerComplianceStore{ComplianceStore: childStore.Compliance(), Root: &newStore}
	newStore.EmojiStore = &OpenTracingLayerEmojiStore{EmojiStore: childStore.Emoji(), Root: &newStore}
	newStore.FileInfoStore = &OpenTracingLayerFileInfoStore{FileInfoStore: childStore.FileInfo(), Root: &newStore}
	newStore.GroupStore = &OpenTracingLayerGroupStore{GroupStore: childStore.Group(), Root: &newStore}
	newStore.JobStore = &OpenTracingLayerJobStore{JobStore: childStore.Job(), Root: &newStore}
	newStore.LicenseStore = &OpenTracingLayerLicenseStore{LicenseStore: childStore.License(), Root: &newStore}
	newStore.LinkMetadataStore = &OpenTracingLayerLinkMetadataStore{LinkMetadataStore: childStore.LinkMetadata(), Root: &newStore}
	newStore.OAuthStore = &OpenTracingLayerOAuthStore{OAuthStore: childStore.OAuth(), Root: &newStore}
	newStore.PluginStore = &OpenTracingLayerPluginStore{PluginStore: childStore.Plugin(), Root: &newStore}
	newStore.PostStore = &OpenTracingLayerPostStore{PostStore: childStore.Post(), Root: &newStore}
	newStore.PreferenceStore = &OpenTracingLayerPreferenceStore{PreferenceStore: childStore.Preference(), Root: &newStore}
	newStore.ProductNoticesStore = &OpenTracingLayerProductNoticesStore{ProductNoticesStore: childStore.ProductNotices(), Root: &newStore}
	newStore.ReactionStore = &OpenTracingLayerReactionStore{ReactionStore: childStore.Reaction(), Root: &newStore}
	newStore.RemoteClusterStore = &OpenTracingLayerRemoteClusterStore{RemoteClusterStore: childStore.RemoteCluster(), Root: &newStore}
	newStore.RetentionPolicyStore = &OpenTracingLayerRetentionPolicyStore{RetentionPolicyStore: childStore.RetentionPolicy(), Root: &newStore}
	newStore.RoleStore = &OpenTracingLayerRoleStore{RoleStore: childStore.Role(), Root: &newStore}
	newStore.SchemeStore = &OpenTracingLayerSchemeStore{SchemeStore: childStore.Scheme(), Root: &newStore}
	newStore.SessionStore = &OpenTracingLayerSessionStore{SessionStore: childStore.Session(), Root: &newStore}
	newStore.SharedChannelStore = &OpenTracingLayerSharedChannelStore{SharedChannelStore: childStore.SharedChannel(), Root: &newStore}
	newStore.StatusStore = &OpenTracingLayerStatusStore{StatusStore: childStore.Status(), Root: &newStore}
	newStore.SystemStore = &OpenTracingLayerSystemStore{SystemStore: childStore.System(), Root: &newStore}
	newStore.TeamStore = &OpenTracingLayerTeamStore{TeamStore: childStore.Team(), Root: &newStore}
	newStore.TermsOfServiceStore = &OpenTracingLayerTermsOfServiceStore{TermsOfServiceStore: childStore.TermsOfService(), Root: &newStore}
	newStore.ThreadStore = &OpenTracingLayerThreadStore{ThreadStore: childStore.Thread(), Root: &newStore}
	newStore.TokenStore = &OpenTracingLayerTokenStore{TokenStore: childStore.Token(), Root: &newStore}
	newStore.UploadSessionStore = &OpenTracingLayerUploadSessionStore{UploadSessionStore: childStore.UploadSession(), Root: &newStore}
	newStore.UserStore = &OpenTracingLayerUserStore{UserStore: childStore.User(), Root: &newStore}
	newStore.UserAccessTokenStore = &OpenTracingLayerUserAccessTokenStore{UserAccessTokenStore: childStore.UserAccessToken(), Root: &newStore}
	newStore.UserTermsOfServiceStore = &OpenTracingLayerUserTermsOfServiceStore{UserTermsOfServiceStore: childStore.UserTermsOfService(), Root: &newStore}
	newStore.WebhookStore = &OpenTracingLayerWebhookStore{WebhookStore: childStore.Webhook(), Root: &newStore}
	return &newStore
}
