// Code generated by mockery v2.10.4. DO NOT EDIT.

// Regenerate this file using `make store-mocks`.

package mocks

import (
	context "context"

	model "github.com/mattermost/mattermost-server/v6/model"
	mock "github.com/stretchr/testify/mock"

	store "github.com/mattermost/mattermost-server/v6/store"
)

// ChannelStore is an autogenerated mock type for the ChannelStore type
type ChannelStore struct {
	mock.Mock
}

// AnalyticsDeletedTypeCount provides a mock function with given fields: teamID, channelType
func (_m *ChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	ret := _m.Called(teamID, channelType)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) int64); ok {
		r0 = rf(teamID, channelType)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, model.ChannelType) error); ok {
		r1 = rf(teamID, channelType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AnalyticsTypeCount provides a mock function with given fields: teamID, channelType
func (_m *ChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	ret := _m.Called(teamID, channelType)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) int64); ok {
		r0 = rf(teamID, channelType)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, model.ChannelType) error); ok {
		r1 = rf(teamID, channelType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Autocomplete provides a mock function with given fields: userID, term, includeDeleted, isGuest
func (_m *ChannelStore) Autocomplete(userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {
	ret := _m.Called(userID, term, includeDeleted, isGuest)

	var r0 model.ChannelListWithTeamData
	if rf, ok := ret.Get(0).(func(string, string, bool, bool) model.ChannelListWithTeamData); ok {
		r0 = rf(userID, term, includeDeleted, isGuest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, bool, bool) error); ok {
		r1 = rf(userID, term, includeDeleted, isGuest)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AutocompleteInTeam provides a mock function with given fields: teamID, userID, term, includeDeleted, isGuest
func (_m *ChannelStore) AutocompleteInTeam(teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, term, includeDeleted, isGuest)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, string, bool, bool) model.ChannelList); ok {
		r0 = rf(teamID, userID, term, includeDeleted, isGuest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string, bool, bool) error); ok {
		r1 = rf(teamID, userID, term, includeDeleted, isGuest)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AutocompleteInTeamForSearch provides a mock function with given fields: teamID, userID, term, includeDeleted
func (_m *ChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, term, includeDeleted)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, string, bool) model.ChannelList); ok {
		r0 = rf(teamID, userID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string, bool) error); ok {
		r1 = rf(teamID, userID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ClearAllCustomRoleAssignments provides a mock function with given fields:
func (_m *ChannelStore) ClearAllCustomRoleAssignments() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ClearCaches provides a mock function with given fields:
func (_m *ChannelStore) ClearCaches() {
	_m.Called()
}

// ClearSidebarOnTeamLeave provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {
	ret := _m.Called(userID, teamID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(userID, teamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CountPostsAfter provides a mock function with given fields: channelID, timestamp, userID
func (_m *ChannelStore) CountPostsAfter(channelID string, timestamp int64, userID string) (int, int, error) {
	ret := _m.Called(channelID, timestamp, userID)

	var r0 int
	if rf, ok := ret.Get(0).(func(string, int64, string) int); ok {
		r0 = rf(channelID, timestamp, userID)
	} else {
		r0 = ret.Get(0).(int)
	}

	var r1 int
	if rf, ok := ret.Get(1).(func(string, int64, string) int); ok {
		r1 = rf(channelID, timestamp, userID)
	} else {
		r1 = ret.Get(1).(int)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(string, int64, string) error); ok {
		r2 = rf(channelID, timestamp, userID)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// CreateDirectChannel provides a mock function with given fields: userID, otherUserID, channelOptions
func (_m *ChannelStore) CreateDirectChannel(userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {
	_va := make([]interface{}, len(channelOptions))
	for _i := range channelOptions {
		_va[_i] = channelOptions[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, userID, otherUserID)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.User, *model.User, ...model.ChannelOption) *model.Channel); ok {
		r0 = rf(userID, otherUserID, channelOptions...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.User, *model.User, ...model.ChannelOption) error); ok {
		r1 = rf(userID, otherUserID, channelOptions...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateInitialSidebarCategories provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) CreateInitialSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	ret := _m.Called(userID, teamID)

	var r0 *model.OrderedSidebarCategories
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateSidebarCategory provides a mock function with given fields: userID, teamID, newCategory
func (_m *ChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(userID, teamID, newCategory)

	var r0 *model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, *model.SidebarCategoryWithChannels) error); ok {
		r1 = rf(userID, teamID, newCategory)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Delete provides a mock function with given fields: channelID, time
func (_m *ChannelStore) Delete(channelID string, time int64) error {
	ret := _m.Called(channelID, time)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64) error); ok {
		r0 = rf(channelID, time)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteSidebarCategory provides a mock function with given fields: categoryID
func (_m *ChannelStore) DeleteSidebarCategory(categoryID string) error {
	ret := _m.Called(categoryID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(categoryID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteSidebarChannelsByPreferences provides a mock function with given fields: preferences
func (_m *ChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {
	ret := _m.Called(preferences)

	var r0 error
	if rf, ok := ret.Get(0).(func(model.Preferences) error); ok {
		r0 = rf(preferences)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Get provides a mock function with given fields: id, allowFromCache
func (_m *ChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(id, allowFromCache)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, bool) *model.Channel); ok {
		r0 = rf(id, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(id, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAll provides a mock function with given fields: teamID
func (_m *ChannelStore) GetAll(teamID string) ([]*model.Channel, error) {
	ret := _m.Called(teamID)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(string) []*model.Channel); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMembersById provides a mock function with given fields: id
func (_m *ChannelStore) GetAllChannelMembersById(id string) ([]string, error) {
	ret := _m.Called(id)

	var r0 []string
	if rf, ok := ret.Get(0).(func(string) []string); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMembersForUser provides a mock function with given fields: userID, allowFromCache, includeDeleted
func (_m *ChannelStore) GetAllChannelMembersForUser(userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {
	ret := _m.Called(userID, allowFromCache, includeDeleted)

	var r0 map[string]string
	if rf, ok := ret.Get(0).(func(string, bool, bool) map[string]string); ok {
		r0 = rf(userID, allowFromCache, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool, bool) error); ok {
		r1 = rf(userID, allowFromCache, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMembersNotifyPropsForChannel provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {
	ret := _m.Called(channelID, allowFromCache)

	var r0 map[string]model.StringMap
	if rf, ok := ret.Get(0).(func(string, bool) map[string]model.StringMap); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]model.StringMap)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannels provides a mock function with given fields: page, perPage, opts
func (_m *ChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {
	ret := _m.Called(page, perPage, opts)

	var r0 model.ChannelListWithTeamData
	if rf, ok := ret.Get(0).(func(int, int, store.ChannelSearchOpts) model.ChannelListWithTeamData); ok {
		r0 = rf(page, perPage, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int, int, store.ChannelSearchOpts) error); ok {
		r1 = rf(page, perPage, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelsCount provides a mock function with given fields: opts
func (_m *ChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {
	ret := _m.Called(opts)

	var r0 int64
	if rf, ok := ret.Get(0).(func(store.ChannelSearchOpts) int64); ok {
		r0 = rf(opts)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(store.ChannelSearchOpts) error); ok {
		r1 = rf(opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelsForExportAfter provides a mock function with given fields: limit, afterID
func (_m *ChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {
	ret := _m.Called(limit, afterID)

	var r0 []*model.ChannelForExport
	if rf, ok := ret.Get(0).(func(int, string) []*model.ChannelForExport); ok {
		r0 = rf(limit, afterID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelForExport)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int, string) error); ok {
		r1 = rf(limit, afterID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllDirectChannelsForExportAfter provides a mock function with given fields: limit, afterID
func (_m *ChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string) ([]*model.DirectChannelForExport, error) {
	ret := _m.Called(limit, afterID)

	var r0 []*model.DirectChannelForExport
	if rf, ok := ret.Get(0).(func(int, string) []*model.DirectChannelForExport); ok {
		r0 = rf(limit, afterID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.DirectChannelForExport)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int, string) error); ok {
		r1 = rf(limit, afterID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByName provides a mock function with given fields: team_id, name, allowFromCache
func (_m *ChannelStore) GetByName(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(team_id, name, allowFromCache)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(team_id, name, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(team_id, name, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNameIncludeDeleted provides a mock function with given fields: team_id, name, allowFromCache
func (_m *ChannelStore) GetByNameIncludeDeleted(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(team_id, name, allowFromCache)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(team_id, name, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(team_id, name, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNames provides a mock function with given fields: team_id, names, allowFromCache
func (_m *ChannelStore) GetByNames(team_id string, names []string, allowFromCache bool) ([]*model.Channel, error) {
	ret := _m.Called(team_id, names, allowFromCache)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(string, []string, bool) []*model.Channel); ok {
		r0 = rf(team_id, names, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, []string, bool) error); ok {
		r1 = rf(team_id, names, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelCounts provides a mock function with given fields: teamID, userID
func (_m *ChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {
	ret := _m.Called(teamID, userID)

	var r0 *model.ChannelCounts
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelCounts); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelCounts)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(teamID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelMembersForExport provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetChannelMembersForExport(userID string, teamID string) ([]*model.ChannelMemberForExport, error) {
	ret := _m.Called(userID, teamID)

	var r0 []*model.ChannelMemberForExport
	if rf, ok := ret.Get(0).(func(string, string) []*model.ChannelMemberForExport); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMemberForExport)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelMembersTimezones provides a mock function with given fields: channelID
func (_m *ChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {
	ret := _m.Called(channelID)

	var r0 []model.StringMap
	if rf, ok := ret.Get(0).(func(string) []model.StringMap); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.StringMap)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelUnread provides a mock function with given fields: channelID, userID
func (_m *ChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {
	ret := _m.Called(channelID, userID)

	var r0 *model.ChannelUnread
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelUnread); ok {
		r0 = rf(channelID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelUnread)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(channelID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannels provides a mock function with given fields: teamID, userID, opts
func (_m *ChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, opts)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, *model.ChannelSearchOpts) model.ChannelList); ok {
		r0 = rf(teamID, userID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, *model.ChannelSearchOpts) error); ok {
		r1 = rf(teamID, userID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsBatchForIndexing provides a mock function with given fields: startTime, startChannelID, limit
func (_m *ChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {
	ret := _m.Called(startTime, startChannelID, limit)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(int64, string, int) []*model.Channel); ok {
		r0 = rf(startTime, startChannelID, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int64, string, int) error); ok {
		r1 = rf(startTime, startChannelID, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByIds provides a mock function with given fields: channelIds, includeDeleted
func (_m *ChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {
	ret := _m.Called(channelIds, includeDeleted)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func([]string, bool) []*model.Channel); ok {
		r0 = rf(channelIds, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(channelIds, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByScheme provides a mock function with given fields: schemeID, offset, limit
func (_m *ChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(schemeID, offset, limit)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(schemeID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(schemeID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByUser provides a mock function with given fields: userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID
func (_m *ChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {
	ret := _m.Called(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, bool, int, int, string) model.ChannelList); ok {
		r0 = rf(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool, int, int, string) error); ok {
		r1 = rf(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsWithCursor provides a mock function with given fields: teamId, userId, opts, afterChannelID
func (_m *ChannelStore) GetChannelsWithCursor(teamId string, userId string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, error) {
	ret := _m.Called(teamId, userId, opts, afterChannelID)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, *model.ChannelSearchOpts, string) model.ChannelList); ok {
		r0 = rf(teamId, userId, opts, afterChannelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, *model.ChannelSearchOpts, string) error); ok {
		r1 = rf(teamId, userId, opts, afterChannelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsWithTeamDataByIds provides a mock function with given fields: channelIds, includeDeleted
func (_m *ChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {
	ret := _m.Called(channelIds, includeDeleted)

	var r0 []*model.ChannelWithTeamData
	if rf, ok := ret.Get(0).(func([]string, bool) []*model.ChannelWithTeamData); ok {
		r0 = rf(channelIds, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelWithTeamData)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(channelIds, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeleted provides a mock function with given fields: team_id, offset, limit, userID
func (_m *ChannelStore) GetDeleted(team_id string, offset int, limit int, userID string) (model.ChannelList, error) {
	ret := _m.Called(team_id, offset, limit, userID)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, int, int, string) model.ChannelList); ok {
		r0 = rf(team_id, offset, limit, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int, string) error); ok {
		r1 = rf(team_id, offset, limit, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeletedByName provides a mock function with given fields: team_id, name
func (_m *ChannelStore) GetDeletedByName(team_id string, name string) (*model.Channel, error) {
	ret := _m.Called(team_id, name)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string) *model.Channel); ok {
		r0 = rf(team_id, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(team_id, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetFileCount provides a mock function with given fields: channelID
func (_m *ChannelStore) GetFileCount(channelID string) (int64, error) {
	ret := _m.Called(channelID)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetForPost provides a mock function with given fields: postID
func (_m *ChannelStore) GetForPost(postID string) (*model.Channel, error) {
	ret := _m.Called(postID)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string) *model.Channel); ok {
		r0 = rf(postID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(postID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGuestCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMany provides a mock function with given fields: ids, allowFromCache
func (_m *ChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {
	ret := _m.Called(ids, allowFromCache)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func([]string, bool) model.ChannelList); ok {
		r0 = rf(ids, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(ids, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMember provides a mock function with given fields: ctx, channelID, userID
func (_m *ChannelStore) GetMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, error) {
	ret := _m.Called(ctx, channelID, userID)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *model.ChannelMember); ok {
		r0 = rf(ctx, channelID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, channelID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCountFromCache provides a mock function with given fields: channelID
func (_m *ChannelStore) GetMemberCountFromCache(channelID string) int64 {
	ret := _m.Called(channelID)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetMemberCountsByGroup provides a mock function with given fields: ctx, channelID, includeTimezones
func (_m *ChannelStore) GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {
	ret := _m.Called(ctx, channelID, includeTimezones)

	var r0 []*model.ChannelMemberCountByGroup
	if rf, ok := ret.Get(0).(func(context.Context, string, bool) []*model.ChannelMemberCountByGroup); ok {
		r0 = rf(ctx, channelID, includeTimezones)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMemberCountByGroup)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, bool) error); ok {
		r1 = rf(ctx, channelID, includeTimezones)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberForPost provides a mock function with given fields: postID, userID
func (_m *ChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {
	ret := _m.Called(postID, userID)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(postID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(postID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembers provides a mock function with given fields: channelID, offset, limit
func (_m *ChannelStore) GetMembers(channelID string, offset int, limit int) (model.ChannelMembers, error) {
	ret := _m.Called(channelID, offset, limit)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelMembers); ok {
		r0 = rf(channelID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(channelID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersByChannelIds provides a mock function with given fields: channelIds, userID
func (_m *ChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {
	ret := _m.Called(channelIds, userID)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func([]string, string) model.ChannelMembers); ok {
		r0 = rf(channelIds, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string, string) error); ok {
		r1 = rf(channelIds, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersByIds provides a mock function with given fields: channelID, userIds
func (_m *ChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {
	ret := _m.Called(channelID, userIds)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelMembers); ok {
		r0 = rf(channelID, userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(channelID, userIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUser provides a mock function with given fields: teamID, userID
func (_m *ChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {
	ret := _m.Called(teamID, userID)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, string) model.ChannelMembers); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(teamID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUserWithCursor provides a mock function with given fields: userID, afterChannel, afterUser, limit, lastUpdateAt
func (_m *ChannelStore) GetMembersForUserWithCursor(userID string, afterChannel string, afterUser string, limit int, lastUpdateAt int) (model.ChannelMembers, error) {
	ret := _m.Called(userID, afterChannel, afterUser, limit, lastUpdateAt)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, string, string, int, int) model.ChannelMembers); ok {
		r0 = rf(userID, afterChannel, afterUser, limit, lastUpdateAt)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string, int, int) error); ok {
		r1 = rf(userID, afterChannel, afterUser, limit, lastUpdateAt)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUserWithPagination provides a mock function with given fields: userID, page, perPage
func (_m *ChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {
	ret := _m.Called(userID, page, perPage)

	var r0 model.ChannelMembersWithTeamData
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelMembersWithTeamData); ok {
		r0 = rf(userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembersWithTeamData)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(userID, page, perPage)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersInfoByChannelIds provides a mock function with given fields: channelIDs
func (_m *ChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {
	ret := _m.Called(channelIDs)

	var r0 map[string][]*model.User
	if rf, ok := ret.Get(0).(func([]string) map[string][]*model.User); ok {
		r0 = rf(channelIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string][]*model.User)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string) error); ok {
		r1 = rf(channelIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMoreChannels provides a mock function with given fields: teamID, userID, offset, limit
func (_m *ChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, offset, limit)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, userID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, int, int) error); ok {
		r1 = rf(teamID, userID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPinnedPostCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPinnedPosts provides a mock function with given fields: channelID
func (_m *ChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {
	ret := _m.Called(channelID)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string) *model.PostList); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPrivateChannelsForTeam provides a mock function with given fields: teamID, offset, limit
func (_m *ChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, offset, limit)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(teamID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPublicChannelsByIdsForTeam provides a mock function with given fields: teamID, channelIds
func (_m *ChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {
	ret := _m.Called(teamID, channelIds)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelList); ok {
		r0 = rf(teamID, channelIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(teamID, channelIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPublicChannelsForTeam provides a mock function with given fields: teamID, offset, limit
func (_m *ChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, offset, limit)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(teamID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategories provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	ret := _m.Called(userID, teamID)

	var r0 *model.OrderedSidebarCategories
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategory provides a mock function with given fields: categoryID
func (_m *ChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(categoryID)

	var r0 *model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(0).(func(string) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(categoryID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(categoryID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategoryOrder provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {
	ret := _m.Called(userID, teamID)

	var r0 []string
	if rf, ok := ret.Get(0).(func(string, string) []string); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamChannels provides a mock function with given fields: teamID
func (_m *ChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {
	ret := _m.Called(teamID)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string) model.ChannelList); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamForChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {
	ret := _m.Called(channelID)

	var r0 *model.Team
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamMembersForChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) GetTeamMembersForChannel(channelID string) ([]string, error) {
	ret := _m.Called(channelID)

	var r0 []string
	if rf, ok := ret.Get(0).(func(string) []string); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupSyncedChannelCount provides a mock function with given fields:
func (_m *ChannelStore) GroupSyncedChannelCount() (int64, error) {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IncrementMentionCount provides a mock function with given fields: channelID, userIDs, isRoot
func (_m *ChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool) error {
	ret := _m.Called(channelID, userIDs, isRoot)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, []string, bool) error); ok {
		r0 = rf(channelID, userIDs, isRoot)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// InvalidateAllChannelMembersForUser provides a mock function with given fields: userID
func (_m *ChannelStore) InvalidateAllChannelMembersForUser(userID string) {
	_m.Called(userID)
}

// InvalidateCacheForChannelMembersNotifyProps provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {
	_m.Called(channelID)
}

// InvalidateChannel provides a mock function with given fields: id
func (_m *ChannelStore) InvalidateChannel(id string) {
	_m.Called(id)
}

// InvalidateChannelByName provides a mock function with given fields: teamID, name
func (_m *ChannelStore) InvalidateChannelByName(teamID string, name string) {
	_m.Called(teamID, name)
}

// InvalidateGuestCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateGuestCount(channelID string) {
	_m.Called(channelID)
}

// InvalidateMemberCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateMemberCount(channelID string) {
	_m.Called(channelID)
}

// InvalidatePinnedPostCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidatePinnedPostCount(channelID string) {
	_m.Called(channelID)
}

// IsUserInChannelUseCache provides a mock function with given fields: userID, channelID
func (_m *ChannelStore) IsUserInChannelUseCache(userID string, channelID string) bool {
	ret := _m.Called(userID, channelID)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, string) bool); ok {
		r0 = rf(userID, channelID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MigrateChannelMembers provides a mock function with given fields: fromChannelID, fromUserID
func (_m *ChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {
	ret := _m.Called(fromChannelID, fromUserID)

	var r0 map[string]string
	if rf, ok := ret.Get(0).(func(string, string) map[string]string); ok {
		r0 = rf(fromChannelID, fromUserID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(fromChannelID, fromUserID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PermanentDelete provides a mock function with given fields: channelID
func (_m *ChannelStore) PermanentDelete(channelID string) error {
	ret := _m.Called(channelID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteByTeam provides a mock function with given fields: teamID
func (_m *ChannelStore) PermanentDeleteByTeam(teamID string) error {
	ret := _m.Called(teamID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(teamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteMembersByChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) PermanentDeleteMembersByChannel(channelID string) error {
	ret := _m.Called(channelID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteMembersByUser provides a mock function with given fields: userID
func (_m *ChannelStore) PermanentDeleteMembersByUser(userID string) error {
	ret := _m.Called(userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveAllDeactivatedMembers provides a mock function with given fields: channelID
func (_m *ChannelStore) RemoveAllDeactivatedMembers(channelID string) error {
	ret := _m.Called(channelID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMember provides a mock function with given fields: channelID, userID
func (_m *ChannelStore) RemoveMember(channelID string, userID string) error {
	ret := _m.Called(channelID, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(channelID, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMembers provides a mock function with given fields: channelID, userIds
func (_m *ChannelStore) RemoveMembers(channelID string, userIds []string) error {
	ret := _m.Called(channelID, userIds)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, []string) error); ok {
		r0 = rf(channelID, userIds)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ResetAllChannelSchemes provides a mock function with given fields:
func (_m *ChannelStore) ResetAllChannelSchemes() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Restore provides a mock function with given fields: channelID, time
func (_m *ChannelStore) Restore(channelID string, time int64) error {
	ret := _m.Called(channelID, time)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64) error); ok {
		r0 = rf(channelID, time)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Save provides a mock function with given fields: channel, maxChannelsPerTeam
func (_m *ChannelStore) Save(channel *model.Channel, maxChannelsPerTeam int64) (*model.Channel, error) {
	ret := _m.Called(channel, maxChannelsPerTeam)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.Channel, int64) *model.Channel); ok {
		r0 = rf(channel, maxChannelsPerTeam)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.Channel, int64) error); ok {
		r1 = rf(channel, maxChannelsPerTeam)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveDirectChannel provides a mock function with given fields: channel, member1, member2
func (_m *ChannelStore) SaveDirectChannel(channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {
	ret := _m.Called(channel, member1, member2)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.Channel, *model.ChannelMember, *model.ChannelMember) *model.Channel); ok {
		r0 = rf(channel, member1, member2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.Channel, *model.ChannelMember, *model.ChannelMember) error); ok {
		r1 = rf(channel, member1, member2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveMember provides a mock function with given fields: member
func (_m *ChannelStore) SaveMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	ret := _m.Called(member)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(*model.ChannelMember) *model.ChannelMember); ok {
		r0 = rf(member)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.ChannelMember) error); ok {
		r1 = rf(member)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveMultipleMembers provides a mock function with given fields: members
func (_m *ChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	ret := _m.Called(members)

	var r0 []*model.ChannelMember
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) []*model.ChannelMember); ok {
		r0 = rf(members)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]*model.ChannelMember) error); ok {
		r1 = rf(members)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchAllChannels provides a mock function with given fields: term, opts
func (_m *ChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {
	ret := _m.Called(term, opts)

	var r0 model.ChannelListWithTeamData
	if rf, ok := ret.Get(0).(func(string, store.ChannelSearchOpts) model.ChannelListWithTeamData); ok {
		r0 = rf(term, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	var r1 int64
	if rf, ok := ret.Get(1).(func(string, store.ChannelSearchOpts) int64); ok {
		r1 = rf(term, opts)
	} else {
		r1 = ret.Get(1).(int64)
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(string, store.ChannelSearchOpts) error); ok {
		r2 = rf(term, opts)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// SearchArchivedInTeam provides a mock function with given fields: teamID, term, userID
func (_m *ChannelStore) SearchArchivedInTeam(teamID string, term string, userID string) (model.ChannelList, error) {
	ret := _m.Called(teamID, term, userID)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, string) model.ChannelList); ok {
		r0 = rf(teamID, term, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string) error); ok {
		r1 = rf(teamID, term, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchForUserInTeam provides a mock function with given fields: userID, teamID, term, includeDeleted
func (_m *ChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(userID, teamID, term, includeDeleted)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, string, bool) model.ChannelList); ok {
		r0 = rf(userID, teamID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string, bool) error); ok {
		r1 = rf(userID, teamID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchGroupChannels provides a mock function with given fields: userID, term
func (_m *ChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {
	ret := _m.Called(userID, term)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string) model.ChannelList); ok {
		r0 = rf(userID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, term)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchInTeam provides a mock function with given fields: teamID, term, includeDeleted
func (_m *ChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, term, includeDeleted)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, bool) model.ChannelList); ok {
		r0 = rf(teamID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(teamID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchMore provides a mock function with given fields: userID, teamID, term
func (_m *ChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {
	ret := _m.Called(userID, teamID, term)

	var r0 model.ChannelList
	if rf, ok := ret.Get(0).(func(string, string, string) model.ChannelList); ok {
		r0 = rf(userID, teamID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, string) error); ok {
		r1 = rf(userID, teamID, term)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetDeleteAt provides a mock function with given fields: channelID, deleteAt, updateAt
func (_m *ChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {
	ret := _m.Called(channelID, deleteAt, updateAt)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, int64) error); ok {
		r0 = rf(channelID, deleteAt, updateAt)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetShared provides a mock function with given fields: channelId, shared
func (_m *ChannelStore) SetShared(channelId string, shared bool) error {
	ret := _m.Called(channelId, shared)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, bool) error); ok {
		r0 = rf(channelId, shared)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Update provides a mock function with given fields: channel
func (_m *ChannelStore) Update(channel *model.Channel) (*model.Channel, error) {
	ret := _m.Called(channel)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.Channel) *model.Channel); ok {
		r0 = rf(channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.Channel) error); ok {
		r1 = rf(channel)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateLastViewedAt provides a mock function with given fields: channelIds, userID
func (_m *ChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {
	ret := _m.Called(channelIds, userID)

	var r0 map[string]int64
	if rf, ok := ret.Get(0).(func([]string, string) map[string]int64); ok {
		r0 = rf(channelIds, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]int64)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]string, string) error); ok {
		r1 = rf(channelIds, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateLastViewedAtPost provides a mock function with given fields: unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot
func (_m *ChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {
	ret := _m.Called(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)

	var r0 *model.ChannelUnreadAt
	if rf, ok := ret.Get(0).(func(*model.Post, string, int, int, bool) *model.ChannelUnreadAt); ok {
		r0 = rf(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelUnreadAt)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.Post, string, int, int, bool) error); ok {
		r1 = rf(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMember provides a mock function with given fields: member
func (_m *ChannelStore) UpdateMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	ret := _m.Called(member)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(*model.ChannelMember) *model.ChannelMember); ok {
		r0 = rf(member)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.ChannelMember) error); ok {
		r1 = rf(member)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMemberNotifyProps provides a mock function with given fields: channelID, userID, props
func (_m *ChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {
	ret := _m.Called(channelID, userID, props)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) *model.ChannelMember); ok {
		r0 = rf(channelID, userID, props)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string, map[string]string) error); ok {
		r1 = rf(channelID, userID, props)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMembersRole provides a mock function with given fields: channelID, userIDs
func (_m *ChannelStore) UpdateMembersRole(channelID string, userIDs []string) error {
	ret := _m.Called(channelID, userIDs)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, []string) error); ok {
		r0 = rf(channelID, userIDs)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateMultipleMembers provides a mock function with given fields: members
func (_m *ChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	ret := _m.Called(members)

	var r0 []*model.ChannelMember
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) []*model.ChannelMember); ok {
		r0 = rf(members)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]*model.ChannelMember) error); ok {
		r1 = rf(members)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateSidebarCategories provides a mock function with given fields: userID, teamID, categories
func (_m *ChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(userID, teamID, categories)

	var r0 []*model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, categories)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.SidebarCategoryWithChannels)
		}
	}

	var r1 []*model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(1).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r1 = rf(userID, teamID, categories)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]*model.SidebarCategoryWithChannels)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(string, string, []*model.SidebarCategoryWithChannels) error); ok {
		r2 = rf(userID, teamID, categories)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// UpdateSidebarCategoryOrder provides a mock function with given fields: userID, teamID, categoryOrder
func (_m *ChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {
	ret := _m.Called(userID, teamID, categoryOrder)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, []string) error); ok {
		r0 = rf(userID, teamID, categoryOrder)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateSidebarChannelCategoryOnMove provides a mock function with given fields: channel, newTeamID
func (_m *ChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {
	ret := _m.Called(channel, newTeamID)

	var r0 error
	if rf, ok := ret.Get(0).(func(*model.Channel, string) error); ok {
		r0 = rf(channel, newTeamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateSidebarChannelsByPreferences provides a mock function with given fields: preferences
func (_m *ChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {
	ret := _m.Called(preferences)

	var r0 error
	if rf, ok := ret.Get(0).(func(model.Preferences) error); ok {
		r0 = rf(preferences)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UserBelongsToChannels provides a mock function with given fields: userID, channelIds
func (_m *ChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {
	ret := _m.Called(userID, channelIds)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, []string) bool); ok {
		r0 = rf(userID, channelIds)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(userID, channelIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
