// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make store-layers"
// DO NOT EDIT

package timerlayer

import (
	"context"
	timemodule "time"

	"github.com/mattermost/mattermost-server/v6/einterfaces"
	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/store"
)

type TimerLayer struct {
	store.Store
	Metrics                   einterfaces.MetricsInterface
	AuditStore                store.AuditStore
	BotStore                  store.BotStore
	ChannelStore              store.ChannelStore
	ChannelMemberHistoryStore store.ChannelMemberHistoryStore
	ClusterDiscoveryStore     store.ClusterDiscoveryStore
	CommandStore              store.CommandStore
	CommandWebhookStore       store.CommandWebhookStore
	ComplianceStore           store.ComplianceStore
	EmojiStore                store.EmojiStore
	FileInfoStore             store.FileInfoStore
	GroupStore                store.GroupStore
	JobStore                  store.JobStore
	LicenseStore              store.LicenseStore
	LinkMetadataStore         store.LinkMetadataStore
	OAuthStore                store.OAuthStore
	PluginStore               store.PluginStore
	PostStore                 store.PostStore
	PreferenceStore           store.PreferenceStore
	ProductNoticesStore       store.ProductNoticesStore
	ReactionStore             store.ReactionStore
	RemoteClusterStore        store.RemoteClusterStore
	RetentionPolicyStore      store.RetentionPolicyStore
	RoleStore                 store.RoleStore
	SchemeStore               store.SchemeStore
	SessionStore              store.SessionStore
	SharedChannelStore        store.SharedChannelStore
	StatusStore               store.StatusStore
	SystemStore               store.SystemStore
	TeamStore                 store.TeamStore
	TermsOfServiceStore       store.TermsOfServiceStore
	ThreadStore               store.ThreadStore
	TokenStore                store.TokenStore
	UploadSessionStore        store.UploadSessionStore
	UserStore                 store.UserStore
	UserAccessTokenStore      store.UserAccessTokenStore
	UserTermsOfServiceStore   store.UserTermsOfServiceStore
	WebhookStore              store.WebhookStore
}

func (s *TimerLayer) Audit() store.AuditStore {
	return s.AuditStore
}

func (s *TimerLayer) Bot() store.BotStore {
	return s.BotStore
}

func (s *TimerLayer) Channel() store.ChannelStore {
	return s.ChannelStore
}

func (s *TimerLayer) ChannelMemberHistory() store.ChannelMemberHistoryStore {
	return s.ChannelMemberHistoryStore
}

func (s *TimerLayer) ClusterDiscovery() store.ClusterDiscoveryStore {
	return s.ClusterDiscoveryStore
}

func (s *TimerLayer) Command() store.CommandStore {
	return s.CommandStore
}

func (s *TimerLayer) CommandWebhook() store.CommandWebhookStore {
	return s.CommandWebhookStore
}

func (s *TimerLayer) Compliance() store.ComplianceStore {
	return s.ComplianceStore
}

func (s *TimerLayer) Emoji() store.EmojiStore {
	return s.EmojiStore
}

func (s *TimerLayer) FileInfo() store.FileInfoStore {
	return s.FileInfoStore
}

func (s *TimerLayer) Group() store.GroupStore {
	return s.GroupStore
}

func (s *TimerLayer) Job() store.JobStore {
	return s.JobStore
}

func (s *TimerLayer) License() store.LicenseStore {
	return s.LicenseStore
}

func (s *TimerLayer) LinkMetadata() store.LinkMetadataStore {
	return s.LinkMetadataStore
}

func (s *TimerLayer) OAuth() store.OAuthStore {
	return s.OAuthStore
}

func (s *TimerLayer) Plugin() store.PluginStore {
	return s.PluginStore
}

func (s *TimerLayer) Post() store.PostStore {
	return s.PostStore
}

func (s *TimerLayer) Preference() store.PreferenceStore {
	return s.PreferenceStore
}

func (s *TimerLayer) ProductNotices() store.ProductNoticesStore {
	return s.ProductNoticesStore
}

func (s *TimerLayer) Reaction() store.ReactionStore {
	return s.ReactionStore
}

func (s *TimerLayer) RemoteCluster() store.RemoteClusterStore {
	return s.RemoteClusterStore
}

func (s *TimerLayer) RetentionPolicy() store.RetentionPolicyStore {
	return s.RetentionPolicyStore
}

func (s *TimerLayer) Role() store.RoleStore {
	return s.RoleStore
}

func (s *TimerLayer) Scheme() store.SchemeStore {
	return s.SchemeStore
}

func (s *TimerLayer) Session() store.SessionStore {
	return s.SessionStore
}

func (s *TimerLayer) SharedChannel() store.SharedChannelStore {
	return s.SharedChannelStore
}

func (s *TimerLayer) Status() store.StatusStore {
	return s.StatusStore
}

func (s *TimerLayer) System() store.SystemStore {
	return s.SystemStore
}

func (s *TimerLayer) Team() store.TeamStore {
	return s.TeamStore
}

func (s *TimerLayer) TermsOfService() store.TermsOfServiceStore {
	return s.TermsOfServiceStore
}

func (s *TimerLayer) Thread() store.ThreadStore {
	return s.ThreadStore
}

func (s *TimerLayer) Token() store.TokenStore {
	return s.TokenStore
}

func (s *TimerLayer) UploadSession() store.UploadSessionStore {
	return s.UploadSessionStore
}

func (s *TimerLayer) User() store.UserStore {
	return s.UserStore
}

func (s *TimerLayer) UserAccessToken() store.UserAccessTokenStore {
	return s.UserAccessTokenStore
}

func (s *TimerLayer) UserTermsOfService() store.UserTermsOfServiceStore {
	return s.UserTermsOfServiceStore
}

func (s *TimerLayer) Webhook() store.WebhookStore {
	return s.WebhookStore
}

type TimerLayerAuditStore struct {
	store.AuditStore
	Root *TimerLayer
}

type TimerLayerBotStore struct {
	store.BotStore
	Root *TimerLayer
}

type TimerLayerChannelStore struct {
	store.ChannelStore
	Root *TimerLayer
}

type TimerLayerChannelMemberHistoryStore struct {
	store.ChannelMemberHistoryStore
	Root *TimerLayer
}

type TimerLayerClusterDiscoveryStore struct {
	store.ClusterDiscoveryStore
	Root *TimerLayer
}

type TimerLayerCommandStore struct {
	store.CommandStore
	Root *TimerLayer
}

type TimerLayerCommandWebhookStore struct {
	store.CommandWebhookStore
	Root *TimerLayer
}

type TimerLayerComplianceStore struct {
	store.ComplianceStore
	Root *TimerLayer
}

type TimerLayerEmojiStore struct {
	store.EmojiStore
	Root *TimerLayer
}

type TimerLayerFileInfoStore struct {
	store.FileInfoStore
	Root *TimerLayer
}

type TimerLayerGroupStore struct {
	store.GroupStore
	Root *TimerLayer
}

type TimerLayerJobStore struct {
	store.JobStore
	Root *TimerLayer
}

type TimerLayerLicenseStore struct {
	store.LicenseStore
	Root *TimerLayer
}

type TimerLayerLinkMetadataStore struct {
	store.LinkMetadataStore
	Root *TimerLayer
}

type TimerLayerOAuthStore struct {
	store.OAuthStore
	Root *TimerLayer
}

type TimerLayerPluginStore struct {
	store.PluginStore
	Root *TimerLayer
}

type TimerLayerPostStore struct {
	store.PostStore
	Root *TimerLayer
}

type TimerLayerPreferenceStore struct {
	store.PreferenceStore
	Root *TimerLayer
}

type TimerLayerProductNoticesStore struct {
	store.ProductNoticesStore
	Root *TimerLayer
}

type TimerLayerReactionStore struct {
	store.ReactionStore
	Root *TimerLayer
}

type TimerLayerRemoteClusterStore struct {
	store.RemoteClusterStore
	Root *TimerLayer
}

type TimerLayerRetentionPolicyStore struct {
	store.RetentionPolicyStore
	Root *TimerLayer
}

type TimerLayerRoleStore struct {
	store.RoleStore
	Root *TimerLayer
}

type TimerLayerSchemeStore struct {
	store.SchemeStore
	Root *TimerLayer
}

type TimerLayerSessionStore struct {
	store.SessionStore
	Root *TimerLayer
}

type TimerLayerSharedChannelStore struct {
	store.SharedChannelStore
	Root *TimerLayer
}

type TimerLayerStatusStore struct {
	store.StatusStore
	Root *TimerLayer
}

type TimerLayerSystemStore struct {
	store.SystemStore
	Root *TimerLayer
}

type TimerLayerTeamStore struct {
	store.TeamStore
	Root *TimerLayer
}

type TimerLayerTermsOfServiceStore struct {
	store.TermsOfServiceStore
	Root *TimerLayer
}

type TimerLayerThreadStore struct {
	store.ThreadStore
	Root *TimerLayer
}

type TimerLayerTokenStore struct {
	store.TokenStore
	Root *TimerLayer
}

type TimerLayerUploadSessionStore struct {
	store.UploadSessionStore
	Root *TimerLayer
}

type TimerLayerUserStore struct {
	store.UserStore
	Root *TimerLayer
}

type TimerLayerUserAccessTokenStore struct {
	store.UserAccessTokenStore
	Root *TimerLayer
}

type TimerLayerUserTermsOfServiceStore struct {
	store.UserTermsOfServiceStore
	Root *TimerLayer
}

type TimerLayerWebhookStore struct {
	store.WebhookStore
	Root *TimerLayer
}

func (s *TimerLayerAuditStore) Get(user_id string, offset int, limit int) (model.Audits, error) {
	start := timemodule.Now()

	result, err := s.AuditStore.Get(user_id, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("AuditStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerAuditStore) PermanentDeleteByUser(userID string) error {
	start := timemodule.Now()

	err := s.AuditStore.PermanentDeleteByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("AuditStore.PermanentDeleteByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerAuditStore) Save(audit *model.Audit) error {
	start := timemodule.Now()

	err := s.AuditStore.Save(audit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("AuditStore.Save", success, elapsed)
	}
	return err
}

func (s *TimerLayerBotStore) Get(userID string, includeDeleted bool) (*model.Bot, error) {
	start := timemodule.Now()

	result, err := s.BotStore.Get(userID, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("BotStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerBotStore) GetAll(options *model.BotGetOptions) ([]*model.Bot, error) {
	start := timemodule.Now()

	result, err := s.BotStore.GetAll(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("BotStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerBotStore) PermanentDelete(userID string) error {
	start := timemodule.Now()

	err := s.BotStore.PermanentDelete(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("BotStore.PermanentDelete", success, elapsed)
	}
	return err
}

func (s *TimerLayerBotStore) Save(bot *model.Bot) (*model.Bot, error) {
	start := timemodule.Now()

	result, err := s.BotStore.Save(bot)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("BotStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerBotStore) Update(bot *model.Bot) (*model.Bot, error) {
	start := timemodule.Now()

	result, err := s.BotStore.Update(bot)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("BotStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.AnalyticsDeletedTypeCount(teamID, channelType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.AnalyticsDeletedTypeCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.AnalyticsTypeCount(teamID, channelType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.AnalyticsTypeCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) Autocomplete(userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.Autocomplete(userID, term, includeDeleted, isGuest)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Autocomplete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) AutocompleteInTeam(teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.AutocompleteInTeam(teamID, userID, term, includeDeleted, isGuest)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.AutocompleteInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.AutocompleteInTeamForSearch(teamID, userID, term, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.AutocompleteInTeamForSearch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) ClearAllCustomRoleAssignments() error {
	start := timemodule.Now()

	err := s.ChannelStore.ClearAllCustomRoleAssignments()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.ClearAllCustomRoleAssignments", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) ClearCaches() {
	start := timemodule.Now()

	s.ChannelStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.ClearSidebarOnTeamLeave(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.ClearSidebarOnTeamLeave", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) CountPostsAfter(channelID string, timestamp int64, userID string) (int, int, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ChannelStore.CountPostsAfter(channelID, timestamp, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.CountPostsAfter", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerChannelStore) CreateDirectChannel(userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.CreateDirectChannel(userID, otherUserID, channelOptions...)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.CreateDirectChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) CreateInitialSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.CreateInitialSidebarCategories(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.CreateInitialSidebarCategories", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.CreateSidebarCategory(userID, teamID, newCategory)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.CreateSidebarCategory", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) Delete(channelID string, time int64) error {
	start := timemodule.Now()

	err := s.ChannelStore.Delete(channelID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) DeleteSidebarCategory(categoryID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.DeleteSidebarCategory(categoryID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.DeleteSidebarCategory", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {
	start := timemodule.Now()

	err := s.ChannelStore.DeleteSidebarChannelsByPreferences(preferences)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.DeleteSidebarChannelsByPreferences", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.Get(id, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAll(teamID string) ([]*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAll(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannelMembersById(id string) ([]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannelMembersById(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannelMembersById", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannelMembersForUser(userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannelMembersForUser(userID, allowFromCache, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannelMembersForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannelMembersNotifyPropsForChannel(channelID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannelMembersNotifyPropsForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannels(page, perPage, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannelsCount(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannelsCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllChannelsForExportAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllChannelsForExportAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string) ([]*model.DirectChannelForExport, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetAllDirectChannelsForExportAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetAllDirectChannelsForExportAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetByName(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetByName(team_id, name, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetByNameIncludeDeleted(team_id string, name string, allowFromCache bool) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetByNameIncludeDeleted(team_id, name, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetByNameIncludeDeleted", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetByNames(team_id string, names []string, allowFromCache bool) ([]*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetByNames(team_id, names, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetByNames", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelCounts(teamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelCounts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelMembersForExport(userID string, teamID string) ([]*model.ChannelMemberForExport, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelMembersForExport(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelMembersForExport", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelMembersTimezones(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelMembersTimezones", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelUnread(channelID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelUnread", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannels(teamID, userID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsBatchForIndexing(startTime, startChannelID, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsBatchForIndexing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsByIds(channelIds, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsByScheme(schemeID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsByScheme", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsByUser(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsWithCursor(teamId string, userId string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsWithCursor(teamId, userId, opts, afterChannelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsWithCursor", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetChannelsWithTeamDataByIds(channelIds, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetChannelsWithTeamDataByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetDeleted(team_id string, offset int, limit int, userID string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetDeleted(team_id, offset, limit, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetDeleted", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetDeletedByName(team_id string, name string) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetDeletedByName(team_id, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetDeletedByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetFileCount(channelID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetFileCount(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetFileCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetForPost(postID string) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetForPost(postID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetForPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetGuestCount(channelID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetGuestCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMany(ids, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMany", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMember(ctx, channelID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMemberCount(channelID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMemberCountFromCache(channelID string) int64 {
	start := timemodule.Now()

	result := s.ChannelStore.GetMemberCountFromCache(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMemberCountFromCache", success, elapsed)
	}
	return result
}

func (s *TimerLayerChannelStore) GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMemberCountsByGroup(ctx, channelID, includeTimezones)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMemberCountsByGroup", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMemberForPost(postID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMemberForPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembers(channelID string, offset int, limit int) (model.ChannelMembers, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembers(channelID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersByChannelIds(channelIds, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersByChannelIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersByIds(channelID, userIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersForUser(teamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersForUserWithCursor(userID string, afterChannel string, afterUser string, limit int, lastUpdateAt int) (model.ChannelMembers, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersForUserWithCursor(userID, afterChannel, afterUser, limit, lastUpdateAt)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersForUserWithCursor", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersForUserWithPagination(userID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersForUserWithPagination", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMembersInfoByChannelIds(channelIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMembersInfoByChannelIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetMoreChannels(teamID, userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetMoreChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetPinnedPostCount(channelID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetPinnedPostCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetPinnedPosts(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetPinnedPosts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetPrivateChannelsForTeam(teamID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetPrivateChannelsForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetPublicChannelsByIdsForTeam(teamID, channelIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetPublicChannelsByIdsForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetPublicChannelsForTeam(teamID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetPublicChannelsForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetSidebarCategories(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetSidebarCategories", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetSidebarCategory(categoryID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetSidebarCategory", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetSidebarCategoryOrder(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetSidebarCategoryOrder", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetTeamChannels(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetTeamChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetTeamForChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetTeamForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GetTeamMembersForChannel(channelID string) ([]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GetTeamMembersForChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GetTeamMembersForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) GroupSyncedChannelCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.GroupSyncedChannelCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.GroupSyncedChannelCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool) error {
	start := timemodule.Now()

	err := s.ChannelStore.IncrementMentionCount(channelID, userIDs, isRoot)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.IncrementMentionCount", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) InvalidateAllChannelMembersForUser(userID string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateAllChannelMembersForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateAllChannelMembersForUser", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateCacheForChannelMembersNotifyProps(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateCacheForChannelMembersNotifyProps", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidateChannel(id string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateChannel(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateChannel", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidateChannelByName(teamID string, name string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateChannelByName(teamID, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateChannelByName", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidateGuestCount(channelID string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateGuestCount(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateGuestCount", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidateMemberCount(channelID string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidateMemberCount(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidateMemberCount", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) InvalidatePinnedPostCount(channelID string) {
	start := timemodule.Now()

	s.ChannelStore.InvalidatePinnedPostCount(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.InvalidatePinnedPostCount", success, elapsed)
	}
}

func (s *TimerLayerChannelStore) IsUserInChannelUseCache(userID string, channelID string) bool {
	start := timemodule.Now()

	result := s.ChannelStore.IsUserInChannelUseCache(userID, channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.IsUserInChannelUseCache", success, elapsed)
	}
	return result
}

func (s *TimerLayerChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.MigrateChannelMembers(fromChannelID, fromUserID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.MigrateChannelMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) PermanentDelete(channelID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.PermanentDelete(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.PermanentDelete", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) PermanentDeleteByTeam(teamID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.PermanentDeleteByTeam(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.PermanentDeleteByTeam", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) PermanentDeleteMembersByChannel(channelID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.PermanentDeleteMembersByChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.PermanentDeleteMembersByChannel", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) PermanentDeleteMembersByUser(userID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.PermanentDeleteMembersByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.PermanentDeleteMembersByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) RemoveAllDeactivatedMembers(channelID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.RemoveAllDeactivatedMembers(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.RemoveAllDeactivatedMembers", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) RemoveMember(channelID string, userID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.RemoveMember(channelID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.RemoveMember", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) RemoveMembers(channelID string, userIds []string) error {
	start := timemodule.Now()

	err := s.ChannelStore.RemoveMembers(channelID, userIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.RemoveMembers", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) ResetAllChannelSchemes() error {
	start := timemodule.Now()

	err := s.ChannelStore.ResetAllChannelSchemes()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.ResetAllChannelSchemes", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) Restore(channelID string, time int64) error {
	start := timemodule.Now()

	err := s.ChannelStore.Restore(channelID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Restore", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) Save(channel *model.Channel, maxChannelsPerTeam int64) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.Save(channel, maxChannelsPerTeam)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SaveDirectChannel(channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SaveDirectChannel(channel, member1, member2)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SaveDirectChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SaveMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SaveMember(member)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SaveMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SaveMultipleMembers(members)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SaveMultipleMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ChannelStore.SearchAllChannels(term, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchAllChannels", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerChannelStore) SearchArchivedInTeam(teamID string, term string, userID string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SearchArchivedInTeam(teamID, term, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchArchivedInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SearchForUserInTeam(userID, teamID, term, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchForUserInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SearchGroupChannels(userID, term)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchGroupChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SearchInTeam(teamID, term, includeDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.SearchMore(userID, teamID, term)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SearchMore", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {
	start := timemodule.Now()

	err := s.ChannelStore.SetDeleteAt(channelID, deleteAt, updateAt)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SetDeleteAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) SetShared(channelId string, shared bool) error {
	start := timemodule.Now()

	err := s.ChannelStore.SetShared(channelId, shared)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.SetShared", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) Update(channel *model.Channel) (*model.Channel, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.Update(channel)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UpdateLastViewedAt(channelIds, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateLastViewedAt", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UpdateLastViewedAtPost(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateLastViewedAtPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateMember(member *model.ChannelMember) (*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UpdateMember(member)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UpdateMemberNotifyProps(channelID, userID, props)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateMemberNotifyProps", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateMembersRole(channelID string, userIDs []string) error {
	start := timemodule.Now()

	err := s.ChannelStore.UpdateMembersRole(channelID, userIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateMembersRole", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UpdateMultipleMembers(members)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateMultipleMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ChannelStore.UpdateSidebarCategories(userID, teamID, categories)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateSidebarCategories", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {
	start := timemodule.Now()

	err := s.ChannelStore.UpdateSidebarCategoryOrder(userID, teamID, categoryOrder)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateSidebarCategoryOrder", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {
	start := timemodule.Now()

	err := s.ChannelStore.UpdateSidebarChannelCategoryOnMove(channel, newTeamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateSidebarChannelCategoryOnMove", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {
	start := timemodule.Now()

	err := s.ChannelStore.UpdateSidebarChannelsByPreferences(preferences)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UpdateSidebarChannelsByPreferences", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {
	start := timemodule.Now()

	result, err := s.ChannelStore.UserBelongsToChannels(userID, channelIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelStore.UserBelongsToChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelMemberHistoryStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelMemberHistoryStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelMemberHistoryStore) GetChannelsLeftSince(userID string, since int64) ([]string, error) {
	start := timemodule.Now()

	result, err := s.ChannelMemberHistoryStore.GetChannelsLeftSince(userID, since)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.GetChannelsLeftSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelMemberHistoryStore) GetUsersInChannelDuring(startTime int64, endTime int64, channelID string) ([]*model.ChannelMemberHistoryResult, error) {
	start := timemodule.Now()

	result, err := s.ChannelMemberHistoryStore.GetUsersInChannelDuring(startTime, endTime, channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.GetUsersInChannelDuring", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelMemberHistoryStore) LogJoinEvent(userID string, channelID string, joinTime int64) error {
	start := timemodule.Now()

	err := s.ChannelMemberHistoryStore.LogJoinEvent(userID, channelID, joinTime)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.LogJoinEvent", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelMemberHistoryStore) LogLeaveEvent(userID string, channelID string, leaveTime int64) error {
	start := timemodule.Now()

	err := s.ChannelMemberHistoryStore.LogLeaveEvent(userID, channelID, leaveTime)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.LogLeaveEvent", success, elapsed)
	}
	return err
}

func (s *TimerLayerChannelMemberHistoryStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	start := timemodule.Now()

	result, err := s.ChannelMemberHistoryStore.PermanentDeleteBatch(endTime, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.PermanentDeleteBatch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerChannelMemberHistoryStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerClusterDiscoveryStore) Cleanup() error {
	start := timemodule.Now()

	err := s.ClusterDiscoveryStore.Cleanup()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.Cleanup", success, elapsed)
	}
	return err
}

func (s *TimerLayerClusterDiscoveryStore) Delete(discovery *model.ClusterDiscovery) (bool, error) {
	start := timemodule.Now()

	result, err := s.ClusterDiscoveryStore.Delete(discovery)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerClusterDiscoveryStore) Exists(discovery *model.ClusterDiscovery) (bool, error) {
	start := timemodule.Now()

	result, err := s.ClusterDiscoveryStore.Exists(discovery)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.Exists", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerClusterDiscoveryStore) GetAll(discoveryType string, clusterName string) ([]*model.ClusterDiscovery, error) {
	start := timemodule.Now()

	result, err := s.ClusterDiscoveryStore.GetAll(discoveryType, clusterName)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerClusterDiscoveryStore) Save(discovery *model.ClusterDiscovery) error {
	start := timemodule.Now()

	err := s.ClusterDiscoveryStore.Save(discovery)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.Save", success, elapsed)
	}
	return err
}

func (s *TimerLayerClusterDiscoveryStore) SetLastPingAt(discovery *model.ClusterDiscovery) error {
	start := timemodule.Now()

	err := s.ClusterDiscoveryStore.SetLastPingAt(discovery)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ClusterDiscoveryStore.SetLastPingAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerCommandStore) AnalyticsCommandCount(teamID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.AnalyticsCommandCount(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.AnalyticsCommandCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandStore) Delete(commandID string, time int64) error {
	start := timemodule.Now()

	err := s.CommandStore.Delete(commandID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerCommandStore) Get(id string) (*model.Command, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandStore) GetByTeam(teamID string) ([]*model.Command, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.GetByTeam(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.GetByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandStore) GetByTrigger(teamID string, trigger string) (*model.Command, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.GetByTrigger(teamID, trigger)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.GetByTrigger", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandStore) PermanentDeleteByTeam(teamID string) error {
	start := timemodule.Now()

	err := s.CommandStore.PermanentDeleteByTeam(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.PermanentDeleteByTeam", success, elapsed)
	}
	return err
}

func (s *TimerLayerCommandStore) PermanentDeleteByUser(userID string) error {
	start := timemodule.Now()

	err := s.CommandStore.PermanentDeleteByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.PermanentDeleteByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerCommandStore) Save(webhook *model.Command) (*model.Command, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.Save(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandStore) Update(hook *model.Command) (*model.Command, error) {
	start := timemodule.Now()

	result, err := s.CommandStore.Update(hook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandWebhookStore) Cleanup() {
	start := timemodule.Now()

	s.CommandWebhookStore.Cleanup()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandWebhookStore.Cleanup", success, elapsed)
	}
}

func (s *TimerLayerCommandWebhookStore) Get(id string) (*model.CommandWebhook, error) {
	start := timemodule.Now()

	result, err := s.CommandWebhookStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandWebhookStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandWebhookStore) Save(webhook *model.CommandWebhook) (*model.CommandWebhook, error) {
	start := timemodule.Now()

	result, err := s.CommandWebhookStore.Save(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandWebhookStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerCommandWebhookStore) TryUse(id string, limit int) error {
	start := timemodule.Now()

	err := s.CommandWebhookStore.TryUse(id, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("CommandWebhookStore.TryUse", success, elapsed)
	}
	return err
}

func (s *TimerLayerComplianceStore) ComplianceExport(compliance *model.Compliance, cursor model.ComplianceExportCursor, limit int) ([]*model.CompliancePost, model.ComplianceExportCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ComplianceStore.ComplianceExport(compliance, cursor, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.ComplianceExport", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerComplianceStore) Get(id string) (*model.Compliance, error) {
	start := timemodule.Now()

	result, err := s.ComplianceStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerComplianceStore) GetAll(offset int, limit int) (model.Compliances, error) {
	start := timemodule.Now()

	result, err := s.ComplianceStore.GetAll(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerComplianceStore) MessageExport(cursor model.MessageExportCursor, limit int) ([]*model.MessageExport, model.MessageExportCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ComplianceStore.MessageExport(cursor, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.MessageExport", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerComplianceStore) Save(compliance *model.Compliance) (*model.Compliance, error) {
	start := timemodule.Now()

	result, err := s.ComplianceStore.Save(compliance)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerComplianceStore) Update(compliance *model.Compliance) (*model.Compliance, error) {
	start := timemodule.Now()

	result, err := s.ComplianceStore.Update(compliance)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ComplianceStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) Delete(emoji *model.Emoji, time int64) error {
	start := timemodule.Now()

	err := s.EmojiStore.Delete(emoji, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerEmojiStore) Get(ctx context.Context, id string, allowFromCache bool) (*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.Get(ctx, id, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) GetByName(ctx context.Context, name string, allowFromCache bool) (*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.GetByName(ctx, name, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) GetList(offset int, limit int, sort string) ([]*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.GetList(offset, limit, sort)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.GetList", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) GetMultipleByName(names []string) ([]*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.GetMultipleByName(names)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.GetMultipleByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) Save(emoji *model.Emoji) (*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.Save(emoji)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerEmojiStore) Search(name string, prefixOnly bool, limit int) ([]*model.Emoji, error) {
	start := timemodule.Now()

	result, err := s.EmojiStore.Search(name, prefixOnly, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("EmojiStore.Search", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) AttachToPost(fileID string, postID string, creatorID string) error {
	start := timemodule.Now()

	err := s.FileInfoStore.AttachToPost(fileID, postID, creatorID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.AttachToPost", success, elapsed)
	}
	return err
}

func (s *TimerLayerFileInfoStore) ClearCaches() {
	start := timemodule.Now()

	s.FileInfoStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerFileInfoStore) CountAll() (int64, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.CountAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.CountAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) DeleteForPost(postID string) (string, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.DeleteForPost(postID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.DeleteForPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) Get(id string) (*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetByIds(ids []string) ([]*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetByIds(ids)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetByPath(path string) (*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetByPath(path)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetByPath", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetFilesBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.FileForIndexing, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetFilesBatchForIndexing(startTime, startFileID, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetFilesBatchForIndexing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetForPost(postID string, readFromMaster bool, includeDeleted bool, allowFromCache bool) ([]*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetForPost(postID, readFromMaster, includeDeleted, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetForPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetForUser(userID string) ([]*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetFromMaster(id string) (*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetFromMaster(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetFromMaster", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) GetWithOptions(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.GetWithOptions(page, perPage, opt)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.GetWithOptions", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) InvalidateFileInfosForPostCache(postID string, deleted bool) {
	start := timemodule.Now()

	s.FileInfoStore.InvalidateFileInfosForPostCache(postID, deleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.InvalidateFileInfosForPostCache", success, elapsed)
	}
}

func (s *TimerLayerFileInfoStore) PermanentDelete(fileID string) error {
	start := timemodule.Now()

	err := s.FileInfoStore.PermanentDelete(fileID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.PermanentDelete", success, elapsed)
	}
	return err
}

func (s *TimerLayerFileInfoStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.PermanentDeleteBatch(endTime, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.PermanentDeleteBatch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) PermanentDeleteByUser(userID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.PermanentDeleteByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.PermanentDeleteByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) Save(info *model.FileInfo) (*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.Save(info)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) Search(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.FileInfoList, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.Search(paramsList, userID, teamID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.Search", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerFileInfoStore) SetContent(fileID string, content string) error {
	start := timemodule.Now()

	err := s.FileInfoStore.SetContent(fileID, content)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.SetContent", success, elapsed)
	}
	return err
}

func (s *TimerLayerFileInfoStore) Upsert(info *model.FileInfo) (*model.FileInfo, error) {
	start := timemodule.Now()

	result, err := s.FileInfoStore.Upsert(info)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("FileInfoStore.Upsert", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) AdminRoleGroupsForSyncableMember(userID string, syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.AdminRoleGroupsForSyncableMember(userID, syncableID, syncableType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.AdminRoleGroupsForSyncableMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.ChannelMembersMinusGroupMembers(channelID, groupIDs, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.ChannelMembersMinusGroupMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) ChannelMembersToAdd(since int64, channelID *string, includeRemovedMembers bool) ([]*model.UserChannelIDPair, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.ChannelMembersToAdd(since, channelID, includeRemovedMembers)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.ChannelMembersToAdd", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) ChannelMembersToRemove(channelID *string) ([]*model.ChannelMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.ChannelMembersToRemove(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.ChannelMembersToRemove", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CountChannelMembersMinusGroupMembers(channelID string, groupIDs []string) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CountChannelMembersMinusGroupMembers(channelID, groupIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CountChannelMembersMinusGroupMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CountGroupsByChannel(channelID string, opts model.GroupSearchOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CountGroupsByChannel(channelID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CountGroupsByChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CountGroupsByTeam(teamID string, opts model.GroupSearchOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CountGroupsByTeam(teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CountGroupsByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CountTeamMembersMinusGroupMembers(teamID string, groupIDs []string) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CountTeamMembersMinusGroupMembers(teamID, groupIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CountTeamMembersMinusGroupMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) Create(group *model.Group) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.Create(group)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.Create", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CreateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CreateGroupSyncable(groupSyncable)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CreateGroupSyncable", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) CreateWithUserIds(group *model.GroupWithUserIds) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.CreateWithUserIds(group)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.CreateWithUserIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) Delete(groupID string) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.Delete(groupID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.DeleteGroupSyncable(groupID, syncableID, syncableType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.DeleteGroupSyncable", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) DeleteMember(groupID string, userID string) (*model.GroupMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.DeleteMember(groupID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.DeleteMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) DeleteMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.DeleteMembers(groupID, userIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.DeleteMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) DistinctGroupMemberCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.DistinctGroupMemberCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.DistinctGroupMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) Get(groupID string) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.Get(groupID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetAllBySource(groupSource model.GroupSource) ([]*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetAllBySource(groupSource)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetAllBySource", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetAllGroupSyncablesByGroupId(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetAllGroupSyncablesByGroupId(groupID, syncableType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetAllGroupSyncablesByGroupId", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetByIDs(groupIDs []string) ([]*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetByIDs(groupIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetByIDs", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetByName(name string, opts model.GroupSearchOpts) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetByName(name, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetByRemoteID(remoteID, groupSource)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetByRemoteID", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetByUser(userID string) ([]*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetGroupSyncable(groupID, syncableID, syncableType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetGroupSyncable", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetGroups(page int, perPage int, opts model.GroupSearchOpts) ([]*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetGroups(page, perPage, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetGroups", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetGroupsAssociatedToChannelsByTeam(teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetGroupsAssociatedToChannelsByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetGroupsByChannel(channelID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetGroupsByChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetGroupsByTeam(teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetGroupsByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMember(groupID string, userID string) (*model.GroupMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMember(groupID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMemberCount(groupID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMemberCount(groupID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMemberUsers(groupID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMemberUsers(groupID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMemberUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMemberUsersInTeam(groupID string, teamID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMemberUsersInTeam(groupID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMemberUsersInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMemberUsersNotInChannel(groupID string, channelID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMemberUsersNotInChannel(groupID, channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMemberUsersNotInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetMemberUsersPage(groupID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetMemberUsersPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GetNonMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GetNonMemberUsersPage(groupID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GetNonMemberUsersPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupChannelCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupChannelCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupChannelCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupCountBySource(source model.GroupSource) (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupCountBySource(source)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupCountBySource", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupCountWithAllowReference() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupCountWithAllowReference()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupCountWithAllowReference", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupMemberCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupMemberCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) GroupTeamCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.GroupTeamCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.GroupTeamCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) PermanentDeleteMembersByUser(userID string) error {
	start := timemodule.Now()

	err := s.GroupStore.PermanentDeleteMembersByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.PermanentDeleteMembersByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerGroupStore) PermittedSyncableAdmins(syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.PermittedSyncableAdmins(syncableID, syncableType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.PermittedSyncableAdmins", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.TeamMembersMinusGroupMembers(teamID, groupIDs, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.TeamMembersMinusGroupMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) TeamMembersToAdd(since int64, teamID *string, includeRemovedMembers bool) ([]*model.UserTeamIDPair, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.TeamMembersToAdd(since, teamID, includeRemovedMembers)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.TeamMembersToAdd", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.TeamMembersToRemove(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.TeamMembersToRemove", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) Update(group *model.Group) (*model.Group, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.Update(group)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.UpdateGroupSyncable(groupSyncable)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.UpdateGroupSyncable", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) UpsertMember(groupID string, userID string) (*model.GroupMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.UpsertMember(groupID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.UpsertMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerGroupStore) UpsertMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	start := timemodule.Now()

	result, err := s.GroupStore.UpsertMembers(groupID, userIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("GroupStore.UpsertMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) Cleanup(expiryTime int64, batchSize int) error {
	start := timemodule.Now()

	err := s.JobStore.Cleanup(expiryTime, batchSize)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.Cleanup", success, elapsed)
	}
	return err
}

func (s *TimerLayerJobStore) Delete(id string) (string, error) {
	start := timemodule.Now()

	result, err := s.JobStore.Delete(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) Get(id string) (*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllByStatus(status string) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllByStatus(status)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllByStatus", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllByType(jobType string) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllByType(jobType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllByType", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllByTypeAndStatus(jobType string, status string) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllByTypeAndStatus(jobType, status)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllByTypeAndStatus", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllByTypePage(jobType string, offset int, limit int) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllByTypePage(jobType, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllByTypePage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllByTypesPage(jobTypes []string, offset int, limit int) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllByTypesPage(jobTypes, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllByTypesPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetAllPage(offset int, limit int) ([]*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetAllPage(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetAllPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetCountByStatusAndType(status string, jobType string) (int64, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetCountByStatusAndType(status, jobType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetCountByStatusAndType", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetNewestJobByStatusAndType(status string, jobType string) (*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetNewestJobByStatusAndType(status, jobType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetNewestJobByStatusAndType", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) GetNewestJobByStatusesAndType(statuses []string, jobType string) (*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.GetNewestJobByStatusesAndType(statuses, jobType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.GetNewestJobByStatusesAndType", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) Save(job *model.Job) (*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.Save(job)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) UpdateOptimistically(job *model.Job, currentStatus string) (bool, error) {
	start := timemodule.Now()

	result, err := s.JobStore.UpdateOptimistically(job, currentStatus)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.UpdateOptimistically", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) UpdateStatus(id string, status string) (*model.Job, error) {
	start := timemodule.Now()

	result, err := s.JobStore.UpdateStatus(id, status)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.UpdateStatus", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerJobStore) UpdateStatusOptimistically(id string, currentStatus string, newStatus string) (bool, error) {
	start := timemodule.Now()

	result, err := s.JobStore.UpdateStatusOptimistically(id, currentStatus, newStatus)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("JobStore.UpdateStatusOptimistically", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerLicenseStore) Get(id string) (*model.LicenseRecord, error) {
	start := timemodule.Now()

	result, err := s.LicenseStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("LicenseStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerLicenseStore) GetAll() ([]*model.LicenseRecord, error) {
	start := timemodule.Now()

	result, err := s.LicenseStore.GetAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("LicenseStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerLicenseStore) Save(license *model.LicenseRecord) (*model.LicenseRecord, error) {
	start := timemodule.Now()

	result, err := s.LicenseStore.Save(license)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("LicenseStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerLinkMetadataStore) Get(url string, timestamp int64) (*model.LinkMetadata, error) {
	start := timemodule.Now()

	result, err := s.LinkMetadataStore.Get(url, timestamp)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("LinkMetadataStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerLinkMetadataStore) Save(linkMetadata *model.LinkMetadata) (*model.LinkMetadata, error) {
	start := timemodule.Now()

	result, err := s.LinkMetadataStore.Save(linkMetadata)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("LinkMetadataStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) DeleteApp(id string) error {
	start := timemodule.Now()

	err := s.OAuthStore.DeleteApp(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.DeleteApp", success, elapsed)
	}
	return err
}

func (s *TimerLayerOAuthStore) GetAccessData(token string) (*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAccessData(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAccessData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetAccessDataByRefreshToken(token string) (*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAccessDataByRefreshToken(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAccessDataByRefreshToken", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetAccessDataByUserForApp(userID string, clientId string) ([]*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAccessDataByUserForApp(userID, clientId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAccessDataByUserForApp", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetApp(id string) (*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetApp(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetApp", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetAppByUser(userID string, offset int, limit int) ([]*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAppByUser(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAppByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetApps(offset int, limit int) ([]*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetApps(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetApps", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetAuthData(code string) (*model.AuthData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAuthData(code)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAuthData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetAuthorizedApps(userID string, offset int, limit int) ([]*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetAuthorizedApps(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetAuthorizedApps", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) GetPreviousAccessData(userID string, clientId string) (*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.GetPreviousAccessData(userID, clientId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.GetPreviousAccessData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) PermanentDeleteAuthDataByUser(userID string) error {
	start := timemodule.Now()

	err := s.OAuthStore.PermanentDeleteAuthDataByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.PermanentDeleteAuthDataByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerOAuthStore) RemoveAccessData(token string) error {
	start := timemodule.Now()

	err := s.OAuthStore.RemoveAccessData(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.RemoveAccessData", success, elapsed)
	}
	return err
}

func (s *TimerLayerOAuthStore) RemoveAllAccessData() error {
	start := timemodule.Now()

	err := s.OAuthStore.RemoveAllAccessData()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.RemoveAllAccessData", success, elapsed)
	}
	return err
}

func (s *TimerLayerOAuthStore) RemoveAuthData(code string) error {
	start := timemodule.Now()

	err := s.OAuthStore.RemoveAuthData(code)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.RemoveAuthData", success, elapsed)
	}
	return err
}

func (s *TimerLayerOAuthStore) SaveAccessData(accessData *model.AccessData) (*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.SaveAccessData(accessData)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.SaveAccessData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) SaveApp(app *model.OAuthApp) (*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.SaveApp(app)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.SaveApp", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) SaveAuthData(authData *model.AuthData) (*model.AuthData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.SaveAuthData(authData)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.SaveAuthData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) UpdateAccessData(accessData *model.AccessData) (*model.AccessData, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.UpdateAccessData(accessData)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.UpdateAccessData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerOAuthStore) UpdateApp(app *model.OAuthApp) (*model.OAuthApp, error) {
	start := timemodule.Now()

	result, err := s.OAuthStore.UpdateApp(app)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("OAuthStore.UpdateApp", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) CompareAndDelete(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.CompareAndDelete(keyVal, oldValue)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.CompareAndDelete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) CompareAndSet(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.CompareAndSet(keyVal, oldValue)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.CompareAndSet", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) Delete(pluginID string, key string) error {
	start := timemodule.Now()

	err := s.PluginStore.Delete(pluginID, key)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerPluginStore) DeleteAllExpired() error {
	start := timemodule.Now()

	err := s.PluginStore.DeleteAllExpired()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.DeleteAllExpired", success, elapsed)
	}
	return err
}

func (s *TimerLayerPluginStore) DeleteAllForPlugin(PluginID string) error {
	start := timemodule.Now()

	err := s.PluginStore.DeleteAllForPlugin(PluginID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.DeleteAllForPlugin", success, elapsed)
	}
	return err
}

func (s *TimerLayerPluginStore) Get(pluginID string, key string) (*model.PluginKeyValue, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.Get(pluginID, key)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) List(pluginID string, page int, perPage int) ([]string, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.List(pluginID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.List", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) SaveOrUpdate(keyVal *model.PluginKeyValue) (*model.PluginKeyValue, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.SaveOrUpdate(keyVal)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.SaveOrUpdate", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPluginStore) SetWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, error) {
	start := timemodule.Now()

	result, err := s.PluginStore.SetWithOptions(pluginID, key, value, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PluginStore.SetWithOptions", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) AnalyticsPostCount(teamID string, mustHaveFile bool, mustHaveHashtag bool) (int64, error) {
	start := timemodule.Now()

	result, err := s.PostStore.AnalyticsPostCount(teamID, mustHaveFile, mustHaveHashtag)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.AnalyticsPostCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) AnalyticsPostCountsByDay(options *model.AnalyticsPostCountsOptions) (model.AnalyticsRows, error) {
	start := timemodule.Now()

	result, err := s.PostStore.AnalyticsPostCountsByDay(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.AnalyticsPostCountsByDay", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) AnalyticsUserCountsWithPostsByDay(teamID string) (model.AnalyticsRows, error) {
	start := timemodule.Now()

	result, err := s.PostStore.AnalyticsUserCountsWithPostsByDay(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.AnalyticsUserCountsWithPostsByDay", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) ClearCaches() {
	start := timemodule.Now()

	s.PostStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerPostStore) Delete(postID string, time int64, deleteByID string) error {
	start := timemodule.Now()

	err := s.PostStore.Delete(postID, time, deleteByID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerPostStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.PostStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) Get(ctx context.Context, id string, opts model.GetPostsOptions, userID string, sanitizeOptions map[string]bool) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.Get(ctx, id, opts, userID, sanitizeOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetDirectPostParentsForExportAfter(limit int, afterID string) ([]*model.DirectPostForExport, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetDirectPostParentsForExportAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetDirectPostParentsForExportAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetEtag(channelID string, allowFromCache bool, collapsedThreads bool) string {
	start := timemodule.Now()

	result := s.PostStore.GetEtag(channelID, allowFromCache, collapsedThreads)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetEtag", success, elapsed)
	}
	return result
}

func (s *TimerLayerPostStore) GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetFlaggedPosts(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetFlaggedPosts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetFlaggedPostsForChannel(userID string, channelID string, offset int, limit int) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetFlaggedPostsForChannel(userID, channelID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetFlaggedPostsForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetFlaggedPostsForTeam(userID string, teamID string, offset int, limit int) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetFlaggedPostsForTeam(userID, teamID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetFlaggedPostsForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetLastPostRowCreateAt() (int64, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetLastPostRowCreateAt()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetLastPostRowCreateAt", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetMaxPostSize() int {
	start := timemodule.Now()

	result := s.PostStore.GetMaxPostSize()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetMaxPostSize", success, elapsed)
	}
	return result
}

func (s *TimerLayerPostStore) GetOldest() (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetOldest()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetOldest", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetOldestEntityCreationTime() (int64, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetOldestEntityCreationTime()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetOldestEntityCreationTime", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetParentsForExportAfter(limit int, afterID string) ([]*model.PostForExport, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetParentsForExportAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetParentsForExportAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostAfterTime(channelID string, time int64, collapsedThreads bool) (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostAfterTime(channelID, time, collapsedThreads)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostAfterTime", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostIdAfterTime(channelID string, time int64, collapsedThreads bool) (string, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostIdAfterTime(channelID, time, collapsedThreads)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostIdAfterTime", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostIdBeforeTime(channelID string, time int64, collapsedThreads bool) (string, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostIdBeforeTime(channelID, time, collapsedThreads)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostIdBeforeTime", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPosts(options model.GetPostsOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPosts(options, allowFromCache, sanitizeOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPosts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsAfter(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsAfter(options, sanitizeOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsBatchForIndexing(startTime int64, startPostID string, limit int) ([]*model.PostForIndexing, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsBatchForIndexing(startTime, startPostID, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsBatchForIndexing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsBefore(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsBefore(options, sanitizeOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsBefore", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsByIds(postIds []string) ([]*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsByIds(postIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsCreatedAt(channelID string, time int64) ([]*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsCreatedAt(channelID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsCreatedAt", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsSince(options model.GetPostsSinceOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetPostsSince(options, allowFromCache, sanitizeOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetPostsSinceForSync(options model.GetPostsSinceForSyncOptions, cursor model.GetPostsSinceForSyncCursor, limit int) ([]*model.Post, model.GetPostsSinceForSyncCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.PostStore.GetPostsSinceForSync(options, cursor, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetPostsSinceForSync", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerPostStore) GetRepliesForExport(parentID string) ([]*model.ReplyForExport, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetRepliesForExport(parentID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetRepliesForExport", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) GetSingle(id string, inclDeleted bool) (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.GetSingle(id, inclDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.GetSingle", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) HasAutoResponsePostByUserSince(options model.GetPostsSinceOptions, userId string) (bool, error) {
	start := timemodule.Now()

	result, err := s.PostStore.HasAutoResponsePostByUserSince(options, userId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.HasAutoResponsePostByUserSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) InvalidateLastPostTimeCache(channelID string) {
	start := timemodule.Now()

	s.PostStore.InvalidateLastPostTimeCache(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.InvalidateLastPostTimeCache", success, elapsed)
	}
}

func (s *TimerLayerPostStore) Overwrite(post *model.Post) (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.Overwrite(post)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Overwrite", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) OverwriteMultiple(posts []*model.Post) ([]*model.Post, int, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.PostStore.OverwriteMultiple(posts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.OverwriteMultiple", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerPostStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	start := timemodule.Now()

	result, err := s.PostStore.PermanentDeleteBatch(endTime, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.PermanentDeleteBatch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.PostStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.PermanentDeleteBatchForRetentionPolicies", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerPostStore) PermanentDeleteByChannel(channelID string) error {
	start := timemodule.Now()

	err := s.PostStore.PermanentDeleteByChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.PermanentDeleteByChannel", success, elapsed)
	}
	return err
}

func (s *TimerLayerPostStore) PermanentDeleteByUser(userID string) error {
	start := timemodule.Now()

	err := s.PostStore.PermanentDeleteByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.PermanentDeleteByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerPostStore) Save(post *model.Post) (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.Save(post)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) SaveMultiple(posts []*model.Post) ([]*model.Post, int, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.PostStore.SaveMultiple(posts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.SaveMultiple", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerPostStore) Search(teamID string, userID string, params *model.SearchParams) (*model.PostList, error) {
	start := timemodule.Now()

	result, err := s.PostStore.Search(teamID, userID, params)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Search", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) SearchPostsForUser(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.PostSearchResults, error) {
	start := timemodule.Now()

	result, err := s.PostStore.SearchPostsForUser(paramsList, userID, teamID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.SearchPostsForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPostStore) Update(newPost *model.Post, oldPost *model.Post) (*model.Post, error) {
	start := timemodule.Now()

	result, err := s.PostStore.Update(newPost, oldPost)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PostStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) CleanupFlagsBatch(limit int64) (int64, error) {
	start := timemodule.Now()

	result, err := s.PreferenceStore.CleanupFlagsBatch(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.CleanupFlagsBatch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) Delete(userID string, category string, name string) error {
	start := timemodule.Now()

	err := s.PreferenceStore.Delete(userID, category, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerPreferenceStore) DeleteCategory(userID string, category string) error {
	start := timemodule.Now()

	err := s.PreferenceStore.DeleteCategory(userID, category)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.DeleteCategory", success, elapsed)
	}
	return err
}

func (s *TimerLayerPreferenceStore) DeleteCategoryAndName(category string, name string) error {
	start := timemodule.Now()

	err := s.PreferenceStore.DeleteCategoryAndName(category, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.DeleteCategoryAndName", success, elapsed)
	}
	return err
}

func (s *TimerLayerPreferenceStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.PreferenceStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) Get(userID string, category string, name string) (*model.Preference, error) {
	start := timemodule.Now()

	result, err := s.PreferenceStore.Get(userID, category, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) GetAll(userID string) (model.Preferences, error) {
	start := timemodule.Now()

	result, err := s.PreferenceStore.GetAll(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) GetCategory(userID string, category string) (model.Preferences, error) {
	start := timemodule.Now()

	result, err := s.PreferenceStore.GetCategory(userID, category)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.GetCategory", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerPreferenceStore) PermanentDeleteByUser(userID string) error {
	start := timemodule.Now()

	err := s.PreferenceStore.PermanentDeleteByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.PermanentDeleteByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerPreferenceStore) Save(preferences model.Preferences) error {
	start := timemodule.Now()

	err := s.PreferenceStore.Save(preferences)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("PreferenceStore.Save", success, elapsed)
	}
	return err
}

func (s *TimerLayerProductNoticesStore) Clear(notices []string) error {
	start := timemodule.Now()

	err := s.ProductNoticesStore.Clear(notices)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ProductNoticesStore.Clear", success, elapsed)
	}
	return err
}

func (s *TimerLayerProductNoticesStore) ClearOldNotices(currentNotices model.ProductNotices) error {
	start := timemodule.Now()

	err := s.ProductNoticesStore.ClearOldNotices(currentNotices)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ProductNoticesStore.ClearOldNotices", success, elapsed)
	}
	return err
}

func (s *TimerLayerProductNoticesStore) GetViews(userID string) ([]model.ProductNoticeViewState, error) {
	start := timemodule.Now()

	result, err := s.ProductNoticesStore.GetViews(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ProductNoticesStore.GetViews", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerProductNoticesStore) View(userID string, notices []string) error {
	start := timemodule.Now()

	err := s.ProductNoticesStore.View(userID, notices)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ProductNoticesStore.View", success, elapsed)
	}
	return err
}

func (s *TimerLayerReactionStore) BulkGetForPosts(postIds []string) ([]*model.Reaction, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.BulkGetForPosts(postIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.BulkGetForPosts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) Delete(reaction *model.Reaction) (*model.Reaction, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.Delete(reaction)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) DeleteAllWithEmojiName(emojiName string) error {
	start := timemodule.Now()

	err := s.ReactionStore.DeleteAllWithEmojiName(emojiName)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.DeleteAllWithEmojiName", success, elapsed)
	}
	return err
}

func (s *TimerLayerReactionStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) GetForPost(postID string, allowFromCache bool) ([]*model.Reaction, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.GetForPost(postID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.GetForPost", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) GetForPostSince(postId string, since int64, excludeRemoteId string, inclDeleted bool) ([]*model.Reaction, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.GetForPostSince(postId, since, excludeRemoteId, inclDeleted)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.GetForPostSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) GetTopForTeamSince(teamID string, userID string, since int64, offset int, limit int) (*model.TopReactionList, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.GetTopForTeamSince(teamID, userID, since, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.GetTopForTeamSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) GetTopForUserSince(userID string, teamID string, since int64, offset int, limit int) (*model.TopReactionList, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.GetTopForUserSince(userID, teamID, since, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.GetTopForUserSince", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.PermanentDeleteBatch(endTime, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.PermanentDeleteBatch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerReactionStore) Save(reaction *model.Reaction) (*model.Reaction, error) {
	start := timemodule.Now()

	result, err := s.ReactionStore.Save(reaction)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ReactionStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) Delete(remoteClusterId string) (bool, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.Delete(remoteClusterId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) Get(remoteClusterId string) (*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.Get(remoteClusterId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) GetAll(filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.GetAll(filter)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) Save(rc *model.RemoteCluster) (*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.Save(rc)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) SetLastPingAt(remoteClusterId string) error {
	start := timemodule.Now()

	err := s.RemoteClusterStore.SetLastPingAt(remoteClusterId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.SetLastPingAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerRemoteClusterStore) Update(rc *model.RemoteCluster) (*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.Update(rc)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRemoteClusterStore) UpdateTopics(remoteClusterId string, topics string) (*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.RemoteClusterStore.UpdateTopics(remoteClusterId, topics)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RemoteClusterStore.UpdateTopics", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) AddChannels(policyId string, channelIds []string) error {
	start := timemodule.Now()

	err := s.RetentionPolicyStore.AddChannels(policyId, channelIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.AddChannels", success, elapsed)
	}
	return err
}

func (s *TimerLayerRetentionPolicyStore) AddTeams(policyId string, teamIds []string) error {
	start := timemodule.Now()

	err := s.RetentionPolicyStore.AddTeams(policyId, teamIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.AddTeams", success, elapsed)
	}
	return err
}

func (s *TimerLayerRetentionPolicyStore) Delete(id string) error {
	start := timemodule.Now()

	err := s.RetentionPolicyStore.Delete(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerRetentionPolicyStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) Get(id string) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetAll(offset int, limit int) ([]*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetAll(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetChannelPoliciesCountForUser(userID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetChannelPoliciesCountForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetChannelPoliciesCountForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetChannelPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForChannel, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetChannelPoliciesForUser(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetChannelPoliciesForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetChannels(policyId string, offset int, limit int) (model.ChannelListWithTeamData, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetChannels(policyId, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetChannels", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetChannelsCount(policyId string) (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetChannelsCount(policyId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetChannelsCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetTeamPoliciesCountForUser(userID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetTeamPoliciesCountForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetTeamPoliciesCountForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetTeamPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForTeam, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetTeamPoliciesForUser(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetTeamPoliciesForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetTeams(policyId string, offset int, limit int) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetTeams(policyId, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetTeams", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) GetTeamsCount(policyId string) (int64, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.GetTeamsCount(policyId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.GetTeamsCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) Patch(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.Patch(patch)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.Patch", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRetentionPolicyStore) RemoveChannels(policyId string, channelIds []string) error {
	start := timemodule.Now()

	err := s.RetentionPolicyStore.RemoveChannels(policyId, channelIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.RemoveChannels", success, elapsed)
	}
	return err
}

func (s *TimerLayerRetentionPolicyStore) RemoveTeams(policyId string, teamIds []string) error {
	start := timemodule.Now()

	err := s.RetentionPolicyStore.RemoveTeams(policyId, teamIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.RemoveTeams", success, elapsed)
	}
	return err
}

func (s *TimerLayerRetentionPolicyStore) Save(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {
	start := timemodule.Now()

	result, err := s.RetentionPolicyStore.Save(policy)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RetentionPolicyStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) AllChannelSchemeRoles() ([]*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.AllChannelSchemeRoles()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.AllChannelSchemeRoles", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) ChannelHigherScopedPermissions(roleNames []string) (map[string]*model.RolePermissions, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.ChannelHigherScopedPermissions(roleNames)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.ChannelHigherScopedPermissions", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) ChannelRolesUnderTeamRole(roleName string) ([]*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.ChannelRolesUnderTeamRole(roleName)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.ChannelRolesUnderTeamRole", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) Delete(roleID string) (*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.Delete(roleID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) Get(roleID string) (*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.Get(roleID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) GetAll() ([]*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.GetAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) GetByName(ctx context.Context, name string) (*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.GetByName(ctx, name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) GetByNames(names []string) ([]*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.GetByNames(names)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.GetByNames", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerRoleStore) PermanentDeleteAll() error {
	start := timemodule.Now()

	err := s.RoleStore.PermanentDeleteAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.PermanentDeleteAll", success, elapsed)
	}
	return err
}

func (s *TimerLayerRoleStore) Save(role *model.Role) (*model.Role, error) {
	start := timemodule.Now()

	result, err := s.RoleStore.Save(role)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("RoleStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) CountByScope(scope string) (int64, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.CountByScope(scope)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.CountByScope", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) CountWithoutPermission(scope string, permissionID string, roleScope model.RoleScope, roleType model.RoleType) (int64, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.CountWithoutPermission(scope, permissionID, roleScope, roleType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.CountWithoutPermission", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) Delete(schemeID string) (*model.Scheme, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.Delete(schemeID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) Get(schemeID string) (*model.Scheme, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.Get(schemeID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) GetAllPage(scope string, offset int, limit int) ([]*model.Scheme, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.GetAllPage(scope, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.GetAllPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) GetByName(schemeName string) (*model.Scheme, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.GetByName(schemeName)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSchemeStore) PermanentDeleteAll() error {
	start := timemodule.Now()

	err := s.SchemeStore.PermanentDeleteAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.PermanentDeleteAll", success, elapsed)
	}
	return err
}

func (s *TimerLayerSchemeStore) Save(scheme *model.Scheme) (*model.Scheme, error) {
	start := timemodule.Now()

	result, err := s.SchemeStore.Save(scheme)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SchemeStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) AnalyticsSessionCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.AnalyticsSessionCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.AnalyticsSessionCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) Cleanup(expiryTime int64, batchSize int64) error {
	start := timemodule.Now()

	err := s.SessionStore.Cleanup(expiryTime, batchSize)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.Cleanup", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) Get(ctx context.Context, sessionIDOrToken string) (*model.Session, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.Get(ctx, sessionIDOrToken)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) GetLastSessionRowCreateAt() (int64, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.GetLastSessionRowCreateAt()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.GetLastSessionRowCreateAt", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) GetSessions(userID string) ([]*model.Session, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.GetSessions(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.GetSessions", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) GetSessionsExpired(thresholdMillis int64, mobileOnly bool, unnotifiedOnly bool) ([]*model.Session, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.GetSessionsExpired(thresholdMillis, mobileOnly, unnotifiedOnly)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.GetSessionsExpired", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) GetSessionsWithActiveDeviceIds(userID string) ([]*model.Session, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.GetSessionsWithActiveDeviceIds(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.GetSessionsWithActiveDeviceIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) PermanentDeleteSessionsByUser(teamID string) error {
	start := timemodule.Now()

	err := s.SessionStore.PermanentDeleteSessionsByUser(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.PermanentDeleteSessionsByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) Remove(sessionIDOrToken string) error {
	start := timemodule.Now()

	err := s.SessionStore.Remove(sessionIDOrToken)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.Remove", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) RemoveAllSessions() error {
	start := timemodule.Now()

	err := s.SessionStore.RemoveAllSessions()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.RemoveAllSessions", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) Save(session *model.Session) (*model.Session, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.Save(session)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) UpdateDeviceId(id string, deviceID string, expiresAt int64) (string, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.UpdateDeviceId(id, deviceID, expiresAt)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateDeviceId", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSessionStore) UpdateExpiredNotify(sessionid string, notified bool) error {
	start := timemodule.Now()

	err := s.SessionStore.UpdateExpiredNotify(sessionid, notified)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateExpiredNotify", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) UpdateExpiresAt(sessionID string, time int64) error {
	start := timemodule.Now()

	err := s.SessionStore.UpdateExpiresAt(sessionID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateExpiresAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) UpdateLastActivityAt(sessionID string, time int64) error {
	start := timemodule.Now()

	err := s.SessionStore.UpdateLastActivityAt(sessionID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateLastActivityAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) UpdateProps(session *model.Session) error {
	start := timemodule.Now()

	err := s.SessionStore.UpdateProps(session)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateProps", success, elapsed)
	}
	return err
}

func (s *TimerLayerSessionStore) UpdateRoles(userID string, roles string) (string, error) {
	start := timemodule.Now()

	result, err := s.SessionStore.UpdateRoles(userID, roles)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SessionStore.UpdateRoles", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) Delete(channelId string) (bool, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.Delete(channelId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.Delete", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) DeleteRemote(remoteId string) (bool, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.DeleteRemote(remoteId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.DeleteRemote", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) Get(channelId string) (*model.SharedChannel, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.Get(channelId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetAll(offset int, limit int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetAll(offset, limit, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetAllCount(opts model.SharedChannelFilterOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetAllCount(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetAllCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetAttachment(fileId string, remoteId string) (*model.SharedChannelAttachment, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetAttachment(fileId, remoteId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetAttachment", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetRemote(id string) (*model.SharedChannelRemote, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetRemote(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetRemote", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetRemoteByIds(channelId string, remoteId string) (*model.SharedChannelRemote, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetRemoteByIds(channelId, remoteId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetRemoteByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetRemoteForUser(remoteId string, userId string) (*model.RemoteCluster, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetRemoteForUser(remoteId, userId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetRemoteForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetRemotes(opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetRemotes(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetRemotes", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetRemotesStatus(channelId string) ([]*model.SharedChannelRemoteStatus, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetRemotesStatus(channelId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetRemotesStatus", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetSingleUser(userID string, channelID string, remoteID string) (*model.SharedChannelUser, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetSingleUser(userID, channelID, remoteID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetSingleUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetUsersForSync(filter model.GetUsersForSyncFilter) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetUsersForSync(filter)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetUsersForSync", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) GetUsersForUser(userID string) ([]*model.SharedChannelUser, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.GetUsersForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.GetUsersForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) HasChannel(channelID string) (bool, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.HasChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.HasChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) HasRemote(channelID string, remoteId string) (bool, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.HasRemote(channelID, remoteId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.HasRemote", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) Save(sc *model.SharedChannel) (*model.SharedChannel, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.Save(sc)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) SaveAttachment(remote *model.SharedChannelAttachment) (*model.SharedChannelAttachment, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.SaveAttachment(remote)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.SaveAttachment", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) SaveRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.SaveRemote(remote)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.SaveRemote", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) SaveUser(remote *model.SharedChannelUser) (*model.SharedChannelUser, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.SaveUser(remote)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.SaveUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) Update(sc *model.SharedChannel) (*model.SharedChannel, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.Update(sc)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) UpdateAttachmentLastSyncAt(id string, syncTime int64) error {
	start := timemodule.Now()

	err := s.SharedChannelStore.UpdateAttachmentLastSyncAt(id, syncTime)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.UpdateAttachmentLastSyncAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerSharedChannelStore) UpdateRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.UpdateRemote(remote)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.UpdateRemote", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSharedChannelStore) UpdateRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error {
	start := timemodule.Now()

	err := s.SharedChannelStore.UpdateRemoteCursor(id, cursor)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.UpdateRemoteCursor", success, elapsed)
	}
	return err
}

func (s *TimerLayerSharedChannelStore) UpdateUserLastSyncAt(userID string, channelID string, remoteID string) error {
	start := timemodule.Now()

	err := s.SharedChannelStore.UpdateUserLastSyncAt(userID, channelID, remoteID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.UpdateUserLastSyncAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerSharedChannelStore) UpsertAttachment(remote *model.SharedChannelAttachment) (string, error) {
	start := timemodule.Now()

	result, err := s.SharedChannelStore.UpsertAttachment(remote)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SharedChannelStore.UpsertAttachment", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerStatusStore) Get(userID string) (*model.Status, error) {
	start := timemodule.Now()

	result, err := s.StatusStore.Get(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerStatusStore) GetByIds(userIds []string) ([]*model.Status, error) {
	start := timemodule.Now()

	result, err := s.StatusStore.GetByIds(userIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.GetByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerStatusStore) GetTotalActiveUsersCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.StatusStore.GetTotalActiveUsersCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.GetTotalActiveUsersCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerStatusStore) ResetAll() error {
	start := timemodule.Now()

	err := s.StatusStore.ResetAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.ResetAll", success, elapsed)
	}
	return err
}

func (s *TimerLayerStatusStore) SaveOrUpdate(status *model.Status) error {
	start := timemodule.Now()

	err := s.StatusStore.SaveOrUpdate(status)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.SaveOrUpdate", success, elapsed)
	}
	return err
}

func (s *TimerLayerStatusStore) UpdateExpiredDNDStatuses() ([]*model.Status, error) {
	start := timemodule.Now()

	result, err := s.StatusStore.UpdateExpiredDNDStatuses()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.UpdateExpiredDNDStatuses", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerStatusStore) UpdateLastActivityAt(userID string, lastActivityAt int64) error {
	start := timemodule.Now()

	err := s.StatusStore.UpdateLastActivityAt(userID, lastActivityAt)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("StatusStore.UpdateLastActivityAt", success, elapsed)
	}
	return err
}

func (s *TimerLayerSystemStore) Get() (model.StringMap, error) {
	start := timemodule.Now()

	result, err := s.SystemStore.Get()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSystemStore) GetByName(name string) (*model.System, error) {
	start := timemodule.Now()

	result, err := s.SystemStore.GetByName(name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSystemStore) InsertIfExists(system *model.System) (*model.System, error) {
	start := timemodule.Now()

	result, err := s.SystemStore.InsertIfExists(system)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.InsertIfExists", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSystemStore) PermanentDeleteByName(name string) (*model.System, error) {
	start := timemodule.Now()

	result, err := s.SystemStore.PermanentDeleteByName(name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.PermanentDeleteByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerSystemStore) Save(system *model.System) error {
	start := timemodule.Now()

	err := s.SystemStore.Save(system)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.Save", success, elapsed)
	}
	return err
}

func (s *TimerLayerSystemStore) SaveOrUpdate(system *model.System) error {
	start := timemodule.Now()

	err := s.SystemStore.SaveOrUpdate(system)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.SaveOrUpdate", success, elapsed)
	}
	return err
}

func (s *TimerLayerSystemStore) SaveOrUpdateWithWarnMetricHandling(system *model.System) error {
	start := timemodule.Now()

	err := s.SystemStore.SaveOrUpdateWithWarnMetricHandling(system)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.SaveOrUpdateWithWarnMetricHandling", success, elapsed)
	}
	return err
}

func (s *TimerLayerSystemStore) Update(system *model.System) error {
	start := timemodule.Now()

	err := s.SystemStore.Update(system)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("SystemStore.Update", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) AnalyticsGetTeamCountForScheme(schemeID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.AnalyticsGetTeamCountForScheme(schemeID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.AnalyticsGetTeamCountForScheme", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) AnalyticsTeamCount(opts *model.TeamSearch) (int64, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.AnalyticsTeamCount(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.AnalyticsTeamCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) ClearAllCustomRoleAssignments() error {
	start := timemodule.Now()

	err := s.TeamStore.ClearAllCustomRoleAssignments()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.ClearAllCustomRoleAssignments", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) ClearCaches() {
	start := timemodule.Now()

	s.TeamStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerTeamStore) Get(id string) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetActiveMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetActiveMemberCount(teamID, restrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetActiveMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetAll() ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetAllForExportAfter(limit int, afterID string) ([]*model.TeamForExport, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetAllForExportAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetAllForExportAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetAllPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetAllPage(offset, limit, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetAllPage", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetAllPrivateTeamListing() ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetAllPrivateTeamListing()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetAllPrivateTeamListing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetAllTeamListing() ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetAllTeamListing()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetAllTeamListing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetByInviteId(inviteID string) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetByInviteId(inviteID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetByInviteId", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetByName(name string) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetByName(name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetByName", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetByNames(name []string) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetByNames(name)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetByNames", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetChannelUnreadsForAllTeams(excludeTeamID string, userID string) ([]*model.ChannelUnread, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetChannelUnreadsForAllTeams(excludeTeamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetChannelUnreadsForAllTeams", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetChannelUnreadsForTeam(teamID string, userID string) ([]*model.ChannelUnread, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetChannelUnreadsForTeam(teamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetChannelUnreadsForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetCommonTeamIDsForTwoUsers(userID string, otherUserID string) ([]string, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetCommonTeamIDsForTwoUsers(userID, otherUserID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetCommonTeamIDsForTwoUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetMany(ids []string) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetMany(ids)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetMany", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetMember(ctx context.Context, teamID string, userID string) (*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetMember(ctx, teamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetMembers(teamID, offset, limit, teamMembersGetOptions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetMembersByIds(teamID string, userIds []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetMembersByIds(teamID, userIds, restrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetMembersByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTeamMembersForExport(userID string) ([]*model.TeamMemberForExport, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTeamMembersForExport(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTeamMembersForExport", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTeamsByScheme(schemeID string, offset int, limit int) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTeamsByScheme(schemeID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTeamsByScheme", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTeamsByUserId(userID string) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTeamsByUserId(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTeamsByUserId", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTeamsForUser(ctx context.Context, userID string) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTeamsForUser(ctx, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTeamsForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTeamsForUserWithPagination(userID string, page int, perPage int) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTeamsForUserWithPagination(userID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTeamsForUserWithPagination", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetTotalMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetTotalMemberCount(teamID, restrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetTotalMemberCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GetUserTeamIds(userID string, allowFromCache bool) ([]string, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GetUserTeamIds(userID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GetUserTeamIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) GroupSyncedTeamCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.GroupSyncedTeamCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.GroupSyncedTeamCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) InvalidateAllTeamIdsForUser(userID string) {
	start := timemodule.Now()

	s.TeamStore.InvalidateAllTeamIdsForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.InvalidateAllTeamIdsForUser", success, elapsed)
	}
}

func (s *TimerLayerTeamStore) MigrateTeamMembers(fromTeamID string, fromUserID string) (map[string]string, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.MigrateTeamMembers(fromTeamID, fromUserID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.MigrateTeamMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) PermanentDelete(teamID string) error {
	start := timemodule.Now()

	err := s.TeamStore.PermanentDelete(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.PermanentDelete", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) RemoveAllMembersByTeam(teamID string) error {
	start := timemodule.Now()

	err := s.TeamStore.RemoveAllMembersByTeam(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.RemoveAllMembersByTeam", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) RemoveAllMembersByUser(userID string) error {
	start := timemodule.Now()

	err := s.TeamStore.RemoveAllMembersByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.RemoveAllMembersByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) RemoveMember(teamID string, userID string) error {
	start := timemodule.Now()

	err := s.TeamStore.RemoveMember(teamID, userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.RemoveMember", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) RemoveMembers(teamID string, userIds []string) error {
	start := timemodule.Now()

	err := s.TeamStore.RemoveMembers(teamID, userIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.RemoveMembers", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) ResetAllTeamSchemes() error {
	start := timemodule.Now()

	err := s.TeamStore.ResetAllTeamSchemes()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.ResetAllTeamSchemes", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) Save(team *model.Team) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.Save(team)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) SaveMember(member *model.TeamMember, maxUsersPerTeam int) (*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.SaveMember(member, maxUsersPerTeam)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SaveMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) SaveMultipleMembers(members []*model.TeamMember, maxUsersPerTeam int) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.SaveMultipleMembers(members, maxUsersPerTeam)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SaveMultipleMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) SearchAll(opts *model.TeamSearch) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.SearchAll(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SearchAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) SearchAllPaged(opts *model.TeamSearch) ([]*model.Team, int64, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.TeamStore.SearchAllPaged(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SearchAllPaged", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerTeamStore) SearchOpen(opts *model.TeamSearch) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.SearchOpen(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SearchOpen", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) SearchPrivate(opts *model.TeamSearch) ([]*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.SearchPrivate(opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.SearchPrivate", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) Update(team *model.Team) (*model.Team, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.Update(team)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) UpdateLastTeamIconUpdate(teamID string, curTime int64) error {
	start := timemodule.Now()

	err := s.TeamStore.UpdateLastTeamIconUpdate(teamID, curTime)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.UpdateLastTeamIconUpdate", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) UpdateMember(member *model.TeamMember) (*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.UpdateMember(member)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.UpdateMember", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) UpdateMembersRole(teamID string, userIDs []string) error {
	start := timemodule.Now()

	err := s.TeamStore.UpdateMembersRole(teamID, userIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.UpdateMembersRole", success, elapsed)
	}
	return err
}

func (s *TimerLayerTeamStore) UpdateMultipleMembers(members []*model.TeamMember) ([]*model.TeamMember, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.UpdateMultipleMembers(members)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.UpdateMultipleMembers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTeamStore) UserBelongsToTeams(userID string, teamIds []string) (bool, error) {
	start := timemodule.Now()

	result, err := s.TeamStore.UserBelongsToTeams(userID, teamIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TeamStore.UserBelongsToTeams", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTermsOfServiceStore) Get(id string, allowFromCache bool) (*model.TermsOfService, error) {
	start := timemodule.Now()

	result, err := s.TermsOfServiceStore.Get(id, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TermsOfServiceStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTermsOfServiceStore) GetLatest(allowFromCache bool) (*model.TermsOfService, error) {
	start := timemodule.Now()

	result, err := s.TermsOfServiceStore.GetLatest(allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TermsOfServiceStore.GetLatest", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTermsOfServiceStore) Save(termsOfService *model.TermsOfService) (*model.TermsOfService, error) {
	start := timemodule.Now()

	result, err := s.TermsOfServiceStore.Save(termsOfService)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TermsOfServiceStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) DeleteMembershipForUser(userId string, postID string) error {
	start := timemodule.Now()

	err := s.ThreadStore.DeleteMembershipForUser(userId, postID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.DeleteMembershipForUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerThreadStore) DeleteOrphanedRows(limit int) (int64, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.DeleteOrphanedRows(limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.DeleteOrphanedRows", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) Get(id string) (*model.Thread, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetMembershipForUser(userId string, postID string) (*model.ThreadMembership, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetMembershipForUser(userId, postID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetMembershipForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetMembershipsForUser(userId string, teamID string) ([]*model.ThreadMembership, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetMembershipsForUser(userId, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetMembershipsForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetPosts(threadID string, since int64) ([]*model.Post, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetPosts(threadID, since)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetPosts", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetTeamsUnreadForUser(userID string, teamIDs []string) (map[string]*model.TeamUnread, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetTeamsUnreadForUser(userID, teamIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetTeamsUnreadForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetThreadFollowers(threadID string, fetchOnlyActive bool) ([]string, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetThreadFollowers(threadID, fetchOnlyActive)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetThreadFollowers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetThreadForUser(teamID string, threadMembership *model.ThreadMembership, extended bool) (*model.ThreadResponse, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetThreadForUser(teamID, threadMembership, extended)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetThreadForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetThreadUnreadReplyCount(threadMembership *model.ThreadMembership) (int64, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetThreadUnreadReplyCount(threadMembership)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetThreadUnreadReplyCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetThreadsForUser(userId string, teamID string, opts model.GetUserThreadsOpts) ([]*model.ThreadResponse, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetThreadsForUser(userId, teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetThreadsForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetTotalThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetTotalThreads(userId, teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetTotalThreads", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetTotalUnreadMentions(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetTotalUnreadMentions(userId, teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetTotalUnreadMentions", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) GetTotalUnreadThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.GetTotalUnreadThreads(userId, teamID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.GetTotalUnreadThreads", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) MaintainMembership(userID string, postID string, opts store.ThreadMembershipOpts) (*model.ThreadMembership, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.MaintainMembership(userID, postID, opts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.MaintainMembership", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerThreadStore) MarkAllAsRead(userID string, threadIds []string) error {
	start := timemodule.Now()

	err := s.ThreadStore.MarkAllAsRead(userID, threadIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.MarkAllAsRead", success, elapsed)
	}
	return err
}

func (s *TimerLayerThreadStore) MarkAllAsReadByChannels(userID string, channelIDs []string) error {
	start := timemodule.Now()

	err := s.ThreadStore.MarkAllAsReadByChannels(userID, channelIDs)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.MarkAllAsReadByChannels", success, elapsed)
	}
	return err
}

func (s *TimerLayerThreadStore) MarkAllAsReadByTeam(userID string, teamID string) error {
	start := timemodule.Now()

	err := s.ThreadStore.MarkAllAsReadByTeam(userID, teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.MarkAllAsReadByTeam", success, elapsed)
	}
	return err
}

func (s *TimerLayerThreadStore) MarkAsRead(userID string, threadID string, timestamp int64) error {
	start := timemodule.Now()

	err := s.ThreadStore.MarkAsRead(userID, threadID, timestamp)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.MarkAsRead", success, elapsed)
	}
	return err
}

func (s *TimerLayerThreadStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.PermanentDeleteBatchForRetentionPolicies", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerThreadStore) PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {
	start := timemodule.Now()

	result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies", success, elapsed)
	}
	return result, resultVar1, err
}

func (s *TimerLayerThreadStore) UpdateMembership(membership *model.ThreadMembership) (*model.ThreadMembership, error) {
	start := timemodule.Now()

	result, err := s.ThreadStore.UpdateMembership(membership)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("ThreadStore.UpdateMembership", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTokenStore) Cleanup(expiryTime int64) {
	start := timemodule.Now()

	s.TokenStore.Cleanup(expiryTime)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.Cleanup", success, elapsed)
	}
}

func (s *TimerLayerTokenStore) Delete(token string) error {
	start := timemodule.Now()

	err := s.TokenStore.Delete(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerTokenStore) GetAllTokensByType(tokenType string) ([]*model.Token, error) {
	start := timemodule.Now()

	result, err := s.TokenStore.GetAllTokensByType(tokenType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.GetAllTokensByType", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTokenStore) GetByToken(token string) (*model.Token, error) {
	start := timemodule.Now()

	result, err := s.TokenStore.GetByToken(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.GetByToken", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerTokenStore) RemoveAllTokensByType(tokenType string) error {
	start := timemodule.Now()

	err := s.TokenStore.RemoveAllTokensByType(tokenType)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.RemoveAllTokensByType", success, elapsed)
	}
	return err
}

func (s *TimerLayerTokenStore) Save(recovery *model.Token) error {
	start := timemodule.Now()

	err := s.TokenStore.Save(recovery)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("TokenStore.Save", success, elapsed)
	}
	return err
}

func (s *TimerLayerUploadSessionStore) Delete(id string) error {
	start := timemodule.Now()

	err := s.UploadSessionStore.Delete(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UploadSessionStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerUploadSessionStore) Get(id string) (*model.UploadSession, error) {
	start := timemodule.Now()

	result, err := s.UploadSessionStore.Get(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UploadSessionStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUploadSessionStore) GetForUser(userID string) ([]*model.UploadSession, error) {
	start := timemodule.Now()

	result, err := s.UploadSessionStore.GetForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UploadSessionStore.GetForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUploadSessionStore) Save(session *model.UploadSession) (*model.UploadSession, error) {
	start := timemodule.Now()

	result, err := s.UploadSessionStore.Save(session)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UploadSessionStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUploadSessionStore) Update(session *model.UploadSession) error {
	start := timemodule.Now()

	err := s.UploadSessionStore.Update(session)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UploadSessionStore.Update", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) AnalyticsActiveCount(time int64, options model.UserCountOptions) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsActiveCount(time, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsActiveCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AnalyticsActiveCountForPeriod(startTime int64, endTime int64, options model.UserCountOptions) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsActiveCountForPeriod(startTime, endTime, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsActiveCountForPeriod", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AnalyticsGetExternalUsers(hostDomain string) (bool, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsGetExternalUsers(hostDomain)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsGetExternalUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AnalyticsGetGuestCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsGetGuestCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsGetGuestCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AnalyticsGetInactiveUsersCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsGetInactiveUsersCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsGetInactiveUsersCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AnalyticsGetSystemAdminCount() (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AnalyticsGetSystemAdminCount()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AnalyticsGetSystemAdminCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) AutocompleteUsersInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, error) {
	start := timemodule.Now()

	result, err := s.UserStore.AutocompleteUsersInChannel(teamID, channelID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.AutocompleteUsersInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) ClearAllCustomRoleAssignments() error {
	start := timemodule.Now()

	err := s.UserStore.ClearAllCustomRoleAssignments()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.ClearAllCustomRoleAssignments", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) ClearCaches() {
	start := timemodule.Now()

	s.UserStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerUserStore) Count(options model.UserCountOptions) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.Count(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.Count", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) DeactivateGuests() ([]string, error) {
	start := timemodule.Now()

	result, err := s.UserStore.DeactivateGuests()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.DeactivateGuests", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) DemoteUserToGuest(userID string) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.DemoteUserToGuest(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.DemoteUserToGuest", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) Get(ctx context.Context, id string) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.Get(ctx, id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAll() ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAll()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAllAfter(limit int, afterID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAllAfter(limit, afterID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAllAfter", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAllNotInAuthService(authServices []string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAllNotInAuthService(authServices)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAllNotInAuthService", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAllProfiles(options *model.UserGetOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAllProfiles(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAllProfiles", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAllProfilesInChannel(ctx context.Context, channelID string, allowFromCache bool) (map[string]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAllProfilesInChannel(ctx, channelID, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAllProfilesInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAllUsingAuthService(authService string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAllUsingAuthService(authService)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAllUsingAuthService", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetAnyUnreadPostCountForChannel(userID string, channelID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetAnyUnreadPostCountForChannel(userID, channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetAnyUnreadPostCountForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetByAuth(authData *string, authService string) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetByAuth(authData, authService)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetByAuth", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetByEmail(email string) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetByEmail(email)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetByEmail", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetByUsername(username string) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetByUsername(username)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetByUsername", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetChannelGroupUsers(channelID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetChannelGroupUsers(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetChannelGroupUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetEtagForAllProfiles() string {
	start := timemodule.Now()

	result := s.UserStore.GetEtagForAllProfiles()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetEtagForAllProfiles", success, elapsed)
	}
	return result
}

func (s *TimerLayerUserStore) GetEtagForProfiles(teamID string) string {
	start := timemodule.Now()

	result := s.UserStore.GetEtagForProfiles(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetEtagForProfiles", success, elapsed)
	}
	return result
}

func (s *TimerLayerUserStore) GetEtagForProfilesNotInTeam(teamID string) string {
	start := timemodule.Now()

	result := s.UserStore.GetEtagForProfilesNotInTeam(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetEtagForProfilesNotInTeam", success, elapsed)
	}
	return result
}

func (s *TimerLayerUserStore) GetForLogin(loginID string, allowSignInWithUsername bool, allowSignInWithEmail bool) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetForLogin(loginID, allowSignInWithUsername, allowSignInWithEmail)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetForLogin", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetKnownUsers(userID string) ([]string, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetKnownUsers(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetKnownUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetMany(ctx context.Context, ids []string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetMany(ctx, ids)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetMany", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetNewUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetNewUsersForTeam(teamID, offset, limit, viewRestrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetNewUsersForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfileByGroupChannelIdsForUser(userID string, channelIds []string) (map[string][]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfileByGroupChannelIdsForUser(userID, channelIds)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfileByGroupChannelIdsForUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfileByIds(ctx context.Context, userIds []string, options *store.UserGetByIdsOpts, allowFromCache bool) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfileByIds(ctx, userIds, options, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfileByIds", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfiles(options *model.UserGetOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfiles(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfiles", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesByUsernames(usernames []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesByUsernames(usernames, viewRestrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesByUsernames", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesInChannel(options *model.UserGetOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesInChannel(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesInChannelByStatus(options *model.UserGetOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesInChannelByStatus(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesInChannelByStatus", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesNotInChannel(teamID string, channelId string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesNotInChannel(teamID, channelId, groupConstrained, offset, limit, viewRestrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesNotInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesNotInTeam(teamID, groupConstrained, offset, limit, viewRestrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesNotInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetProfilesWithoutTeam(options *model.UserGetOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetProfilesWithoutTeam(options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetProfilesWithoutTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetRecentlyActiveUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetRecentlyActiveUsersForTeam(teamID, offset, limit, viewRestrictions)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetRecentlyActiveUsersForTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetSystemAdminProfiles() (map[string]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetSystemAdminProfiles()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetSystemAdminProfiles", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetTeamGroupUsers(teamID string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetTeamGroupUsers(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetTeamGroupUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetUnreadCount(userID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetUnreadCount(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetUnreadCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetUnreadCountForChannel(userID string, channelID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetUnreadCountForChannel(userID, channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetUnreadCountForChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetUsersBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.UserForIndexing, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetUsersBatchForIndexing(startTime, startFileID, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetUsersBatchForIndexing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) GetUsersWithInvalidEmails(page int, perPage int, restrictedDomains string) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.GetUsersWithInvalidEmails(page, perPage, restrictedDomains)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.GetUsersWithInvalidEmails", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) InferSystemInstallDate() (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.InferSystemInstallDate()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.InferSystemInstallDate", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) InsertUsers(users []*model.User) error {
	start := timemodule.Now()

	err := s.UserStore.InsertUsers(users)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.InsertUsers", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) InvalidateProfileCacheForUser(userID string) {
	start := timemodule.Now()

	s.UserStore.InvalidateProfileCacheForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.InvalidateProfileCacheForUser", success, elapsed)
	}
}

func (s *TimerLayerUserStore) InvalidateProfilesInChannelCache(channelID string) {
	start := timemodule.Now()

	s.UserStore.InvalidateProfilesInChannelCache(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.InvalidateProfilesInChannelCache", success, elapsed)
	}
}

func (s *TimerLayerUserStore) InvalidateProfilesInChannelCacheByUser(userID string) {
	start := timemodule.Now()

	s.UserStore.InvalidateProfilesInChannelCacheByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.InvalidateProfilesInChannelCacheByUser", success, elapsed)
	}
}

func (s *TimerLayerUserStore) IsEmpty(excludeBots bool) (bool, error) {
	start := timemodule.Now()

	result, err := s.UserStore.IsEmpty(excludeBots)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.IsEmpty", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) PermanentDelete(userID string) error {
	start := timemodule.Now()

	err := s.UserStore.PermanentDelete(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.PermanentDelete", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) PromoteGuestToUser(userID string) error {
	start := timemodule.Now()

	err := s.UserStore.PromoteGuestToUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.PromoteGuestToUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) ResetAuthDataToEmailForUsers(service string, userIDs []string, includeDeleted bool, dryRun bool) (int, error) {
	start := timemodule.Now()

	result, err := s.UserStore.ResetAuthDataToEmailForUsers(service, userIDs, includeDeleted, dryRun)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.ResetAuthDataToEmailForUsers", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) ResetLastPictureUpdate(userID string) error {
	start := timemodule.Now()

	err := s.UserStore.ResetLastPictureUpdate(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.ResetLastPictureUpdate", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) Save(user *model.User) (*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.Save(user)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) Search(teamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.Search(teamID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.Search", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchInChannel(channelID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchInGroup(groupID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchInGroup", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchNotInChannel(teamID, channelID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchNotInChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchNotInGroup(groupID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchNotInGroup", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchNotInTeam(notInTeamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchNotInTeam(notInTeamID, term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchNotInTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) SearchWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, error) {
	start := timemodule.Now()

	result, err := s.UserStore.SearchWithoutTeam(term, options)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.SearchWithoutTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) Update(user *model.User, allowRoleUpdate bool) (*model.UserUpdate, error) {
	start := timemodule.Now()

	result, err := s.UserStore.Update(user, allowRoleUpdate)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.Update", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) UpdateAuthData(userID string, service string, authData *string, email string, resetMfa bool) (string, error) {
	start := timemodule.Now()

	result, err := s.UserStore.UpdateAuthData(userID, service, authData, email, resetMfa)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateAuthData", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) UpdateFailedPasswordAttempts(userID string, attempts int) error {
	start := timemodule.Now()

	err := s.UserStore.UpdateFailedPasswordAttempts(userID, attempts)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateFailedPasswordAttempts", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdateLastPictureUpdate(userID string) error {
	start := timemodule.Now()

	err := s.UserStore.UpdateLastPictureUpdate(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateLastPictureUpdate", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdateMfaActive(userID string, active bool) error {
	start := timemodule.Now()

	err := s.UserStore.UpdateMfaActive(userID, active)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateMfaActive", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdateMfaSecret(userID string, secret string) error {
	start := timemodule.Now()

	err := s.UserStore.UpdateMfaSecret(userID, secret)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateMfaSecret", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdateNotifyProps(userID string, props map[string]string) error {
	start := timemodule.Now()

	err := s.UserStore.UpdateNotifyProps(userID, props)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateNotifyProps", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdatePassword(userID string, newPassword string) error {
	start := timemodule.Now()

	err := s.UserStore.UpdatePassword(userID, newPassword)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdatePassword", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserStore) UpdateUpdateAt(userID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.UserStore.UpdateUpdateAt(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.UpdateUpdateAt", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserStore) VerifyEmail(userID string, email string) (string, error) {
	start := timemodule.Now()

	result, err := s.UserStore.VerifyEmail(userID, email)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserStore.VerifyEmail", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) Delete(tokenID string) error {
	start := timemodule.Now()

	err := s.UserAccessTokenStore.Delete(tokenID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserAccessTokenStore) DeleteAllForUser(userID string) error {
	start := timemodule.Now()

	err := s.UserAccessTokenStore.DeleteAllForUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.DeleteAllForUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserAccessTokenStore) Get(tokenID string) (*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.Get(tokenID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.Get", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) GetAll(offset int, limit int) ([]*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.GetAll(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.GetAll", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) GetByToken(tokenString string) (*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.GetByToken(tokenString)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.GetByToken", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) GetByUser(userID string, page int, perPage int) ([]*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.GetByUser(userID, page, perPage)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.GetByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) Save(token *model.UserAccessToken) (*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.Save(token)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) Search(term string) ([]*model.UserAccessToken, error) {
	start := timemodule.Now()

	result, err := s.UserAccessTokenStore.Search(term)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.Search", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserAccessTokenStore) UpdateTokenDisable(tokenID string) error {
	start := timemodule.Now()

	err := s.UserAccessTokenStore.UpdateTokenDisable(tokenID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.UpdateTokenDisable", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserAccessTokenStore) UpdateTokenEnable(tokenID string) error {
	start := timemodule.Now()

	err := s.UserAccessTokenStore.UpdateTokenEnable(tokenID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserAccessTokenStore.UpdateTokenEnable", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserTermsOfServiceStore) Delete(userID string, termsOfServiceId string) error {
	start := timemodule.Now()

	err := s.UserTermsOfServiceStore.Delete(userID, termsOfServiceId)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserTermsOfServiceStore.Delete", success, elapsed)
	}
	return err
}

func (s *TimerLayerUserTermsOfServiceStore) GetByUser(userID string) (*model.UserTermsOfService, error) {
	start := timemodule.Now()

	result, err := s.UserTermsOfServiceStore.GetByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserTermsOfServiceStore.GetByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerUserTermsOfServiceStore) Save(userTermsOfService *model.UserTermsOfService) (*model.UserTermsOfService, error) {
	start := timemodule.Now()

	result, err := s.UserTermsOfServiceStore.Save(userTermsOfService)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("UserTermsOfServiceStore.Save", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) AnalyticsIncomingCount(teamID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.AnalyticsIncomingCount(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.AnalyticsIncomingCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) AnalyticsOutgoingCount(teamID string) (int64, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.AnalyticsOutgoingCount(teamID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.AnalyticsOutgoingCount", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) ClearCaches() {
	start := timemodule.Now()

	s.WebhookStore.ClearCaches()

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.ClearCaches", success, elapsed)
	}
}

func (s *TimerLayerWebhookStore) DeleteIncoming(webhookID string, time int64) error {
	start := timemodule.Now()

	err := s.WebhookStore.DeleteIncoming(webhookID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.DeleteIncoming", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) DeleteOutgoing(webhookID string, time int64) error {
	start := timemodule.Now()

	err := s.WebhookStore.DeleteOutgoing(webhookID, time)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.DeleteOutgoing", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) GetIncoming(id string, allowFromCache bool) (*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncoming(id, allowFromCache)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncoming", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetIncomingByChannel(channelID string) ([]*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncomingByChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncomingByChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetIncomingByTeam(teamID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncomingByTeam(teamID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncomingByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetIncomingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncomingByTeamByUser(teamID, userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncomingByTeamByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetIncomingList(offset int, limit int) ([]*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncomingList(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncomingList", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetIncomingListByUser(userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetIncomingListByUser(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetIncomingListByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoing(id string) (*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoing(id)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingByChannel(channelID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingByChannel(channelID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingByChannel", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingByChannelByUser(channelID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingByChannelByUser(channelID, userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingByChannelByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingByTeam(teamID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingByTeam(teamID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingByTeam", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingByTeamByUser(teamID, userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingByTeamByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingList(offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingList(offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingList", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) GetOutgoingListByUser(userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.GetOutgoingListByUser(userID, offset, limit)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.GetOutgoingListByUser", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) InvalidateWebhookCache(webhook string) {
	start := timemodule.Now()

	s.WebhookStore.InvalidateWebhookCache(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if true {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.InvalidateWebhookCache", success, elapsed)
	}
}

func (s *TimerLayerWebhookStore) PermanentDeleteIncomingByChannel(channelID string) error {
	start := timemodule.Now()

	err := s.WebhookStore.PermanentDeleteIncomingByChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.PermanentDeleteIncomingByChannel", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) PermanentDeleteIncomingByUser(userID string) error {
	start := timemodule.Now()

	err := s.WebhookStore.PermanentDeleteIncomingByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.PermanentDeleteIncomingByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) PermanentDeleteOutgoingByChannel(channelID string) error {
	start := timemodule.Now()

	err := s.WebhookStore.PermanentDeleteOutgoingByChannel(channelID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.PermanentDeleteOutgoingByChannel", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) PermanentDeleteOutgoingByUser(userID string) error {
	start := timemodule.Now()

	err := s.WebhookStore.PermanentDeleteOutgoingByUser(userID)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.PermanentDeleteOutgoingByUser", success, elapsed)
	}
	return err
}

func (s *TimerLayerWebhookStore) SaveIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.SaveIncoming(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.SaveIncoming", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) SaveOutgoing(webhook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.SaveOutgoing(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.SaveOutgoing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) UpdateIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.UpdateIncoming(webhook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.UpdateIncoming", success, elapsed)
	}
	return result, err
}

func (s *TimerLayerWebhookStore) UpdateOutgoing(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {
	start := timemodule.Now()

	result, err := s.WebhookStore.UpdateOutgoing(hook)

	elapsed := float64(timemodule.Since(start)) / float64(timemodule.Second)
	if s.Root.Metrics != nil {
		success := "false"
		if err == nil {
			success = "true"
		}
		s.Root.Metrics.ObserveStoreMethodDuration("WebhookStore.UpdateOutgoing", success, elapsed)
	}
	return result, err
}

func (s *TimerLayer) Close() {
	s.Store.Close()
}

func (s *TimerLayer) DropAllTables() {
	s.Store.DropAllTables()
}

func (s *TimerLayer) LockToMaster() {
	s.Store.LockToMaster()
}

func (s *TimerLayer) MarkSystemRanUnitTests() {
	s.Store.MarkSystemRanUnitTests()
}

func (s *TimerLayer) SetContext(context context.Context) {
	s.Store.SetContext(context)
}

func (s *TimerLayer) TotalMasterDbConnections() int {
	return s.Store.TotalMasterDbConnections()
}

func (s *TimerLayer) TotalReadDbConnections() int {
	return s.Store.TotalReadDbConnections()
}

func (s *TimerLayer) TotalSearchDbConnections() int {
	return s.Store.TotalSearchDbConnections()
}

func (s *TimerLayer) UnlockFromMaster() {
	s.Store.UnlockFromMaster()
}

func New(childStore store.Store, metrics einterfaces.MetricsInterface) *TimerLayer {
	newStore := TimerLayer{
		Store:   childStore,
		Metrics: metrics,
	}

	newStore.AuditStore = &TimerLayerAuditStore{AuditStore: childStore.Audit(), Root: &newStore}
	newStore.BotStore = &TimerLayerBotStore{BotStore: childStore.Bot(), Root: &newStore}
	newStore.ChannelStore = &TimerLayerChannelStore{ChannelStore: childStore.Channel(), Root: &newStore}
	newStore.ChannelMemberHistoryStore = &TimerLayerChannelMemberHistoryStore{ChannelMemberHistoryStore: childStore.ChannelMemberHistory(), Root: &newStore}
	newStore.ClusterDiscoveryStore = &TimerLayerClusterDiscoveryStore{ClusterDiscoveryStore: childStore.ClusterDiscovery(), Root: &newStore}
	newStore.CommandStore = &TimerLayerCommandStore{CommandStore: childStore.Command(), Root: &newStore}
	newStore.CommandWebhookStore = &TimerLayerCommandWebhookStore{CommandWebhookStore: childStore.CommandWebhook(), Root: &newStore}
	newStore.ComplianceStore = &TimerLayerComplianceStore{ComplianceStore: childStore.Compliance(), Root: &newStore}
	newStore.EmojiStore = &TimerLayerEmojiStore{EmojiStore: childStore.Emoji(), Root: &newStore}
	newStore.FileInfoStore = &TimerLayerFileInfoStore{FileInfoStore: childStore.FileInfo(), Root: &newStore}
	newStore.GroupStore = &TimerLayerGroupStore{GroupStore: childStore.Group(), Root: &newStore}
	newStore.JobStore = &TimerLayerJobStore{JobStore: childStore.Job(), Root: &newStore}
	newStore.LicenseStore = &TimerLayerLicenseStore{LicenseStore: childStore.License(), Root: &newStore}
	newStore.LinkMetadataStore = &TimerLayerLinkMetadataStore{LinkMetadataStore: childStore.LinkMetadata(), Root: &newStore}
	newStore.OAuthStore = &TimerLayerOAuthStore{OAuthStore: childStore.OAuth(), Root: &newStore}
	newStore.PluginStore = &TimerLayerPluginStore{PluginStore: childStore.Plugin(), Root: &newStore}
	newStore.PostStore = &TimerLayerPostStore{PostStore: childStore.Post(), Root: &newStore}
	newStore.PreferenceStore = &TimerLayerPreferenceStore{PreferenceStore: childStore.Preference(), Root: &newStore}
	newStore.ProductNoticesStore = &TimerLayerProductNoticesStore{ProductNoticesStore: childStore.ProductNotices(), Root: &newStore}
	newStore.ReactionStore = &TimerLayerReactionStore{ReactionStore: childStore.Reaction(), Root: &newStore}
	newStore.RemoteClusterStore = &TimerLayerRemoteClusterStore{RemoteClusterStore: childStore.RemoteCluster(), Root: &newStore}
	newStore.RetentionPolicyStore = &TimerLayerRetentionPolicyStore{RetentionPolicyStore: childStore.RetentionPolicy(), Root: &newStore}
	newStore.RoleStore = &TimerLayerRoleStore{RoleStore: childStore.Role(), Root: &newStore}
	newStore.SchemeStore = &TimerLayerSchemeStore{SchemeStore: childStore.Scheme(), Root: &newStore}
	newStore.SessionStore = &TimerLayerSessionStore{SessionStore: childStore.Session(), Root: &newStore}
	newStore.SharedChannelStore = &TimerLayerSharedChannelStore{SharedChannelStore: childStore.SharedChannel(), Root: &newStore}
	newStore.StatusStore = &TimerLayerStatusStore{StatusStore: childStore.Status(), Root: &newStore}
	newStore.SystemStore = &TimerLayerSystemStore{SystemStore: childStore.System(), Root: &newStore}
	newStore.TeamStore = &TimerLayerTeamStore{TeamStore: childStore.Team(), Root: &newStore}
	newStore.TermsOfServiceStore = &TimerLayerTermsOfServiceStore{TermsOfServiceStore: childStore.TermsOfService(), Root: &newStore}
	newStore.ThreadStore = &TimerLayerThreadStore{ThreadStore: childStore.Thread(), Root: &newStore}
	newStore.TokenStore = &TimerLayerTokenStore{TokenStore: childStore.Token(), Root: &newStore}
	newStore.UploadSessionStore = &TimerLayerUploadSessionStore{UploadSessionStore: childStore.UploadSession(), Root: &newStore}
	newStore.UserStore = &TimerLayerUserStore{UserStore: childStore.User(), Root: &newStore}
	newStore.UserAccessTokenStore = &TimerLayerUserAccessTokenStore{UserAccessTokenStore: childStore.UserAccessToken(), Root: &newStore}
	newStore.UserTermsOfServiceStore = &TimerLayerUserTermsOfServiceStore{UserTermsOfServiceStore: childStore.UserTermsOfService(), Root: &newStore}
	newStore.WebhookStore = &TimerLayerWebhookStore{WebhookStore: childStore.Webhook(), Root: &newStore}
	return &newStore
}
