---
layout: default
title: Built-in Commands - Reference Manual - csvq
category: reference
---

# Built-in Commands

| name | description |
| :- | :- |
| [ECHO](#echo)       | Print a value |
| [PRINT](#print)     | Print a value formatted according to the type  |
| [PRINTF](#printf)   | Print a formatted value |
| [SOURCE](#source)   | Load and execute an external file |
| [EXECUTE](#execute) | Execute a string as statements |
| [SHOW](#show)       | Show objects |
| [SHOW FIELDS](#show_fields) | Show fields in a table or a view |
| [CHDIR](#chdir)     | Change current working directory |
| [PWD](#pwd)         | Print current working directory |
| [RELOAD CONFIG](#reload-config) | Reload configuration json files |
| [SYNTAX](#syntax)   | Print syntax |

## Command Syntax

### ECHO
{: #echo}

Print a value. This command returns the same result as "PRINTF '%s' USING value".

```sql
ECHO value;
```

_value_
: [value]({{ '/reference/value.html' | relative_url }})


### PRINT
{: #print}

Print a value formatted according to the type.

```sql
PRINT value;
```

_value_
: [value]({{ '/reference/value.html' | relative_url }})


### PRINTF
{: #printf}

Print a formatted value.

```sql
PRINTF format [, replace_value ...];
PRINTF format USING replace_value [, replace_value ...];
```

_format_
: [string]({{ '/reference/value.html#string' | relative_url }})

_replace_value_
: [value]({{ '/reference/value.html' | relative_url }})

The format is the same as the [FORMAT function]({{ '/reference/string-functions.html#format' | relative_url }})


### SOURCE
{: #source}

Load and execute an external file as a part of the procedure.

```sql
SOURCE file_path;
```

_file_path_
: [string]({{ '/reference/value.html#string' | relative_url }}) or [identifier]({{ '/reference/statement.html#parsing' | relative_url }})


### EXECUTE
{: #execute}

Execute a string as statements.

```sql
EXECUTE statements;
EXECUTE statements USING replace_value [, replace_value...];
```

_statements_
: [string]({{ '/reference/value.html#string' | relative_url }})

_replace_value_
: [string]({{ '/reference/value.html#string' | relative_url }})

If _replace_values_ are specified, then placeholders in _statements_ are replaced with _replace_values_.
The format is the same as the [FORMAT function]({{ '/reference/string-functions.html#format' | relative_url }})


### SHOW
{: #show}

Show objects.

```sql
SHOW {TABLES|VIEWS|CURSORS|FUNCTIONS|STATEMENTS|FLAGS|ENV|RUNINFO};
```

TABLES
: Loaded Tables

VIEWS
: Created [Temporary Tables]({{ '/reference/temporary-table.html' | relative_url }})

CURSORS
: Declared [Cursors]({{ '/reference/cursor.html' | relative_url }})

FUNCTIONS
: Declared [User Defined Functions]({{ '/reference/user-defined-function.html' | relative_url }})

STATEMENTS
: [Prepared Statements]({{ '/reference/prepared-statement.html' | relative_url }})

FLAGS
: List of [Flags]({{ '/reference/flag.html' | relative_url }})

ENV
: List of [Environment Variables]({{ '/reference/environment-variable.html' | relative_url }})

RUNINFO
: List of [Runtime Information]({{ '/reference/runtime-information.html' | relative_url }})

### SHOW FIELDS
{: #show_fields}

Show fields in a table or a view.

```sql
SHOW FIELDS FROM table_name;
```

_table_name_
: [identifier]({{ '/reference/statement.html#parsing' | relative_url }}) or [Table Object]({{ '/reference/select-query.html#from_clause' | relative_url }})
  
  table name or view name.



### CHDIR
{: #chdir}

Change current working directory.

```sql
CHDIR directory_path;
```

_directory_path_
: [string]({{ '/reference/value.html#string' | relative_url }}) or [identifier]({{ '/reference/statement.html#parsing' | relative_url }})



### PWD
{: #pwd}

Print current working directory.

```sql
PWD;
```


### RELOAD CONFIG
{: #reload-config}

Reload [configuration json files]({{ '/reference/command.html#configurations' | relative_url }}).

```sql
RELOAD CONFIG;
```


### SYNTAX
{: #syntax}

Print syntax.

```sql
SYNTAX [search_word [, search_word ...]];
```

_search_word_
: [string]({{ '/reference/value.html#string' | relative_url }}) or [identifier]({{ '/reference/statement.html#parsing' | relative_url }})
