// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Kubernetes Engine API
//
// API for the Kubernetes Engine service (also known as the Container Engine for Kubernetes service). Use this API to build, deploy,
// and manage cloud-native applications. For more information, see
// Overview of Kubernetes Engine (https://docs.oracle.com/iaas/Content/ContEng/Concepts/contengoverview.htm).
//

package containerengine

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// NodePoolPlacementConfigDetails The location where a node pool will place nodes.
type NodePoolPlacementConfigDetails struct {

	// The availability domain in which to place nodes.
	// Example: `Uocm:PHX-AD-1`
	AvailabilityDomain *string `mandatory:"true" json:"availabilityDomain"`

	// The OCID of the subnet in which to place nodes.
	SubnetId *string `mandatory:"true" json:"subnetId"`

	// The OCID of the compute capacity reservation in which to place the compute instance.
	CapacityReservationId *string `mandatory:"false" json:"capacityReservationId"`

	PreemptibleNodeConfig *PreemptibleNodeConfigDetails `mandatory:"false" json:"preemptibleNodeConfig"`

	// A list of fault domains in which to place nodes.
	FaultDomains []string `mandatory:"false" json:"faultDomains"`
}

func (m NodePoolPlacementConfigDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m NodePoolPlacementConfigDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
