// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Media Services API
//
// Media Services (includes Media Flow and Media Streams) is a fully managed service for processing media (video) source content. Use Media Flow and Media Streams to transcode and package digital video using configurable workflows and stream video outputs.
// Use the Media Services API to configure media workflows and run Media Flow jobs, create distribution channels, ingest assets, create Preview URLs and play assets. For more information, see Media Flow (https://docs.cloud.oracle.com/iaas/Content/dms-mediaflow/home.htm) and Media Streams (https://docs.cloud.oracle.com/iaas/Content/dms-mediastream/home.htm).
//

package mediaservices

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateStreamCdnConfigDetails The information about the new CDN Configuration.
type CreateStreamCdnConfigDetails struct {

	// CDN Config display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// Distribution Channel Identifier.
	DistributionChannelId *string `mandatory:"true" json:"distributionChannelId"`

	Config StreamCdnConfigSection `mandatory:"true" json:"config"`

	// Whether publishing to CDN is enabled.
	IsEnabled *bool `mandatory:"false" json:"isEnabled"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Locks associated with this resource.
	Locks []ResourceLock `mandatory:"false" json:"locks"`
}

func (m CreateStreamCdnConfigDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateStreamCdnConfigDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *CreateStreamCdnConfigDetails) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		IsEnabled             *bool                             `json:"isEnabled"`
		FreeformTags          map[string]string                 `json:"freeformTags"`
		DefinedTags           map[string]map[string]interface{} `json:"definedTags"`
		Locks                 []ResourceLock                    `json:"locks"`
		DisplayName           *string                           `json:"displayName"`
		DistributionChannelId *string                           `json:"distributionChannelId"`
		Config                streamcdnconfigsection            `json:"config"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.IsEnabled = model.IsEnabled

	m.FreeformTags = model.FreeformTags

	m.DefinedTags = model.DefinedTags

	m.Locks = make([]ResourceLock, len(model.Locks))
	copy(m.Locks, model.Locks)
	m.DisplayName = model.DisplayName

	m.DistributionChannelId = model.DistributionChannelId

	nn, e = model.Config.UnmarshalPolymorphicJSON(model.Config.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.Config = nn.(StreamCdnConfigSection)
	} else {
		m.Config = nil
	}

	return
}
