package sprite

const Font_JR_A = `
XXXX
 X  X
 X   X
 XXXXX
 X   X
 X   X
XX   XX`

const Font_JR_B = `
XXXX
 X  X
 X  X
 XXXXX
 X    X
 X    X
XXXXXX`

const Font_JR_C = `
  XXX X
 X   XX
X
X
X
 X    X
  XXXX`

const Font_JR_D = `
XXXXX
 X   X
 X    X
 X    X
 X    X
 X    X
XXXXXX`

const Font_JR_E = `
XXXXXXX
 X    X
 X
 XXX
 X
 X    X
XXXXXXX`

const Font_JR_F = `
XXXXXXX
 X    X
 X
 XXX
 X
 X
XXX`

const Font_JR_G = `
  XXX X
 X   XX
X
X
X   XXX
 X    X
  XXXXX`

const Font_JR_H = `
XXX XXX
 X   X
 X   X
 XXXXX
 X   X
 X   X
XXX XXX`

const Font_JR_I = `
 XXXX
  X
  X
  X
  X
  X
 XXXX`

const Font_JR_J = `
 XXXXXXX
  X   X
      X
      X
 XX   X
  X   X
   XXX`

const Font_JR_K = `
XXX  XX
 X  X
 X X
 XXXX
 X   X
 X   X
XXX  XX`

const Font_JR_L = `
XXX
 X
 X
 X
 X
 X    X
XXXXXXX`

const Font_JR_M = `
XX   XX
 XX XX
 X X X
 X   X
 X   X
 X   X
XXX XXX`

const Font_JR_N = `
XX  XXX
 XX  X
 XX  X
 X X X
 X  XX
 X  XX
XXX  XX`

const Font_JR_O = `
  XXX
 X   X
X     X
X     X
X     X
 X   X
  XXX`

const Font_JR_P = `
XXXXX
 X   X
 X   X
 XXXX
 X
 X
XXX`

const Font_JR_Q = `
  XXX
 X   X
X     X
X     X
X   X X
 X   X
  XXX X`

const Font_JR_R = `
XXXXX
 X   X
 X   X
 XXXX
 X   X
 X   X
XXX XXX`

const Font_JR_S = `
 XXXX X
X    XX
X
 XXXXX
      X
XX    X
X XXXX`

const Font_JR_T = `
XXXXXXX
X  X  X
   X
   X
   X
   X
  XXX`

const Font_JR_U = `
XXX XXX
 X   X
 X   X
 X   X
 X   X
 X   X
  XXX`

const Font_JR_V = `
XXX XXX
 X   X
 X   X
 X  X
 X X
 XX
XX`

const Font_JR_W = `
XX   XX
 X   X
 X   X
 X   X
 X X X
 XX XX
XX   XX`

const Font_JR_X = `
XX   XX
 X   X
  X X
   X
  X X
 X   X
XX   XX`

const Font_JR_Y = `
XXX XXX
 X   X
 X   X
  XXX
   X
   X
  XXX`

const Font_JR_Z = `
XXXXXXX
X     X
     X
  XXX
 X
X     X
XXXXXXX`

const Font_JR_a = `


 XXXX
     X
 XXXXX
X    X
 XXXX X`

const Font_JR_b = `
XX
 X
 XXXXX
 X    X
 X    X
 X    X
XXXXXX`

const Font_JR_c = `


 XXXXX
X     X
X
X
 XXXXX`

const Font_JR_d = `
     XX
     X
 XXXXX
X    X
X    X
X    X
 XXXXXX`

const Font_JR_e = `


 XXXXX
X     X
XXXXXXX
X
 XXXXX`

const Font_JR_f = `
   XXX
  X  X
 XXX
  X
  X
  X
 XXX`

const Font_JR_g = `


 XXXXXX
X     X
X     X
 XXXXXX
      X
XXXXXX`

const Font_JR_h = `
XX
 X
 XXXX
 X   X
 X   X
 X   X
XX   XX`

const Font_JR_i = `
  X

 XXX
  X
  X
  X
 XXXX`

const Font_JR_j = `
   X

  XXXX
  X  X
     X
     X
     X
  XXX`

const Font_JR_k = `
XX
 X   X
 X  X
 XXX
 X  X
 X   X
XX   XX`

const Font_JR_l = `
  XX
   X
   X
   X
   X
   X
    XX`

const Font_JR_m = `


XXX X
 X X X
 X X X
 X X X
XX   XX`

const Font_JR_n = `


XXXXX
 X   X
 X   X
 X   X
XX   XX`

const Font_JR_o = `


 XXXX
X    X
X     X
X     X
 XXXXX`

const Font_JR_p = `


XXXXXX
 X    X
 X    X
 XXXXX
 X
XX`

const Font_JR_q = `


 XXXXXX
X    X
X    X
 XXXXX
     X
     XX`

const Font_JR_r = `


XX XXX
 XX   X
 X
 X
XXX`

const Font_JR_s = `


 XXXXX
X
 XXXXX
      X
 XXXXX`

const Font_JR_t = `

   X
  XXXX
   X
   X
   X
    XX`

const Font_JR_u = `


XX   XX
 X   X
 X   X
 X   X
  XXX`

const Font_JR_v = `


XX   XX
 X   X
 X  X
 X X
 XX`

const Font_JR_w = `


XX   XX
 X X X
 X X X
 X X X
 XX X`

const Font_JR_x = `


XX   XX
  X X
   X
  X X
XX   XX`

const Font_JR_y = `


XX   XX
 X   X
 X   X
  XXXX
     X
 XXXX`

const Font_JR_z = `


XXXXXXX
X    XX
  XXX
XX    X
XXXXXXX`

const Font_JR_0 = `
  XXX
 X   X
X   X X
X  X  X
X X   X
 X   X
  XXX`

const Font_JR_1 = `
   X
  XX
 X X
   X
   X
   X
 XXXXX`

const Font_JR_2 = `
 XXXXX
X     X
      X
     X
  XXX
XX
XXXXXXX`

const Font_JR_3 = `
XXXXXXX
X    X
    X
    XX
      X
X     X
 XXXXX`

const Font_JR_4 = `
   XX
  X X
 X  X
X   X
XXXXXXX
    X
    X`

const Font_JR_5 = `
XXXXXXX
X     X
X
XXXXXX
      X
X     X
 XXXXX`

const Font_JR_6 = `
 XXXXX
X     X
X
XXXXXX
X     X
X     X
 XXXXX`

const Font_JR_7 = `
XXXXXXX
X     X
     X
    X
   X
   X
   X`

const Font_JR_8 = `
 XXXXX
X     X
X     X
 XXXXX
X     X
X     X
 XXXXX`

const Font_JR_9 = `
 XXXXX
X     X
X     X
 XXXXXX
      X
X     X
 XXXXX`

const Font_JR_period = `





  XX
  XX`

const Font_JR_comma = `





  XX
  XX
   X`

const Font_JR_semicolon = `

  XX
  XX

  XX
  XX
   X`

const Font_JR_colon = `

  XX
  XX

  XX
  XX`

const Font_JR_minus = `


 XXXXX`

const Font_JR_plus = `

   X
   X
 XXXXX
   X
   X`

const Font_JR_times = `

   X
 X X X
  XXX
  XXX
 X X X
   X`

const Font_JR_slash = `

     X
    X
    X
   X
   X
  X`

const Font_JR_percent = `

 XX  X
 XX X
    X
   X
   X XX
  X  XX`

const Font_JR_lt = `

    X
   X
  X
   X
    X`

const Font_JR_gt = `

  X
   X
    X
   X
  X`

const Font_JR_exclamation = `
   XX
   XX
   X
   X

  XX
  XX`

const Font_JR_question = `
  XXXX
 X   XX
     XX
   XXX
   XX

   XX`

const Font_JR_down = `



 X   X
  X X
   X`

const Font_JR_up = `

   X
  X X
 X   X`

const Font_JR_l_bracket = `
  XXX
  X
  X
  X
  X
  X
  XXX`

const Font_JR_r_bracket = `
  XXX
    X
    X
    X
    X
    X
  XXX`

const Font_JR_l_paren = `
    X
   X
  X
  X
  X
   X
    X`

const Font_JR_r_paren = `
  X
   X
    X
    X
    X
   X
  X`

const Font_JR_l_brace = `
    XX
   X
   X
  X
   X
   X
    XX`

const Font_JR_r_brace = `
  XX
    X
    X
     X
    X
    X
  XX`

const Font_JR_sharp = `

  X  X
 XXXXXX
  X  X
 XXXXXX
  X  X`

const Font_JR_amp = `
  XX
 X  X
 X  X
 XXX
X   X X
X    X
 XXXX X`

const Font_JR_equals = `


 XXXXX

 XXXXX`

const Font_JR_double_quot = `
 XX XX
 XX XX
  X  X`

const Font_JR_quot = `
   XX
   XX
    X`

const Font_JR_at = `
  XXX
 X   X
X XXX X
X X X X
X  XXX
 X
  XXXX`

const Font_JR_pipe = `
   X
   X
   X
   X
   X
   X
   X
   X`

const Font_JR_b_slash = `

  X
   X
   X
    X
    X
     X`

const Font_JR_eszett = `
  XX
 X  X
 X X
 X  XX
 X    X
 X X  X
 X  XX
X`

const Font_JR_star = `

 X   X
  XXX
  X X
  XXX
 X   X`

const Font_JR_underscore = `







XXXXXXXX`

const Font_JR_tilde = `
 XXX  X
X  XXX`

const Font_JR_dollars = `
   X
 XXXXX
X  X
 XXXXX
   X  X
 XXXXX
   X`

// NewJRFont provides a font based upon Jim Reed's RPG Tileset
func NewJRFont() *Font {
	m := map[rune]string{
		'A':  Font_JR_A,
		'B':  Font_JR_B,
		'C':  Font_JR_C,
		'D':  Font_JR_D,
		'E':  Font_JR_E,
		'F':  Font_JR_F,
		'G':  Font_JR_G,
		'H':  Font_JR_H,
		'I':  Font_JR_I,
		'J':  Font_JR_J,
		'K':  Font_JR_K,
		'L':  Font_JR_L,
		'M':  Font_JR_M,
		'N':  Font_JR_N,
		'O':  Font_JR_O,
		'P':  Font_JR_P,
		'Q':  Font_JR_Q,
		'R':  Font_JR_R,
		'S':  Font_JR_S,
		'T':  Font_JR_T,
		'U':  Font_JR_U,
		'V':  Font_JR_V,
		'W':  Font_JR_W,
		'X':  Font_JR_X,
		'Y':  Font_JR_Y,
		'Z':  Font_JR_Z,
		'a':  Font_JR_a,
		'b':  Font_JR_b,
		'c':  Font_JR_c,
		'd':  Font_JR_d,
		'e':  Font_JR_e,
		'f':  Font_JR_f,
		'g':  Font_JR_g,
		'h':  Font_JR_h,
		'i':  Font_JR_i,
		'j':  Font_JR_j,
		'k':  Font_JR_k,
		'l':  Font_JR_l,
		'm':  Font_JR_m,
		'n':  Font_JR_n,
		'o':  Font_JR_o,
		'p':  Font_JR_p,
		'q':  Font_JR_q,
		'r':  Font_JR_r,
		's':  Font_JR_s,
		't':  Font_JR_t,
		'u':  Font_JR_u,
		'v':  Font_JR_v,
		'w':  Font_JR_w,
		'x':  Font_JR_x,
		'y':  Font_JR_y,
		'z':  Font_JR_z,
		'0':  Font_JR_0,
		'1':  Font_JR_1,
		'2':  Font_JR_2,
		'3':  Font_JR_3,
		'4':  Font_JR_4,
		'5':  Font_JR_5,
		'6':  Font_JR_6,
		'7':  Font_JR_7,
		'8':  Font_JR_8,
		'9':  Font_JR_9,
		'.':  Font_JR_period,
		',':  Font_JR_comma,
		';':  Font_JR_semicolon,
		':':  Font_JR_colon,
		'-':  Font_JR_minus,
		'+':  Font_JR_plus,
		'*':  Font_JR_times,
		'/':  Font_JR_slash,
		'%':  Font_JR_percent,
		'<':  Font_JR_lt,
		'>':  Font_JR_gt,
		'!':  Font_JR_exclamation,
		'?':  Font_JR_question,
		'∨':  Font_JR_down, // unicode U+2228
		'^':  Font_JR_up,
		'[':  Font_JR_l_bracket,
		']':  Font_JR_r_bracket,
		'(':  Font_JR_l_paren,
		')':  Font_JR_r_paren,
		'{':  Font_JR_l_brace,
		'}':  Font_JR_r_brace,
		'#':  Font_JR_sharp,
		'&':  Font_JR_amp,
		'=':  Font_JR_equals,
		'"':  Font_JR_double_quot,
		'\'': Font_JR_quot,
		'@':  Font_JR_at,
		'|':  Font_JR_pipe,
		'\\': Font_JR_b_slash,
		'ß':  Font_JR_eszett,
		'☆':  Font_JR_star,
		'_':  Font_JR_underscore,
		'~':  Font_JR_tilde,
		'$':  Font_JR_dollars,
	}

	return NewFont(m, 8, 9)
}
