package transform

import "testing"

func TestParseCommand(t *testing.T) {
	program, args, ok := ParseCommand("cmd.exe /c calc")
	if !ok {
		t.Fatal("Failed to parse command")
	}

	if program != "cmd.exe" || args != "/c calc" {
		t.Fatalf("Program or args returned unexpected values: %s %s", program, args)
	}

	t.Log(program + " " + args)
}
