// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package metastore provides access to the Dataproc Metastore API.
//
// For product documentation, see: https://cloud.google.com/dataproc-metastore/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/metastore/v2"
//	...
//	ctx := context.Background()
//	metastoreService, err := metastore.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	metastoreService, err := metastore.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	metastoreService, err := metastore.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package metastore // import "google.golang.org/api/metastore/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "metastore:v2"
const apiName = "metastore"
const apiVersion = "v2"
const basePath = "https://metastore.googleapis.com/"
const basePathTemplate = "https://metastore.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://metastore.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Services = NewProjectsLocationsServicesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Services *ProjectsLocationsServicesService
}

func NewProjectsLocationsServicesService(s *Service) *ProjectsLocationsServicesService {
	rs := &ProjectsLocationsServicesService{s: s}
	rs.Backups = NewProjectsLocationsServicesBackupsService(s)
	return rs
}

type ProjectsLocationsServicesService struct {
	s *Service

	Backups *ProjectsLocationsServicesBackupsService
}

func NewProjectsLocationsServicesBackupsService(s *Service) *ProjectsLocationsServicesBackupsService {
	rs := &ProjectsLocationsServicesBackupsService{s: s}
	return rs
}

type ProjectsLocationsServicesBackupsService struct {
	s *Service
}

// GoogleCloudMetastoreV1AlterMetadataResourceLocationResponse: Response
// message for DataprocMetastore.AlterMetadataResourceLocation.
type GoogleCloudMetastoreV1AlterMetadataResourceLocationResponse struct {
}

// GoogleCloudMetastoreV1CustomRegionMetadata: Metadata about a custom region.
// This is only populated if the region is a custom region. For single/multi
// regions, it will be empty.
type GoogleCloudMetastoreV1CustomRegionMetadata struct {
	// OptionalReadOnlyRegions: The read-only regions for this custom region.
	OptionalReadOnlyRegions []string `json:"optionalReadOnlyRegions,omitempty"`
	// RequiredReadWriteRegions: The read-write regions for this custom region.
	RequiredReadWriteRegions []string `json:"requiredReadWriteRegions,omitempty"`
	// WitnessRegion: The Spanner witness region for this custom region.
	WitnessRegion string `json:"witnessRegion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1CustomRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1CustomRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1ErrorDetails: Error details in public error message
// for DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1ErrorDetails struct {
	// Details: Additional structured details about this error.Keys define the
	// failure items. Value describes the exception or details of the item.
	Details map[string]string `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1ErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1ErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1HiveMetastoreVersion: A specification of a supported
// version of the Hive Metastore software.
type GoogleCloudMetastoreV1HiveMetastoreVersion struct {
	// IsDefault: Whether version will be chosen by the server if a metastore
	// service is created with a HiveMetastoreConfig that omits the version.
	IsDefault bool `json:"isDefault,omitempty"`
	// Version: The semantic version of the Hive Metastore software.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1HiveMetastoreVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1HiveMetastoreVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1LocationMetadata: Metadata about the service in a
// location.
type GoogleCloudMetastoreV1LocationMetadata struct {
	// CustomRegionMetadata: Possible configurations supported if the current
	// region is a custom region.
	CustomRegionMetadata []*GoogleCloudMetastoreV1CustomRegionMetadata `json:"customRegionMetadata,omitempty"`
	// MultiRegionMetadata: The multi-region metadata if the current region is a
	// multi-region.
	MultiRegionMetadata *GoogleCloudMetastoreV1MultiRegionMetadata `json:"multiRegionMetadata,omitempty"`
	// SupportedHiveMetastoreVersions: The versions of Hive Metastore that can be
	// used when creating a new metastore service in this location. The server
	// guarantees that exactly one HiveMetastoreVersion in the list will set
	// is_default.
	SupportedHiveMetastoreVersions []*GoogleCloudMetastoreV1HiveMetastoreVersion `json:"supportedHiveMetastoreVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomRegionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRegionMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1LocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1MoveTableToDatabaseResponse: Response message for
// DataprocMetastore.MoveTableToDatabase.
type GoogleCloudMetastoreV1MoveTableToDatabaseResponse struct {
}

// GoogleCloudMetastoreV1MultiRegionMetadata: The metadata for the multi-region
// that includes the constituent regions. The metadata is only populated if the
// region is multi-region. For single region or custom dual region, it will be
// empty.
type GoogleCloudMetastoreV1MultiRegionMetadata struct {
	// ConstituentRegions: The regions constituting the multi-region.
	ConstituentRegions []string `json:"constituentRegions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstituentRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstituentRegions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1MultiRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1MultiRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1OperationMetadata: Represents the metadata of a
// long-running operation.
type GoogleCloudMetastoreV1OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the caller has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1QueryMetadataResponse: Response message for
// DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1QueryMetadataResponse struct {
	// ResultManifestUri: The manifest URI is link to a JSON instance in Cloud
	// Storage. This instance manifests immediately along with
	// QueryMetadataResponse. The content of the URI is not retriable until the
	// long-running operation query against the metadata finishes.
	ResultManifestUri string `json:"resultManifestUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultManifestUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultManifestUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1QueryMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1QueryMetadataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaAlterMetadataResourceLocationResponse: Response
// message for DataprocMetastore.AlterMetadataResourceLocation.
type GoogleCloudMetastoreV1alphaAlterMetadataResourceLocationResponse struct {
}

// GoogleCloudMetastoreV1alphaCancelMigrationResponse: Response message for
// DataprocMetastore.CancelMigration.
type GoogleCloudMetastoreV1alphaCancelMigrationResponse struct {
	// MigrationExecution: The relative resource name of the migration execution,
	// in the following
	// form:projects/{project_number}/locations/{location_id}/services/{service_id}/
	// migrationExecutions/{migration_execution_id}.
	MigrationExecution string `json:"migrationExecution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationExecution") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaCancelMigrationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaCancelMigrationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaCompleteMigrationResponse: Response message for
// DataprocMetastore.CompleteMigration.
type GoogleCloudMetastoreV1alphaCompleteMigrationResponse struct {
	// MigrationExecution: The relative resource name of the migration execution,
	// in the following
	// form:projects/{project_number}/locations/{location_id}/services/{service_id}/
	// migrationExecutions/{migration_execution_id}.
	MigrationExecution string `json:"migrationExecution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationExecution") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaCompleteMigrationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaCompleteMigrationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaCustomRegionMetadata: Metadata about a custom
// region. This is only populated if the region is a custom region. For
// single/multi regions, it will be empty.
type GoogleCloudMetastoreV1alphaCustomRegionMetadata struct {
	// OptionalReadOnlyRegions: The read-only regions for this custom region.
	OptionalReadOnlyRegions []string `json:"optionalReadOnlyRegions,omitempty"`
	// RequiredReadWriteRegions: The read-write regions for this custom region.
	RequiredReadWriteRegions []string `json:"requiredReadWriteRegions,omitempty"`
	// WitnessRegion: The Spanner witness region for this custom region.
	WitnessRegion string `json:"witnessRegion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaCustomRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaCustomRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaErrorDetails: Error details in public error
// message for DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1alphaErrorDetails struct {
	// Details: Additional structured details about this error.Keys define the
	// failure items. Value describes the exception or details of the item.
	Details map[string]string `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaHiveMetastoreVersion: A specification of a
// supported version of the Hive Metastore software.
type GoogleCloudMetastoreV1alphaHiveMetastoreVersion struct {
	// IsDefault: Whether version will be chosen by the server if a metastore
	// service is created with a HiveMetastoreConfig that omits the version.
	IsDefault bool `json:"isDefault,omitempty"`
	// Version: The semantic version of the Hive Metastore software.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaHiveMetastoreVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaHiveMetastoreVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaLocationMetadata: Metadata about the service in a
// location.
type GoogleCloudMetastoreV1alphaLocationMetadata struct {
	// CustomRegionMetadata: Possible configurations supported if the current
	// region is a custom region.
	CustomRegionMetadata []*GoogleCloudMetastoreV1alphaCustomRegionMetadata `json:"customRegionMetadata,omitempty"`
	// MultiRegionMetadata: The multi-region metadata if the current region is a
	// multi-region.
	MultiRegionMetadata *GoogleCloudMetastoreV1alphaMultiRegionMetadata `json:"multiRegionMetadata,omitempty"`
	// SupportedHiveMetastoreVersions: The versions of Hive Metastore that can be
	// used when creating a new metastore service in this location. The server
	// guarantees that exactly one HiveMetastoreVersion in the list will set
	// is_default.
	SupportedHiveMetastoreVersions []*GoogleCloudMetastoreV1alphaHiveMetastoreVersion `json:"supportedHiveMetastoreVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomRegionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRegionMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaLocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaLocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaMoveTableToDatabaseResponse: Response message for
// DataprocMetastore.MoveTableToDatabase.
type GoogleCloudMetastoreV1alphaMoveTableToDatabaseResponse struct {
}

// GoogleCloudMetastoreV1alphaMultiRegionMetadata: The metadata for the
// multi-region that includes the constituent regions. The metadata is only
// populated if the region is multi-region. For single region or custom dual
// region, it will be empty.
type GoogleCloudMetastoreV1alphaMultiRegionMetadata struct {
	// ConstituentRegions: The regions constituting the multi-region.
	ConstituentRegions []string `json:"constituentRegions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstituentRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstituentRegions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaMultiRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaMultiRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaOperationMetadata: Represents the metadata of a
// long-running operation.
type GoogleCloudMetastoreV1alphaOperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the caller has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1alphaQueryMetadataResponse: Response message for
// DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1alphaQueryMetadataResponse struct {
	// ResultManifestUri: The manifest URI is link to a JSON instance in Cloud
	// Storage. This instance manifests immediately along with
	// QueryMetadataResponse. The content of the URI is not retriable until the
	// long-running operation query against the metadata finishes.
	ResultManifestUri string `json:"resultManifestUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultManifestUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultManifestUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1alphaQueryMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1alphaQueryMetadataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaAlterMetadataResourceLocationResponse: Response
// message for DataprocMetastore.AlterMetadataResourceLocation.
type GoogleCloudMetastoreV1betaAlterMetadataResourceLocationResponse struct {
}

// GoogleCloudMetastoreV1betaCancelMigrationResponse: Response message for
// DataprocMetastore.CancelMigration.
type GoogleCloudMetastoreV1betaCancelMigrationResponse struct {
	// MigrationExecution: The relative resource name of the migration execution,
	// in the following
	// form:projects/{project_number}/locations/{location_id}/services/{service_id}/
	// migrationExecutions/{migration_execution_id}.
	MigrationExecution string `json:"migrationExecution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationExecution") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaCancelMigrationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaCancelMigrationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaCompleteMigrationResponse: Response message for
// DataprocMetastore.CompleteMigration.
type GoogleCloudMetastoreV1betaCompleteMigrationResponse struct {
	// MigrationExecution: The relative resource name of the migration execution,
	// in the following
	// form:projects/{project_number}/locations/{location_id}/services/{service_id}/
	// migrationExecutions/{migration_execution_id}.
	MigrationExecution string `json:"migrationExecution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationExecution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationExecution") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaCompleteMigrationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaCompleteMigrationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaCustomRegionMetadata: Metadata about a custom
// region. This is only populated if the region is a custom region. For
// single/multi regions, it will be empty.
type GoogleCloudMetastoreV1betaCustomRegionMetadata struct {
	// OptionalReadOnlyRegions: The read-only regions for this custom region.
	OptionalReadOnlyRegions []string `json:"optionalReadOnlyRegions,omitempty"`
	// RequiredReadWriteRegions: The read-write regions for this custom region.
	RequiredReadWriteRegions []string `json:"requiredReadWriteRegions,omitempty"`
	// WitnessRegion: The Spanner witness region for this custom region.
	WitnessRegion string `json:"witnessRegion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptionalReadOnlyRegions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaCustomRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaCustomRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaErrorDetails: Error details in public error
// message for DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1betaErrorDetails struct {
	// Details: Additional structured details about this error.Keys define the
	// failure items. Value describes the exception or details of the item.
	Details map[string]string `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaHiveMetastoreVersion: A specification of a
// supported version of the Hive Metastore software.
type GoogleCloudMetastoreV1betaHiveMetastoreVersion struct {
	// IsDefault: Whether version will be chosen by the server if a metastore
	// service is created with a HiveMetastoreConfig that omits the version.
	IsDefault bool `json:"isDefault,omitempty"`
	// Version: The semantic version of the Hive Metastore software.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsDefault") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsDefault") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaHiveMetastoreVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaHiveMetastoreVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaLocationMetadata: Metadata about the service in a
// location.
type GoogleCloudMetastoreV1betaLocationMetadata struct {
	// CustomRegionMetadata: Possible configurations supported if the current
	// region is a custom region.
	CustomRegionMetadata []*GoogleCloudMetastoreV1betaCustomRegionMetadata `json:"customRegionMetadata,omitempty"`
	// MultiRegionMetadata: The multi-region metadata if the current region is a
	// multi-region.
	MultiRegionMetadata *GoogleCloudMetastoreV1betaMultiRegionMetadata `json:"multiRegionMetadata,omitempty"`
	// SupportedHiveMetastoreVersions: The versions of Hive Metastore that can be
	// used when creating a new metastore service in this location. The server
	// guarantees that exactly one HiveMetastoreVersion in the list will set
	// is_default.
	SupportedHiveMetastoreVersions []*GoogleCloudMetastoreV1betaHiveMetastoreVersion `json:"supportedHiveMetastoreVersions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomRegionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRegionMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaLocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaLocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaMoveTableToDatabaseResponse: Response message for
// DataprocMetastore.MoveTableToDatabase.
type GoogleCloudMetastoreV1betaMoveTableToDatabaseResponse struct {
}

// GoogleCloudMetastoreV1betaMultiRegionMetadata: The metadata for the
// multi-region that includes the constituent regions. The metadata is only
// populated if the region is multi-region. For single region or custom dual
// region, it will be empty.
type GoogleCloudMetastoreV1betaMultiRegionMetadata struct {
	// ConstituentRegions: The regions constituting the multi-region.
	ConstituentRegions []string `json:"constituentRegions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConstituentRegions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConstituentRegions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaMultiRegionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaMultiRegionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaOperationMetadata: Represents the metadata of a
// long-running operation.
type GoogleCloudMetastoreV1betaOperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the caller has
	// requested cancellation of the operation. Operations that have successfully
	// been cancelled have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV1betaQueryMetadataResponse: Response message for
// DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV1betaQueryMetadataResponse struct {
	// ResultManifestUri: The manifest URI is link to a JSON instance in Cloud
	// Storage. This instance manifests immediately along with
	// QueryMetadataResponse. The content of the URI is not retriable until the
	// long-running operation query against the metadata finishes.
	ResultManifestUri string `json:"resultManifestUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultManifestUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultManifestUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV1betaQueryMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV1betaQueryMetadataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest: Request message
// for DataprocMetastore.AlterMetadataResourceLocation.
type GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest struct {
	// LocationUri: Required. The new location URI for the metadata resource.
	LocationUri string `json:"locationUri,omitempty"`
	// ResourceName: Required. The relative metadata resource name in the following
	// format.databases/{database_id} or databases/{database_id}/tables/{table_id}
	// or databases/{database_id}/tables/{table_id}/partitions/{partition_id}
	ResourceName string `json:"resourceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2AlterTablePropertiesRequest: Request message for
// DataprocMetastore.AlterTableProperties.
type GoogleCloudMetastoreV2AlterTablePropertiesRequest struct {
	// Properties: A map that describes the desired values to mutate. If
	// update_mask is empty, the properties will not update. Otherwise, the
	// properties only alters the value whose associated paths exist in the update
	// mask
	Properties map[string]string `json:"properties,omitempty"`
	// TableName: Required. The name of the table containing the properties you're
	// altering in the following format.databases/{database_id}/tables/{table_id}
	TableName string `json:"tableName,omitempty"`
	// UpdateMask: A field mask that specifies the metadata table properties that
	// are overwritten by the update. Fields specified in the update_mask are
	// relative to the resource (not to the full request). A field is overwritten
	// if it is in the mask.For example, given the target properties: properties {
	// a: 1 b: 2 } And an update properties: properties { a: 2 b: 3 c: 4 } then if
	// the field mask is:paths: "properties.b", "properties.c"then the result will
	// be: properties { a: 1 b: 3 c: 4 }
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2AlterTablePropertiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2AlterTablePropertiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2AuxiliaryVersionConfig: Configuration information for
// the auxiliary service versions.
type GoogleCloudMetastoreV2AuxiliaryVersionConfig struct {
	// ConfigOverrides: A mapping of Hive metastore configuration key-value pairs
	// to apply to the auxiliary Hive metastore (configured in hive-site.xml) in
	// addition to the primary version's overrides. If keys are present in both the
	// auxiliary version's overrides and the primary version's overrides, the value
	// from the auxiliary version's overrides takes precedence.
	ConfigOverrides map[string]string `json:"configOverrides,omitempty"`
	// Endpoints: Output only. The list of endpoints used to access the auxiliary
	// metastore service, includes version and region data.
	Endpoints []*GoogleCloudMetastoreV2Endpoint `json:"endpoints,omitempty"`
	// Version: The Hive metastore version of the auxiliary service. It must be
	// less than the primary Hive metastore service's version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2AuxiliaryVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2AuxiliaryVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2Backup: The details of a backup resource.
type GoogleCloudMetastoreV2Backup struct {
	// CreateTime: Output only. The time when the backup was started.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The description of the backup.
	Description string `json:"description,omitempty"`
	// EndTime: Output only. The time when the backup finished creating.
	EndTime string `json:"endTime,omitempty"`
	// Name: Immutable. The relative resource name of the backup, in the following
	// form:projects/{project_number}/locations/{location_id}/services/{service_id}/
	// backups/{backup_id}
	Name string `json:"name,omitempty"`
	// RestoringServices: Output only. Services that are restoring from the backup.
	RestoringServices []string `json:"restoringServices,omitempty"`
	// ServiceRevision: Output only. The revision of the service at the time of
	// backup.
	ServiceRevision *GoogleCloudMetastoreV2Service `json:"serviceRevision,omitempty"`
	// State: Output only. The current state of the backup.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state of the backup is unknown.
	//   "CREATING" - The backup is being created.
	//   "DELETING" - The backup is being deleted.
	//   "ACTIVE" - The backup is active and ready to use.
	//   "FAILED" - The backup failed.
	//   "RESTORING" - The backup is being restored.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2Backup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2Backup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2DataCatalogConfig: Specifies how metastore metadata
// should be integrated with the Data Catalog service.
type GoogleCloudMetastoreV2DataCatalogConfig struct {
	// Enabled: Optional. Defines whether the metastore metadata should be synced
	// to Data Catalog. The default value is to disable syncing metastore metadata
	// to Data Catalog.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2DataCatalogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2DataCatalogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2DatabaseDump: A specification of the location of and
// metadata about a database dump from a relational database management system.
type GoogleCloudMetastoreV2DatabaseDump struct {
	// GcsUri: Required. A Cloud Storage object or folder URI that specifies the
	// source from which to import metadata. It must begin with gs://.
	GcsUri string `json:"gcsUri,omitempty"`
	// Type: Optional. The type of the database dump. If unspecified, defaults to
	// MYSQL.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type of the database dump is unknown.
	//   "MYSQL" - Database dump is a MySQL dump file.
	//   "AVRO" - Database dump contains Avro files.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2DatabaseDump) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2DatabaseDump
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2EncryptionConfig: Encryption settings for the service.
type GoogleCloudMetastoreV2EncryptionConfig struct {
}

// GoogleCloudMetastoreV2Endpoint: An endpoint used to access the metastore
// service.
type GoogleCloudMetastoreV2Endpoint struct {
	// EndpointUri: Output only. The URI of the endpoint used to access the
	// metastore service.
	EndpointUri string `json:"endpointUri,omitempty"`
	// Region: Output only. The region where the endpoint is located.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ExportMetadataRequest: Request message for
// DataprocMetastore.ExportMetadata.
type GoogleCloudMetastoreV2ExportMetadataRequest struct {
	// DatabaseDumpType: Optional. The type of the database dump. If unspecified,
	// defaults to MYSQL.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type of the database dump is unknown.
	//   "MYSQL" - Database dump is a MySQL dump file.
	//   "AVRO" - Database dump contains Avro files.
	DatabaseDumpType string `json:"databaseDumpType,omitempty"`
	// DestinationGcsFolder: A Cloud Storage URI of a folder, in the format gs:///.
	// A sub-folder containing exported files will be created below it.
	DestinationGcsFolder string `json:"destinationGcsFolder,omitempty"`
	// RequestId: Optional. A request ID. Specify a unique request ID to allow the
	// server to ignore the request if it has completed. The server will ignore
	// subsequent requests that provide a duplicate request ID for at least 60
	// minutes after the first request.For example, if an initial request times
	// out, followed by another request with the same request ID, the server
	// ignores the second request to prevent the creation of duplicate
	// commitments.The request ID must be a valid UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format). A zero
	// UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseDumpType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseDumpType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ExportMetadataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ExportMetadataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2HiveMetastoreConfig: Specifies configuration
// information specific to running Hive metastore software as the metastore
// service.
type GoogleCloudMetastoreV2HiveMetastoreConfig struct {
	// AuxiliaryVersions: Optional. A mapping of Hive metastore version to the
	// auxiliary version configuration. When specified, a secondary Hive metastore
	// service is created along with the primary service. All auxiliary versions
	// must be less than the service's primary version. The key is the auxiliary
	// service name and it must match the regular expression a-z?. This means that
	// the first character must be a lowercase letter, and all the following
	// characters must be hyphens, lowercase letters, or digits, except the last
	// character, which cannot be a hyphen.
	AuxiliaryVersions map[string]GoogleCloudMetastoreV2AuxiliaryVersionConfig `json:"auxiliaryVersions,omitempty"`
	// ConfigOverrides: Optional. A mapping of Hive metastore configuration
	// key-value pairs to apply to the Hive metastore (configured in
	// hive-site.xml). The mappings override system defaults (some keys cannot be
	// overridden). These overrides are also applied to auxiliary versions and can
	// be further customized in the auxiliary version's AuxiliaryVersionConfig.
	ConfigOverrides map[string]string `json:"configOverrides,omitempty"`
	// EndpointProtocol: Optional. The protocol to use for the metastore service
	// endpoint. If unspecified, defaults to GRPC.
	//
	// Possible values:
	//   "ENDPOINT_PROTOCOL_UNSPECIFIED" - The protocol is not set.
	//   "THRIFT" - Use the legacy Apache Thrift protocol for the metastore service
	// endpoint.
	//   "GRPC" - Use the modernized gRPC protocol for the metastore service
	// endpoint.
	EndpointProtocol string `json:"endpointProtocol,omitempty"`
	// Version: Immutable. The Hive metastore schema version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryVersions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2HiveMetastoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2HiveMetastoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ImportMetadataRequest: Request message for
// DataprocMetastore.CreateMetadataImport.
type GoogleCloudMetastoreV2ImportMetadataRequest struct {
	// DatabaseDump: Immutable. A database dump from a pre-existing metastore's
	// database.
	DatabaseDump *GoogleCloudMetastoreV2DatabaseDump `json:"databaseDump,omitempty"`
	// Description: Optional. The description of the metadata import.
	Description string `json:"description,omitempty"`
	// RequestId: Optional. A request ID. Specify a unique request ID to allow the
	// server to ignore the request if it has completed. The server will ignore
	// subsequent requests that provide a duplicate request ID for at least 60
	// minutes after the first request.For example, if an initial request times
	// out, followed by another request with the same request ID, the server
	// ignores the second request to prevent the creation of duplicate
	// commitments.The request ID must be a valid UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format). A zero
	// UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseDump") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseDump") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ImportMetadataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ImportMetadataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2LatestBackup: The details of the latest scheduled
// backup.
type GoogleCloudMetastoreV2LatestBackup struct {
	// BackupId: Output only. The ID of an in-progress scheduled backup. Empty if
	// no backup is in progress.
	BackupId string `json:"backupId,omitempty"`
	// Duration: Output only. The duration of the backup completion.
	Duration string `json:"duration,omitempty"`
	// StartTime: Output only. The time when the backup was started.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The current state of the backup.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state of the backup is unknown.
	//   "IN_PROGRESS" - The backup is in progress.
	//   "SUCCEEDED" - The backup completed.
	//   "FAILED" - The backup failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2LatestBackup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2LatestBackup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ListBackupsResponse: Response message for
// DataprocMetastore.ListBackups.
type GoogleCloudMetastoreV2ListBackupsResponse struct {
	// Backups: The backups of the specified service.
	Backups []*GoogleCloudMetastoreV2Backup `json:"backups,omitempty"`
	// NextPageToken: A token that can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ListBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ListBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ListServicesResponse: Response message for
// DataprocMetastore.ListServices.
type GoogleCloudMetastoreV2ListServicesResponse struct {
	// NextPageToken: A token that can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Services: The services in the specified location.
	Services []*GoogleCloudMetastoreV2Service `json:"services,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ListServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ListServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2MetadataIntegration: Specifies how metastore metadata
// should be integrated with external services.
type GoogleCloudMetastoreV2MetadataIntegration struct {
	// DataCatalogConfig: Optional. The integration config for the Data Catalog
	// service.
	DataCatalogConfig *GoogleCloudMetastoreV2DataCatalogConfig `json:"dataCatalogConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataCatalogConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataCatalogConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2MetadataIntegration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2MetadataIntegration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2MoveTableToDatabaseRequest: Request message for
// DataprocMetastore.MoveTableToDatabase.
type GoogleCloudMetastoreV2MoveTableToDatabaseRequest struct {
	// DbName: Required. The name of the database where the table resides.
	DbName string `json:"dbName,omitempty"`
	// DestinationDbName: Required. The name of the database where the table should
	// be moved.
	DestinationDbName string `json:"destinationDbName,omitempty"`
	// TableName: Required. The name of the table to be moved.
	TableName string `json:"tableName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DbName") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DbName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2MoveTableToDatabaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2MoveTableToDatabaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2QueryMetadataRequest: Request message for
// DataprocMetastore.QueryMetadata.
type GoogleCloudMetastoreV2QueryMetadataRequest struct {
	// Query: Required. A read-only SQL query to execute against the metadata
	// database. The query cannot change or mutate the data.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2QueryMetadataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2QueryMetadataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2RestoreServiceRequest: Request message for
// DataprocMetastore.Restore.
type GoogleCloudMetastoreV2RestoreServiceRequest struct {
	// Backup: Optional. The relative resource name of the metastore service backup
	// to restore from, in the following
	// form:projects/{project_id}/locations/{location_id}/services/{service_id}/back
	// ups/{backup_id}. Mutually exclusive with backup_location, and exactly one of
	// the two must be set.
	Backup string `json:"backup,omitempty"`
	// BackupLocation: Optional. A Cloud Storage URI specifying the location of the
	// backup artifacts, namely - backup avro files under "avro/",
	// backup_metastore.json and service.json, in the following form:gs://.
	// Mutually exclusive with backup, and exactly one of the two must be set.
	BackupLocation string `json:"backupLocation,omitempty"`
	// RequestId: Optional. A request ID. Specify a unique request ID to allow the
	// server to ignore the request if it has completed. The server will ignore
	// subsequent requests that provide a duplicate request ID for at least 60
	// minutes after the first request.For example, if an initial request times
	// out, followed by another request with the same request ID, the server
	// ignores the second request to prevent the creation of duplicate
	// commitments.The request ID must be a valid UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format). A zero
	// UUID (00000000-0000-0000-0000-000000000000) is not supported.
	RequestId string `json:"requestId,omitempty"`
	// RestoreType: Optional. The type of restore. If unspecified, defaults to
	// METADATA_ONLY.
	//
	// Possible values:
	//   "RESTORE_TYPE_UNSPECIFIED" - The restore type is unknown.
	//   "FULL" - The service's metadata and configuration are restored.
	//   "METADATA_ONLY" - Only the service's metadata is restored.
	RestoreType string `json:"restoreType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Backup") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2RestoreServiceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2RestoreServiceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ScalingConfig: Represents the scaling configuration of
// a metastore service.
type GoogleCloudMetastoreV2ScalingConfig struct {
	// ScalingFactor: Optional. Scaling factor from 1 to 5, increments of 1.
	ScalingFactor int64 `json:"scalingFactor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScalingFactor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScalingFactor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ScalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ScalingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2ScheduledBackup: This specifies the configuration of
// scheduled backup.
type GoogleCloudMetastoreV2ScheduledBackup struct {
	// BackupLocation: Optional. A Cloud Storage URI of a folder, in the format
	// gs:///. A sub-folder containing backup files will be stored below it.
	BackupLocation string `json:"backupLocation,omitempty"`
	// CronSchedule: Optional. The scheduled interval in Cron format, see
	// https://en.wikipedia.org/wiki/Cron The default is empty: scheduled backup is
	// not enabled. Must be specified to enable scheduled backups.
	CronSchedule string `json:"cronSchedule,omitempty"`
	// Enabled: Optional. Defines whether the scheduled backup is enabled. The
	// default value is false.
	Enabled bool `json:"enabled,omitempty"`
	// LatestBackup: Output only. The details of the latest scheduled backup.
	LatestBackup *GoogleCloudMetastoreV2LatestBackup `json:"latestBackup,omitempty"`
	// NextScheduledTime: Output only. The time when the next backups execution is
	// scheduled to start.
	NextScheduledTime string `json:"nextScheduledTime,omitempty"`
	// TimeZone: Optional. Specifies the time zone to be used when interpreting
	// cron_schedule. Must be a time zone name from the time zone database
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones), e.g.
	// America/Los_Angeles or Africa/Abidjan. If left unspecified, the default is
	// UTC.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2ScheduledBackup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2ScheduledBackup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudMetastoreV2Service: A managed metastore service that serves
// metadata queries.
type GoogleCloudMetastoreV2Service struct {
	// CreateTime: Output only. The time when the metastore service was created.
	CreateTime string `json:"createTime,omitempty"`
	// EncryptionConfig: Immutable. Information used to configure the Dataproc
	// Metastore service to encrypt customer data at rest. Cannot be updated.
	EncryptionConfig *GoogleCloudMetastoreV2EncryptionConfig `json:"encryptionConfig,omitempty"`
	// Endpoints: Output only. The list of endpoints used to access the metastore
	// service.
	Endpoints []*GoogleCloudMetastoreV2Endpoint `json:"endpoints,omitempty"`
	// HiveMetastoreConfig: Configuration information specific to running Hive
	// metastore software as the metastore service.
	HiveMetastoreConfig *GoogleCloudMetastoreV2HiveMetastoreConfig `json:"hiveMetastoreConfig,omitempty"`
	// Labels: User-defined labels for the metastore service.
	Labels map[string]string `json:"labels,omitempty"`
	// MetadataIntegration: Optional. The setting that defines how metastore
	// metadata should be integrated with external services and systems.
	MetadataIntegration *GoogleCloudMetastoreV2MetadataIntegration `json:"metadataIntegration,omitempty"`
	// Name: Immutable. The relative resource name of the metastore service, in the
	// following
	// format:projects/{project_number}/locations/{location_id}/services/{service_id
	// }.
	Name string `json:"name,omitempty"`
	// ScalingConfig: Optional. Scaling configuration of the metastore service.
	ScalingConfig *GoogleCloudMetastoreV2ScalingConfig `json:"scalingConfig,omitempty"`
	// ScheduledBackup: Optional. The configuration of scheduled backup for the
	// metastore service.
	ScheduledBackup *GoogleCloudMetastoreV2ScheduledBackup `json:"scheduledBackup,omitempty"`
	// State: Output only. The current state of the metastore service.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state of the metastore service is unknown.
	//   "CREATING" - The metastore service is in the process of being created.
	//   "ACTIVE" - The metastore service is running and ready to serve queries.
	//   "SUSPENDING" - The metastore service is entering suspension. Its
	// query-serving availability may cease unexpectedly.
	//   "SUSPENDED" - The metastore service is suspended and unable to serve
	// queries.
	//   "UPDATING" - The metastore service is being updated. It remains usable but
	// cannot accept additional update requests or be deleted at this time.
	//   "DELETING" - The metastore service is undergoing deletion. It cannot be
	// used.
	//   "ERROR" - The metastore service has encountered an error and cannot be
	// used. The metastore service should be deleted.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. Additional information about the current state of
	// the metastore service, if available.
	StateMessage string `json:"stateMessage,omitempty"`
	// Uid: Output only. The globally unique resource identifier of the metastore
	// service.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The time when the metastore service was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WarehouseGcsUri: Required. A Cloud Storage URI (starting with gs://) that
	// specifies the default warehouse directory of the Hive Metastore.
	WarehouseGcsUri string `json:"warehouseGcsUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudMetastoreV2Service) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudMetastoreV2Service
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is false, it means the operation is still in progress. If
	// true, the operation is completed, and either error or response is available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the name
	// should be a resource name ending with operations/{unique_id}.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as Delete, the response is
	// google.protobuf.Empty. If the original method is standard Get/Create/Update,
	// the response should be the resource. For other methods, the response should
	// have the type XxxResponse, where Xxx is the original method name. For
	// example, if the original method name is TakeSnapshot(), the inferred
	// response type is TakeSnapshotResponse.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The Status type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each Status message
// contains three pieces of data: error code, error message, and error
// details.You can find out more about this error model and how to work with it
// in the API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsServicesAlterLocationCall struct {
	s                                                          *Service
	service                                                    string
	googlecloudmetastorev2altermetadataresourcelocationrequest *GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// AlterLocation: Alter metadata resource location. The metadata resource can
// be a database, table, or partition. This functionality only updates the
// parent directory for the respective metadata resource and does not transfer
// any existing data to the new location.
//
//   - service: The relative resource name of the metastore service to mutate
//     metadata, in the following
//     format:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) AlterLocation(service string, googlecloudmetastorev2altermetadataresourcelocationrequest *GoogleCloudMetastoreV2AlterMetadataResourceLocationRequest) *ProjectsLocationsServicesAlterLocationCall {
	c := &ProjectsLocationsServicesAlterLocationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2altermetadataresourcelocationrequest = googlecloudmetastorev2altermetadataresourcelocationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesAlterLocationCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesAlterLocationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesAlterLocationCall) Context(ctx context.Context) *ProjectsLocationsServicesAlterLocationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesAlterLocationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesAlterLocationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2altermetadataresourcelocationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:alterLocation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.alterLocation" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesAlterLocationCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesAlterTablePropertiesCall struct {
	s                                                 *Service
	service                                           string
	googlecloudmetastorev2altertablepropertiesrequest *GoogleCloudMetastoreV2AlterTablePropertiesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// AlterTableProperties: Alter metadata table properties.
//
//   - service: The relative resource name of the Dataproc Metastore service
//     that's being used to mutate metadata table properties, in the following
//     format:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) AlterTableProperties(service string, googlecloudmetastorev2altertablepropertiesrequest *GoogleCloudMetastoreV2AlterTablePropertiesRequest) *ProjectsLocationsServicesAlterTablePropertiesCall {
	c := &ProjectsLocationsServicesAlterTablePropertiesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2altertablepropertiesrequest = googlecloudmetastorev2altertablepropertiesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesAlterTablePropertiesCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesAlterTablePropertiesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesAlterTablePropertiesCall) Context(ctx context.Context) *ProjectsLocationsServicesAlterTablePropertiesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesAlterTablePropertiesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesAlterTablePropertiesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2altertablepropertiesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:alterTableProperties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.alterTableProperties" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesAlterTablePropertiesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesCreateCall struct {
	s                             *Service
	parent                        string
	googlecloudmetastorev2service *GoogleCloudMetastoreV2Service
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Creates a metastore service in a project and location.
//
//   - parent: The relative resource name of the location in which to create a
//     metastore service, in the following
//     form:projects/{project_number}/locations/{location_id}.
func (r *ProjectsLocationsServicesService) Create(parent string, googlecloudmetastorev2service *GoogleCloudMetastoreV2Service) *ProjectsLocationsServicesCreateCall {
	c := &ProjectsLocationsServicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudmetastorev2service = googlecloudmetastorev2service
	return c
}

// RequestId sets the optional parameter "requestId": A request ID. Specify a
// unique request ID to allow the server to ignore the request if it has
// completed. The server will ignore subsequent requests that provide a
// duplicate request ID for at least 60 minutes after the first request.For
// example, if an initial request times out, followed by another request with
// the same request ID, the server ignores the second request to prevent the
// creation of duplicate commitments.The request ID must be a valid UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A zero
// UUID (00000000-0000-0000-0000-000000000000) is not supported.
func (c *ProjectsLocationsServicesCreateCall) RequestId(requestId string) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// ServiceId sets the optional parameter "serviceId": Required. The ID of the
// metastore service, which is used as the final component of the metastore
// service's name.This value must be between 2 and 63 characters long
// inclusive, begin with a letter, end with a letter or number, and consist of
// alpha-numeric ASCII characters or hyphens.
func (c *ProjectsLocationsServicesCreateCall) ServiceId(serviceId string) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("serviceId", serviceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesCreateCall) Context(ctx context.Context) *ProjectsLocationsServicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single service.
//
//   - name: The relative resource name of the metastore service to delete, in
//     the following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }.
func (r *ProjectsLocationsServicesService) Delete(name string) *ProjectsLocationsServicesDeleteCall {
	c := &ProjectsLocationsServicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID. Specify a
// unique request ID to allow the server to ignore the request if it has
// completed. The server will ignore subsequent requests that provide a
// duplicate request ID for at least 60 minutes after the first request.For
// example, if an initial request times out, followed by another request with
// the same request ID, the server ignores the second request to prevent the
// creation of duplicate commitments.The request ID must be a valid UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A zero
// UUID (00000000-0000-0000-0000-000000000000) is not supported.
func (c *ProjectsLocationsServicesDeleteCall) RequestId(requestId string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesDeleteCall) Context(ctx context.Context) *ProjectsLocationsServicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesExportMetadataCall struct {
	s                                           *Service
	service                                     string
	googlecloudmetastorev2exportmetadatarequest *GoogleCloudMetastoreV2ExportMetadataRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// ExportMetadata: Exports metadata from a service.
//
//   - service: The relative resource name of the metastore service to run
//     export, in the following
//     form:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) ExportMetadata(service string, googlecloudmetastorev2exportmetadatarequest *GoogleCloudMetastoreV2ExportMetadataRequest) *ProjectsLocationsServicesExportMetadataCall {
	c := &ProjectsLocationsServicesExportMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2exportmetadatarequest = googlecloudmetastorev2exportmetadatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesExportMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesExportMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesExportMetadataCall) Context(ctx context.Context) *ProjectsLocationsServicesExportMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesExportMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesExportMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2exportmetadatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:exportMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.exportMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesExportMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a single service.
//
//   - name: The relative resource name of the metastore service to retrieve, in
//     the following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }.
func (r *ProjectsLocationsServicesService) Get(name string) *ProjectsLocationsServicesGetCall {
	c := &ProjectsLocationsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesGetCall) Context(ctx context.Context) *ProjectsLocationsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudMetastoreV2Service.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudMetastoreV2Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudMetastoreV2Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesImportMetadataCall struct {
	s                                           *Service
	name                                        string
	googlecloudmetastorev2importmetadatarequest *GoogleCloudMetastoreV2ImportMetadataRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// ImportMetadata: Imports Metadata into a Dataproc Metastore service.
//
//   - name: Immutable. The relative resource name of the metastore service to
//     run import, in the following
//     form:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) ImportMetadata(name string, googlecloudmetastorev2importmetadatarequest *GoogleCloudMetastoreV2ImportMetadataRequest) *ProjectsLocationsServicesImportMetadataCall {
	c := &ProjectsLocationsServicesImportMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudmetastorev2importmetadatarequest = googlecloudmetastorev2importmetadatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesImportMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesImportMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesImportMetadataCall) Context(ctx context.Context) *ProjectsLocationsServicesImportMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesImportMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesImportMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2importmetadatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:importMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.importMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesImportMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists services in a project and location.
//
//   - parent: The relative resource name of the location of metastore services
//     to list, in the following
//     form:projects/{project_number}/locations/{location_id}.
func (r *ProjectsLocationsServicesService) List(parent string) *ProjectsLocationsServicesListCall {
	c := &ProjectsLocationsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter to apply to list
// results.
func (c *ProjectsLocationsServicesListCall) Filter(filter string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Specify the ordering of
// results as described in Sorting Order
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If not
// specified, the results will be sorted in the default order.
func (c *ProjectsLocationsServicesListCall) OrderBy(orderBy string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// services to return. The response may contain less than the maximum number.
// If unspecified, no more than 500 services are returned. The maximum value is
// 1000; values above 1000 are changed to 1000.
func (c *ProjectsLocationsServicesListCall) PageSize(pageSize int64) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous DataprocMetastore.ListServices call. Provide this token to
// retrieve the subsequent page.To retrieve the first page, supply an empty
// page token.When paginating, other parameters provided to
// DataprocMetastore.ListServices must match the call that provided the page
// token.
func (c *ProjectsLocationsServicesListCall) PageToken(pageToken string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesListCall) Context(ctx context.Context) *ProjectsLocationsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudMetastoreV2ListServicesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudMetastoreV2ListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudMetastoreV2ListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServicesListCall) Pages(ctx context.Context, f func(*GoogleCloudMetastoreV2ListServicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServicesMoveTableToDatabaseCall struct {
	s                                                *Service
	service                                          string
	googlecloudmetastorev2movetabletodatabaserequest *GoogleCloudMetastoreV2MoveTableToDatabaseRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// MoveTableToDatabase: Move a table to another database.
//
//   - service: The relative resource name of the metastore service to mutate
//     metadata, in the following
//     format:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) MoveTableToDatabase(service string, googlecloudmetastorev2movetabletodatabaserequest *GoogleCloudMetastoreV2MoveTableToDatabaseRequest) *ProjectsLocationsServicesMoveTableToDatabaseCall {
	c := &ProjectsLocationsServicesMoveTableToDatabaseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2movetabletodatabaserequest = googlecloudmetastorev2movetabletodatabaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesMoveTableToDatabaseCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesMoveTableToDatabaseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesMoveTableToDatabaseCall) Context(ctx context.Context) *ProjectsLocationsServicesMoveTableToDatabaseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesMoveTableToDatabaseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesMoveTableToDatabaseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2movetabletodatabaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:moveTableToDatabase")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.moveTableToDatabase" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesMoveTableToDatabaseCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesPatchCall struct {
	s                             *Service
	name                          string
	googlecloudmetastorev2service *GoogleCloudMetastoreV2Service
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Patch: Updates the parameters of a single service.
//
//   - name: Immutable. The relative resource name of the metastore service, in
//     the following
//     format:projects/{project_number}/locations/{location_id}/services/{service_
//     id}.
func (r *ProjectsLocationsServicesService) Patch(name string, googlecloudmetastorev2service *GoogleCloudMetastoreV2Service) *ProjectsLocationsServicesPatchCall {
	c := &ProjectsLocationsServicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudmetastorev2service = googlecloudmetastorev2service
	return c
}

// RequestId sets the optional parameter "requestId": A request ID. Specify a
// unique request ID to allow the server to ignore the request if it has
// completed. The server will ignore subsequent requests that provide a
// duplicate request ID for at least 60 minutes after the first request.For
// example, if an initial request times out, followed by another request with
// the same request ID, the server ignores the second request to prevent the
// creation of duplicate commitments.The request ID must be a valid UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A zero
// UUID (00000000-0000-0000-0000-000000000000) is not supported.
func (c *ProjectsLocationsServicesPatchCall) RequestId(requestId string) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A field mask
// used to specify the fields to be overwritten in the metastore service
// resource by the update. Fields specified in the update_mask are relative to
// the resource (not to the full request). A field is overwritten if it is in
// the mask.
func (c *ProjectsLocationsServicesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesPatchCall) Context(ctx context.Context) *ProjectsLocationsServicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesQueryMetadataCall struct {
	s                                          *Service
	service                                    string
	googlecloudmetastorev2querymetadatarequest *GoogleCloudMetastoreV2QueryMetadataRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// QueryMetadata: Query Dataproc Metastore metadata.
//
//   - service: The relative resource name of the metastore service to query
//     metadata, in the following
//     format:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) QueryMetadata(service string, googlecloudmetastorev2querymetadatarequest *GoogleCloudMetastoreV2QueryMetadataRequest) *ProjectsLocationsServicesQueryMetadataCall {
	c := &ProjectsLocationsServicesQueryMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2querymetadatarequest = googlecloudmetastorev2querymetadatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesQueryMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesQueryMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesQueryMetadataCall) Context(ctx context.Context) *ProjectsLocationsServicesQueryMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesQueryMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesQueryMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2querymetadatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:queryMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.queryMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesQueryMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesRestoreCall struct {
	s                                           *Service
	service                                     string
	googlecloudmetastorev2restoreservicerequest *GoogleCloudMetastoreV2RestoreServiceRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Restore: Restores a service from a backup.
//
//   - service: The relative resource name of the metastore service to run
//     restore, in the following
//     form:projects/{project_id}/locations/{location_id}/services/{service_id}.
func (r *ProjectsLocationsServicesService) Restore(service string, googlecloudmetastorev2restoreservicerequest *GoogleCloudMetastoreV2RestoreServiceRequest) *ProjectsLocationsServicesRestoreCall {
	c := &ProjectsLocationsServicesRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.service = service
	c.googlecloudmetastorev2restoreservicerequest = googlecloudmetastorev2restoreservicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesRestoreCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesRestoreCall) Context(ctx context.Context) *ProjectsLocationsServicesRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2restoreservicerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+service}:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"service": c.service,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.restore" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesRestoreCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesBackupsCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudmetastorev2backup *GoogleCloudMetastoreV2Backup
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Creates a new backup in a given project and location.
//
//   - parent: The relative resource name of the service in which to create a
//     backup of the following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }.
func (r *ProjectsLocationsServicesBackupsService) Create(parent string, googlecloudmetastorev2backup *GoogleCloudMetastoreV2Backup) *ProjectsLocationsServicesBackupsCreateCall {
	c := &ProjectsLocationsServicesBackupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudmetastorev2backup = googlecloudmetastorev2backup
	return c
}

// BackupId sets the optional parameter "backupId": Required. The ID of the
// backup, which is used as the final component of the backup's name.This value
// must be between 1 and 64 characters long, begin with a letter, end with a
// letter or number, and consist of alpha-numeric ASCII characters or hyphens.
func (c *ProjectsLocationsServicesBackupsCreateCall) BackupId(backupId string) *ProjectsLocationsServicesBackupsCreateCall {
	c.urlParams_.Set("backupId", backupId)
	return c
}

// RequestId sets the optional parameter "requestId": A request ID. Specify a
// unique request ID to allow the server to ignore the request if it has
// completed. The server will ignore subsequent requests that provide a
// duplicate request ID for at least 60 minutes after the first request.For
// example, if an initial request times out, followed by another request with
// the same request ID, the server ignores the second request to prevent the
// creation of duplicate commitments.The request ID must be a valid UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A zero
// UUID (00000000-0000-0000-0000-000000000000) is not supported.
func (c *ProjectsLocationsServicesBackupsCreateCall) RequestId(requestId string) *ProjectsLocationsServicesBackupsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesBackupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesBackupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesBackupsCreateCall) Context(ctx context.Context) *ProjectsLocationsServicesBackupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesBackupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesBackupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudmetastorev2backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.backups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesBackupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesBackupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single backup.
//
//   - name: The relative resource name of the backup to delete, in the following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }/backups/{backup_id}.
func (r *ProjectsLocationsServicesBackupsService) Delete(name string) *ProjectsLocationsServicesBackupsDeleteCall {
	c := &ProjectsLocationsServicesBackupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A request ID. Specify a
// unique request ID to allow the server to ignore the request if it has
// completed. The server will ignore subsequent requests that provide a
// duplicate request ID for at least 60 minutes after the first request.For
// example, if an initial request times out, followed by another request with
// the same request ID, the server ignores the second request to prevent the
// creation of duplicate commitments.The request ID must be a valid UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A zero
// UUID (00000000-0000-0000-0000-000000000000) is not supported.
func (c *ProjectsLocationsServicesBackupsDeleteCall) RequestId(requestId string) *ProjectsLocationsServicesBackupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesBackupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesBackupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesBackupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsServicesBackupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesBackupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesBackupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.backups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesBackupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesBackupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single backup.
//
//   - name: The relative resource name of the backup to retrieve, in the
//     following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }/backups/{backup_id}.
func (r *ProjectsLocationsServicesBackupsService) Get(name string) *ProjectsLocationsServicesBackupsGetCall {
	c := &ProjectsLocationsServicesBackupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesBackupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesBackupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesBackupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesBackupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesBackupsGetCall) Context(ctx context.Context) *ProjectsLocationsServicesBackupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesBackupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesBackupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.backups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudMetastoreV2Backup.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesBackupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudMetastoreV2Backup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudMetastoreV2Backup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLocationsServicesBackupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists backups in a service.
//
//   - parent: The relative resource name of the service whose backups to list,
//     in the following
//     form:projects/{project_number}/locations/{location_id}/services/{service_id
//     }/backups.
func (r *ProjectsLocationsServicesBackupsService) List(parent string) *ProjectsLocationsServicesBackupsListCall {
	c := &ProjectsLocationsServicesBackupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter to apply to list
// results.
func (c *ProjectsLocationsServicesBackupsListCall) Filter(filter string) *ProjectsLocationsServicesBackupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Specify the ordering of
// results as described in Sorting Order
// (https://cloud.google.com/apis/design/design_patterns#sorting_order). If not
// specified, the results will be sorted in the default order.
func (c *ProjectsLocationsServicesBackupsListCall) OrderBy(orderBy string) *ProjectsLocationsServicesBackupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// backups to return. The response may contain less than the maximum number. If
// unspecified, no more than 500 backups are returned. The maximum value is
// 1000; values above 1000 are changed to 1000.
func (c *ProjectsLocationsServicesBackupsListCall) PageSize(pageSize int64) *ProjectsLocationsServicesBackupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous DataprocMetastore.ListBackups call. Provide this token to
// retrieve the subsequent page.To retrieve the first page, supply an empty
// page token.When paginating, other parameters provided to
// DataprocMetastore.ListBackups must match the call that provided the page
// token.
func (c *ProjectsLocationsServicesBackupsListCall) PageToken(pageToken string) *ProjectsLocationsServicesBackupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesBackupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesBackupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesBackupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesBackupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesBackupsListCall) Context(ctx context.Context) *ProjectsLocationsServicesBackupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesBackupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesBackupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "metastore.projects.locations.services.backups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudMetastoreV2ListBackupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesBackupsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudMetastoreV2ListBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudMetastoreV2ListBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServicesBackupsListCall) Pages(ctx context.Context, f func(*GoogleCloudMetastoreV2ListBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
