// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package forms provides access to the Google Forms API.
//
// For product documentation, see: https://developers.google.com/workspace/forms/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/forms/v1"
//	...
//	ctx := context.Background()
//	formsService, err := forms.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	formsService, err := forms.NewService(ctx, option.WithScopes(forms.FormsResponsesReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	formsService, err := forms.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	formsService, err := forms.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package forms // import "google.golang.org/api/forms/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "forms:v1"
const apiName = "forms"
const apiVersion = "v1"
const basePath = "https://forms.googleapis.com/"
const basePathTemplate = "https://forms.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://forms.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, create, and delete all of your Google Drive files
	DriveScope = "https://www.googleapis.com/auth/drive"

	// See, edit, create, and delete only the specific Google Drive files you use
	// with this app
	DriveFileScope = "https://www.googleapis.com/auth/drive.file"

	// See and download all your Google Drive files
	DriveReadonlyScope = "https://www.googleapis.com/auth/drive.readonly"

	// See, edit, create, and delete all your Google Forms forms
	FormsBodyScope = "https://www.googleapis.com/auth/forms.body"

	// See all your Google Forms forms
	FormsBodyReadonlyScope = "https://www.googleapis.com/auth/forms.body.readonly"

	// See all responses to your Google Forms forms
	FormsResponsesReadonlyScope = "https://www.googleapis.com/auth/forms.responses.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/drive",
		"https://www.googleapis.com/auth/drive.file",
		"https://www.googleapis.com/auth/drive.readonly",
		"https://www.googleapis.com/auth/forms.body",
		"https://www.googleapis.com/auth/forms.body.readonly",
		"https://www.googleapis.com/auth/forms.responses.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Forms = NewFormsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Forms *FormsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFormsService(s *Service) *FormsService {
	rs := &FormsService{s: s}
	rs.Responses = NewFormsResponsesService(s)
	rs.Watches = NewFormsWatchesService(s)
	return rs
}

type FormsService struct {
	s *Service

	Responses *FormsResponsesService

	Watches *FormsWatchesService
}

func NewFormsResponsesService(s *Service) *FormsResponsesService {
	rs := &FormsResponsesService{s: s}
	return rs
}

type FormsResponsesService struct {
	s *Service
}

func NewFormsWatchesService(s *Service) *FormsWatchesService {
	rs := &FormsWatchesService{s: s}
	return rs
}

type FormsWatchesService struct {
	s *Service
}

// Answer: The submitted answer for a question.
type Answer struct {
	// FileUploadAnswers: Output only. The answers to a file upload question.
	FileUploadAnswers *FileUploadAnswers `json:"fileUploadAnswers,omitempty"`
	// Grade: Output only. The grade for the answer if the form was a quiz.
	Grade *Grade `json:"grade,omitempty"`
	// QuestionId: Output only. The question's ID. See also Question.question_id.
	QuestionId string `json:"questionId,omitempty"`
	// TextAnswers: Output only. The specific answers as text.
	TextAnswers *TextAnswers `json:"textAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileUploadAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileUploadAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Answer) MarshalJSON() ([]byte, error) {
	type NoMethod Answer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateFormRequest: A batch of updates to perform on a form. All the
// specified updates are made or none of them are.
type BatchUpdateFormRequest struct {
	// IncludeFormInResponse: Whether to return an updated version of the model in
	// the response.
	IncludeFormInResponse bool `json:"includeFormInResponse,omitempty"`
	// Requests: Required. The update requests of this batch.
	Requests []*Request `json:"requests,omitempty"`
	// WriteControl: Provides control over how write requests are executed.
	WriteControl *WriteControl `json:"writeControl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeFormInResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeFormInResponse") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateFormRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateFormRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchUpdateFormResponse: Response to a BatchUpdateFormRequest.
type BatchUpdateFormResponse struct {
	// Form: Based on the bool request field `include_form_in_response`, a form
	// with all applied mutations/updates is returned or not. This may be later
	// than the revision ID created by these changes.
	Form *Form `json:"form,omitempty"`
	// Replies: The reply of the updates. This maps 1:1 with the update requests,
	// although replies to some requests may be empty.
	Replies []*Response `json:"replies,omitempty"`
	// WriteControl: The updated write control after applying the request.
	WriteControl *WriteControl `json:"writeControl,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Form") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Form") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchUpdateFormResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchUpdateFormResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChoiceQuestion: A radio/checkbox/dropdown question.
type ChoiceQuestion struct {
	// Options: Required. List of options that a respondent must choose from.
	Options []*Option `json:"options,omitempty"`
	// Shuffle: Whether the options should be displayed in random order for
	// different instances of the quiz. This is often used to prevent cheating by
	// respondents who might be looking at another respondent's screen, or to
	// address bias in a survey that might be introduced by always putting the same
	// options first or last.
	Shuffle bool `json:"shuffle,omitempty"`
	// Type: Required. The type of choice question.
	//
	// Possible values:
	//   "CHOICE_TYPE_UNSPECIFIED" - Default value. Unused.
	//   "RADIO" - Radio buttons: All choices are shown to the user, who can only
	// pick one of them.
	//   "CHECKBOX" - Checkboxes: All choices are shown to the user, who can pick
	// any number of them.
	//   "DROP_DOWN" - Drop-down menu: The choices are only shown to the user on
	// demand, otherwise only the current choice is shown. Only one option can be
	// chosen.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChoiceQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod ChoiceQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudPubsubTopic: A Pub/Sub topic.
type CloudPubsubTopic struct {
	// TopicName: Required. A fully qualified Pub/Sub topic name to publish the
	// events to. This topic must be owned by the calling project and already exist
	// in Pub/Sub.
	TopicName string `json:"topicName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TopicName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TopicName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudPubsubTopic) MarshalJSON() ([]byte, error) {
	type NoMethod CloudPubsubTopic
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CorrectAnswer: A single correct answer for a question. For multiple-valued
// (`CHECKBOX`) questions, several `CorrectAnswer`s may be needed to represent
// a single correct response option.
type CorrectAnswer struct {
	// Value: Required. The correct answer value. See the documentation for
	// TextAnswer.value for details on how various value types are formatted.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CorrectAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod CorrectAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CorrectAnswers: The answer key for a question.
type CorrectAnswers struct {
	// Answers: A list of correct answers. A quiz response can be automatically
	// graded based on these answers. For single-valued questions, a response is
	// marked correct if it matches any value in this list (in other words,
	// multiple correct answers are possible). For multiple-valued (`CHECKBOX`)
	// questions, a response is marked correct if it contains exactly the values in
	// this list.
	Answers []*CorrectAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CorrectAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod CorrectAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateItemRequest: Create an item in a form.
type CreateItemRequest struct {
	// Item: Required. The item to create.
	Item *Item `json:"item,omitempty"`
	// Location: Required. Where to place the new item.
	Location *Location `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateItemRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateItemResponse: The result of creating an item.
type CreateItemResponse struct {
	// ItemId: The ID of the created item.
	ItemId string `json:"itemId,omitempty"`
	// QuestionId: The ID of the question created as part of this item, for a
	// question group it lists IDs of all the questions created for this item.
	QuestionId []string `json:"questionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ItemId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ItemId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateItemResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CreateItemResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateWatchRequest: Create a new watch.
type CreateWatchRequest struct {
	// Watch: Required. The watch object. No ID should be set on this object; use
	// `watch_id` instead.
	Watch *Watch `json:"watch,omitempty"`
	// WatchId: The ID to use for the watch. If specified, the ID must not already
	// be in use. If not specified, an ID is generated. This value should be 4-63
	// characters, and valid characters are /a-z-/.
	WatchId string `json:"watchId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Watch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Watch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateWatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateWatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateQuestion: A date question. Date questions default to just month + day.
type DateQuestion struct {
	// IncludeTime: Whether to include the time as part of the question.
	IncludeTime bool `json:"includeTime,omitempty"`
	// IncludeYear: Whether to include the year as part of the question.
	IncludeYear bool `json:"includeYear,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod DateQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteItemRequest: Delete an item in a form.
type DeleteItemRequest struct {
	// Location: Required. The location of the item to delete.
	Location *Location `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteItemRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExtraMaterial: Supplementary material to the feedback.
type ExtraMaterial struct {
	// Link: Text feedback.
	Link *TextLink `json:"link,omitempty"`
	// Video: Video feedback.
	Video *VideoLink `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Link") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Link") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExtraMaterial) MarshalJSON() ([]byte, error) {
	type NoMethod ExtraMaterial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Feedback: Feedback for a respondent about their response to a question.
type Feedback struct {
	// Material: Additional information provided as part of the feedback, often
	// used to point the respondent to more reading and resources.
	Material []*ExtraMaterial `json:"material,omitempty"`
	// Text: Required. The main text of the feedback.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Material") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Material") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feedback) MarshalJSON() ([]byte, error) {
	type NoMethod Feedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileUploadAnswer: Info for a single file submitted to a file upload
// question.
type FileUploadAnswer struct {
	// FileId: Output only. The ID of the Google Drive file.
	FileId string `json:"fileId,omitempty"`
	// FileName: Output only. The file name, as stored in Google Drive on upload.
	FileName string `json:"fileName,omitempty"`
	// MimeType: Output only. The MIME type of the file, as stored in Google Drive
	// on upload.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileUploadAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod FileUploadAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileUploadAnswers: All submitted files for a FileUpload question.
type FileUploadAnswers struct {
	// Answers: Output only. All submitted files for a FileUpload question.
	Answers []*FileUploadAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileUploadAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod FileUploadAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileUploadQuestion: A file upload question. The API currently does not
// support creating file upload questions.
type FileUploadQuestion struct {
	// FolderId: Required. The ID of the Drive folder where uploaded files are
	// stored.
	FolderId string `json:"folderId,omitempty"`
	// MaxFileSize: Maximum number of bytes allowed for any single file uploaded to
	// this question.
	MaxFileSize int64 `json:"maxFileSize,omitempty,string"`
	// MaxFiles: Maximum number of files that can be uploaded for this question in
	// a single response.
	MaxFiles int64 `json:"maxFiles,omitempty"`
	// Types: File types accepted by this question.
	//
	// Possible values:
	//   "FILE_TYPE_UNSPECIFIED" - Default value. Unused.
	//   "ANY" - No restrictions on type.
	//   "DOCUMENT" - A Google Docs document.
	//   "PRESENTATION" - A Google Slides presentation.
	//   "SPREADSHEET" - A Google Sheets spreadsheet.
	//   "DRAWING" - A drawing.
	//   "PDF" - A PDF.
	//   "IMAGE" - An image.
	//   "VIDEO" - A video.
	//   "AUDIO" - An audio file.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FolderId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FolderId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileUploadQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod FileUploadQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Form: A Google Forms document. A form is created in Drive, and deleting a
// form or changing its access protections is done via the Drive API
// (https://developers.google.com/drive/api/v3/about-sdk).
type Form struct {
	// FormId: Output only. The form ID.
	FormId string `json:"formId,omitempty"`
	// Info: Required. The title and description of the form.
	Info *Info `json:"info,omitempty"`
	// Items: Required. A list of the form's items, which can include section
	// headers, questions, embedded media, etc.
	Items []*Item `json:"items,omitempty"`
	// LinkedSheetId: Output only. The ID of the linked Google Sheet which is
	// accumulating responses from this Form (if such a Sheet exists).
	LinkedSheetId string `json:"linkedSheetId,omitempty"`
	// PublishSettings: Output only. The publishing settings for a form. This field
	// isn't set for legacy forms because they don't have the `publish_settings`
	// field. All newly created forms support publish settings. Forms with
	// `publish_settings` value set can call SetPublishSettings API to publish or
	// unpublish the form.
	PublishSettings *PublishSettings `json:"publishSettings,omitempty"`
	// ResponderUri: Output only. The form URI to share with responders. This opens
	// a page that allows the user to submit responses but not edit the questions.
	// For forms that have `publish_settings` value set, this is the published form
	// URI.
	ResponderUri string `json:"responderUri,omitempty"`
	// RevisionId: Output only. The revision ID of the form. Used in the
	// WriteControl in update requests to identify the revision on which the
	// changes are based. The format of the revision ID may change over time, so it
	// should be treated opaquely. A returned revision ID is only guaranteed to be
	// valid for 24 hours after it has been returned and cannot be shared across
	// users. If the revision ID is unchanged between calls, then the form
	// *content* has not changed. Conversely, a changed ID (for the same form and
	// user) usually means the form *content* has been updated; however, a changed
	// ID can also be due to internal factors such as ID format changes. Form
	// content excludes form metadata, including: * sharing settings (who has
	// access to the form) * `publish_settings` (if the form supports publishing
	// and if it is published)
	RevisionId string `json:"revisionId,omitempty"`
	// Settings: The form's settings. This must be updated with
	// UpdateSettingsRequest; it is ignored during `forms.create` and
	// UpdateFormInfoRequest.
	Settings *FormSettings `json:"settings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FormId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FormId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Form) MarshalJSON() ([]byte, error) {
	type NoMethod Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FormResponse: A form response.
type FormResponse struct {
	// Answers: Output only. The actual answers to the questions, keyed by
	// question_id.
	Answers map[string]Answer `json:"answers,omitempty"`
	// CreateTime: Output only. Timestamp for the first time the response was
	// submitted.
	CreateTime string `json:"createTime,omitempty"`
	// FormId: Output only. The form ID.
	FormId string `json:"formId,omitempty"`
	// LastSubmittedTime: Output only. Timestamp for the most recent time the
	// response was submitted. Does not track changes to grades.
	LastSubmittedTime string `json:"lastSubmittedTime,omitempty"`
	// RespondentEmail: Output only. The email address (if collected) for the
	// respondent.
	RespondentEmail string `json:"respondentEmail,omitempty"`
	// ResponseId: Output only. The response ID.
	ResponseId string `json:"responseId,omitempty"`
	// TotalScore: Output only. The total number of points the respondent received
	// for their submission Only set if the form was a quiz and the response was
	// graded. This includes points automatically awarded via autograding adjusted
	// by any manual corrections entered by the form owner.
	TotalScore float64 `json:"totalScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FormResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FormResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *FormResponse) UnmarshalJSON(data []byte) error {
	type NoMethod FormResponse
	var s1 struct {
		TotalScore gensupport.JSONFloat64 `json:"totalScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TotalScore = float64(s1.TotalScore)
	return nil
}

// FormSettings: A form's settings.
type FormSettings struct {
	// EmailCollectionType: Optional. The setting that determines whether the form
	// collects email addresses from respondents.
	//
	// Possible values:
	//   "EMAIL_COLLECTION_TYPE_UNSPECIFIED" - Unspecified. This value is unused.
	//   "DO_NOT_COLLECT" - The form doesn't collect email addresses. Default value
	// if the form owner uses a Google account.
	//   "VERIFIED" - The form collects email addresses automatically based on the
	// account of the signed-in user. Default value if the form owner uses a Google
	// Workspace account.
	//   "RESPONDER_INPUT" - The form collects email addresses using a field that
	// the respondent completes on the form.
	EmailCollectionType string `json:"emailCollectionType,omitempty"`
	// QuizSettings: Settings related to quiz forms and grading.
	QuizSettings *QuizSettings `json:"quizSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailCollectionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailCollectionType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FormSettings) MarshalJSON() ([]byte, error) {
	type NoMethod FormSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Grade: Grade information associated with a respondent's answer to a
// question.
type Grade struct {
	// Correct: Output only. Whether the question was answered correctly or not. A
	// zero-point score is not enough to infer incorrectness, since a correctly
	// answered question could be worth zero points.
	Correct bool `json:"correct,omitempty"`
	// Feedback: Output only. Additional feedback given for an answer.
	Feedback *Feedback `json:"feedback,omitempty"`
	// Score: Output only. The numeric score awarded for the answer.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Correct") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Correct") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Grade) MarshalJSON() ([]byte, error) {
	type NoMethod Grade
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Grade) UnmarshalJSON(data []byte) error {
	type NoMethod Grade
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// Grading: Grading for a single question
type Grading struct {
	// CorrectAnswers: Required. The answer key for the question. Responses are
	// automatically graded based on this field.
	CorrectAnswers *CorrectAnswers `json:"correctAnswers,omitempty"`
	// GeneralFeedback: The feedback displayed for all answers. This is commonly
	// used for short answer questions when a quiz owner wants to quickly give
	// respondents some sense of whether they answered the question correctly
	// before they've had a chance to officially grade the response. General
	// feedback cannot be set for automatically graded multiple choice questions.
	GeneralFeedback *Feedback `json:"generalFeedback,omitempty"`
	// PointValue: Required. The maximum number of points a respondent can
	// automatically get for a correct answer. This must not be negative.
	PointValue int64 `json:"pointValue,omitempty"`
	// WhenRight: The feedback displayed for correct responses. This feedback can
	// only be set for multiple choice questions that have correct answers
	// provided.
	WhenRight *Feedback `json:"whenRight,omitempty"`
	// WhenWrong: The feedback displayed for incorrect responses. This feedback can
	// only be set for multiple choice questions that have correct answers
	// provided.
	WhenWrong *Feedback `json:"whenWrong,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorrectAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorrectAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Grading) MarshalJSON() ([]byte, error) {
	type NoMethod Grading
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Grid: A grid of choices (radio or check boxes) with each row constituting a
// separate question. Each row has the same choices, which are shown as the
// columns.
type Grid struct {
	// Columns: Required. The choices shared by each question in the grid. In other
	// words, the values of the columns. Only `CHECK_BOX` and `RADIO` choices are
	// allowed.
	Columns *ChoiceQuestion `json:"columns,omitempty"`
	// ShuffleQuestions: If `true`, the questions are randomly ordered. In other
	// words, the rows appear in a different order for every respondent.
	ShuffleQuestions bool `json:"shuffleQuestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Grid) MarshalJSON() ([]byte, error) {
	type NoMethod Grid
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Image: Data representing an image.
type Image struct {
	// AltText: A description of the image that is shown on hover and read by
	// screenreaders.
	AltText string `json:"altText,omitempty"`
	// ContentUri: Output only. A URI from which you can download the image; this
	// is valid only for a limited time.
	ContentUri string `json:"contentUri,omitempty"`
	// Properties: Properties of an image.
	Properties *MediaProperties `json:"properties,omitempty"`
	// SourceUri: Input only. The source URI is the URI used to insert the image.
	// The source URI can be empty when fetched.
	SourceUri string `json:"sourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AltText") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AltText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageItem: An item containing an image.
type ImageItem struct {
	// Image: Required. The image displayed in the item.
	Image *Image `json:"image,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageItem) MarshalJSON() ([]byte, error) {
	type NoMethod ImageItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Info: The general information for a form.
type Info struct {
	// Description: The description of the form.
	Description string `json:"description,omitempty"`
	// DocumentTitle: Output only. The title of the document which is visible in
	// Drive. If `Info.title` is empty, `document_title` may appear in its place in
	// the Google Forms UI and be visible to responders. `document_title` can be
	// set on create, but cannot be modified by a batchUpdate request. Please use
	// the Google Drive API
	// (https://developers.google.com/drive/api/v3/reference/files/update) if you
	// need to programmatically update `document_title`.
	DocumentTitle string `json:"documentTitle,omitempty"`
	// Title: Required. The title of the form which is visible to responders.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Info) MarshalJSON() ([]byte, error) {
	type NoMethod Info
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Item: A single item of the form. `kind` defines which kind of item it is.
type Item struct {
	// Description: The description of the item.
	Description string `json:"description,omitempty"`
	// ImageItem: Displays an image on the page.
	ImageItem *ImageItem `json:"imageItem,omitempty"`
	// ItemId: The item ID. On creation, it can be provided but the ID must not be
	// already used in the form. If not provided, a new ID is assigned.
	ItemId string `json:"itemId,omitempty"`
	// PageBreakItem: Starts a new page with a title.
	PageBreakItem *PageBreakItem `json:"pageBreakItem,omitempty"`
	// QuestionGroupItem: Poses one or more questions to the user with a single
	// major prompt.
	QuestionGroupItem *QuestionGroupItem `json:"questionGroupItem,omitempty"`
	// QuestionItem: Poses a question to the user.
	QuestionItem *QuestionItem `json:"questionItem,omitempty"`
	// TextItem: Displays a title and description on the page.
	TextItem *TextItem `json:"textItem,omitempty"`
	// Title: The title of the item.
	Title string `json:"title,omitempty"`
	// VideoItem: Displays a video on the page.
	VideoItem *VideoItem `json:"videoItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Item) MarshalJSON() ([]byte, error) {
	type NoMethod Item
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListFormResponsesResponse: Response to a ListFormResponsesRequest.
type ListFormResponsesResponse struct {
	// NextPageToken: If set, there are more responses. To get the next page of
	// responses, provide this as `page_token` in a future request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Responses: The returned form responses. Note: The `formId` field is not
	// returned in the `FormResponse` object for list requests.
	Responses []*FormResponse `json:"responses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListFormResponsesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFormResponsesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWatchesResponse: The response of a ListWatchesRequest.
type ListWatchesResponse struct {
	// Watches: The returned watches.
	Watches []*Watch `json:"watches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Watches") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Watches") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWatchesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWatchesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A specific location in a form.
type Location struct {
	// Index: The index of an item in the form. This must be in the range [0..*N*),
	// where *N* is the number of items in the form.
	Index int64 `json:"index,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MediaProperties: Properties of the media.
type MediaProperties struct {
	// Alignment: Position of the media.
	//
	// Possible values:
	//   "ALIGNMENT_UNSPECIFIED" - Default value. Unused.
	//   "LEFT" - Left align.
	//   "RIGHT" - Right align.
	//   "CENTER" - Center.
	Alignment string `json:"alignment,omitempty"`
	// Width: The width of the media in pixels. When the media is displayed, it is
	// scaled to the smaller of this value or the width of the displayed form. The
	// original aspect ratio of the media is preserved. If a width is not specified
	// when the media is added to the form, it is set to the width of the media
	// source. Width must be between 0 and 740, inclusive. Setting width to 0 or
	// unspecified is only permitted when updating the media source.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alignment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MediaProperties) MarshalJSON() ([]byte, error) {
	type NoMethod MediaProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MoveItemRequest: Move an item in a form.
type MoveItemRequest struct {
	// NewLocation: Required. The new location for the item.
	NewLocation *Location `json:"newLocation,omitempty"`
	// OriginalLocation: Required. The location of the item to move.
	OriginalLocation *Location `json:"originalLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewLocation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MoveItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod MoveItemRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Option: An option for a Choice question.
type Option struct {
	// GoToAction: Section navigation type.
	//
	// Possible values:
	//   "GO_TO_ACTION_UNSPECIFIED" - Default value. Unused.
	//   "NEXT_SECTION" - Go to the next section.
	//   "RESTART_FORM" - Go back to the beginning of the form.
	//   "SUBMIT_FORM" - Submit form immediately.
	GoToAction string `json:"goToAction,omitempty"`
	// GoToSectionId: Item ID of section header to go to.
	GoToSectionId string `json:"goToSectionId,omitempty"`
	// Image: Display image as an option.
	Image *Image `json:"image,omitempty"`
	// IsOther: Whether the option is "other". Currently only applies to `RADIO`
	// and `CHECKBOX` choice types, but is not allowed in a QuestionGroupItem.
	IsOther bool `json:"isOther,omitempty"`
	// Value: Required. The choice as presented to the user.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoToAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoToAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Option) MarshalJSON() ([]byte, error) {
	type NoMethod Option
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PageBreakItem: A page break. The title and description of this item are
// shown at the top of the new page.
type PageBreakItem struct {
}

// PublishSettings: The publishing settings of a form.
type PublishSettings struct {
	// PublishState: Optional. The publishing state of a form. When updating
	// `publish_state`, both `is_published` and `is_accepting_responses` must be
	// set. However, setting `is_accepting_responses` to `true` and `is_published`
	// to `false` isn't supported and returns an error.
	PublishState *PublishState `json:"publishState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublishState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublishState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PublishSettings) MarshalJSON() ([]byte, error) {
	type NoMethod PublishSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PublishState: The publishing state of a form.
type PublishState struct {
	// IsAcceptingResponses: Required. Whether the form accepts responses. If
	// `is_published` is set to `false`, this field is forced to `false`.
	IsAcceptingResponses bool `json:"isAcceptingResponses,omitempty"`
	// IsPublished: Required. Whether the form is published and visible to others.
	IsPublished bool `json:"isPublished,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsAcceptingResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsAcceptingResponses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PublishState) MarshalJSON() ([]byte, error) {
	type NoMethod PublishState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Question: Any question. The specific type of question is known by its
// `kind`.
type Question struct {
	// ChoiceQuestion: A respondent can choose from a pre-defined set of options.
	ChoiceQuestion *ChoiceQuestion `json:"choiceQuestion,omitempty"`
	// DateQuestion: A respondent can enter a date.
	DateQuestion *DateQuestion `json:"dateQuestion,omitempty"`
	// FileUploadQuestion: A respondent can upload one or more files.
	FileUploadQuestion *FileUploadQuestion `json:"fileUploadQuestion,omitempty"`
	// Grading: Grading setup for the question.
	Grading *Grading `json:"grading,omitempty"`
	// QuestionId: Read only. The question ID. On creation, it can be provided but
	// the ID must not be already used in the form. If not provided, a new ID is
	// assigned.
	QuestionId string `json:"questionId,omitempty"`
	// RatingQuestion: A respondent can choose a rating from a pre-defined set of
	// icons.
	RatingQuestion *RatingQuestion `json:"ratingQuestion,omitempty"`
	// Required: Whether the question must be answered in order for a respondent to
	// submit their response.
	Required bool `json:"required,omitempty"`
	// RowQuestion: A row of a QuestionGroupItem.
	RowQuestion *RowQuestion `json:"rowQuestion,omitempty"`
	// ScaleQuestion: A respondent can choose a number from a range.
	ScaleQuestion *ScaleQuestion `json:"scaleQuestion,omitempty"`
	// TextQuestion: A respondent can enter a free text response.
	TextQuestion *TextQuestion `json:"textQuestion,omitempty"`
	// TimeQuestion: A respondent can enter a time.
	TimeQuestion *TimeQuestion `json:"timeQuestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChoiceQuestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChoiceQuestion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Question) MarshalJSON() ([]byte, error) {
	type NoMethod Question
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QuestionGroupItem: Defines a question that comprises multiple questions
// grouped together.
type QuestionGroupItem struct {
	// Grid: The question group is a grid with rows of multiple choice questions
	// that share the same options. When `grid` is set, all questions in the group
	// must be of kind `row`.
	Grid *Grid `json:"grid,omitempty"`
	// Image: The image displayed within the question group above the specific
	// questions.
	Image *Image `json:"image,omitempty"`
	// Questions: Required. A list of questions that belong in this question group.
	// A question must only belong to one group. The `kind` of the group may affect
	// what types of questions are allowed.
	Questions []*Question `json:"questions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Grid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Grid") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QuestionGroupItem) MarshalJSON() ([]byte, error) {
	type NoMethod QuestionGroupItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QuestionItem: A form item containing a single question.
type QuestionItem struct {
	// Image: The image displayed within the question.
	Image *Image `json:"image,omitempty"`
	// Question: Required. The displayed question.
	Question *Question `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QuestionItem) MarshalJSON() ([]byte, error) {
	type NoMethod QuestionItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QuizSettings: Settings related to quiz forms and grading. These must be
// updated with the UpdateSettingsRequest.
type QuizSettings struct {
	// IsQuiz: Whether this form is a quiz or not. When true, responses are graded
	// based on question Grading. Upon setting to false, all question Grading is
	// deleted.
	IsQuiz bool `json:"isQuiz,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsQuiz") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsQuiz") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QuizSettings) MarshalJSON() ([]byte, error) {
	type NoMethod QuizSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RatingQuestion: A rating question. The user has a range of icons to choose
// from.
type RatingQuestion struct {
	// IconType: Required. The icon type to use for the rating.
	//
	// Possible values:
	//   "RATING_ICON_TYPE_UNSPECIFIED" - Default value. Unused.
	//   "STAR" - A star icon.
	//   "HEART" - A heart icon.
	//   "THUMB_UP" - A thumbs down icon.
	IconType string `json:"iconType,omitempty"`
	// RatingScaleLevel: Required. The rating scale level of the rating question.
	RatingScaleLevel int64 `json:"ratingScaleLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IconType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IconType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RatingQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod RatingQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RenewWatchRequest: Renew an existing Watch for seven days.
type RenewWatchRequest struct {
}

// Request: The kinds of update requests that can be made.
type Request struct {
	// CreateItem: Create a new item.
	CreateItem *CreateItemRequest `json:"createItem,omitempty"`
	// DeleteItem: Delete an item.
	DeleteItem *DeleteItemRequest `json:"deleteItem,omitempty"`
	// MoveItem: Move an item to a specified location.
	MoveItem *MoveItemRequest `json:"moveItem,omitempty"`
	// UpdateFormInfo: Update Form's Info.
	UpdateFormInfo *UpdateFormInfoRequest `json:"updateFormInfo,omitempty"`
	// UpdateItem: Update an item.
	UpdateItem *UpdateItemRequest `json:"updateItem,omitempty"`
	// UpdateSettings: Updates the Form's settings.
	UpdateSettings *UpdateSettingsRequest `json:"updateSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Request) MarshalJSON() ([]byte, error) {
	type NoMethod Request
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Response: A single response from an update.
type Response struct {
	// CreateItem: The result of creating an item.
	CreateItem *CreateItemResponse `json:"createItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Response) MarshalJSON() ([]byte, error) {
	type NoMethod Response
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RowQuestion: Configuration for a question that is part of a question group.
type RowQuestion struct {
	// Title: Required. The title for the single row in the QuestionGroupItem.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RowQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod RowQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScaleQuestion: A scale question. The user has a range of numeric values to
// choose from.
type ScaleQuestion struct {
	// High: Required. The highest possible value for the scale.
	High int64 `json:"high,omitempty"`
	// HighLabel: The label to display describing the highest point on the scale.
	HighLabel string `json:"highLabel,omitempty"`
	// Low: Required. The lowest possible value for the scale.
	Low int64 `json:"low,omitempty"`
	// LowLabel: The label to display describing the lowest point on the scale.
	LowLabel string `json:"lowLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "High") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "High") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScaleQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod ScaleQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetPublishSettingsRequest: Updates the publish settings of a Form.
type SetPublishSettingsRequest struct {
	// PublishSettings: Required. The desired publish settings to apply to the
	// form.
	PublishSettings *PublishSettings `json:"publishSettings,omitempty"`
	// UpdateMask: Optional. The `publish_settings` fields to update. This field
	// mask accepts the following values: * `publish_state`: Updates or replaces
	// all `publish_state` settings. * "*": Updates or replaces all
	// `publish_settings` fields.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublishSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublishSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetPublishSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetPublishSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetPublishSettingsResponse: The response of a `SetPublishSettings` request.
type SetPublishSettingsResponse struct {
	// FormId: Required. The ID of the Form. This is same as the `Form.form_id`
	// field.
	FormId string `json:"formId,omitempty"`
	// PublishSettings: The publish settings of the form.
	PublishSettings *PublishSettings `json:"publishSettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FormId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FormId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetPublishSettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SetPublishSettingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextAnswer: An answer to a question represented as text.
type TextAnswer struct {
	// Value: Output only. The answer value. Formatting used for different kinds of
	// question: * ChoiceQuestion * `RADIO` or `DROP_DOWN`: A single string
	// corresponding to the option that was selected. * `CHECKBOX`: Multiple
	// strings corresponding to each option that was selected. * TextQuestion: The
	// text that the user entered. * ScaleQuestion: A string containing the number
	// that was selected. * DateQuestion * Without time or year: MM-DD e.g. "05-19"
	// * With year: YYYY-MM-DD e.g. "1986-05-19" * With time: MM-DD HH:MM e.g.
	// "05-19 14:51" * With year and time: YYYY-MM-DD HH:MM e.g. "1986-05-19 14:51"
	// * TimeQuestion: String with time or duration in HH:MM format e.g. "14:51" *
	// RowQuestion within QuestionGroupItem: The answer for each row of a
	// QuestionGroupItem is represented as a separate Answer. Each will contain one
	// string for `RADIO`-type choices or multiple strings for `CHECKBOX` choices.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod TextAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextAnswers: A question's answers as text.
type TextAnswers struct {
	// Answers: Output only. Answers to a question. For multiple-value
	// ChoiceQuestions, each answer is a separate value.
	Answers []*TextAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod TextAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextItem: A text item.
type TextItem struct {
}

// TextLink: Link for text.
type TextLink struct {
	// DisplayText: Required. Display text for the URI.
	DisplayText string `json:"displayText,omitempty"`
	// Uri: Required. The URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextLink) MarshalJSON() ([]byte, error) {
	type NoMethod TextLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TextQuestion: A text-based question.
type TextQuestion struct {
	// Paragraph: Whether the question is a paragraph question or not. If not, the
	// question is a short text question.
	Paragraph bool `json:"paragraph,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paragraph") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paragraph") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TextQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod TextQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeQuestion: A time question.
type TimeQuestion struct {
	// Duration: `true` if the question is about an elapsed time. Otherwise it is
	// about a time of day.
	Duration bool `json:"duration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod TimeQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateFormInfoRequest: Update Form's Info.
type UpdateFormInfoRequest struct {
	// Info: The info to update.
	Info *Info `json:"info,omitempty"`
	// UpdateMask: Required. Only values named in this mask are changed. At least
	// one field must be specified. The root `info` is implied and should not be
	// specified. A single "*" can be used as short-hand for updating every
	// field.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Info") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Info") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateFormInfoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateFormInfoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateItemRequest: Update an item in a form.
type UpdateItemRequest struct {
	// Item: Required. New values for the item. Note that item and question IDs are
	// used if they are provided (and are in the field mask). If an ID is blank
	// (and in the field mask) a new ID is generated. This means you can modify an
	// item by getting the form via forms.get, modifying your local copy of that
	// item to be how you want it, and using UpdateItemRequest to write it back,
	// with the IDs being the same (or not in the field mask).
	Item *Item `json:"item,omitempty"`
	// Location: Required. The location identifying the item to update.
	Location *Location `json:"location,omitempty"`
	// UpdateMask: Required. Only values named in this mask are changed.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateItemRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateItemRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateSettingsRequest: Update Form's FormSettings.
type UpdateSettingsRequest struct {
	// Settings: Required. The settings to update with.
	Settings *FormSettings `json:"settings,omitempty"`
	// UpdateMask: Required. Only values named in this mask are changed. At least
	// one field must be specified. The root `settings` is implied and should not
	// be specified. A single "*" can be used as short-hand for updating every
	// field.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Settings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Settings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Video: Data representing a video.
type Video struct {
	// Properties: Properties of a video.
	Properties *MediaProperties `json:"properties,omitempty"`
	// YoutubeUri: Required. A YouTube URI.
	YoutubeUri string `json:"youtubeUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Properties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Properties") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Video) MarshalJSON() ([]byte, error) {
	type NoMethod Video
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VideoItem: An item containing a video.
type VideoItem struct {
	// Caption: The text displayed below the video.
	Caption string `json:"caption,omitempty"`
	// Video: Required. The video displayed in the item.
	Video *Video `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Caption") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Caption") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VideoItem) MarshalJSON() ([]byte, error) {
	type NoMethod VideoItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VideoLink: Link to a video.
type VideoLink struct {
	// DisplayText: Required. The display text for the link.
	DisplayText string `json:"displayText,omitempty"`
	// YoutubeUri: The URI of a YouTube video.
	YoutubeUri string `json:"youtubeUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VideoLink) MarshalJSON() ([]byte, error) {
	type NoMethod VideoLink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Watch: A watch for events for a form. When the designated event happens, a
// notification will be published to the specified target. The notification's
// attributes will include a `formId` key that has the ID of the watched form
// and an `eventType` key that has the string of the type. Messages are sent
// with at-least-once delivery and are only dropped in extraordinary
// circumstances. Typically all notifications should be reliably delivered
// within a few seconds; however, in some situations notifications may be
// delayed. A watch expires seven days after it is created unless it is renewed
// with watches.renew
type Watch struct {
	// CreateTime: Output only. Timestamp of when this was created.
	CreateTime string `json:"createTime,omitempty"`
	// ErrorType: Output only. The most recent error type for an attempted
	// delivery. To begin watching the form again a call can be made to
	// watches.renew which also clears this error information.
	//
	// Possible values:
	//   "ERROR_TYPE_UNSPECIFIED" - Unspecified error type.
	//   "PROJECT_NOT_AUTHORIZED" - The cloud project does not have access to the
	// form being watched. This occurs if the user has revoked the authorization
	// for your project to access their form(s). Watches with this error will not
	// be retried. To attempt to begin watching the form again a call can be made
	// to watches.renew
	//   "NO_USER_ACCESS" - The user that granted access no longer has access to
	// the form being watched. Watches with this error will not be retried. To
	// attempt to begin watching the form again a call can be made to watches.renew
	//   "OTHER_ERRORS" - Another type of error has occurred. Whether notifications
	// will continue depends on the watch state.
	ErrorType string `json:"errorType,omitempty"`
	// EventType: Required. Which event type to watch for.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Unspecified event type. This value should not
	// be used.
	//   "SCHEMA" - The schema event type. A watch with this event type will be
	// notified about changes to form content and settings.
	//   "RESPONSES" - The responses event type. A watch with this event type will
	// be notified when form responses are submitted.
	EventType string `json:"eventType,omitempty"`
	// ExpireTime: Output only. Timestamp for when this will expire. Each
	// watches.renew call resets this to seven days in the future.
	ExpireTime string `json:"expireTime,omitempty"`
	// Id: Output only. The ID of this watch. See notes on
	// CreateWatchRequest.watch_id.
	Id string `json:"id,omitempty"`
	// State: Output only. The current state of the watch. Additional details about
	// suspended watches can be found by checking the `error_type`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "ACTIVE" - Watch is active.
	//   "SUSPENDED" - The watch is suspended due to an error that may be resolved.
	// The watch will continue to exist until it expires. To attempt to reactivate
	// the watch a call can be made to watches.renew
	State string `json:"state,omitempty"`
	// Target: Required. Where to send the notification.
	Target *WatchTarget `json:"target,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Watch) MarshalJSON() ([]byte, error) {
	type NoMethod Watch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WatchTarget: The target for notification delivery.
type WatchTarget struct {
	// Topic: A Pub/Sub topic. To receive notifications, the topic must grant
	// publish privileges to the Forms service account
	// `serviceAccount:forms-notifications@system.gserviceaccount.com`. Only the
	// project that owns a topic may create a watch with it. Pub/Sub delivery
	// guarantees should be considered.
	Topic *CloudPubsubTopic `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Topic") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Topic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WatchTarget) MarshalJSON() ([]byte, error) {
	type NoMethod WatchTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteControl: Provides control over how write requests are executed.
type WriteControl struct {
	// RequiredRevisionId: The revision ID of the form that the write request is
	// applied to. If this is not the latest revision of the form, the request is
	// not processed and returns a 400 bad request error.
	RequiredRevisionId string `json:"requiredRevisionId,omitempty"`
	// TargetRevisionId: The target revision ID of the form that the write request
	// is applied to. If changes have occurred after this revision, the changes in
	// this update request are transformed against those changes. This results in a
	// new revision of the form that incorporates both the changes in the request
	// and the intervening changes, with the server resolving conflicting changes.
	// The target revision ID may only be used to write to recent versions of a
	// form. If the target revision is too far behind the latest revision, the
	// request is not processed and returns a 400 (Bad Request Error). The request
	// may be retried after reading the latest version of the form. In most cases a
	// target revision ID remains valid for several minutes after it is read, but
	// for frequently-edited forms this window may be shorter.
	TargetRevisionId string `json:"targetRevisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequiredRevisionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequiredRevisionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteControl) MarshalJSON() ([]byte, error) {
	type NoMethod WriteControl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FormsBatchUpdateCall struct {
	s                      *Service
	formId                 string
	batchupdateformrequest *BatchUpdateFormRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// BatchUpdate: Change the form with a batch of updates.
//
// - formId: The form ID.
func (r *FormsService) BatchUpdate(formId string, batchupdateformrequest *BatchUpdateFormRequest) *FormsBatchUpdateCall {
	c := &FormsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.batchupdateformrequest = batchupdateformrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsBatchUpdateCall) Fields(s ...googleapi.Field) *FormsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsBatchUpdateCall) Context(ctx context.Context) *FormsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchupdateformrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.batchUpdate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.batchUpdate" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchUpdateFormResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FormsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*BatchUpdateFormResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchUpdateFormResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.batchUpdate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsCreateCall struct {
	s          *Service
	form       *Form
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new form using the title given in the provided form message
// in the request. *Important:* Only the form.info.title and
// form.info.document_title fields are copied to the new form. All other fields
// including the form description, items and settings are disallowed. To create
// a new form and add items, you must first call forms.create to create an
// empty form with a title and (optional) document title, and then call
// forms.update to add the items.
func (r *FormsService) Create(form *Form) *FormsCreateCall {
	c := &FormsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.form = form
	return c
}

// Unpublished sets the optional parameter "unpublished": Whether the form is
// unpublished. If set to `true`, the form doesn't accept responses. If set to
// `false` or unset, the form is published and accepts responses.
func (c *FormsCreateCall) Unpublished(unpublished bool) *FormsCreateCall {
	c.urlParams_.Set("unpublished", fmt.Sprint(unpublished))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsCreateCall) Fields(s ...googleapi.Field) *FormsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsCreateCall) Context(ctx context.Context) *FormsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.form)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Form.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsCreateCall) Do(opts ...googleapi.CallOption) (*Form, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Form{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsGetCall struct {
	s            *Service
	formId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a form.
//
// - formId: The form ID.
func (r *FormsService) Get(formId string) *FormsGetCall {
	c := &FormsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsGetCall) Fields(s ...googleapi.Field) *FormsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FormsGetCall) IfNoneMatch(entityTag string) *FormsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsGetCall) Context(ctx context.Context) *FormsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Form.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsGetCall) Do(opts ...googleapi.CallOption) (*Form, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Form{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsSetPublishSettingsCall struct {
	s                         *Service
	formId                    string
	setpublishsettingsrequest *SetPublishSettingsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// SetPublishSettings: Updates the publish settings of a form. Legacy forms
// aren't supported because they don't have the `publish_settings` field.
//
// - formId: The ID of the form. You can get the id from `Form.form_id` field.
func (r *FormsService) SetPublishSettings(formId string, setpublishsettingsrequest *SetPublishSettingsRequest) *FormsSetPublishSettingsCall {
	c := &FormsSetPublishSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.setpublishsettingsrequest = setpublishsettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsSetPublishSettingsCall) Fields(s ...googleapi.Field) *FormsSetPublishSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsSetPublishSettingsCall) Context(ctx context.Context) *FormsSetPublishSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsSetPublishSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsSetPublishSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setpublishsettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}:setPublishSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.setPublishSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.setPublishSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *SetPublishSettingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FormsSetPublishSettingsCall) Do(opts ...googleapi.CallOption) (*SetPublishSettingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SetPublishSettingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.setPublishSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsResponsesGetCall struct {
	s            *Service
	formId       string
	responseId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get one response from the form.
//
// - formId: The form ID.
// - responseId: The response ID within the form.
func (r *FormsResponsesService) Get(formId string, responseId string) *FormsResponsesGetCall {
	c := &FormsResponsesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.responseId = responseId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsResponsesGetCall) Fields(s ...googleapi.Field) *FormsResponsesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FormsResponsesGetCall) IfNoneMatch(entityTag string) *FormsResponsesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsResponsesGetCall) Context(ctx context.Context) *FormsResponsesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsResponsesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsResponsesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/responses/{responseId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId":     c.formId,
		"responseId": c.responseId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.responses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.responses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FormResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsResponsesGetCall) Do(opts ...googleapi.CallOption) (*FormResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FormResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.responses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsResponsesListCall struct {
	s            *Service
	formId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List a form's responses.
//
// - formId: ID of the Form whose responses to list.
func (r *FormsResponsesService) List(formId string) *FormsResponsesListCall {
	c := &FormsResponsesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	return c
}

// Filter sets the optional parameter "filter": Which form responses to return.
// Currently, the only supported filters are: * timestamp > *N* which means to
// get all form responses submitted after (but not at) timestamp *N*. *
// timestamp >= *N* which means to get all form responses submitted at and
// after timestamp *N*. For both supported filters, timestamp must be formatted
// in RFC3339 UTC "Zulu" format. Examples: "2014-10-02T15:01:23Z" and
// "2014-10-02T15:01:23.045123456Z".
func (c *FormsResponsesListCall) Filter(filter string) *FormsResponsesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// responses to return. The service may return fewer than this value. If
// unspecified or zero, at most 5000 responses are returned.
func (c *FormsResponsesListCall) PageSize(pageSize int64) *FormsResponsesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token returned by
// a previous list response. If this field is set, the form and the values of
// the filter must be the same as for the original request.
func (c *FormsResponsesListCall) PageToken(pageToken string) *FormsResponsesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsResponsesListCall) Fields(s ...googleapi.Field) *FormsResponsesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FormsResponsesListCall) IfNoneMatch(entityTag string) *FormsResponsesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsResponsesListCall) Context(ctx context.Context) *FormsResponsesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsResponsesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsResponsesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/responses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.responses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.responses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListFormResponsesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FormsResponsesListCall) Do(opts ...googleapi.CallOption) (*ListFormResponsesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListFormResponsesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.responses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FormsResponsesListCall) Pages(ctx context.Context, f func(*ListFormResponsesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FormsWatchesCreateCall struct {
	s                  *Service
	formId             string
	createwatchrequest *CreateWatchRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Create: Create a new watch. If a watch ID is provided, it must be unused.
// For each invoking project, the per form limit is one watch per
// Watch.EventType. A watch expires seven days after it is created (see
// Watch.expire_time).
//
// - formId: ID of the Form to watch.
func (r *FormsWatchesService) Create(formId string, createwatchrequest *CreateWatchRequest) *FormsWatchesCreateCall {
	c := &FormsWatchesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.createwatchrequest = createwatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsWatchesCreateCall) Fields(s ...googleapi.Field) *FormsWatchesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsWatchesCreateCall) Context(ctx context.Context) *FormsWatchesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsWatchesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsWatchesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.createwatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/watches")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.watches.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.watches.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Watch.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsWatchesCreateCall) Do(opts ...googleapi.CallOption) (*Watch, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Watch{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.watches.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsWatchesDeleteCall struct {
	s          *Service
	formId     string
	watchId    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a watch.
//
// - formId: The ID of the Form.
// - watchId: The ID of the Watch to delete.
func (r *FormsWatchesService) Delete(formId string, watchId string) *FormsWatchesDeleteCall {
	c := &FormsWatchesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.watchId = watchId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsWatchesDeleteCall) Fields(s ...googleapi.Field) *FormsWatchesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsWatchesDeleteCall) Context(ctx context.Context) *FormsWatchesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsWatchesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsWatchesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/watches/{watchId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId":  c.formId,
		"watchId": c.watchId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.watches.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.watches.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsWatchesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.watches.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsWatchesListCall struct {
	s            *Service
	formId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Return a list of the watches owned by the invoking project. The
// maximum number of watches is two: For each invoker, the limit is one for
// each event type per form.
//
// - formId: ID of the Form whose watches to list.
func (r *FormsWatchesService) List(formId string) *FormsWatchesListCall {
	c := &FormsWatchesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsWatchesListCall) Fields(s ...googleapi.Field) *FormsWatchesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FormsWatchesListCall) IfNoneMatch(entityTag string) *FormsWatchesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsWatchesListCall) Context(ctx context.Context) *FormsWatchesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsWatchesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsWatchesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/watches")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId": c.formId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.watches.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.watches.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWatchesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FormsWatchesListCall) Do(opts ...googleapi.CallOption) (*ListWatchesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWatchesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.watches.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FormsWatchesRenewCall struct {
	s                 *Service
	formId            string
	watchId           string
	renewwatchrequest *RenewWatchRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Renew: Renew an existing watch for seven days. The state of the watch after
// renewal is `ACTIVE`, and the `expire_time` is seven days from the renewal.
// Renewing a watch in an error state (e.g. `SUSPENDED`) succeeds if the error
// is no longer present, but fail otherwise. After a watch has expired,
// RenewWatch returns `NOT_FOUND`.
//
// - formId: The ID of the Form.
// - watchId: The ID of the Watch to renew.
func (r *FormsWatchesService) Renew(formId string, watchId string, renewwatchrequest *RenewWatchRequest) *FormsWatchesRenewCall {
	c := &FormsWatchesRenewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.formId = formId
	c.watchId = watchId
	c.renewwatchrequest = renewwatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FormsWatchesRenewCall) Fields(s ...googleapi.Field) *FormsWatchesRenewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FormsWatchesRenewCall) Context(ctx context.Context) *FormsWatchesRenewCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FormsWatchesRenewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FormsWatchesRenewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.renewwatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/forms/{formId}/watches/{watchId}:renew")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"formId":  c.formId,
		"watchId": c.watchId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "forms.forms.watches.renew", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "forms.forms.watches.renew" call.
// Any non-2xx status code is an error. Response headers are in either
// *Watch.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FormsWatchesRenewCall) Do(opts ...googleapi.CallOption) (*Watch, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Watch{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "forms.forms.watches.renew", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
