//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
// MIB declaration (Message Information Block)
//
// Version 1.00
//

#include "tagconst.h"
#include "objects.h"

// structure to hold one MIB entry
typedef struct
{
   unsigned short tagdesc;    // object descriptor number
   void *payload;             // pointer to the payload data
   unsigned char maxlen;      // max length of data
   unsigned char attrib;      // read/write/pre-execute flags
} MIBEntry;

// pointer to a group vector
typedef int (*GroupVect)(int,uchar,int);

// MIB constants
#define  RE          0x01
#define  WE          0x02
#define  PRE_EX      0x04
#define  POST_EX     0x08

// prototypes needed for MIB
extern int VectOWBranch(int,uchar,int);
extern int VectOWCluster(int,uchar,int);
extern int VectOWSensor(int,uchar,int);
extern int VectOWActuator(int,uchar,int);

#ifdef MIB_DECL

// Message Information Block
MIBEntry MIB[] = 
   { { GD_OWBranch,        (GroupVect)(VectOWBranch),    0,    PRE_EX | POST_EX },
     { GD_OWSensor,        (GroupVect)(VectOWSensor),    0,    POST_EX },
     { GD_OWActuator,      (GroupVect)(VectOWActuator),  0,    POST_EX },
     { GD_OWCluster,       (GroupVect)(VectOWCluster),   0,    PRE_EX | POST_EX },
     { GD_ParseData,       NULL,                         0,    POST_EX },
     { DD_ChannelMask,     NULL,                         4,    RE | WE },
     { DD_ChannelState,    NULL,                         4,    RE | WE },
     { DD_Description,     NULL,                         255,  RE | WE },
     { DD_Location,        NULL,                         255,  RE | WE },
     { DD_UnitName,        NULL,                         255,  RE | WE },
     { DD_InitState,       NULL,                         255,  RE | WE },
     { DD_ScaleFactorM,    NULL,                         4,    RE | WE },
     { DD_ScaleFactorD,    NULL,                         4,    RE | WE },
     { DD_AccessMethod,    NULL,                         4,    RE | WE },
     { DD_RomData,         NULL,                         8,    RE | WE },
     { DD_ClusterID,       NULL,                         MSGIDMAX, RE | WE },
     { DD_ClusterRev,      NULL,                         4,    RE | WE },
     { DD_Manufacturer,    NULL,                         255,  RE | WE },
     { DD_ManufacturerCode,NULL,                         8,    RE | WE },
     { DD_Enum,            NULL,                         4,    RE | WE },
     { DD_SecondsSince1970,NULL,                         4,    RE | WE },
     { 0,                  NULL,                         0,    0} };

#else

extern MIBEntry MIB[];

#endif


